/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.query;

import com.kingdee.bos.dao.xml.impl.AbstractMDElement;
import com.kingdee.bos.metadata.query.JoinItemCollection;
import com.kingdee.bos.metadata.query.JoinQueryInfo;
import com.kingdee.bos.metadata.query.SubObjectInfo;
import com.kingdee.bos.metadata.query.util.JoinType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.Uuid;
import java.io.Serializable;

public class JoinInfo
extends AbstractMDElement
implements Serializable {
    private transient String name = null;
    private transient JoinQueryInfo query = null;

    public JoinInfo() {
        this((JoinQueryInfo)null);
        this.init();
    }

    public JoinInfo(JoinQueryInfo query) {
        this.put("joinItems", new JoinItemCollection());
        this.setQuery(query);
        this.query = query;
        this.init();
    }

    @Override
    protected void clearVariableWhenValueChanged(String key) {
        super.clearVariableWhenValueChanged(key);
        if ("name".equals(key)) {
            this.name = null;
            return;
        }
        if ("query".equals(key)) {
            this.query = null;
            return;
        }
    }

    public String getNewJoinItemName() {
        return Uuid.create().toString();
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.getString("name");
        }
        return this.name;
    }

    public void setName(String item) {
        this.setString("name", item);
    }

    public String getFormulaString() {
        String s = this.getString("formulaString");
        if ((s == null || s.length() == 0) && this.getJoinItems().size() == 1) {
            s = "#0";
        }
        return s;
    }

    public void setFormulaString(String item) {
        if (item.length() == 0) {
            item = "#0";
        }
        this.setString("formulaString", item);
    }

    public SubObjectInfo getLeftObject() {
        return (SubObjectInfo)this.get("leftObject");
    }

    public void setLeftObject(SubObjectInfo item) {
        this.put("leftObject", item);
    }

    public SubObjectInfo getRightObject() {
        return (SubObjectInfo)this.get("rightObject");
    }

    public void setRightObject(SubObjectInfo item) {
        this.put("rightObject", item);
    }

    public JoinItemCollection getJoinItems() {
        return (JoinItemCollection)this.get("joinItems");
    }

    public JoinType getJoinType() {
        JoinType type = JoinType.getEnum(this.getString("type"));
        if (type == null) {
            return JoinType.INNERJOIN;
        }
        return type;
    }

    public void setJoinType(JoinType item) {
        this.setString("type", item.getName());
    }

    public JoinQueryInfo getQuery() {
        if (this.query == null) {
            this.query = (JoinQueryInfo)this.get("query");
        }
        return this.query;
    }

    public void setQuery(JoinQueryInfo item) {
        this.put("query", item);
    }

    @Override
    public BOSObjectType getBOSType() {
        return BOSObjectType.create((String)"qjon");
    }

    @Override
    public int hashCode() {
        int h = super.hashCode();
        h += JoinInfo.hashCode(this.getName());
        return h += JoinInfo.hashCode(this.getQuery());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof JoinInfo)) {
            return false;
        }
        JoinInfo that = (JoinInfo)o;
        return JoinInfo.equals(this.getName(), that.getName()) && JoinInfo.equals(this.getQuery(), that.getQuery());
    }
}

