/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.query;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.xml.impl.AbstractMDElement;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.query.PropertyRefCollection;
import com.kingdee.bos.metadata.query.PropertyRefToken;
import com.kingdee.bos.metadata.query.PropertyUnitInfo;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.metadata.query.SubQueryInfo;
import com.kingdee.bos.metadata.query.token.IToken;
import com.kingdee.bos.metadata.query.token.TokenType;
import com.kingdee.bos.metadata.query.util.QueryUtil;
import com.kingdee.bos.util.BOSObjectType;
import java.io.Serializable;
import java.util.Map;

public class PropertyRefInfo
extends AbstractMDElement
implements Serializable,
IToken {
    private transient boolean isTransformProperty = true;
    private transient PropertyUnitInfo unit = null;
    private transient SubEntityInfo subEn = null;
    private transient PropertyInfo prop = null;
    private transient SQLType sqlType = null;
    private static final BOSObjectType BOS_TYPE = BOSObjectType.create((String)"qprf");

    public PropertyRefInfo() {
        this(null, null, null);
    }

    public PropertyRefInfo(PropertyUnitInfo unit) {
        this(unit, null, null);
    }

    public PropertyRefInfo(PropertyUnitInfo unit, SubEntityInfo subEn, PropertyInfo prop) {
        this.setUnit(unit);
        this.setSubEntity(subEn);
        this.setRefProperty(prop);
    }

    void setIsTransformProperty(boolean flag) {
        this.isTransformProperty = flag;
    }

    boolean getIsTransformProperty() {
        return this.isTransformProperty;
    }

    public SubEntityInfo getSubEntity() {
        if (this.subEn == null) {
            this.subEn = (SubEntityInfo)this.get("subEntity");
        }
        return this.subEn;
    }

    public void setSubEntity(SubEntityInfo item) {
        this.put("subEntity", item);
        this.subEn = item;
        this.sqlType = null;
    }

    public PropertyInfo getRefProperty() {
        if (this.prop == null) {
            this.prop = (PropertyInfo)this.get("refProperty");
        }
        return this.prop;
    }

    void setRefProperty(PropertyInfo item) {
        this.put("refProperty", item);
        this.prop = item;
        this.sqlType = null;
    }

    public PropertyUnitInfo getUnit() {
        if (this.unit == null) {
            this.unit = (PropertyUnitInfo)this.get("parentUnit");
        }
        return this.unit;
    }

    public void setUnit(PropertyUnitInfo item) {
        this.put("parentUnit", item);
        this.unit = item;
    }

    public SubQueryInfo getSubQuery() {
        return (SubQueryInfo)this.get("subQuery");
    }

    public void setSubQuery(SubQueryInfo item) {
        this.put("subQuery", item);
        this.sqlType = null;
    }

    public PropertyUnitInfo getRefUnit() {
        return (PropertyUnitInfo)this.get("refUnit");
    }

    public void setRefUnit(PropertyUnitInfo item) {
        this.put("refUnit", item);
        this.sqlType = null;
    }

    @Override
    public TokenType getTokenType() {
        return TokenType.OBJECTVALUE;
    }

    @Override
    public String showValue() throws BOSException {
        return new PropertyRefToken(this).showValue();
    }

    public String showValue(boolean bParaType, Map paraMap) throws BOSException {
        return this.showValue();
    }

    public SQLType getSQLType() {
        if (this.sqlType == null) {
            PropertyRefCollection propRefs;
            PropertyUnitInfo propUnit;
            SQLType type = null;
            if (this.getSubEntity() != null) {
                PropertyInfo prop = this.getRefProperty();
                if (prop == null) {
                    type = null;
                }
                ColumnInfo col = null;
                try {
                    col = QueryUtil.getColumnInfoByProp(prop, this.getSubEntity());
                }
                catch (BOSException e) {
                    type = null;
                }
                type = col == null ? null : col.getTypeName();
            } else if (this.getSubQuery() != null && (propUnit = this.getRefUnit()) != null && (propRefs = propUnit.getPropertyRefs()) != null && propRefs.size() >= 1) {
                type = propRefs.get(0).getSQLType();
            }
            this.sqlType = type;
        }
        return this.sqlType;
    }

    @Override
    public BOSObjectType getBOSType() {
        return BOS_TYPE;
    }

    @Override
    public int hashCode() {
        int h = super.hashCode();
        return h += PropertyRefInfo.hashCode(this.getUnit());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof PropertyRefInfo)) {
            return false;
        }
        if (!PropertyRefInfo.equals(this.getUnit(), ((PropertyRefInfo)o).getUnit())) {
            return false;
        }
        return super.equals(o);
    }
}

