/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.query;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.InvalidMetaDataException;
import com.kingdee.bos.dao.DeleContext;
import com.kingdee.bos.dao.DeleContextUtil;
import com.kingdee.bos.metadata.AbstractMDValueDele;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.query.JoinCollectionDele;
import com.kingdee.bos.metadata.query.JoinCreator;
import com.kingdee.bos.metadata.query.JoinInfo;
import com.kingdee.bos.metadata.query.JoinQueryInfo;
import com.kingdee.bos.metadata.query.PropertyUnitCollectionDele;
import com.kingdee.bos.metadata.query.PropertyUnitDele;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryFilterDele;
import com.kingdee.bos.metadata.query.QueryFilterInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.QueryPKDele;
import com.kingdee.bos.metadata.query.QueryParameterCollectionDele;
import com.kingdee.bos.metadata.query.QuerySorterItemCollection;
import com.kingdee.bos.metadata.query.QuerySorterItemCollectionDele;
import com.kingdee.bos.metadata.query.SelectorInfo4Dele;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.metadata.query.SubObjectCollectionDele;
import com.kingdee.bos.metadata.query.SubObjectDele;
import com.kingdee.bos.metadata.query.UnionQueryInfo;
import com.kingdee.bos.metadata.query.util.QueryDeleUtil;
import com.kingdee.bos.metadata.query.util.QueryState;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class QueryDele
extends AbstractMDValueDele {
    public static final int JOIN = 0;
    public static final int UNION = 1;
    public static final int VIRTUAL = 2;
    private int type;
    public QueryState mode = QueryState.RUNTIME;
    protected List headSubObjects = null;

    private QueryDele(QueryInfo target, DeleContext ctx) {
        super(target, ctx);
        this.setType();
        this.put("units", new PropertyUnitCollectionDele(target.getUnits(), ctx));
        this.put("parameters", new QueryParameterCollectionDele(target.getParameters(), ctx));
        this.put("subObjects", new SubObjectCollectionDele(target.getSubObjects(), ctx));
        this.put("defaultSorters", new QuerySorterItemCollectionDele(target.getDefaultSorters(), ctx));
        if (this.type == 0) {
            this.put("joins", new JoinCollectionDele(((JoinQueryInfo)target).getJoins(), ctx));
        }
        this.put("queryPK", QueryPKDele.getInstance(target.getQueryPK(), ctx));
        QueryFilterInfo filter = target.getDefaultFilter();
        if (filter != null) {
            this.put("defaultFilter", QueryFilterDele.getInstance(filter, ctx));
        } else {
            this.put("defaultFilter", QueryFilterDele.newInstance(this));
        }
        QuerySorterItemCollection sorters = target.getDefaultSorters();
        if (sorters != null) {
            this.put("defaultSorters", new QuerySorterItemCollectionDele(sorters, ctx));
        } else {
            this.put("defaultSorters", QuerySorterItemCollectionDele.newInstance(ctx));
        }
        if (target instanceof JoinQueryInfo) {
            this.put("isDistinct", ((JoinQueryInfo)target).isIsDistinct());
        }
    }

    public String getName() {
        return ((QueryInfo)this.target).getName();
    }

    public String getFullName() {
        return ((QueryInfo)this.target).getFullName();
    }

    public QueryPKDele getQueryPK() {
        return (QueryPKDele)this.get("queryPK");
    }

    public QueryFilterDele getDefaultFilter() {
        QueryFilterDele filter = (QueryFilterDele)this.get("defaultFilter");
        if (filter != null) {
            filter.setQuery(this);
            filter.setName("defaultFilter");
        }
        return filter;
    }

    public QuerySorterItemCollectionDele getDefaultSorters() {
        return (QuerySorterItemCollectionDele)this.get("defaultSorters");
    }

    private void setType() {
        this.type = this.target instanceof JoinQueryInfo ? 0 : (this.target instanceof UnionQueryInfo ? 1 : 2);
    }

    public int getType() {
        return this.type;
    }

    public static QueryDele getInstance(QueryInfo query, DeleContext ctx) {
        if (query == null) {
            return null;
        }
        QueryDele dele = (QueryDele)DeleContextUtil.get(query.getBOSType(), ctx, query);
        if (dele == null) {
            dele = new QueryDele(query, ctx);
        }
        return dele;
    }

    public SubObjectDele getMainObject() throws BOSException {
        return SubObjectDele.getInstance(((QueryInfo)this.target).getMainObject(), this.ctx);
    }

    public SelectorInfo4Dele getSelector() {
        SelectorInfo4Dele selector = new SelectorInfo4Dele();
        PropertyUnitCollectionDele units = this.getUnits();
        int size = units.size();
        for (int i = 0; i < size; ++i) {
            PropertyUnitDele unit = units.get(i);
            if (!(unit.getTarget() instanceof QueryFieldInfo) || !unit.isIsSelector()) continue;
            selector.add(unit);
        }
        return selector;
    }

    public PropertyUnitCollectionDele getUnits() {
        return (PropertyUnitCollectionDele)this.get("units");
    }

    public SubObjectCollectionDele getSubObjects() {
        return (SubObjectCollectionDele)this.get("subObjects");
    }

    public QueryParameterCollectionDele getParameters() {
        return (QueryParameterCollectionDele)this.get("parameters");
    }

    @Override
    public BOSObjectType getBOSType() {
        return this.target.getBOSType();
    }

    public boolean isIsDistinct() {
        Object value = this.get("isDistinct");
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return false;
    }

    public void setIsDistinct(boolean value) {
        if (this.target instanceof JoinQueryInfo) {
            this.put("isDistinct", value);
        }
    }

    public String getNewJoinName() {
        if (this.type == 0) {
            return ((JoinQueryInfo)this.target).getNewJoinName();
        }
        return null;
    }

    public String getNewSubObjectName(String name) {
        int i = 0;
        String newName = name;
        while (this.getSubObjects().contains(newName)) {
            ++i;
            if (newName.length() == name.length()) {
                newName = newName + i;
                continue;
            }
            newName = newName.substring(0, newName.length() - ("" + i).length()) + i;
        }
        return newName;
    }

    public String getNewSubObjectName() {
        return this.getNewSubObjectName("NewSubObject");
    }

    public String getNewUnitName() {
        return ((QueryInfo)this.target).getNewUnitName();
    }

    public String getNewParameterName() {
        return ((QueryInfo)this.target).getNewParameterName();
    }

    public JoinCollectionDele getJoins() {
        return (JoinCollectionDele)this.get("joins");
    }

    public void addJoin(SubObjectDele left, SubObjectDele right, RelationshipInfo rela) throws BOSException {
        this.addJoin((SubEntityInfo)left.getTarget(), (SubEntityInfo)right.getTarget(), rela);
    }

    public void addJoin(SubEntityInfo left, SubEntityInfo right, RelationshipInfo rela) throws BOSException {
        JoinInfo join = new JoinCreator(left, right, rela).create(new JoinCreator.Carrier(this));
        this.getJoins().add(join);
    }

    public List getUnionObjects() throws BOSException {
        SubObjectCollectionDele subObjs = this.getSubObjects();
        if (subObjs.size() <= 1) {
            throw new BOSException("Union Query must include at least two sub query!");
        }
        ArrayList<SubObjectDele> unionObjs = new ArrayList<SubObjectDele>();
        SubObjectDele main = this.getMainObject();
        int size = subObjs.size();
        for (int i = 0; i < size; ++i) {
            SubObjectDele s = subObjs.get(i);
            if (s.getName().equals(main.getName())) continue;
            unionObjs.add(s);
        }
        if (unionObjs.size() == 0) {
            throw new InvalidMetaDataException("Can't find the union object.");
        }
        return unionObjs;
    }

    public String getFormulaString() {
        String s = this.getString("formulaString");
        if (StringUtils.isEmpty((String)s)) {
            s = this.getSubObjects().size() == 1 ? "#0" : "";
        }
        return s;
    }

    public void setFormulaString(String formula) {
        this.setString("formulaString", formula);
    }

    public void clearHeadSubObjects() {
        this.headSubObjects = null;
    }

    public List getHeadSubObjects() throws BOSException {
        if (this.headSubObjects == null) {
            this.headSubObjects = QueryDeleUtil.getHeadSubEntityCollection(this);
        }
        return this.headSubObjects;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        if (!(that instanceof QueryDele)) {
            return false;
        }
        if (StringUtils.isEmpty((String)this.getFullName())) {
            return false;
        }
        return this.getFullName().equals(((QueryDele)that).getFullName());
    }
}

