/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.query;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.InvalidMetaDataException;
import com.kingdee.bos.dao.DeleContext;
import com.kingdee.bos.dao.DeleContextUtil;
import com.kingdee.bos.metadata.AbstractMDValueDele;
import com.kingdee.bos.metadata.query.QueryDele;
import com.kingdee.bos.metadata.query.QueryFilterInfo;
import com.kingdee.bos.metadata.query.QueryFilterItemCollectionDele;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.token.CollectionFormulaParser;
import com.kingdee.bos.metadata.query.token.LogicToken;
import com.kingdee.bos.metadata.query.token.TokenKey;
import com.kingdee.bos.metadata.query.util.QueryUtil;
import com.kingdee.util.StringUtils;

public class QueryFilterDele
extends AbstractMDValueDele {
    private QueryFilterDele(QueryFilterInfo filter, DeleContext ctx) {
        super(filter, ctx);
        this.setQuery(QueryDele.getInstance(filter.getQuery(), ctx));
        this.put("filterItems", new QueryFilterItemCollectionDele(filter.getFilterItems(), ctx));
    }

    public static QueryFilterDele getInstance(QueryFilterInfo filter, DeleContext ctx) {
        if (filter == null) {
            return null;
        }
        QueryFilterDele dele = (QueryFilterDele)DeleContextUtil.get(filter.getBOSType(), ctx, filter);
        if (dele == null) {
            dele = new QueryFilterDele(filter, ctx);
        }
        return dele;
    }

    public static QueryFilterDele newInstance(QueryDele query) {
        QueryFilterDele dele = new QueryFilterDele(new QueryFilterInfo((QueryInfo)query.getTarget()), query.getContext());
        dele.isTgtNew = true;
        dele.setQuery(query);
        return dele;
    }

    public QueryFilterItemCollectionDele getFilterItems() {
        return (QueryFilterItemCollectionDele)this.get("filterItems");
    }

    public String getFormulaString() {
        String s = this.getString("formulaString");
        if (StringUtils.isEmpty((String)s)) {
            s = this.getFilterItems().size() == 1 ? "#0" : "";
        }
        return s;
    }

    public void setFormulaString(String formulaString) {
        this.setString("formulaString", formulaString);
    }

    public String getName() {
        String name = this.getString("name");
        if (StringUtils.isEmpty((String)name)) {
            name = "defaultFilter";
        }
        return name;
    }

    public void setName(String item) {
        this.setString("name", item);
    }

    public QueryDele getQuery() {
        return (QueryDele)this.get("query");
    }

    public void setQuery(QueryDele item) {
        this.put("query", item);
    }

    public void mergeFilter(QueryFilterDele filter, String logic) throws BOSException {
        String oldMaskString = QueryUtil.processMaskString(this.getFilterItems().size(), this.getFormulaString());
        String newMaskString = QueryUtil.processMaskString(filter.getFilterItems().size(), filter.getFormulaString());
        if (!TokenKey.isLogicWord(logic)) {
            throw new InvalidMetaDataException("The logic operator is not avaliable.");
        }
        CollectionFormulaParser parserNew = new CollectionFormulaParser(StringUtils.addBracket((String)newMaskString), filter.getFilterItems());
        CollectionFormulaParser parserOld = new CollectionFormulaParser(StringUtils.addBracket((String)oldMaskString), this.getFilterItems());
        parserOld.tokenList.add(new LogicToken(logic));
        parserOld.tokenList.addAll(parserNew.tokenList);
        this.getFilterItems().addObjectCollection(filter.getFilterItems());
        this.setFormulaString(parserOld.tokenList.showOrginValue());
    }

    public void addFilterItem(QueryFilterDele filter) throws BOSException {
        String maskString = QueryUtil.processMaskString(filter.getFilterItems().size(), filter.getFormulaString());
        this.setFormulaString(maskString);
        this.getFilterItems().addObjectCollection(filter.getFilterItems());
    }
}

