/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.query;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.xml.impl.AbstractMDElement;
import com.kingdee.bos.metadata.query.JoinInfo;
import com.kingdee.bos.metadata.query.JoinQueryInfo;
import com.kingdee.bos.metadata.query.PropertyUnitInfo;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryFilterInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.QueryParameterInfo;
import com.kingdee.bos.metadata.query.QuerySorterItemInfo;
import com.kingdee.bos.metadata.query.SubObjectInfo;
import com.kingdee.bos.metadata.query.util.GroupType;
import com.kingdee.bos.metadata.query.util.QueryUtil;
import com.kingdee.bos.metadata.validate.ValidateList;
import com.kingdee.bos.metadata.validate.ValidateMetaData;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class QueryValidate {
    private static final Logger logger = Logger.getLogger(QueryValidate.class);
    private QueryInfo query;
    private ValidateMetaData vld;

    public QueryValidate(QueryInfo query, ValidateMetaData vld) {
        this.query = query;
        this.vld = vld == null ? new ValidateMetaData() : vld;
    }

    public ValidateList validate() {
        int i;
        HashMap<String, AbstractMDElement> map = new HashMap<String, AbstractMDElement>();
        for (int i2 = 0; i2 < this.query.getSubObjects().size(); ++i2) {
            SubObjectInfo sub = this.query.getSubObjects().get(i2);
            if (map.containsKey(sub.getName())) {
                this.vld.addError("Duplicated SubObject: " + sub.getName());
                continue;
            }
            map.put(sub.getName(), sub);
        }
        map = new HashMap();
        HashSet<String> set = new HashSet<String>();
        for (int i3 = 0; i3 < this.query.getUnits().size(); ++i3) {
            PropertyUnitInfo unit = this.query.getUnits().get(i3);
            if (unit instanceof QueryFieldInfo && unit.isIsSelector()) {
                if (unit.getGroupType() == GroupType.NONE) {
                    set.add("NoGroup");
                } else {
                    set.add("Group");
                }
            }
            if (map.containsKey(unit.getName())) {
                this.vld.addError("Duplicated PropertyUnit: " + unit.getName());
            } else {
                map.put(unit.getName(), unit);
            }
            this.validateUnit(unit, this.vld);
        }
        if (set.size() > 1) {
            this.vld.addError("The grouping of queryField exist error,please check all queryfields!");
        }
        if (this.query instanceof JoinQueryInfo) {
            JoinQueryInfo jqy = (JoinQueryInfo)this.query;
            map = new HashMap();
            for (int i4 = 0; i4 < jqy.getJoins().size(); ++i4) {
                JoinInfo join = jqy.getJoins().get(i4);
                if (map.containsKey(join.getName())) {
                    this.vld.addError("Duplicated Join: " + join.getName());
                } else {
                    map.put(join.getName(), join);
                }
                this.validateJoin(join, this.vld);
            }
        }
        map = new HashMap();
        for (i = 0; i < this.query.getParameters().size(); ++i) {
            QueryParameterInfo pa = this.query.getParameters().get(i);
            if (map.containsKey(pa.getName())) {
                this.vld.addError("Duplicated Parameter: " + pa.getName());
                continue;
            }
            map.put(pa.getName(), pa);
        }
        if (this.query.getDefaultFilter() != null && this.query.getDefaultFilter().getFilterItems().size() != 0) {
            this.validateFilter(this.query.getDefaultFilter(), this.vld);
        }
        map = new HashMap();
        for (i = 0; i < this.query.getDefaultSorters().size(); ++i) {
            QuerySorterItemInfo item = this.query.getDefaultSorters().get(i);
            if (map.containsKey(item.getPropertyName())) {
                this.vld.addError("Duplicated Default Sorter: " + item.getPropertyName());
                continue;
            }
            map.put(item.getPropertyName(), item);
        }
        return this.vld.getValidateList();
    }

    private void validateFilter(QueryFilterInfo filter, ValidateMetaData vla) {
        try {
            if (StringUtils.isEmpty((String)QueryUtil.getFilterString(filter))) {
                throw new BOSException("The default filter's show value is null.");
            }
        }
        catch (BOSException err) {
            vla.addError(err.getMessage());
        }
        catch (Exception err) {
            vla.addError("The default filter 's formula is error.");
        }
    }

    private void validateUnit(PropertyUnitInfo unit, ValidateMetaData vla) {
        try {
            if (StringUtils.isEmpty((String)QueryUtil.getUnitString(unit))) {
                throw new BOSException("The Property Unit " + unit + "'s show value is null.");
            }
        }
        catch (BOSException err) {
            logger.error((Object)err, (Throwable)err);
            vla.addError(err.getMessage());
        }
        catch (Exception err) {
            logger.error((Object)err, (Throwable)err);
            vla.addError("The Propertyunit: " + unit.getName() + "'s formula define is error.");
        }
    }

    private void validateJoin(JoinInfo join, ValidateMetaData vla) {
        try {
            if (StringUtils.isEmpty((String)QueryUtil.getJoinString(join))) {
                throw new BOSException("The Join's show value is null.");
            }
        }
        catch (BOSException err) {
            logger.error((Object)err, (Throwable)err);
            vla.addError(err.getMessage());
        }
        catch (Exception err) {
            logger.error((Object)err, (Throwable)err);
            String message = "The link between Object: " + join.getLeftObject().getName() + " And " + join.getRightObject().getName();
            vla.addError("The Propertyunit: " + message + " formula define is error.");
        }
    }
}

