/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.query.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.query.QueryDele;
import com.kingdee.bos.metadata.query.util.QuerySqlAccessBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BuilderState {
    protected static final Logger logger = Logger.getLogger(BuilderState.class);
    private EntityViewInfo view;
    private Map<String, EntityViewInfo> viewMap;
    protected final QueryDele query;
    protected final QuerySqlAccessBase qsa;
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>(2);

    public BuilderState(QuerySqlAccessBase qsa) {
        this.qsa = qsa;
        this.query = qsa.query;
    }

    public final EntityViewInfo getView() {
        if (this.view == null) {
            this.view = new EntityViewInfo();
        }
        return this.view;
    }

    private final void setView(EntityViewInfo view) {
        if (this.view == null && view == null || this.view != null && this.view.equals(view)) {
            return;
        }
        ChangeEvent event = new ChangeEvent();
        event.type = 0;
        event.oldValue = this.view;
        event.value = view;
        this.fireChangeEvent(event);
        this.view = view;
        this.query.clearHeadSubObjects();
    }

    public final void set(EntityViewInfo view, Map<String, EntityViewInfo> map) {
        if (map != null && !map.isEmpty()) {
            this.setViewMap(map);
        } else {
            this.setView(view);
        }
    }

    public final Map<String, EntityViewInfo> getViewMap() {
        if (this.viewMap == null) {
            this.viewMap = new HashMap<String, EntityViewInfo>(1);
        }
        return this.viewMap;
    }

    private final void setViewMap(Map<String, EntityViewInfo> map) {
        if (this.viewMap != null && this.viewMap.equals(map) || this.viewMap == null && map == null) {
            return;
        }
        ChangeEvent event = new ChangeEvent();
        event.type = 1;
        event.oldValue = this.viewMap;
        event.value = map;
        this.fireChangeEvent(event);
        this.viewMap = map;
        this.query.clearHeadSubObjects();
        try {
            if (this.query.getType() != 0) {
                throw new BOSException("Can't process query type");
            }
            this.setView(this.getViewFromMap(this.viewMap));
        }
        catch (BOSException e) {
            logger.debug((Object)e.getMessage());
        }
    }

    public EntityViewInfo getViewFromMap(Map<String, EntityViewInfo> views) throws BOSException {
        if (views != null && this.query.getType() == 0) {
            String mainObjectName = this.query.getMainObject().getName();
            if (views.containsKey(mainObjectName)) {
                return views.get(mainObjectName);
            }
            return null;
        }
        return null;
    }

    void registerChangeListener(ChangeListener l) {
        if (l != null) {
            this.listeners.add(l);
        }
    }

    void fireChangeEvent(ChangeEvent event) {
        int size = this.listeners.size();
        for (int i = 0; i < size; ++i) {
            this.listeners.get(i).clear(event);
        }
    }

    public static class ChangeEvent {
        public static final int VIEW = 0;
        public static final int VIEWMAP = 1;
        public int type;
        public Object oldValue;
        public Object value;
    }

    public static interface ChangeListener {
        public void clear(ChangeEvent var1);
    }
}

