/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.query.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.InvalidMetaDataException;
import com.kingdee.bos.metadata.data.CrossTableInfo;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.data.ExtendedTableInfo;
import com.kingdee.bos.metadata.data.PrimaryKeyInfo;
import com.kingdee.bos.metadata.data.TableMapInfo;
import com.kingdee.bos.metadata.entity.EntityObjectCtrl;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.ExtendedFieldInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.query.JoinCollectionDele;
import com.kingdee.bos.metadata.query.JoinDele;
import com.kingdee.bos.metadata.query.JoinInfo;
import com.kingdee.bos.metadata.query.JoinItemDele;
import com.kingdee.bos.metadata.query.PropertyRefCollectionDele;
import com.kingdee.bos.metadata.query.PropertyRefDele;
import com.kingdee.bos.metadata.query.PropertyUnitDele;
import com.kingdee.bos.metadata.query.QueryDele;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.metadata.query.SubObjectDele;
import com.kingdee.bos.metadata.query.SubQueryInfo;
import com.kingdee.bos.metadata.query.token.CollectionFormulaParser;
import com.kingdee.bos.metadata.query.util.AbstractBuilder;
import com.kingdee.bos.metadata.query.util.BuilderState;
import com.kingdee.bos.metadata.query.util.JoinType;
import com.kingdee.bos.metadata.query.util.QueryDeleUtil;
import com.kingdee.bos.metadata.query.util.QuerySQLFormater;
import com.kingdee.bos.metadata.query.util.QuerySqlAccessBase;
import com.kingdee.bos.metadata.query.util.QueryUtil;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.sql.dom.SqlSelect;
import com.kingdee.bos.sql.dom.SqlSelectBase;
import com.kingdee.bos.sql.formater.FormaterException;
import com.kingdee.bos.sql.parser.SelectParser;
import com.kingdee.util.Assert;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class FromBuilder
extends AbstractBuilder {
    private StringBuffer from = null;
    private HashMap subEntityNameTable = new HashMap();

    public FromBuilder(QuerySqlAccessBase qsa) {
        super(qsa);
    }

    @Override
    public String getSql() throws BOSException {
        if (this.from == null) {
            this.buildFrom();
        }
        return this.from.toString();
    }

    @Override
    public void clear(BuilderState.ChangeEvent e) {
        if (e.type == 1) {
            this.from = null;
            this.subEntityNameTable.clear();
        }
    }

    private void buildFrom() throws BOSException {
        this.from = new StringBuffer();
        SubObjectDele obj = null;
        if (this.query.getType() == 0) {
            this.from.append(" From ");
            obj = this.query.getMainObject();
            this.from.append(this.getSubObjectName(obj));
            this.subEntityNameTable.put(obj.getName(), null);
            List<PropertyUnitDele> fldCol = this.query.getUnits().getQueryFields();
            int queryFieldSize = fldCol.size();
            if (this.isInheritInLeftObject(obj)) {
                PropertyRefCollectionDele joinRefs = this.getInheritPropRefsFromJoin(this.query);
                int inheritPropSize = joinRefs.size();
                if (queryFieldSize != 0 && inheritPropSize == 0) {
                    this.processQueryField(fldCol, queryFieldSize, obj);
                }
                if (queryFieldSize != 0 && inheritPropSize != 0) {
                    this.from.append(this.buildInheritRelation(joinRefs));
                    this.processQueryField(fldCol, queryFieldSize, obj);
                }
            } else {
                this.processRightObject(this.query);
                this.processReverseObject(this.query);
                if (queryFieldSize != 0) {
                    int n = fldCol.size();
                    for (int j = 0; j < n; ++j) {
                        PropertyUnitDele fld = fldCol.get(j);
                        this.from.append(this.buildInheritRelation(fld.getPropertyRefs()));
                    }
                }
            }
        } else if (this.query.getType() == 1) {
            obj = this.query.getMainObject();
            if (obj.getType() == 1) {
                obj.setSql(this.filterOrder(this.getNewSubQuerySqlAccess(this.query, obj.getQueryRef(), null).getSql().toString()));
            }
            List unionObjs = this.query.getUnionObjects();
            int length = unionObjs.size();
            for (int i = 0; i < length; ++i) {
                SubObjectDele s = (SubObjectDele)unionObjs.get(i);
                if (s.getType() != 1) continue;
                s.setSql(this.filterOrder(this.getNewSubQuerySqlAccess(this.query, s.getQueryRef(), null).getSql().toString()));
            }
            this.from.append(FromBuilder.getUnionSQL(this.query));
        } else {
            Assert.that((String)"Unknown query type.", (boolean)false);
        }
    }

    private static String getUnionSQL(QueryDele union) throws BOSException {
        CollectionFormulaParser paser = new CollectionFormulaParser(union.getFormulaString(), union.getSubObjects());
        return paser.tokenList.showValue();
    }

    private String filterOrder(String sql) throws BOSException {
        SqlSelect sqlSelect = null;
        SelectParser parser = null;
        StringBuffer buff = new StringBuffer();
        QuerySQLFormater formater = new QuerySQLFormater(buff);
        try {
            parser = new SelectParser(sql);
            SqlSelectBase selectBase = parser.select();
            if (selectBase instanceof SqlSelect) {
                sqlSelect = (SqlSelect)selectBase;
                if (sqlSelect != null) {
                    sqlSelect.orderBy.clear();
                    formater.formatSelectBase((SqlSelectBase)sqlSelect);
                } else {
                    throw new BOSException("Get SqlSelect failed!");
                }
            }
            return buff.toString();
        }
        catch (ParserException parseException) {
            throw new BOSException("parse sql error, sql = " + sql, (Throwable)parseException);
        }
        catch (FormaterException formaterExcption) {
            throw new BOSException("format sql error, sql = " + sql, (Throwable)formaterExcption);
        }
    }

    String getSubObjectName(SubObjectDele subObj) throws BOSException {
        String name = "";
        if (subObj.getType() == 0) {
            if (subObj.getEntityRef() == null) {
                throw FromBuilder.NullRefException(subObj);
            }
            if (subObj.getEntityRef().getTable() == null) {
                throw FromBuilder.NullRefException(subObj.getEntityRef());
            }
            name = subObj.getEntityRef().getTable().getName();
            name = name + " AS \"" + QueryUtil.getEntityAlias(subObj.getName()) + '\"';
        } else if (subObj.getType() == 1) {
            if (subObj.getQueryRef() == null) {
                throw FromBuilder.NullRefException(subObj);
            }
            EntityViewInfo view = this.getViewInfoFromMap(subObj.getName());
            if (view == null) {
                view = new EntityViewInfo();
            }
            QuerySqlAccessBase qsa = this.getNewSubQuerySqlAccess(this.query, subObj.getQueryRef(), view);
            String subSql = qsa.getSql();
            name = '\"' + subObj.getName() + '\"';
            name = " (" + subSql + ") " + " AS " + ' ' + name;
        } else {
            throw new BOSException("Unknow subobject type: " + subObj.getClass().toString());
        }
        return name;
    }

    private EntityViewInfo getViewInfoFromMap(String key) throws BOSException {
        Map<String, EntityViewInfo> viewMap = this.qsa.state.getViewMap();
        if (viewMap == null || viewMap.size() == 0) {
            return null;
        }
        if (viewMap.containsKey(key)) {
            return viewMap.get(key);
        }
        return null;
    }

    private QuerySqlAccessBase getNewSubQuerySqlAccess(QueryDele mainQuery, QueryInfo subQuery, EntityViewInfo view) throws BOSException {
        QuerySqlAccessBase newqsa = this.qsa.newInstance(mainQuery.getContext().bosCtx, subQuery);
        if (view != null) {
            newqsa.select.setTop(view.getTopCount());
            newqsa.state.set(view, null);
        }
        return newqsa;
    }

    private void processQueryField(List fldCol, int queryFieldSize, SubObjectDele obj) throws BOSException {
        PropertyUnitDele fld;
        int j = 0;
        PropertyRefCollectionDele refs = null;
        for (j = 0; j < queryFieldSize; ++j) {
            fld = (PropertyUnitDele)fldCol.get(j);
            refs = fld.getPropertyRefs();
            if (!this.isParentProp(obj, refs)) continue;
            this.from.append(this.buildInheritRelation(refs));
        }
        this.processRightObject(this.query);
        for (j = 0; j < queryFieldSize; ++j) {
            fld = (PropertyUnitDele)fldCol.get(j);
            refs = fld.getPropertyRefs();
            if (this.isParentProp(obj, refs)) continue;
            this.from.append(this.buildInheritRelation(refs));
        }
    }

    private boolean isParentProp(SubObjectDele obj, PropertyRefCollectionDele refs) throws BOSException {
        if (obj.getType() == 0) {
            EntityObjectInfo entity = obj.getEntityRef();
            PropertyCollection props = entity.getEntityProperties();
            int n = props.size();
            for (int i = 0; i < n; ++i) {
                PropertyInfo info = props.get(i);
                int m = refs.size();
                for (int j = 0; j < m; ++j) {
                    if (refs.get(j).getSubEntity() == null || !StringUtils.equalsIgnoreCase((String)info.getName().toString(), (String)refs.get(j).getRefProperty().getName().toString())) continue;
                    return true;
                }
            }
        } else {
            throw new BOSException("Left Object is not a EntityObjectInfo" + obj.getName());
        }
        return false;
    }

    private void processRightObject(QueryDele query) throws BOSException {
        SubObjectDele obj = null;
        int index = 0;
        int number = 0;
        int n = query.getSubObjects().size();
        for (int i = 0; i < n; ++i) {
            obj = query.getSubObjects().get(i);
            index = number = this.processMultiRelation(obj, index);
            this.buildJoin(obj);
        }
    }

    private void processReverseObject(QueryDele query) throws BOSException {
        int n = query.getSubObjects().size();
        for (int i = 0; i < n; ++i) {
            SubObjectDele obj = query.getSubObjects().get(i);
            this.buildReverseJoin(obj);
        }
    }

    private boolean isInheritInLeftObject(SubObjectDele leftObject) throws BOSException {
        EntityObjectInfo baseEntity;
        return leftObject.getType() == 0 && (baseEntity = leftObject.getEntityRef().getBaseEntity()) != null && !baseEntity.isAbstract();
    }

    private void buildJoin(SubObjectDele subObj) throws BOSException {
        if (this.query.getType() == 0) {
            JoinCollectionDele joins = subObj.getJoinsFromClient();
            if (joins.size() != 0) {
                this.processBuildJoin(subObj, joins, true);
            }
        } else {
            Assert.that((String)"Unknown query type.", (boolean)false);
        }
    }

    private void buildReverseJoin(SubObjectDele subObj) throws BOSException {
        if (this.query.getType() == 0) {
            JoinCollectionDele joins = subObj.getJoinsFromSupplier();
            if (joins.size() != 0) {
                this.processBuildJoin(subObj, joins, false);
            }
        } else {
            Assert.that((String)"Unknown query type.", (boolean)false);
        }
    }

    private void processBuildJoin(SubObjectDele subObj, JoinCollectionDele joins, boolean bRight) throws BOSException {
        int n = joins.size();
        for (int j = 0; j < n; ++j) {
            SubObjectDele rightObj = bRight ? joins.get(j).getRightObject() : joins.get(j).getLeftObject();
            EntityObjectInfo entity = null;
            boolean flag = false;
            int m = 0;
            int count = 0;
            HashMap map = new HashMap();
            if (rightObj.getType() == 0) {
                entity = rightObj.getEntityRef();
                if (entity != null && entity.getBaseEntity() != null && !entity.getBaseEntity().isAbstract()) {
                    for (m = 0; m < entity.getProperties().size(); ++m) {
                        if (map.containsKey(entity.getProperties().get(m).getName())) continue;
                        map.put(entity.getProperties().get(m).getName(), null);
                    }
                    block2: for (m = 0; m < joins.get(j).getJoinItems().size(); ++m) {
                        PropertyUnitDele prop = bRight ? joins.get(j).getJoinItems().get(m).getRightField() : joins.get(j).getJoinItems().get(m).getLeftField();
                        for (int l = 0; l < prop.getPropertyRefs().size(); ++l) {
                            if (!map.containsKey(prop.getPropertyRefs().get(0).getRefProperty().getName())) continue;
                            flag = true;
                            continue block2;
                        }
                    }
                } else {
                    flag = true;
                }
            } else {
                flag = true;
            }
            if (flag) {
                if (this.subEntityNameTable.containsKey(rightObj.getName())) continue;
                this.from.append(' ' + joins.get(j).getJoinType().getName() + ' ');
                this.from.append(this.getSubObjectName(rightObj));
                this.subEntityNameTable.put(rightObj.getName(), null);
            } else {
                SubObjectDele baseRightObj = null;
                if (entity != null && entity.getBaseEntity() != null && !entity.getBaseEntity().isAbstract()) {
                    baseRightObj = SubObjectDele.newSubEntity(rightObj.getQuery(), entity.getBaseEntity());
                    baseRightObj.setName(rightObj.getName() + "_parent" + count);
                    if (!this.subEntityNameTable.containsKey(baseRightObj.getName())) {
                        this.from.append(' ' + joins.get(j).getJoinType().getName() + ' ');
                        this.from.append(this.getSubObjectName(baseRightObj));
                        this.subEntityNameTable.put(baseRightObj.getName(), null);
                    }
                }
            }
            RelationshipInfo rel = null;
            if (subObj.getType() == 0 && rightObj.getType() == 0) {
                EntityObjectInfo left = subObj.getEntityRef();
                EntityObjectInfo right = rightObj.getEntityRef();
                rel = this.getMultiRelation(left, right);
            }
            if (rel == null) {
                this.from.append(QueryDeleUtil.getJoinString(joins.get(j)));
            }
            if (flag || entity.getBaseEntity().isAbstract() || this.subEntityNameTable.containsKey(rightObj.getName())) continue;
            this.from.append(' ' + joins.get(j).getJoinType().getName() + ' ');
            String innerName = entity.getTable().getName() + " AS " + '\"' + rightObj.getName() + '\"';
            this.from.append(innerName);
            this.subEntityNameTable.put(rightObj.getName(), null);
            this.from.append(this.getInheriateJoinString(rightObj, rightObj.getName() + "_parent" + count, entity.getBaseEntity()));
        }
    }

    private PropertyRefCollectionDele getInheritPropRefsFromJoin(QueryDele query) throws BOSException {
        PropertyRefCollectionDele refs = PropertyRefCollectionDele.newInstance(query.getContext());
        if (query.getType() == 0) {
            JoinCollectionDele joins = query.getJoins();
            int w = joins.size();
            for (int i = 0; i < w; ++i) {
                JoinDele join = joins.get(i);
                int r = join.getJoinItems().size();
                for (int j = 0; j < r; ++j) {
                    JoinItemDele joinItem = join.getJoinItems().get(j);
                    int o = joinItem.getLeftField().getPropertyRefs().size();
                    for (int m = 0; m < o; ++m) {
                        PropertyRefDele ref = joinItem.getLeftField().getPropertyRefs().get(m);
                        if (ref.getSubEntity() == null || ref.getSubEntity().getEntityRef().getBaseEntity() == null) continue;
                        boolean flag = false;
                        int u = ref.getSubEntity().getEntityRef().getProperties().size();
                        for (int n = 0; n < u; ++n) {
                            if (!ref.getRefProperty().getName().equalsIgnoreCase(ref.getSubEntity().getEntityRef().getProperties().get(n).getName())) continue;
                            flag = true;
                            break;
                        }
                        if (flag) continue;
                        refs.add(ref);
                    }
                }
            }
        }
        return refs;
    }

    private String buildInheritRelation(PropertyRefCollectionDele refs) throws BOSException {
        StringBuffer buildFrom = new StringBuffer();
        int n = refs.size();
        for (int k = 0; k < n; ++k) {
            DataTableInfo table;
            if (refs.get(k).getSubEntity() == null || refs.get(k).getRefProperty() == null || refs.get(k).getSubEntity().getEntityRef() == null) continue;
            SubObjectDele subEn = refs.get(k).getSubEntity();
            EntityObjectInfo parent = subEn.getEntityRef().getBaseEntity();
            PropertyInfo prop = refs.get(k).getRefProperty();
            int count = 0;
            DataTableInfo dataTableInfo = table = parent != null ? parent.getTable() : null;
            while (!(parent == null || table == null && parent.isAbstract())) {
                String name;
                if (!subEn.getEntityRef().getProperties().contains(prop) && parent.getEntityProperties().contains(prop) && !this.subEntityNameTable.containsKey(name = subEn.getName() + "_parent" + count)) {
                    buildFrom.append(' ' + JoinType.LEFTJOIN.getName() + ' ');
                    String innerName = table.getName() + " AS " + '\"' + name + '\"';
                    buildFrom.append(innerName);
                    this.subEntityNameTable.put(name, null);
                    buildFrom.append(this.getInheriateJoinString(subEn, name, parent));
                    this.processExtendTable(parent, prop, name);
                    break;
                }
                parent = parent.getBaseEntity();
                ++count;
                if (parent == null) continue;
                table = parent.getTable();
            }
            this.processExtendTable(subEn, prop);
        }
        return buildFrom.toString();
    }

    private int processMultiRelation(SubObjectDele subObj, int index) throws BOSException {
        if (subObj.getType() == 0) {
            SubObjectDele subLeftEn = subObj;
            EntityObjectInfo client = subLeftEn.getEntityRef();
            if (client == null) {
                throw FromBuilder.NullRefException(subLeftEn);
            }
            JoinCollectionDele joins = subLeftEn.getJoinsFromClient();
            int n = joins.size();
            for (int j = 0; j < n; ++j) {
                SubObjectDele subRightEn = joins.get(j).getRightObject();
                if (subRightEn.getType() != 0) continue;
                EntityObjectInfo supplier = subRightEn.getEntityRef();
                if (supplier == null) {
                    throw FromBuilder.NullRefException(subRightEn);
                }
                RelationshipInfo rel = this.getMultiRelation(client, supplier);
                if (rel == null) continue;
                CrossTableInfo cross = rel.getCrossTable();
                TableMapInfo clientMap = null;
                TableMapInfo supplierMap = null;
                if (client.getTable().getName().equals(cross.getClientTableMap().getRefTable().getName())) {
                    clientMap = cross.getClientTableMap();
                    supplierMap = cross.getSupplierTableMap();
                } else if (client.getTable().getName().equals(cross.getSupplierTableMap().getRefTable().getName())) {
                    clientMap = cross.getSupplierTableMap();
                    supplierMap = cross.getClientTableMap();
                } else {
                    throw new BOSException("Can't get the cross table's define.");
                }
                if (clientMap.getKeyMaps().size() != 1 || supplierMap.getKeyMaps().size() != 1) {
                    throw new BOSException("Can't recognize the cross table's format.");
                }
                String crossName = '\"' + rel.getName() + "_cross" + index + '\"';
                this.subEntityNameTable.put(subLeftEn.getName(), null);
                this.subEntityNameTable.put(subRightEn.getName(), null);
                String joinString = " Inner join " + cross.getName() + " AS " + crossName + '\n';
                joinString = joinString + " ON \"" + subLeftEn.getName() + '\"' + '.';
                joinString = joinString + clientMap.getKeyMaps().get(0).getRefColumn().getName() + " = ";
                joinString = joinString + crossName + '.' + clientMap.getKeyMaps().get(0).getSelfColumn().getName() + '\n';
                joinString = joinString + " Inner join " + this.getSubObjectName(subRightEn);
                joinString = joinString + " ON \"" + subRightEn.getName() + '\"' + '.';
                joinString = joinString + supplierMap.getKeyMaps().get(0).getRefColumn().getName() + " = ";
                joinString = joinString + crossName + '.' + supplierMap.getKeyMaps().get(0).getSelfColumn().getName() + '\n';
                this.from.append(joinString);
                return ++index;
            }
        }
        return index;
    }

    private RelationshipInfo getMultiRelation(EntityObjectInfo client, EntityObjectInfo supplier) throws BOSException {
        PropertyCollection properties = client.getProperties();
        int n = properties.size();
        for (int i = 0; i < n; ++i) {
            if (!(properties.get(i) instanceof LinkPropertyInfo)) continue;
            LinkPropertyInfo lnkProp = (LinkPropertyInfo)properties.get(i);
            if (lnkProp == null) {
                throw FromBuilder.NullRefException(lnkProp);
            }
            RelationshipInfo rel = lnkProp.getRelationship();
            if (rel == null) {
                throw FromBuilder.NullRefException(client.getFullName() + " 's LinkProperty[" + lnkProp.getName() + "] 's Relation is null");
            }
            if (rel.getClientObject() == null) {
                throw FromBuilder.NullRefException(client.getFullName() + " 's LinkProperty[" + lnkProp.getName() + "] 's Relation[" + rel.getFullName() + "] 's ClientObject is null");
            }
            if (rel.getSupplierObject() == null) {
                throw FromBuilder.NullRefException(client.getFullName() + " 's LinkProperty[" + lnkProp.getName() + "] 's Relation[" + rel.getFullName() + "] 's SupplierObject is null");
            }
            String relClientFullName = rel.getClientObject().getFullName();
            String relSupplierFullName = rel.getSupplierObject().getFullName();
            if ((!relClientFullName.equals(client.getFullName()) || !relSupplierFullName.equals(supplier.getFullName())) && (!relSupplierFullName.equals(client.getFullName()) || !relClientFullName.equals(supplier.getFullName())) || !rel.isMultiRelation()) continue;
            return rel;
        }
        return null;
    }

    private void processExtendTable(SubObjectDele subEn, PropertyInfo prop) throws BOSException {
        if (subEn.getEntityRef() == null) {
            throw FromBuilder.NullRefException(subEn);
        }
        this.processExtendTable(subEn.getEntityRef(), prop, subEn.getName());
    }

    private void processExtendTable(EntityObjectInfo subEn, PropertyInfo prop, String parentName) throws BOSException {
        String name;
        ExtendedFieldInfo exFld = prop.getExtendedField();
        if (exFld != null && exFld.getExtendedTable() != null && !this.subEntityNameTable.containsKey(name = parentName + "_extend")) {
            this.from.append(' ' + JoinType.LEFTJOIN.getName() + ' ');
            String innerName = exFld.getExtendedTable().getName() + " AS " + '\"' + name + '\"';
            this.from.append(innerName);
            this.subEntityNameTable.put(name, null);
            this.from.append(this.getExtendJoinString(subEn, parentName, name, exFld.getExtendedTable()));
        }
    }

    private String getExtendJoinString(EntityObjectInfo subEn, String name, String extendName, ExtendedTableInfo table) throws BOSException {
        String joinString = " ON \"" + name + '\"' + '.';
        PropertyInfo prop = subEn.getLogicalKey().getKeyPropertys().get(0);
        if (prop.getMappingField() == null) {
            throw FromBuilder.NullRefException(prop);
        }
        joinString = joinString + prop.getMappingField().getName() + " = ";
        joinString = joinString + '\"' + extendName + '\"' + '.';
        PrimaryKeyInfo pk = table.getPrimaryKey();
        if (pk.getPKColumns().size() == 0) {
            throw FromBuilder.NullRefException(pk);
        }
        joinString = joinString + pk.getPKColumns().get(0).getColumn().getName();
        return joinString;
    }

    private String getInheriateJoinString(SubObjectDele subEn, String parentName, EntityObjectInfo parent) throws BOSException {
        String joinString = " ON \"" + subEn.getName() + '\"' + '.';
        EntityObjectInfo entity = subEn.getEntityRef();
        assert (entity != null);
        EntityObjectCtrl.fillEntityLogicalKey(entity);
        PropertyInfo prop = entity.getLogicalKey().getKeyPropertys().get(0);
        if (prop.getMappingField() == null) {
            throw FromBuilder.NullRefException(prop);
        }
        joinString = joinString + prop.getMappingField().getName() + " = ";
        joinString = joinString + '\"' + parentName + '\"' + '.';
        prop = parent.getLogicalKey().getKeyPropertys().get(0);
        if (prop.getMappingField() == null) {
            throw FromBuilder.NullRefException(prop);
        }
        joinString = joinString + prop.getMappingField().getName();
        return joinString;
    }

    private static BOSException NullRefException(Object obj) {
        String message = "";
        if (obj instanceof String) {
            message = (String)obj;
        } else if (obj instanceof SubEntityInfo) {
            message = "SubEntity: " + ((SubEntityInfo)obj).getName();
            message = message + " 's EntityRef is null";
        } else if (obj instanceof SubObjectDele) {
            message = ((SubObjectDele)obj).getType() == 0 ? "SubEntity: " : "SubQuery: ";
            message = message + ((SubObjectDele)obj).getName();
            message = message + " 's QueryRef is null";
        } else if (obj instanceof EntityObjectInfo) {
            message = "EntityObject: " + ((EntityObjectInfo)obj).getName();
            message = message + " 's MappingTable is null";
        } else if (obj instanceof JoinInfo) {
            message = "Join: " + ((JoinInfo)obj).getName();
            message = message + " 's RightObject is null";
        } else if (obj instanceof JoinDele) {
            message = "Join: " + ((JoinDele)obj).getName();
            message = message + " 's RightObject is null";
        } else if (obj instanceof SubQueryInfo) {
            message = "SubQuery: " + ((SubQueryInfo)obj).getName();
            message = message + " 's QueryRef is null";
        } else if (obj instanceof LinkPropertyInfo) {
            message = "LinkPropertyInfo: " + ((LinkPropertyInfo)obj).getName();
            message = message + " 's Relation is null";
        } else if (obj instanceof PropertyInfo) {
            message = "Property: " + ((PropertyInfo)obj).getName();
            message = message + " 's Mappingfield is null";
        } else if (obj instanceof PrimaryKeyInfo) {
            message = "PrimaryKeyInfo: " + ((PrimaryKeyInfo)obj).getName();
            message = message + " 's KeyColumn's count is zero";
        } else if (obj == null) {
            message = "NullPointerException";
        }
        InvalidMetaDataException ex = new InvalidMetaDataException(message);
        return ex;
    }
}

