/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.query.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RTQueryJoinInfo;
import com.kingdee.bos.metadata.entity.RTQueryJoinItemCollection;
import com.kingdee.bos.metadata.entity.RTQueryJoinItemInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.JoinInfo;
import com.kingdee.bos.metadata.query.JoinItemInfo;
import com.kingdee.bos.metadata.query.JoinQueryInfo;
import com.kingdee.bos.metadata.query.PropertyRefInfo;
import com.kingdee.bos.metadata.query.PropertyUnitInfo;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.SelectorInfo;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.query.util.Query4EntityUtil;
import com.kingdee.bos.metadata.util.MetaDataLoader;
import java.util.ArrayList;
import java.util.List;

public class JoinQueryUtil {
    public static void addRTJoinInfo(JoinQueryInfo query, Context ctx, RTQueryJoinInfo info) throws BOSException {
        if (query instanceof JoinQueryInfo) {
            JoinQueryInfo jqy = query;
            if (Query4EntityUtil.getSubEntityEntityByName(query, info.getRightEntityName()) != null) {
                return;
            }
            String leftEntityName = null;
            String leftFieldName = null;
            String rightEntityName = null;
            String rightFieldName = null;
            IMetaDataPK rightEntityPK = null;
            CompareType compareType = null;
            leftEntityName = info.getLeftEntityName();
            rightEntityName = info.getRightEntityName();
            rightEntityPK = info.getRightEntityPK();
            EntityObjectInfo rightObject = MetaDataLoader.getEntity(ctx, rightEntityPK);
            SubEntityInfo subLeftEn = (SubEntityInfo)jqy.getSubObjects().get(leftEntityName);
            SubEntityInfo subRightEn = new SubEntityInfo(jqy, rightObject);
            subRightEn.setName(rightEntityName);
            jqy.getSubObjects().add(subRightEn);
            RelationshipInfo rel = new RelationshipInfo();
            rel.setType(RelationshipType.COMPOSITION);
            rel.setClientObject(subLeftEn.getEntityRef());
            rel.setSupplierObject(rightObject);
            JoinInfo newJoinInfo = new JoinInfo(query);
            newJoinInfo.setLeftObject(subLeftEn);
            newJoinInfo.setRightObject(subRightEn);
            newJoinInfo.setJoinType(info.getJoinType());
            RTQueryJoinItemCollection joinColl = info.getRtQueryJoinItemInfos();
            for (int i = 0; i < joinColl.size(); ++i) {
                RTQueryJoinItemInfo rtItemInfo = joinColl.get(i);
                leftFieldName = rtItemInfo.getLeftFieldName();
                rightFieldName = rtItemInfo.getRightFieldName();
                compareType = rtItemInfo.getCompareType();
                JoinItemInfo joinItem = new JoinItemInfo(newJoinInfo);
                PropertyUnitInfo leftUnit = new PropertyUnitInfo(query);
                PropertyRefInfo ref = new PropertyRefInfo(leftUnit, subLeftEn, subLeftEn.getEntityRef().getPropertyByName(leftFieldName));
                leftUnit.getPropertyRefs().add(ref);
                leftUnit.setName(query.getNewUnitName());
                joinItem.setLeftField(leftUnit);
                query.getUnits().add(leftUnit);
                PropertyUnitInfo rightUnit = new PropertyUnitInfo(query);
                PropertyRefInfo ref2 = new PropertyRefInfo(rightUnit, subRightEn, subRightEn.getEntityRef().getPropertyByName(rightFieldName));
                rightUnit.setName(query.getNewUnitName());
                rightUnit.getPropertyRefs().add(ref2);
                joinItem.setRightField(rightUnit);
                query.getUnits().add(rightUnit);
                joinItem.setCompareType(compareType);
                newJoinInfo.getJoinItems().add(joinItem);
                String formula = newJoinInfo.getFormulaString();
                if (i != 0) {
                    formula = formula + " and #" + i;
                }
                newJoinInfo.setFormulaString(formula);
            }
            newJoinInfo.setName(query.getNewJoinName());
            jqy.getJoins().add(newJoinInfo);
        }
    }

    public static void addRTQueryKey(JoinQueryInfo query, Context ctx, RTQueryJoinInfo info, EntityViewInfo view) throws BOSException {
        if (!info.isSubEntry()) {
            return;
        }
        if (query instanceof JoinQueryInfo) {
            JoinQueryInfo jqy = query;
            boolean bExist = false;
            SelectorInfo selectColl = query.getSelector();
            for (int i = 0; i < selectColl.size(); ++i) {
                QueryFieldInfo fieldInfo = selectColl.get(i);
                String fieldName = fieldInfo.getName();
                List names = JoinQueryUtil.getEntityNameListByQueryFieldName(fieldName);
                if (!names.contains(info.getRightEntityName())) continue;
                bExist = true;
                break;
            }
            if (!bExist) {
                return;
            }
            SubEntityInfo subRightEn = Query4EntityUtil.getSubEntityEntityByName(query, info.getRightEntityName());
            if (subRightEn == null) {
                return;
            }
            PropertyCollection pc = subRightEn.getEntityRef().getLogicalKey().getKeyPropertys();
            for (int i = 0; i < pc.size(); ++i) {
                PropertyInfo pkPropInfo = pc.get(i);
                QueryFieldInfo newPkFieldInfo = new QueryFieldInfo(jqy);
                newPkFieldInfo.setName(subRightEn.getName() + "." + pkPropInfo.getName());
                PropertyUnitInfo propertyUnitInfo = new PropertyUnitInfo(jqy);
                propertyUnitInfo.setName(pkPropInfo.getName());
                PropertyRefInfo propertyRefInfo = new PropertyRefInfo(propertyUnitInfo, subRightEn, pkPropInfo);
                newPkFieldInfo.getPropertyRefs().add(propertyRefInfo);
                newPkFieldInfo.setIsSelector(true);
                newPkFieldInfo.setIsFilter(false);
                jqy.getUnits().add(newPkFieldInfo);
                SelectorItemInfo itemInfo = new SelectorItemInfo(newPkFieldInfo.getName());
                itemInfo.getExtendedProperties().put("isVisibleInTable", Boolean.FALSE.toString());
                view.getSelector().add(itemInfo);
                if (jqy.getQueryPK().getKeyPropertys().contains(newPkFieldInfo)) continue;
                jqy.getQueryPK().getKeyPropertys().add(newPkFieldInfo);
            }
        }
    }

    private static List getEntityNameListByQueryFieldName(String fieldName) throws BOSException {
        ArrayList<String> names = new ArrayList<String>();
        if (fieldName != null && fieldName.indexOf(".") > 0) {
            int begin = 0;
            int idx = fieldName.indexOf(".", begin);
            while (idx > 0) {
                names.add(fieldName.substring(begin, idx));
                begin = idx + 1;
                idx = fieldName.indexOf(".", begin);
            }
        }
        return names;
    }
}

