/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.query.util;

import com.kingdee.bos.metadata.data.NLSSortType;
import com.kingdee.bos.sql.dom.KHint;
import com.kingdee.bos.sql.dom.SqlJoinedTableSource;
import com.kingdee.bos.sql.dom.SqlOrderByItem;
import com.kingdee.bos.sql.dom.SqlSelect;
import com.kingdee.bos.sql.dom.SqlSelectBase;
import com.kingdee.bos.sql.dom.SqlSelectItem;
import com.kingdee.bos.sql.dom.SqlSubQueryTableSource;
import com.kingdee.bos.sql.dom.SqlTableSource;
import com.kingdee.bos.sql.dom.SqlTableSourceBase;
import com.kingdee.bos.sql.dom.SqlUnionSelect;
import com.kingdee.bos.sql.dom.expr.SqlExpr;
import com.kingdee.bos.sql.formater.DrSQLFormater;
import com.kingdee.bos.sql.formater.FormaterException;
import java.util.Iterator;
import java.util.List;

public class QuerySQLFormater
extends DrSQLFormater {
    public QuerySQLFormater() {
    }

    public QuerySQLFormater(StringBuffer sb) {
        super(sb);
    }

    public void formatSelectBase(SqlSelectBase select) throws FormaterException {
        if (select instanceof SqlSelect) {
            this.formatSelect((SqlSelect)select, this.buffer);
        } else if (select instanceof SqlUnionSelect) {
            SqlUnionSelect unionSelect = (SqlUnionSelect)select;
            if (unionSelect.left instanceof SqlUnionSelect && ((SqlUnionSelect)unionSelect.left).option != unionSelect.option) {
                this.buffer.append('(');
                this.formatSelectBase(unionSelect.left);
                this.buffer.append(')');
            } else {
                this.formatSelectBase(unionSelect.left);
            }
            if (unionSelect.option == 0) {
                this.buffer.append("\n\nUNION\n\n");
            } else if (unionSelect.option == 1) {
                this.buffer.append("\n\nUNION ALL\n\n");
            } else {
                throw new FormaterException("Eorr Union Option.");
            }
            if (unionSelect.right instanceof SqlUnionSelect && ((SqlUnionSelect)unionSelect.right).option != unionSelect.option) {
                this.buffer.append('(');
                this.formatSelectBase(unionSelect.right);
                this.buffer.append(')');
            } else {
                this.formatSelectBase(unionSelect.right);
            }
            if (unionSelect.orderBy.size() != 0) {
                this.buffer.append("\n\nORDER BY ");
                boolean flag = false;
                Iterator iterator = unionSelect.orderBy.iterator();
                while (iterator.hasNext()) {
                    if (flag) {
                        this.buffer.append(", ");
                    }
                    SqlOrderByItem orderByIterm = (SqlOrderByItem)iterator.next();
                    this.formatExpr(orderByIterm.expr);
                    if (orderByIterm.chineseOrderByMode == 2) {
                        this.buffer.append(" " + NLSSortType.SCHINESE_PINYIN.getName());
                    }
                    if (orderByIterm.mode == 0) {
                        this.buffer.append(" ASC");
                    } else {
                        this.buffer.append(" DESC");
                    }
                    flag = true;
                }
            }
        }
    }

    public void formatSelectItem(SqlSelectItem item) throws FormaterException {
        if (item.alias != null && item.alias.length() != 0) {
            this.formatExpr(item.expr);
            this.buffer.append(" AS ");
            this.buffer.append(item.alias.toUpperCase());
        } else {
            this.formatExpr(item.expr, false);
        }
    }

    public void formatSelect(SqlSelect select, StringBuffer buffer) throws FormaterException {
        buffer.append("SELECT \n\n");
        List hints = select.getHints();
        if (hints != null && hints.size() > 0) {
            buffer.append("/*+ ");
            for (int i = 0; i < hints.size(); ++i) {
                KHint hint = (KHint)hints.get(i);
                buffer.append(hint.toString());
                buffer.append(" ");
            }
            buffer.append("*/ ");
        }
        if (select.distinct == 1) {
            buffer.append("DISTINCT ");
        } else if (select.distinct != 0) {
            throw new FormaterException("distinct option not support.");
        }
        if (select.limit != null) {
            buffer.append("TOP ");
            buffer.append(select.limit.value);
            buffer.append(" ");
            if (select.limit.type == 1) {
                throw new FormaterException("TOP PERCENT is not support.");
            }
        }
        Iterator iterator = select.selectList.iterator();
        boolean flag = false;
        while (iterator.hasNext()) {
            if (flag) {
                buffer.append(", \n");
            }
            SqlSelectItem item = (SqlSelectItem)iterator.next();
            this.formatSelectItem(item);
            flag = true;
        }
        if (select.tableSource != null) {
            buffer.append("\n\nFROM ");
            this.formatTableSource(select.tableSource);
        }
        if (select.condition != null) {
            buffer.append("\n\nWHERE ");
            this.formatExpr(select.condition);
        }
        if (select.groupBy.size() != 0) {
            buffer.append("\n\nGROUP BY \n");
            flag = false;
            iterator = select.groupBy.iterator();
            while (iterator.hasNext()) {
                if (flag) {
                    buffer.append(",");
                    buffer.append("\n");
                }
                SqlExpr expr = (SqlExpr)iterator.next();
                this.formatExpr(expr);
                flag = true;
            }
        }
        if (select.having != null) {
            buffer.append("\n\nHAVING ");
            this.formatExpr(select.having);
        }
        if (select.orderBy.size() != 0) {
            buffer.append("\n\nORDER BY \n");
            flag = false;
            iterator = select.orderBy.iterator();
            while (iterator.hasNext()) {
                if (flag) {
                    buffer.append(",");
                    buffer.append("\n");
                }
                SqlOrderByItem orderByIterm = (SqlOrderByItem)iterator.next();
                this.formatExpr(orderByIterm.expr);
                if (orderByIterm.chineseOrderByMode == 2) {
                    buffer.append(" " + NLSSortType.SCHINESE_PINYIN.getName());
                }
                if (orderByIterm.mode == 0) {
                    buffer.append(" ASC");
                } else {
                    buffer.append(" DESC");
                }
                flag = true;
            }
        }
    }

    public void formatTableSource(SqlTableSourceBase tableSource) throws FormaterException {
        if (tableSource instanceof SqlTableSource) {
            SqlTableSource simpleTableSource = (SqlTableSource)tableSource;
            this.buffer.append(simpleTableSource.name);
            if (simpleTableSource.alias != null && simpleTableSource.alias.length() != 0) {
                this.buffer.append(" AS ");
                this.buffer.append(simpleTableSource.alias.toUpperCase());
                if (simpleTableSource.lockingHint != null && simpleTableSource.lockingHint.length() > 0) {
                    this.buffer.append(" WITH (");
                    this.buffer.append(simpleTableSource.lockingHint.toUpperCase());
                    this.buffer.append(")");
                }
            }
        } else if (tableSource instanceof SqlJoinedTableSource) {
            SqlJoinedTableSource joinedTable = (SqlJoinedTableSource)tableSource;
            this.formatTableSource(joinedTable.left);
            switch (joinedTable.joinType) {
                case 4: {
                    this.buffer.append("\n\nCROSS JOIN ");
                    break;
                }
                case 3: {
                    this.buffer.append("\n\nFULL OUTER JOIN ");
                    break;
                }
                case 0: {
                    this.buffer.append("\n\nINNER JOIN ");
                    break;
                }
                case 1: {
                    this.buffer.append("\n\nLEFT OUTER JOIN ");
                    break;
                }
                case 2: {
                    this.buffer.append("\n\nRIGHT OUTER JOIN ");
                    break;
                }
                default: {
                    throw new FormaterException("error");
                }
            }
            this.formatTableSource(joinedTable.right);
            if (joinedTable.condition != null) {
                this.buffer.append("\nON ");
                this.formatExpr(joinedTable.condition);
            }
        } else if (tableSource instanceof SqlSubQueryTableSource) {
            SqlSubQueryTableSource subQueryTableSource = (SqlSubQueryTableSource)tableSource;
            this.buffer.append("(");
            this.formatSelectBase(subQueryTableSource.subQuery);
            this.buffer.append(")");
            if (tableSource.alias != null) {
                this.buffer.append(" AS ");
                this.buffer.append(tableSource.alias.toUpperCase());
            }
        } else {
            throw new FormaterException("TODO");
        }
    }

    public void getFromCause(SqlSelect select) throws FormaterException {
        if (select.tableSource != null) {
            this.buffer.append("FROM ");
            this.formatTableSource(select.tableSource);
        }
        String rtnStr = this.buffer.toString();
        rtnStr = rtnStr.replaceAll("\n", " ");
        this.buffer.setLength(0);
        this.buffer.append(rtnStr);
    }

    public void getConditionCause(SqlSelect select) throws FormaterException {
        if (select.condition != null) {
            this.formatExpr(select.condition);
        }
        String rtnStr = this.buffer.toString();
        rtnStr = rtnStr.replaceAll("\n", " ");
        this.buffer.setLength(0);
        this.buffer.append(rtnStr);
    }
}

