/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.query.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.PropertyUnitDele;
import com.kingdee.bos.metadata.query.QueryFieldDele;
import com.kingdee.bos.metadata.query.QueryFilterDele;
import com.kingdee.bos.metadata.query.QueryFilterItemCollectionDele;
import com.kingdee.bos.metadata.query.QueryFilterItemDele;
import com.kingdee.bos.metadata.query.QueryParameterDele;
import com.kingdee.bos.metadata.query.util.AbstractBuilder;
import com.kingdee.bos.metadata.query.util.BuilderState;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.query.util.QueryDeleUtil;
import com.kingdee.bos.metadata.query.util.QuerySqlAccessBase;
import java.util.Map;

class WhereBuilder
extends AbstractBuilder {
    private StringBuffer where = null;
    private boolean bParaType;
    private Map paraMap;

    WhereBuilder(QuerySqlAccessBase qsa) {
        super(qsa);
    }

    @Override
    public String getSql() throws BOSException {
        if (this.where == null) {
            this.buildWhere();
        }
        return this.where.toString();
    }

    void setParam(boolean bParaType, Map paraMap) {
        if (!(this.bParaType == bParaType && (this.paraMap == null && paraMap == null || this.paraMap != null && this.paraMap.equals(paraMap)))) {
            this.bParaType = bParaType;
            this.paraMap = paraMap;
            this.where = null;
        }
    }

    private void buildWhere() throws BOSException {
        this.where = new StringBuffer();
        int paCount = this.query.getParameters().size();
        QueryFilterDele filter = this.getFilter();
        QueryFilterItemCollectionDele items = filter.getFilterItems();
        if (paCount == 0 && items.size() == 0) {
            return;
        }
        this.where.append(" Where ");
        if (items.size() != 0) {
            this.where.append("(");
            if (!this.bParaType) {
                this.where.append(QueryDeleUtil.getFilterString(filter));
            } else {
                this.where.append(QueryDeleUtil.getFilterString(filter, this.bParaType, this.paraMap));
            }
            this.where.append(")");
            if (paCount != 0) {
                this.where.append(" AND ");
            }
        }
        for (int i = 0; i < paCount; ++i) {
            QueryParameterDele qpa = this.query.getParameters().get(i);
            if (i != 0) {
                this.where.append(" AND ");
            }
            this.where.append(QueryDeleUtil.getUnitString(qpa.getQueryField()));
            this.where.append(qpa.getCompareType().getName() + " ? ");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private QueryFilterDele getFilter() throws BOSException {
        QueryFilterDele queryFilter = this.query.getDefaultFilter();
        FilterInfo filter = this.qsa.state.getView().getFilter();
        if (filter == null) {
            return queryFilter;
        }
        QueryFilterDele subFilter = null;
        if (filter.getFilterItems().size() != 0) {
            subFilter = QueryFilterDele.newInstance(this.query);
            subFilter.setFormulaString(filter.getMaskString());
            int n = filter.getFilterItems().size();
            for (int i = 0; i < n; ++i) {
                FilterItemInfo item = filter.getFilterItems().get(i);
                QueryFilterItemDele nitem = QueryFilterItemDele.newInstance(subFilter, this.query.getContext());
                if (!item.isFuncCol()) {
                    PropertyUnitDele fld = null;
                    fld = item.getPropertyName() == null && (CompareType.EXISTS.equals((Object)item.getCompareType()) || CompareType.NOTEXISTS.equals((Object)item.getCompareType())) ? QueryFieldDele.newInstance(this.query) : this.query.getUnits().getIgnoreCase(item.getPropertyName());
                    if (fld == null) {
                        fld = QueryDeleUtil.processPropertyName(this.query, item.getPropertyName(), false);
                    }
                    if (fld == null) throw new BOSException("Can't found the propertyInfo: [" + item.getPropertyName() + "] in query [ " + this.query.getFullName() + "]!");
                    nitem.setCompareValue(item.getCompareValue());
                    nitem.setQueryField(fld);
                    nitem.setCompareType(item.getCompareType());
                } else {
                    nitem.setPropertyName(item.getPropertyName());
                    nitem.setCompareType(item.getCompareType());
                    nitem.setCompareValueIsProperty(false);
                    nitem.setExprReturnType(item.getExprReturnType());
                    nitem.setCompareValue(item.getCompareValue());
                    nitem.setFuncCol(item.isFuncCol());
                }
                if (item.isCompareValueIsProperty()) {
                    PropertyUnitDele fld2 = this.query.getUnits().get(item.getCompareValue().toString());
                    if (fld2 == null) {
                        fld2 = QueryDeleUtil.processPropertyName(this.query, item.getCompareValue().toString(), false);
                    }
                    if (fld2 == null) throw new BOSException("Can't found the compare propertyInfo: [" + item.getCompareValue().toString() + "] in query [ " + this.query.getFullName() + "]!");
                    nitem.setCompareValueIsProperty(true);
                    nitem.setCompareValue(fld2);
                }
                subFilter.getFilterItems().add(nitem);
            }
        }
        if (subFilter == null) return queryFilter;
        if (queryFilter.getFilterItems().size() != 0) {
            queryFilter.mergeFilter(subFilter, "AND");
            return queryFilter;
        } else {
            queryFilter.addFilterItem(subFilter);
        }
        return queryFilter;
    }

    @Override
    public void clear(BuilderState.ChangeEvent e) {
        if (e.type == 0) {
            this.where = null;
        }
    }
}

