/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.report;

import com.kingdee.bos.metadata.report.BIMRptQueryStorage;
import com.kingdee.bos.metadata.report.BIMRptStorage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.log4j.Logger;

public class BIMRptCompress {
    private static Logger logger = Logger.getLogger(BIMRptCompress.class);

    private BIMRptCompress() {
    }

    public static byte[] zipReport(BIMRptStorage rpt) {
        byte[] data = null;
        try {
            ByteArrayOutputStream baOut = new ByteArrayOutputStream();
            GZIPOutputStream gzOut = new GZIPOutputStream(baOut);
            ObjectOutputStream objOut = new ObjectOutputStream(gzOut);
            objOut.writeObject(rpt);
            objOut.flush();
            objOut.close();
            gzOut.close();
            data = baOut.toByteArray();
            baOut.close();
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
        return data;
    }

    public static BIMRptStorage upZipReport(byte[] data) {
        BIMRptStorage rpt = null;
        try {
            ByteArrayInputStream baIn = new ByteArrayInputStream(data);
            GZIPInputStream gzIn = new GZIPInputStream(baIn);
            ObjectInputStream objIn = new ObjectInputStream(gzIn);
            rpt = (BIMRptStorage)objIn.readObject();
            baIn.close();
            gzIn.close();
            objIn.close();
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
        return rpt;
    }

    public static byte[] zipQuery(BIMRptQueryStorage query) {
        byte[] data = null;
        try {
            ByteArrayOutputStream baOut = new ByteArrayOutputStream();
            GZIPOutputStream gzOut = new GZIPOutputStream(baOut);
            ObjectOutputStream objOut = new ObjectOutputStream(gzOut);
            objOut.writeObject(query);
            objOut.flush();
            objOut.close();
            gzOut.close();
            data = baOut.toByteArray();
            baOut.close();
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
        return data;
    }

    public static BIMRptQueryStorage upZipQuery(byte[] data) {
        BIMRptQueryStorage query = null;
        try {
            ByteArrayInputStream baIn = new ByteArrayInputStream(data);
            GZIPInputStream gzIn = new GZIPInputStream(baIn);
            ObjectInputStream objIn = new ObjectInputStream(gzIn);
            query = (BIMRptQueryStorage)objIn.readObject();
            baIn.close();
            gzIn.close();
            objIn.close();
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
        return query;
    }
}

