/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.report;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import org.apache.log4j.Logger;

public class FileUtil {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.metadata.report.FileUtil");

    private FileUtil() {
    }

    public static byte[] loadFile2Stream(String filePath) {
        File f = new File(filePath);
        return FileUtil.loadFile2Stream(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] loadFile2Stream(File file) {
        int len = new Long(file.length()).intValue();
        byte[] template = new byte[len];
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            fis.read(template);
            fis.close();
        }
        catch (FileNotFoundException e) {
            logger.error((Object)e, (Throwable)e);
            byte[] byArray = null;
            return byArray;
        }
        catch (IOException e) {
            logger.error((Object)e, (Throwable)e);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)"close FileInputStream error!", (Throwable)e);
            }
        }
        return template;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadFile2Text(String filePath) {
        StringBuffer sb = new StringBuffer();
        RandomAccessFile file = null;
        try {
            file = new RandomAccessFile(filePath, "r");
            long filePointer = 0L;
            long length = file.length();
            while (filePointer < length) {
                String s = file.readLine();
                sb.append(s).append("\n");
                filePointer = file.getFilePointer();
            }
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
        finally {
            try {
                if (file != null) {
                    file.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)"close RandomAccessFile error!", (Throwable)e);
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void appendText2File(String filePath, String text) {
        RandomAccessFile file = null;
        try {
            File f = new File(filePath);
            if (!f.exists()) {
                f.createNewFile();
            }
            file = new RandomAccessFile(filePath, "rw");
            file.seek(file.length());
            file.write(text.getBytes());
        }
        catch (IOException e) {
            logger.error((Object)e, (Throwable)e);
        }
        finally {
            try {
                if (file != null) {
                    file.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)"close RandomAccessFile error!", (Throwable)e);
            }
        }
    }

    public static byte[] loadStream2byte(InputStream stream) {
        ByteArrayOutputStream swapStream = new ByteArrayOutputStream();
        byte[] buff = new byte[100];
        int rc = 0;
        try {
            while ((rc = stream.read(buff, 0, 100)) > 0) {
                swapStream.write(buff, 0, rc);
            }
        }
        catch (IOException e) {
            logger.error((Object)e, (Throwable)e);
        }
        return swapStream.toByteArray();
    }
}

