/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.resource;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.resource.BizExceptionInfo;
import com.kingdee.bos.metadata.resource.BizExceptionSubItemCollection;
import com.kingdee.bos.metadata.resource.BizExceptionSubItemInfo;
import com.kingdee.util.NumericException;
import com.kingdee.util.NumericExceptionSubItem;
import java.lang.reflect.Constructor;

public class BizExceptionUtil {
    public static NumericException getNumericException(Context ctx, IMetaDataPK bizExcePK, String subCode) throws BOSException {
        BizExceptionInfo bizExce = (BizExceptionInfo)MetaDataLoaderFactory.getMetaDataLoader(ctx).get(MetaDataTypeList.BIZEXCEPTION, bizExcePK);
        if (bizExce != null) {
            BizExceptionSubItemCollection bizSubCollection = bizExce.getBizExceptionSubItems();
            String bizExceItemName = null;
            boolean subCodeFound = false;
            int n = bizSubCollection.size();
            for (int i = 0; i < n; ++i) {
                BizExceptionSubItemInfo bizExceItem = bizSubCollection.get(i);
                if (!bizExceItem.getSubCode().equals(subCode)) continue;
                bizExceItemName = bizExceItem.getName();
                subCodeFound = true;
            }
            if (subCodeFound) {
                String className = bizExce.getClassName();
                NumericExceptionSubItem subItem = new NumericExceptionSubItem(subCode, bizExceItemName);
                Class<?> numericExceClass = null;
                try {
                    numericExceClass = Class.forName(className);
                }
                catch (ClassNotFoundException e) {
                    throw new BOSException("cannot found NumericException class:" + className, (Throwable)e);
                }
                Constructor<?> cons = null;
                NumericException exception = null;
                try {
                    cons = numericExceClass.getConstructor(NumericExceptionSubItem.class);
                    exception = (NumericException)cons.newInstance(subItem);
                }
                catch (Exception e) {
                    throw new BOSException("cannot create NumericException instance", (Throwable)e);
                }
                return exception;
            }
        }
        return null;
    }

    public static NumericException getNumericException(Context ctx, String bizExceFullName, String subCode) throws BOSException {
        return BizExceptionUtil.getNumericException(ctx, MetaDataPK.create(bizExceFullName), subCode);
    }
}

