/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.resource;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.xml.impl.MetadataCleaner;
import com.kingdee.bos.dao.xml.impl.MetadataClearListener;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueCollection;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.metadata.resource.DynamicEnumDAO;
import com.kingdee.bos.metadata.resource.EnumResource;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.enums.DynamicEnum;
import com.kingdee.util.enums.Enum;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class DynamicEnumAssist
extends DynamicEnum.DynamicAssist {
    private static final Logger logger = Logger.getLogger(DynamicEnumAssist.class);
    private final Map<String, EnumResource> cache = new HashMap<String, EnumResource>();

    DynamicEnumAssist(String pk) {
        super(pk);
    }

    protected void initEnum() {
        this.init(ConfigMDUtil.getAIS());
    }

    private synchronized void init(String ais) {
        if (this.cache.containsKey(ais)) {
            return;
        }
        if (ConfigMDUtil.isClient()) {
            try {
                EnumResource er = DynamicEnumDAO.getRemoteInstance().getEnumResource(this.pk);
                er.createEnum();
                this.cache.put(ais, er);
            }
            catch (BOSException e) {
                logger.error((Object)"DynamicEnumAssist init enum error.", (Throwable)e);
                this.cache.put(ais, EnumResource.NULL);
            }
        } else {
            this.cache.put(ais, DynamicEnumAssist.create(this.pk));
        }
    }

    private static EnumResource create(String pk) {
        BizEnumValueCollection valueCol;
        BizEnumInfo bizEnum = MetaDataLoaderFactory.getLocalMetaDataLoader(ConfigMDUtil.getContext()).getEnum(MetaDataPK.create(pk));
        if (bizEnum != null && (valueCol = bizEnum.getEnumValue()) != null && valueCol.size() > 0) {
            HashMap<String, Map<String, String>> resources = new HashMap<String, Map<String, String>>(3);
            int size = valueCol.size();
            for (int i = 0; i < size; ++i) {
                Locale[] locales;
                BizEnumValueInfo valueInfo = valueCol.get(i);
                String v = valueInfo.getString();
                if (v == null) {
                    v = Integer.toString(valueInfo.getInt());
                }
                new DynamicEnum(pk, valueInfo.getName(), v);
                for (Locale l : locales = valueInfo.getCurrentLocales()) {
                    HashMap<String, String> rs = (HashMap<String, String>)resources.get(LocaleUtils.getLocaleString((Locale)l));
                    if (rs == null) {
                        rs = new HashMap<String, String>(4);
                        resources.put(LocaleUtils.getLocaleString((Locale)l), rs);
                    }
                    rs.put(valueInfo.getName(), valueInfo.getAlias(l));
                }
            }
            return new EnumResource(DynamicEnum.getEnumList((String)pk), resources);
        }
        return EnumResource.NULL;
    }

    synchronized EnumResource getEnumResource(Context ctx) {
        String ais = ctx != null ? ctx.getAIS() : ConfigMDUtil.getAIS();
        EnumResource er = this.cache.get(ais);
        while (er == null) {
            this.init(ais);
            er = this.cache.get(ais);
        }
        return er;
    }

    protected boolean isKeyErasable() {
        return true;
    }

    protected String getKey() {
        String ais = ConfigMDUtil.getAIS();
        return ais + "$" + this.pk;
    }

    protected String getResource(String name, Locale locale) {
        EnumResource er = this.getEnumResource(null);
        if (er.resources != null) {
            Map<String, String> rs;
            if (locale == null && (locale = ContextUtils.getOriginalLocaleFromEnv()) == null) {
                locale = LocaleUtils.getDefaultOriginLocale();
            }
            if ((rs = er.resources.get(LocaleUtils.getLocaleString((Locale)locale))) != null) {
                return rs.get(name);
            }
        }
        return null;
    }

    static {
        DynamicEnum.DynamicAssist.registerFactory((DynamicEnum.DynamicAssist.Factory)new MDEnumAssisFactory());
        MetadataCleaner.registerListener(new MetadataClearListener(){

            @Override
            public void clearAll() {
                MDEnumAssisFactory.clear();
            }

            @Override
            public void clear(String key) {
            }
        });
    }

    static class MDEnumAssisFactory
    implements DynamicEnum.DynamicAssist.Factory {
        private static final Map<String, DynamicEnumAssist> cache = new HashMap<String, DynamicEnumAssist>();

        MDEnumAssisFactory() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DynamicEnum.DynamicAssist getInstance(String pk) {
            DynamicEnumAssist assist = cache.get(pk);
            if (assist == null) {
                Map<String, DynamicEnumAssist> map = cache;
                synchronized (map) {
                    assist = cache.get(pk);
                    if (assist == null) {
                        assist = new DynamicEnumAssist(pk);
                        cache.put(pk, assist);
                    }
                }
            }
            return assist;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void clear() {
            Map<String, DynamicEnumAssist> map = cache;
            synchronized (map) {
                Enum.clear();
                cache.clear();
            }
        }
    }
}

