/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.rule;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.IBOSObject;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.management.application.MetaDataInfo;
import com.kingdee.bos.metadata.rule.Result;
import com.kingdee.bos.metadata.rule.RuleExecuteException;
import com.kingdee.bos.metadata.rule.RuleInfo;
import com.kingdee.bos.metadata.rule.RulePropertyInfo;
import com.kingdee.bos.metadata.rule.RuleUtils;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.Assert;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Scriptable;

public class RuleExecutor {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.metadata.rule.RuleExecutor");
    private org.mozilla.javascript.Context ctx = null;
    private Scriptable scope = null;
    private String script = null;
    private Context userContext = null;
    private RuleInfo rule = null;

    public RuleExecutor() {
        this.init();
    }

    public RuleExecutor(Context userContext, IMetaDataPK rulePK) {
        this(userContext, MetaDataLoaderFactory.getLocalMetaDataLoader(userContext).getRule(rulePK));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RuleExecutor(Context userContext, RuleInfo rule) {
        this.init();
        this.rule = rule;
        if (rule == null) {
            Assert.that((boolean)false, (String)"rule cannot be null!");
        }
        RuleUtils.compile(rule);
        this.script = rule.getScript();
        org.mozilla.javascript.Context.enter((org.mozilla.javascript.Context)this.ctx);
        try {
            this.setUserContext(userContext);
            logger.debug((Object)this.script);
            this.ctx.evaluateString(this.scope, this.script, "rule", 1, null);
        }
        catch (Exception e) {
            logger.error((Object)e);
            Assert.that((boolean)false, (String)e.getMessage());
        }
        finally {
            org.mozilla.javascript.Context.exit();
        }
    }

    public RuleExecutor(String script) {
        this(null, script);
    }

    public RuleExecutor(Context userContext, String script) {
        this.init();
        this.script = script;
        this.setUserContext(userContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerFunction(String function) {
        org.mozilla.javascript.Context.enter((org.mozilla.javascript.Context)this.ctx);
        try {
            logger.debug((Object)function);
            this.ctx.evaluateString(this.scope, function, "rule", 1, null);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.error((Object)e);
            boolean bl = false;
            return bl;
        }
        finally {
            org.mozilla.javascript.Context.exit();
        }
    }

    public void setUserContext(Context userContext) {
        this.userContext = null;
        if (userContext == null) {
            return;
        }
        org.mozilla.javascript.Context.enter((org.mozilla.javascript.Context)this.ctx);
        try {
            this.scope.delete("CONTEXT");
            this.inner_AddParameter("CONTEXT", userContext);
        }
        catch (Exception e) {
            logger.error((Object)e);
            Assert.that((boolean)false, (String)e.getMessage());
        }
        finally {
            org.mozilla.javascript.Context.exit();
        }
    }

    public Result executeFunction(String functionName) throws RuleExecuteException {
        org.mozilla.javascript.Context.enter((org.mozilla.javascript.Context)this.ctx);
        try {
            this.setUp();
            Object fObj = this.scope.get(functionName, this.scope);
            if (!(fObj instanceof Function)) {
                Assert.that((boolean)false, (String)("Invalidate functionName : " + functionName));
                Result result = null;
                return result;
            }
            Function f = (Function)fObj;
            Object result = f.call(this.ctx, this.scope, this.scope, null);
            this.scope.put("RESULT", this.scope, result);
            this.tearDown();
            Result result2 = new Result(this.rule, this.scope);
            return result2;
        }
        catch (JavaScriptException e) {
            throw new RuleExecuteException(e.getMessage());
        }
        finally {
            org.mozilla.javascript.Context.exit();
        }
    }

    public Result execute(String script) throws RuleExecuteException {
        return this.execute(this.userContext, script);
    }

    public Result execute() throws RuleExecuteException {
        return this.execute(this.userContext, this.script);
    }

    public Result execute(Context userContext, String script) throws RuleExecuteException {
        this.script = script;
        org.mozilla.javascript.Context.enter((org.mozilla.javascript.Context)this.ctx);
        try {
            this.setUp();
            this.setUserContext(userContext);
            Object result = this.ctx.evaluateString(this.scope, script, "rule", 1, null);
            this.scope.put("RESULT", this.scope, result);
            this.tearDown();
            Result result2 = new Result(null, this.scope);
            return result2;
        }
        catch (JavaScriptException e) {
            throw new RuleExecuteException(e.getMessage());
        }
        finally {
            org.mozilla.javascript.Context.exit();
        }
    }

    protected void init() {
        this.ctx = org.mozilla.javascript.Context.enter(null);
        this.scope = this.ctx.initStandardObjects(null);
        try {
            this.initInnerParameter();
        }
        catch (Exception e) {
            Assert.that((boolean)false, (String)e.getMessage());
        }
        finally {
            org.mozilla.javascript.Context.exit();
        }
    }

    public void addParameter(String propName, Object obj) {
        if (StringUtils.isEmpty((String)propName)) {
            Assert.that((boolean)false, (String)"Invalidate parameter!");
        }
        if (this.rule != null) {
            boolean flag = false;
            int n = this.rule.getRuleProperties().size();
            for (int i = 0; i < n; ++i) {
                RulePropertyInfo prop = this.rule.getRuleProperties().get(i);
                if (!prop.isSetter() || !prop.getName().equalsIgnoreCase(propName)) continue;
                flag = true;
                break;
            }
            if (!flag) {
                Assert.that((boolean)false, (String)"The property isn't defined or the property's isSetter() == false");
            }
        }
        this.inner_AddParameter(propName, obj);
    }

    protected void initInnerParameter() {
        if (this.rule == null) {
            return;
        }
        if (this.userContext == null) {
            Assert.that((boolean)false, (String)"User context cannot be null!");
        }
        int n = this.rule.getRuleProperties().size();
        for (int i = 0; i < n; ++i) {
            RulePropertyInfo prop = this.rule.getRuleProperties().get(i);
            if (prop.isSetter() || prop.getMetaEntity() == null) continue;
            try {
                MetaDataInfo meta = prop.getMetaEntity();
                IBOSObject bosObj = BOSObjectFactory.createBOSObject(this.userContext, BOSObjectType.create((String)meta.getMetaDataType()));
                Scriptable jsArgs = org.mozilla.javascript.Context.toObject((Object)bosObj, (Scriptable)this.scope);
                this.scope.put(prop.getName(), this.scope, (Object)jsArgs);
                continue;
            }
            catch (BOSException bose) {
                logger.error((Object)bose);
            }
        }
    }

    private void inner_AddParameter(String propName, Object obj) {
        this.ctx = org.mozilla.javascript.Context.enter((org.mozilla.javascript.Context)this.ctx);
        if (obj != null) {
            Scriptable jsArgs = org.mozilla.javascript.Context.toObject((Object)obj, (Scriptable)this.scope);
            this.scope.put(propName, this.scope, (Object)jsArgs);
        } else {
            this.scope.put(propName, this.scope, null);
        }
        org.mozilla.javascript.Context.exit();
    }

    private void setUp() throws JavaScriptException {
        org.mozilla.javascript.Context.enter((org.mozilla.javascript.Context)this.ctx);
        try {
            Object fObj = this.scope.get("setUp", this.scope);
            if (fObj != null && fObj instanceof Function) {
                Function f = (Function)fObj;
                f.call(this.ctx, this.scope, this.scope, null);
            }
        }
        finally {
            org.mozilla.javascript.Context.exit();
        }
    }

    private void tearDown() throws JavaScriptException {
        org.mozilla.javascript.Context.enter((org.mozilla.javascript.Context)this.ctx);
        try {
            Object fObj = this.scope.get("tearDown", this.scope);
            if (fObj != null && fObj instanceof Function) {
                Function f = (Function)fObj;
                f.call(this.ctx, this.scope, this.scope, null);
            }
        }
        finally {
            org.mozilla.javascript.Context.exit();
        }
    }
}

