/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.rule.formula;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.rule.formula.CompileException;
import com.kingdee.bos.metadata.rule.formula.Function;
import com.kingdee.bos.metadata.rule.formula.SystemFunctions;
import com.kingdee.bos.metadata.rule.formula.SystemObjects;
import com.kingdee.util.InvalidDataException;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;

public class Compiler {
    public static final String META = "META";
    public static final String THIS = "THIS";
    public static final String PROPERTIES = "PROPERTIES";
    public static final String SYSTEMFUNCTIONBODY = "SYSTEMFUNCTIONBODY";

    public static String compile(Context ctx, String formula, IObjectValue ov) {
        if (StringUtils.isEmpty((String)formula)) {
            return formula;
        }
        String script = formula;
        if (script.trim().charAt(script.trim().length() - 1) != ';') {
            script = script + ';';
        }
        Map _context = Compiler.initCompileContext(ctx, script, ov);
        script = Compiler.processVariables(_context, script);
        script = Compiler.processSystemObjects(_context, script);
        script = Compiler.processSystemFunctions(_context, script);
        script = Compiler.generateSystemFunctionBodies(_context, script);
        return script;
    }

    private static String generateSystemFunctionBodies(Map _context, String script) {
        Map sysFuncs = (Map)_context.get(SYSTEMFUNCTIONBODY);
        if (sysFuncs == null || sysFuncs.size() <= 0) {
            return script;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(script);
        Iterator it = sysFuncs.entrySet().iterator();
        while (it.hasNext()) {
            sb.append("\n");
            sb.append((String)it.next().getValue());
        }
        return sb.toString();
    }

    private static String processSystemObjects(Map _context, String script) {
        StringBuffer sb = new StringBuffer();
        String tmp = script;
        int[] index = new int[]{0};
        while (index[0] < tmp.length()) {
            char c = tmp.charAt(index[0]);
            if (Character.isJavaIdentifierStart(c)) {
                int i = index[0];
                index[0] = index[0] + 1;
                while (index[0] < tmp.length()) {
                    c = tmp.charAt(index[0]);
                    if (!Character.isJavaIdentifierPart(c)) {
                        sb.append(SystemObjects.getObjectCode(tmp.substring(i, index[0])));
                        sb.append(tmp.substring(index[0], index[0] + 1));
                        break;
                    }
                    if (index[0] == tmp.length() - 1) {
                        sb.append(tmp.substring(i, index[0]));
                        break;
                    }
                    index[0] = index[0] + 1;
                }
            } else {
                sb.append(c);
            }
            index[0] = index[0] + 1;
        }
        return sb.toString();
    }

    private static String processSystemFunctions(Map _context, String script) {
        StringBuffer sb = new StringBuffer();
        String tmp = script;
        int[] index = new int[]{0};
        while (index[0] < tmp.length()) {
            char c = tmp.charAt(index[0]);
            int i = index[0];
            if (Character.isJavaIdentifierStart(c)) {
                while (index[0] < tmp.length()) {
                    c = tmp.charAt(index[0]);
                    if (!Character.isJavaIdentifierPart(c)) {
                        if (c == '(') {
                            sb.append(Compiler.processFunction(_context, tmp, i, index));
                            i = index[0] + 1;
                            break;
                        }
                        sb.append(tmp.substring(i, index[0] + 1));
                        i = index[0] + 1;
                    } else if (index[0] == tmp.length() - 1) {
                        sb.append(tmp.substring(i, index[0]) + 1);
                        break;
                    }
                    index[0] = index[0] + 1;
                }
            } else {
                sb.append(c);
            }
            index[0] = index[0] + 1;
        }
        return sb.toString();
    }

    private static String processFunction(Map _context, String script, int i, int[] index) {
        String funcName = script.substring(i, index[0]);
        Function func = SystemFunctions.getFunction(_context, funcName);
        int start = i;
        if (func != null) {
            start = index[0] + 1;
            while (index[0] < script.length()) {
                char c = script.charAt(index[0]);
                if (c == '\"') {
                    Compiler.getString(script, index);
                } else {
                    if (c == ')') {
                        func.addParameter(script.substring(start, index[0]));
                        Hashtable<String, String> bodies = (Hashtable<String, String>)_context.get(SYSTEMFUNCTIONBODY);
                        if (bodies == null) {
                            bodies = new Hashtable<String, String>();
                            _context.put(SYSTEMFUNCTIONBODY, bodies);
                        }
                        bodies.put(func.getName(), func.generateBodyCode());
                        return func.generateCallCode();
                    }
                    if (c == ',') {
                        func.addParameter(script.substring(start, index[0]));
                        index[0] = index[0] + 1;
                        start = index[0];
                    }
                }
                index[0] = index[0] + 1;
            }
        } else {
            while (index[0] < script.length()) {
                char c = script.charAt(index[0]);
                if (c == ')') {
                    return script.substring(start, index[0] + 1);
                }
                index[0] = index[0] + 1;
            }
        }
        throw new CompileException("Invalidate function define!");
    }

    private static String getParameter(String script, int[] index) {
        return null;
    }

    private static String getString(String script, int[] index) {
        int i = index[0];
        while (index[0] < script.length()) {
            char c = script.charAt(index[0]);
            if (c == '\\') {
                index[0] = index[0] + 1;
            } else if (c == '\"') {
                index[0] = index[0] + 1;
                return script.substring(i, index[0]);
            }
            index[0] = index[0] + 1;
        }
        throw new CompileException("Unclosed quote!");
    }

    private static String getChar(String script, int[] index) {
        char c;
        int i = index[0];
        if (index[0] + 2 < script.length() && (c = script.charAt(index[0] + 2)) == '\'') {
            index[0] = index[0] + 2;
            return script.substring(i, index[0]);
        }
        throw new CompileException("Unclosed single quote!");
    }

    private static String processVariables(Map _context, String script) {
        StringBuffer sb = new StringBuffer();
        int[] index = new int[]{script.indexOf(91)};
        while (index[0] != -1) {
            sb.append(script.substring(0, index[0]));
            sb.append(Compiler.processVariable(_context, script, index));
            script = script.substring(index[0], script.length());
        }
        sb.append(script);
        return sb.toString();
    }

    private static String processVariable(Map _context, String script, int[] index) {
        int i = index[0];
        StringBuffer sb = new StringBuffer();
        String tmp = script;
        index[0] = index[0] + 1;
        while (index[0] < tmp.length()) {
            char c = tmp.charAt(index[0]);
            if (c == '\"') {
                Compiler.getString(tmp, index);
            } else if (c == '\\') {
                index[0] = index[0] + 1;
            } else if (c == '\'') {
                Compiler.getChar(tmp, index);
            } else if (c == ']') {
                sb.append(tmp.substring(i, index[0] + 1));
                index[0] = index[0] + 1;
                break;
            }
            index[0] = index[0] + 1;
        }
        if (StringUtils.isEmpty((String)sb.toString())) {
            throw new CompileException("Cannot found ] in script");
        }
        return Compiler.translateVariable(_context, sb.toString());
    }

    private static String translateVariable(Map _context, String variable) {
        StringBuffer sb = new StringBuffer();
        String tmp = variable.substring(1, variable.length() - 1);
        StringTokenizer token = new StringTokenizer(tmp, ".");
        EntityObjectInfo entity = (EntityObjectInfo)_context.get(META);
        PropertyCollection props = (PropertyCollection)_context.get(PROPERTIES);
        int n = token.countTokens();
        for (int i = 0; i < n; ++i) {
            String var = token.nextToken().trim();
            boolean flag = false;
            for (int j = 0; j < props.size(); ++j) {
                PropertyInfo prop = props.get(j);
                String key = prop.getName();
                String alias = prop.getAlias();
                if (key != null && var.startsWith(key) || !StringUtils.isEmpty((String)alias) && var.startsWith(alias)) {
                    sb.append(i == 0 ? "SOURCE." + key : "." + key);
                    if (prop instanceof OwnPropertyInfo) {
                        props = null;
                    } else if (prop instanceof LinkPropertyInfo) {
                        RelationshipInfo relation = ((LinkPropertyInfo)prop).getRelationship();
                        if (relation.getClientObject().equals(entity)) {
                            entity = relation.getSupplierObject();
                            props = entity.getInheritedProperties();
                        } else {
                            entity = relation.getClientObject();
                            props = entity.getInheritedProperties();
                        }
                    }
                    flag = true;
                    break;
                }
                if (!var.startsWith("get") || i == 0) continue;
                sb.append("." + var);
                flag = true;
                break;
            }
            if (flag) continue;
            return variable;
        }
        return sb.toString();
    }

    private static Map initCompileContext(Context ctx, String formula, IObjectValue ov) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        EntityObjectInfo entity = MetaDataLoaderFactory.getMetaDataLoader(ctx).getEntity(ov.getBOSType());
        if (entity == null) {
            throw new InvalidDataException("Cannot load entity [" + ov.getBOSType() + "] from cache!");
        }
        PropertyCollection props = entity.getInheritedProperties();
        context.put(META, entity);
        context.put(THIS, ov);
        context.put(PROPERTIES, props);
        return context;
    }

    static {
        SystemObjects.registerObjects();
        SystemFunctions.regsterFunctions();
    }
}

