/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.ui;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.xml.IXMLDAO;
import com.kingdee.bos.dao.xml.XMLDAO;
import com.kingdee.bos.metadata.AbstractMetaDataCtrl;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bizrule.RuleSetInfo;
import com.kingdee.bos.metadata.bizrule.common.AbstractExpressionInfo;
import com.kingdee.bos.metadata.bizrule.common.ActionCollection;
import com.kingdee.bos.metadata.bizrule.common.ActionInfo;
import com.kingdee.bos.metadata.bizrule.common.ConditionCollection;
import com.kingdee.bos.metadata.bizrule.common.ConditionInfo;
import com.kingdee.bos.metadata.bizrule.common.ExpressionCollection;
import com.kingdee.bos.metadata.bizrule.common.ExpressionType;
import com.kingdee.bos.metadata.bizrule.common.GroupExpressionInfo;
import com.kingdee.bos.metadata.bizrule.common.MethodInfo;
import com.kingdee.bos.metadata.bizrule.common.ParameterCollection;
import com.kingdee.bos.metadata.bizrule.common.SimpleExpressionInfo;
import com.kingdee.bos.metadata.code.CodeFactory;
import com.kingdee.bos.metadata.management.DeployOptionInfo;
import com.kingdee.bos.metadata.ui.ComponentCollection;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.EventBindingInfo;
import com.kingdee.bos.metadata.ui.IUIObjectCtrl;
import com.kingdee.bos.metadata.ui.UIObjectAssembler;
import com.kingdee.bos.metadata.ui.UIObjectCollection;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class UIObjectCtrl
extends AbstractMetaDataCtrl
implements IUIObjectCtrl {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.metadata.ui.UIObjectCtrl");
    public static final String UI_TYPE = "uitype";
    public static final String EVENT_SCENCE = "scene";
    public static final String EVENT_SCENCE_SERVER = "server";
    public static final String EVENT_SCENCE_CLIENT = "client";
    public static final String UI_TYPE_WEBFORM = "WebForm";
    public static final String UI_TYPE_GUIPANEL = "GuiPanel";

    public UIObjectCtrl(Context ctx) {
        super(ctx);
        super.registerInterface(IUIObjectCtrl.class, (Object)this);
        this.loadSelfMetametaData(MetaDataPK.create("metametadata.bizrule", "simpleExpression"));
        this.loadSelfMetametaData(MetaDataPK.create("metametadata.bizrule", "groupExpression"));
        this.loadSelfMetametaData(MetaDataPK.create("metametadata.bizrule", "constraintRule"));
        this.loadSelfMetametaData(MetaDataPK.create("metametadata.bizrule", "computationRule"));
        this.loadSelfMetametaData(MetaDataPK.create("metametadata.bizrule", "conditionRule"));
        this.loadSelfMetametaData(MetaDataPK.create("metametadata.bizrule", "ruleSet"));
        this.loadSelfMetametaData(MetaDataPK.create("metametadata.ui", "uiObject"));
    }

    public UIObjectCtrl() {
        super.registerInterface(IUIObjectCtrl.class, (Object)this);
    }

    @Override
    public BOSObjectType getType() {
        return MetaDataTypeList.UIOBJECT;
    }

    @Override
    public void addnew(IMetaDataPK pk, UIObjectInfo uiObjectInfo) throws BOSException {
        ComponentCollection components = uiObjectInfo.getComponents();
        uiObjectInfo.setComponents(UIObjectCtrl.treeToCol(components));
        this.getDAO().addnew(pk, uiObjectInfo);
        uiObjectInfo.setComponents(components);
    }

    @Override
    public IMetaDataPK addnew(UIObjectInfo uiObjectInfo) throws BOSException {
        ComponentCollection components = uiObjectInfo.getComponents();
        uiObjectInfo.setComponents(UIObjectCtrl.treeToCol(components));
        IMetaDataPK metaDataPK = (IMetaDataPK)this.getDAO().addnew(uiObjectInfo);
        uiObjectInfo.setComponents(components);
        return metaDataPK;
    }

    @Override
    public void remove(IMetaDataPK metaType) throws BOSException {
        this.getDAO().delete(metaType);
    }

    @Override
    public void update(IMetaDataPK metaType, UIObjectInfo uiObjectInfo) throws BOSException {
        UIObjectInfo model = uiObjectInfo;
        if (model.isAssembled()) {
            model = UIObjectAssembler.parseUI(this.getContext(), model);
        }
        this.getDAO().update(metaType, model);
    }

    @Override
    public boolean exists(IMetaDataPK metaType) throws BOSException {
        return this.getDAO().exists(metaType);
    }

    @Override
    public UIObjectInfo getValue(IMetaDataPK metaType) throws BOSException {
        UIObjectInfo uiObjectInfo = (UIObjectInfo)this.getDAO().getValue(metaType);
        this.afterLoad(uiObjectInfo);
        return uiObjectInfo;
    }

    @Override
    public synchronized UIObjectInfo getValueNotCache(IMetaDataPK metaType) throws BOSException {
        XMLDAO.clearCache(this.getContext(), MetaDataTypeList.UIOBJECT);
        UIObjectInfo uiObjectInfo = (UIObjectInfo)this.getDAO().getValue(metaType);
        XMLDAO.clearCache(this.getContext(), MetaDataTypeList.UIOBJECT);
        this.afterLoad(uiObjectInfo);
        return uiObjectInfo;
    }

    @Override
    public UIObjectInfo getAllValue(IMetaDataPK metaType) throws BOSException {
        return this.getAllValue(metaType, true);
    }

    @Override
    public UIObjectInfo getAllValue(IMetaDataPK metaType, boolean isClearCache) throws BOSException {
        long startTime = 0L;
        startTime = System.currentTimeMillis();
        UIObjectInfo uiObjectInfo = isClearCache ? this.getValueNotCache(metaType) : this.getValue(metaType);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\u88c5\u8f7d\u5143\u6570\u636e" + metaType.getFullName() + "\u5171\u8017\u65f6\uff1a" + (System.currentTimeMillis() - startTime)));
            startTime = System.currentTimeMillis();
        }
        uiObjectInfo = UIObjectAssembler.assembleUI(this.getContext(), uiObjectInfo);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\u62fc\u88c5\u5b8c\u6574UI\u5bf9\u8c61" + metaType.getFullName() + "\u5171\u8017\u65f6\uff1a" + (System.currentTimeMillis() - startTime)));
        }
        return uiObjectInfo;
    }

    private UIObjectInfo getUncheckValue(IMetaDataPK metaType) throws BOSException {
        long startTime = System.currentTimeMillis();
        UIObjectInfo uiObjectInfo = this.getValueNotCache(metaType);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\u53d1\u5e03UI " + metaType.getFullName() + "\u8fc7\u7a0b\u4e2d\uff0c\u88c5\u8f7dUI\u5171\u8017\u65f6\uff1a" + (System.currentTimeMillis() - startTime)));
            startTime = System.currentTimeMillis();
        }
        uiObjectInfo = UIObjectAssembler.assembleUI(this.getContext(), uiObjectInfo);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\u53d1\u5e03UI " + metaType.getFullName() + "\u8fc7\u7a0b\u4e2d\uff0c\u62fc\u88c5UI\u5171\u8017\u65f6\uff1a" + (System.currentTimeMillis() - startTime)));
        }
        return uiObjectInfo;
    }

    public UIObjectCollection getCollection() throws BOSException {
        UIObjectCollection uiObjects = (UIObjectCollection)this.getDAO().getCollection();
        int n = uiObjects.size();
        for (int i = 0; i < n; ++i) {
            UIObjectInfo uiObjectInfo = uiObjects.get(i);
            this.versionUpdate(uiObjectInfo);
            uiObjectInfo.setComponents(this.colToTree(uiObjectInfo.getComponents()));
            this.afterLoad(uiObjectInfo);
        }
        return uiObjects;
    }

    public UIObjectCollection getCollection(String pgName) throws BOSException {
        UIObjectCollection uiObjects = (UIObjectCollection)((IXMLDAO)this.getDAO()).getCollection(pgName);
        int n = uiObjects.size();
        for (int i = 0; i < n; ++i) {
            UIObjectInfo uiObjectInfo = uiObjects.get(i);
            this.versionUpdate(uiObjectInfo);
            uiObjectInfo.setComponents(this.colToTree(uiObjectInfo.getComponents()));
            this.afterLoad(uiObjectInfo);
        }
        return uiObjects;
    }

    @Override
    public IMetaDataPK[] getPKList() throws BOSException {
        return (IMetaDataPK[])this.getDAO().getPKList();
    }

    @Override
    public IMetaDataPK[] getPKList(String pgName) throws BOSException {
        return (IMetaDataPK[])((IXMLDAO)this.getDAO()).getPKList(pgName);
    }

    @Override
    public IObjectValue load(InputStream is) throws DataAccessException {
        UIObjectInfo uiObjectInfo = (UIObjectInfo)super.load(is);
        this.afterLoad(uiObjectInfo);
        return uiObjectInfo;
    }

    UIObjectInfo _load(IMetaDataPK metaType) throws BOSException {
        return this.getValueNotCache(metaType);
    }

    @Override
    public void store(IObjectValue ov, OutputStream os) throws DataAccessException {
        super.store(ov, os);
    }

    private String getObjectID(IObjectValue info) {
        if (info == null) {
            return null;
        }
        String id = info.getString("id");
        if (StringUtils.isEmpty((String)id)) {
            id = Uuid.create().toString();
            info.setString("id", id);
        }
        return id;
    }

    private Hashtable transToHashtable(IObjectCollection col) {
        Hashtable<String, IObjectValue> table = new Hashtable<String, IObjectValue>();
        if (col != null) {
            int m = col.size();
            for (int j = 0; j < m; ++j) {
                String id = this.getObjectID(col.getObject(j));
                table.put(id, col.getObject(j));
            }
        }
        return table;
    }

    private void setExpressionsToMethod(MethodInfo methodInfo, ExpressionCollection expCol, Hashtable table) {
        if (methodInfo == null) {
            return;
        }
        ParameterCollection paramCol = methodInfo.getParameters();
        int m = paramCol.size();
        for (int i = 0; i < m; ++i) {
            String expressionID = paramCol.get(i).getString("expressionID");
            paramCol.get(i).setExpression((AbstractExpressionInfo)table.get(expressionID));
        }
    }

    private void setExpressionsToExp(AbstractExpressionInfo expInfo, ExpressionCollection expCol, Hashtable table) {
        String id = expInfo.getString("id");
        if (expInfo instanceof GroupExpressionInfo) {
            GroupExpressionInfo geInfo = (GroupExpressionInfo)expInfo;
            geInfo.getExpressions().clear();
            int n = expCol.size();
            for (int i = 0; i < n; ++i) {
                String parentID = expCol.get(i).getString("parentID");
                if (!id.equals(parentID)) continue;
                geInfo.getExpressions().add(expCol.get(i));
            }
        } else if (expInfo instanceof SimpleExpressionInfo) {
            String ownerID;
            SimpleExpressionInfo seInfo = (SimpleExpressionInfo)expInfo;
            if (seInfo.getType() == ExpressionType.METHODINVOKE) {
                String ownerID2;
                if (seInfo.getMethod() != null && !StringUtils.isEmpty((String)(ownerID2 = seInfo.getMethod().getString("ownerID")))) {
                    seInfo.getMethod().setOwner((SimpleExpressionInfo)table.get(ownerID2));
                }
                this.setExpressionsToMethod(seInfo.getMethod(), expCol, table);
            } else if (seInfo.getType() == ExpressionType.PROPERTYACCESS && seInfo.getProperty() != null && !StringUtils.isEmpty((String)(ownerID = seInfo.getProperty().getString("ownerID")))) {
                seInfo.getProperty().setOwner((SimpleExpressionInfo)table.get(ownerID));
            }
        }
    }

    private void afterLoad(UIObjectInfo info) {
        ConditionCollection conditions;
        RuleSetInfo rsInfo = info.getRuleSet();
        if (rsInfo == null || rsInfo.getBoolean("_hasReConstruct")) {
            return;
        }
        ExpressionCollection expCol = (ExpressionCollection)rsInfo.get("expressions");
        if (expCol == null) {
            expCol = new ExpressionCollection();
        }
        Hashtable expTable = this.transToHashtable(expCol);
        int n = expCol.size();
        for (int i = 0; i < n; ++i) {
            this.setExpressionsToExp(expCol.get(i), expCol, expTable);
        }
        ActionCollection actions = (ActionCollection)rsInfo.get("actions");
        if (actions != null) {
            int n2 = actions.size();
            for (int i = 0; i < n2; ++i) {
                ActionInfo action = actions.get(i);
                String expressionID = action.getString("expressionID");
                if (StringUtils.isEmpty((String)expressionID)) continue;
                action.setExpression((AbstractExpressionInfo)expTable.get(expressionID));
            }
        }
        if ((conditions = (ConditionCollection)rsInfo.get("conditions")) != null) {
            int n3 = conditions.size();
            for (int i = 0; i < n3; ++i) {
                ConditionInfo condition = conditions.get(i);
                String expressionID = condition.getString("expressionID");
                if (StringUtils.isEmpty((String)expressionID)) continue;
                condition.setExpression((AbstractExpressionInfo)expTable.get(expressionID));
            }
        }
        rsInfo.setBoolean("_hasReConstruct", true);
    }

    private void versionUpdate(UIObjectInfo info) {
        String oldControlPackage = "com.kingdee.bos.ui.swing";
        String oldControlPrefix = "com.kingdee.bos.ui.swing.T";
        String newControlPrefix = "com.kingdee.bos.ctrl.swing.KD";
        String oldTTableName = "com.kingdee.bos.ui.swing.TTable";
        String newTTableName = "com.kingdee.bos.ctrl.swing.TTable";
        String oldKDTableName = "com.kingdee.bos.ctrl.kdf.kdtable.KDTable";
        String newKDTableName = "com.kingdee.bos.ctrl.kdf.table.KDTable";
        Hashtable<String, String> adapterMap = new Hashtable<String, String>();
        adapterMap.put("java.awt.event.HierarchyBoundsListener", "java.awt.event.HierarchyBoundsAdapter");
        adapterMap.put("java.awt.event.ContainerListener", "java.awt.event.ContainerAdapter");
        adapterMap.put("java.awt.event.FocusListener", "java.awt.event.FocusAdapter");
        adapterMap.put("java.awt.event.KeyListener", "java.awt.event.KeyAdapter");
        adapterMap.put("java.awt.event.MouseListener", "java.awt.event.MouseAdapter");
        adapterMap.put("java.awt.event.MouseMotionListener", "java.awt.event.MouseMotionAdapter");
        adapterMap.put("java.awt.event.ComponentListener", "java.awt.event.ComponentAdapter");
        adapterMap.put("java.awt.dnd.DragSourceListener", "java.awt.dnd.DragSourceAdapter");
        adapterMap.put("java.awt.dnd.DropTargetListener", "java.awt.dnd.DropTargetAdapter");
        adapterMap.put("javax.swing.event.InternalFrameListener", "javax.swing.event.InternalFrameAdapter");
        adapterMap.put("javax.swing.event.MouseInputListener", "javax.swing.event.MouseInputAdapter");
        adapterMap.put("java.awt.event.WindowListener", "java.awt.event.WindowAdapter");
        int m = info.getComponents().size();
        for (int i = 0; i < m; ++i) {
            ComponentInfo cInfo = info.getComponents().get(i);
            String controlType = cInfo.getClassType();
            if (controlType.indexOf(oldControlPackage) >= 0) {
                if (controlType.equals(oldTTableName)) {
                    cInfo.setClassType(newTTableName);
                } else {
                    cInfo.setClassType(StringUtils.replace((String)controlType, (String)oldControlPrefix, (String)newControlPrefix));
                }
                int n = cInfo.getEventBindings().size();
                for (int j = 0; j < n; ++j) {
                    EventBindingInfo ebInfo = cInfo.getEventBindings().get(j);
                    String listenerType = ebInfo.getListenerType();
                    ebInfo.setEventType(StringUtils.replace((String)listenerType, (String)"Listener", (String)"Event"));
                    if (adapterMap.containsKey(listenerType)) {
                        ebInfo.setListenerAdapter(adapterMap.get(listenerType).toString());
                        continue;
                    }
                    ebInfo.setListenerAdapter(listenerType);
                }
                continue;
            }
            if (!controlType.equals(oldKDTableName)) continue;
            cInfo.setClassType(newKDTableName);
        }
    }

    public static ComponentCollection treeToCol(ComponentCollection components) {
        ComponentCollection col = new ComponentCollection();
        int n = components.size();
        for (int i = 0; i < n; ++i) {
            UIObjectCtrl.addToCol(components.get(i), col);
        }
        return col;
    }

    public static void addToCol(ComponentInfo info, ComponentCollection col) {
        col.add(info);
        int n = info.getComponents().size();
        for (int i = 0; i < n; ++i) {
            UIObjectCtrl.addToCol(info.getComponents().get(i), col);
        }
    }

    private ComponentCollection colToTree(ComponentCollection components) {
        ComponentCollection col = new ComponentCollection();
        int n = components.size();
        for (int i = 0; i < n; ++i) {
            if (components.get(i).getParent() == null) {
                col.add(components.get(i));
                continue;
            }
            components.get(i).getParent().getComponents().add(components.get(i));
        }
        return col;
    }

    @Override
    public void deploy(AbstractMetaDataValue ui, DeployOptionInfo options) throws BOSException {
        super.deploy(ui, options);
        if (!(ui instanceof UIObjectInfo)) {
            return;
        }
        UIObjectInfo model = (UIObjectInfo)ui;
        if (options.isDeployCode() && !UI_TYPE_WEBFORM.equals(model.getString(UI_TYPE))) {
            long startTime = System.currentTimeMillis();
            model.setGenAgent(this.isGenAgent(options, model));
            CodeFactory.setGenRPCCode(options.isDeployRPC());
            CodeFactory.createUICode(options.getDevLevel(), this.getContext(), options.getJavaOutputDir(), model);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\u53d1\u5e03UI\u5bf9\u8c61" + model.getFullName() + "\u7684\u6240\u6709\u6587\u4ef6\u5171\u8017\u65f6:" + (System.currentTimeMillis() - startTime)));
            }
        }
    }

    @Override
    public void deploy(IMetaDataPK pk, DeployOptionInfo options) throws BOSException {
        super.deploy(pk, options);
        UIObjectInfo uiObjInfo = this.getAllValue(pk);
        if (options.isDeployCode() && !UI_TYPE_WEBFORM.equals(uiObjInfo.getString(UI_TYPE))) {
            long startTime = System.currentTimeMillis();
            UIObjectInfo model = this.getUncheckValue(pk);
            model.setGenAgent(this.isGenAgent(options, model));
            CodeFactory.setGenRPCCode(options.isDeployRPC());
            CodeFactory.createUICode(options.getDevLevel(), this.getContext(), options.getJavaOutputDir(), model);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\u53d1\u5e03UI\u5bf9\u8c61" + pk.getFullName() + "\u7684\u6240\u6709\u6587\u4ef6\u5171\u8017\u65f6:" + (System.currentTimeMillis() - startTime)));
            }
        }
    }

    @Override
    public UIObjectCollection getRawCollection() throws BOSException {
        return (UIObjectCollection)this.getDAO().getCollection();
    }

    @Override
    public UIObjectCollection getRawCollection(String pgName) throws BOSException {
        return (UIObjectCollection)((IXMLDAO)this.getDAO()).getCollection(pgName);
    }

    @Override
    public void rawUpdate(IMetaDataPK metaType, UIObjectInfo uiObjectInfo) throws BOSException {
        this.getDAO().update(metaType, uiObjectInfo);
    }

    private boolean isGenAgent(DeployOptionInfo options, UIObjectInfo model) {
        boolean ret = options.needToGenAgent(MetaDataTypeList.UIOBJECT, MetaDataPK.create(model.getFullName()));
        if (!ret) {
            return false;
        }
        return ret;
    }

    public static void beforeSave(UIObjectInfo ui) {
        UIObjectCtrl.reorder(ui);
    }

    private static void reorder(UIObjectInfo ui) {
        if (ui != null && ui.getMainPanelComponent() != null) {
            ComponentCollection col = new ComponentCollection();
            col.add(ui.getMainPanelComponent());
            ComponentCollection toolBars = ui.getToolbarsPanel().getComponents();
            for (int i = 0; i < toolBars.size(); ++i) {
                ComponentInfo toolBar = toolBars.get(i);
                toolBar.setParent(null);
                col.add(toolBar);
            }
            if (ui.getMenubarComponent() != null) {
                col.add(ui.getMenubarComponent());
            }
            UIObjectCtrl.reorder(col, ui.getMainPanelComponent());
            ui.setComponents(col);
        }
    }

    private static void reorder(ComponentCollection newCollection, ComponentInfo comp) {
        newCollection.addObjectCollection(comp.getComponents());
        Iterator iter = comp.getComponents().iterator();
        while (iter.hasNext()) {
            ComponentInfo child = (ComponentInfo)iter.next();
            UIObjectCtrl.reorder(newCollection, child);
        }
    }
}

