/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.upgrade;

import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.upgrade.EntryNotFoundException;
import com.kingdee.bos.metadata.upgrade.ReadOnlyException;
import com.kingdee.bos.metadata.upgrade.Solution;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipOutputStream;

public class FileUtil {
    private static final int STREAM_BUFF_LENGTH = 4096;
    private static final byte[] STREAM_BUFF = new byte[4096];

    public static void clearDir(File dir) {
        try {
            File[] files = dir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                if (file.isDirectory()) {
                    FileUtil.deleteDir(file);
                }
                file.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void deleteDir(File dir) {
        try {
            File[] files = dir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                if (file.isDirectory()) {
                    FileUtil.deleteDir(file);
                }
                file.delete();
            }
            dir.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void copySolutionFoo(Solution from, Solution to) {
        try {
            Enumeration e = from.getEntrys("");
            while (e.hasMoreElements()) {
                String entry = (String)e.nextElement();
                File toFile = new File(to.getRoot(), entry);
                if (from.isEntryFile(entry)) {
                    FileUtil.createFile(toFile);
                } else {
                    toFile.mkdirs();
                }
                long lastUpdate = 0L;
                try {
                    lastUpdate = from.getEntryTime(entry);
                    if (lastUpdate <= 0L) continue;
                    toFile.setLastModified(lastUpdate);
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void copySolution(Solution from, Solution to) throws ReadOnlyException, EntryNotFoundException, IOException {
        FileUtil.copyTree(from, to, "");
    }

    public static void copySolution(Solution from, Solution to, boolean overwrite) throws ReadOnlyException, EntryNotFoundException, IOException {
        FileUtil.copyTree(from, to, "", overwrite);
    }

    public static void copyTree(Solution from, Solution to, String tree) throws ReadOnlyException, EntryNotFoundException, IOException {
        FileUtil.copyTree(from, to, tree, false);
    }

    public static void copyTree(Solution from, Solution to, String tree, boolean overwrite) throws ReadOnlyException, EntryNotFoundException, IOException {
        Enumeration e = from.getEntrys(tree);
        while (e.hasMoreElements()) {
            String entry = (String)e.nextElement();
            FileUtil.copyEntry(entry, from, to, overwrite);
        }
    }

    public static void copyEntry(String entry, Solution from, Solution to) throws ReadOnlyException, EntryNotFoundException, IOException {
        FileUtil.copyEntry(entry, from, to, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyEntry(String entry, Solution from, Solution to, boolean overwrite) throws ReadOnlyException, EntryNotFoundException, IOException {
        if (null == to || null == from) {
            throw new IllegalArgumentException();
        }
        if (!to.canWrite()) {
            throw new ReadOnlyException();
        }
        if (null == entry || entry.length() <= 0) {
            return;
        }
        if (to.isEntryExist(entry) && !overwrite) {
            return;
        }
        File toFile = new File(to.getRoot(), entry);
        if (from.isEntryFile(entry)) {
            FileUtil.createFile(toFile);
            InputStream is = null;
            OutputStream os = null;
            try {
                is = from.getEntryInputStream(entry);
                os = to.getEntryOutputStream(entry);
                FileUtil.copyStream(is, os);
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (os != null) {
                        os.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        toFile.mkdirs();
        long lastUpdate = 0L;
        try {
            lastUpdate = from.getEntryTime(entry);
            if (lastUpdate > 0L) {
                toFile.setLastModified(lastUpdate);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isNoChange(String entry, Solution from, Solution to) {
        try {
            long fromTime = from.getEntryTime(entry);
            long toTime = to.getEntryTime(entry);
            if (fromTime > 0L && fromTime == toTime) {
                long fromSize = from.getEntrySize(entry);
                long toSize = to.getEntrySize(entry);
                if (fromSize > 0L && fromSize == toSize) {
                    return true;
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public static void createFile(File file) throws IOException {
        File dir = file.getParentFile();
        if (null != dir) {
            dir.mkdirs();
        }
        file.createNewFile();
    }

    public static void createDir(File dir) throws IOException {
        dir.mkdirs();
    }

    public static IMetaDataPK entry2PK(String entry) {
        int dot;
        String name = entry;
        if ('/' == name.charAt(name.length() - 1)) {
            name = name.substring(0, name.length() - 1);
        }
        if ((dot = entry.indexOf(".")) != -1) {
            name = entry.substring(0, dot);
        }
        name = name.replace('/', '.');
        return MetaDataPK.create(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void packSolution(Solution solution, OutputStream os) throws IOException {
        ZipOutputStream jos = null;
        try {
            jos = new JarOutputStream(new BufferedOutputStream(os));
            Enumeration e = solution.getEntrys();
            while (e.hasMoreElements()) {
                String entryName = (String)e.nextElement();
                JarEntry entry = new JarEntry(entryName);
                ((JarOutputStream)jos).putNextEntry(entry);
                if (entry.isDirectory()) continue;
                BufferedInputStream is = null;
                try {
                    is = new BufferedInputStream(solution.getEntryInputStream(entryName));
                    int readNum = 0;
                    while ((readNum = ((InputStream)is).read(STREAM_BUFF)) != -1) {
                        jos.write(STREAM_BUFF, 0, readNum);
                    }
                }
                finally {
                    try {
                        if (is == null) continue;
                        ((InputStream)is).close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        finally {
            if (jos != null) {
                try {
                    jos.finish();
                }
                catch (IOException iOException) {}
                try {
                    jos.flush();
                }
                catch (IOException iOException) {}
                try {
                    jos.closeEntry();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static void copyStream(InputStream is, OutputStream os) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(is);
        BufferedOutputStream bos = new BufferedOutputStream(os);
        int readNum = 0;
        while ((readNum = bis.read(STREAM_BUFF)) != -1) {
            bos.write(STREAM_BUFF, 0, readNum);
        }
        bos.flush();
        bis.close();
        bos.close();
    }
}

