/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.upgrade.loader;

import com.kingdee.bos.dao.MissingDAOMetaDataException;
import com.kingdee.bos.dao.xml.Utils;
import com.kingdee.bos.dao.xml.XMLLoader;
import com.kingdee.bos.engine.DevMDException;
import com.kingdee.bos.engine.MDLoaderException;
import com.kingdee.bos.engine.MDNotFoundException;
import com.kingdee.bos.engine.MDParseError;
import com.kingdee.bos.engine.MDSaveException;
import com.kingdee.bos.engine.MetadataState;
import com.kingdee.bos.engine.difftool.PathsHelper;
import com.kingdee.bos.engine.impl.BOSTypeHelper;
import com.kingdee.bos.engine.impl.DirResBase;
import com.kingdee.bos.engine.impl.IResBase;
import com.kingdee.bos.engine.impl.JarResBase;
import com.kingdee.bos.engine.impl.MetadataXMLAssembler;
import com.kingdee.bos.engine.impl.ResEntry;
import com.kingdee.bos.engine.impl.XMLException;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.LanguageInfo;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.metadata.upgrade.MergeModelEnum;
import com.kingdee.bos.metadata.upgrade.loader.MDParser3;
import com.kingdee.bos.metadata.upgrade.loader.Saver3;
import com.kingdee.bos.metadata.util.XmlUtils;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.XMLParser;
import com.kingdee.util.LocaleUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.Stack;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class Loader3 {
    private static final Logger logger = Logger.getLogger(Loader3.class);
    private final SortedMap caches = new TreeMap();
    private final MDParser3 parser;
    private final Saver3 saver;
    String solutionName;
    String solutionEntry;
    Set<String> localeNames;
    private volatile int engineState = 0;
    XMLLoader metametaLoader = null;
    BOSTypeHelper typeHelper = null;
    private IResBase workDir;
    private IResBase[] bases;
    private MetadataXMLAssembler assembler;
    private Set workSet = null;
    private PrintWriter mrWriter = null;
    private static byte[] BUFF = new byte[4096];
    private MergeModelEnum mergeModel = MergeModelEnum.WHOLE;

    public Loader3(String paths, XMLLoader loader, BOSTypeHelper helper) throws IOException {
        this(null, PathsHelper.paths2File(paths), loader, helper);
    }

    public Loader3(String path, String paths, XMLLoader loader, BOSTypeHelper helper) throws IOException {
        this(path == null ? null : new File(path), PathsHelper.paths2File(paths), loader, helper);
    }

    public Loader3(File saveDir, File[] basePaths, XMLLoader loader, BOSTypeHelper helper) {
        this.metametaLoader = loader;
        this.typeHelper = helper;
        this.parser = new MDParser3(this);
        this.saver = new Saver3(this);
        this.assembler = new MetadataXMLAssembler(this.metametaLoader);
        if (basePaths != null) {
            ArrayList<DirResBase> tempBase = new ArrayList<DirResBase>();
            for (int i = basePaths.length - 1; i >= 0; --i) {
                IResBase res;
                File base = basePaths[i];
                if (base.isDirectory()) {
                    res = new DirResBase(base);
                    tempBase.add((DirResBase)res);
                    this.processDir(base, res, false);
                    continue;
                }
                if (!base.isFile()) continue;
                res = new JarResBase(base);
                tempBase.add((DirResBase)res);
                this.processJar(base, res);
            }
            this.bases = tempBase.toArray(new IResBase[tempBase.size()]);
        }
        if (saveDir != null) {
            if (!saveDir.isDirectory()) {
                throw new IllegalArgumentException("\u8bbe\u7f6e\u7684\u5f53\u524d\u5143\u6570\u636e\u5de5\u4f5c\u533a\u4e0d\u5b58\u5728\u6216\u4e0d\u662f\u4e00\u4e2a\u76ee\u5f55\u3002Detail File=" + saveDir.getPath());
            }
            this.workDir = new DirResBase(saveDir);
            this.workSet = new HashSet();
            this.processDir(saveDir, this.workDir, true);
        }
        try {
            this.bootSolution();
            this.engineState = 1;
        }
        catch (Exception e) {
            logger.info((Object)"\u65b0\u5efa\u4e00\u4e2a\u5143\u6570\u636e\u89e3\u51b3\u65b9\u6848\uff0c\u8fd8\u6ca1\u6709\u521d\u59cb\u5316SolutionInfo\uff0c\u8bf7initSolution\u3002", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processBOIndex() {
        Properties entityIndex = new Properties();
        Properties facadeIndex = new Properties();
        if (this.bases != null) {
            for (int i = 0; i < this.bases.length; ++i) {
                IResBase base = this.bases[i];
                InputStream is = null;
                try {
                    is = base.getInputStream("entity_pkmapping.properties");
                    entityIndex.load(is);
                }
                catch (Exception exception) {
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                try {
                    is = base.getInputStream("facade_pkmapping.properties");
                    facadeIndex.load(is);
                    continue;
                }
                catch (Exception exception) {
                    continue;
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
        if (this.workDir != null) {
            OutputStream os = null;
            try {
                os = this.workDir.getOutputStream("entity_pkmapping.properties");
                entityIndex.store(os, "Metadata Merged Index");
            }
            catch (Exception exception) {
            }
            finally {
                if (os != null) {
                    try {
                        os.flush();
                    }
                    catch (IOException iOException) {}
                    try {
                        os.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            try {
                os = this.workDir.getOutputStream("facade_pkmapping.properties");
                facadeIndex.store(os, "Metadata Merged Index");
            }
            catch (Exception exception) {
            }
            finally {
                if (os != null) {
                    try {
                        os.flush();
                    }
                    catch (IOException iOException) {}
                    try {
                        os.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private void processJar(File file, IResBase res) {
        JarFile jar = null;
        try {
            jar = new JarFile(file);
            Enumeration<JarEntry> e = jar.entries();
            String entryName = null;
            while (e.hasMoreElements()) {
                entryName = e.nextElement().toString();
                int pos = entryName.lastIndexOf(".");
                String suffix = "";
                if (pos != -1) {
                    suffix = entryName.substring(pos);
                }
                if (!this.typeHelper.allSuffixs.contains(suffix)) continue;
                ResEntry resEntry = this.ensureTrue(entryName);
                resEntry.b = res;
            }
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Init Metadata Jar:" + file.getAbsolutePath() + " Error. Cause:" + ioe.getMessage());
        }
        finally {
            try {
                if (jar != null) {
                    jar.close();
                }
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
    }

    private void processDir(File dir, IResBase res, boolean isFrag) {
        Stack paths = new Stack();
        this.processDir0(dir, res, paths, isFrag);
    }

    private void processDir0(File dir, IResBase res, Stack paths, boolean isFrag) {
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.isDirectory()) {
                paths.push(file.getName());
                this.processDir0(file, res, paths, isFrag);
                paths.pop();
                continue;
            }
            if (!file.isFile()) continue;
            String name = file.getName();
            int pos = name.lastIndexOf(".");
            String suffix = "";
            if (pos != -1) {
                suffix = name.substring(pos);
            }
            if (!this.typeHelper.allSuffixs.contains(suffix)) continue;
            String fullname = this.joinPath(paths, name);
            ResEntry resEntry = this.ensureTrue(fullname, isFrag);
            if (isFrag) {
                resEntry.f = res;
                continue;
            }
            resEntry.b = res;
        }
    }

    private String joinPath(Stack paths, String name) {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < paths.size(); ++i) {
            String path = (String)paths.get(i);
            buff.append(path);
            buff.append("/");
        }
        buff.append(name);
        return buff.toString();
    }

    private void bootSolution() throws MDNotFoundException {
        String entry = this.findBootSolutionEntry();
        ResEntry solutionEntry = this.ensure(entry);
        this.solutionEntry = entry;
        if (solutionEntry.getState() == 0 || solutionEntry.getState() == 2) {
            IResBase res = null;
            res = solutionEntry.f != null ? solutionEntry.f : solutionEntry.b;
            try {
                Document dom = this.loadDOM(res, entry);
                this.initLocales(dom);
            }
            catch (Exception e) {
                throw new RuntimeException("\u65e0\u6cd5\u6b63\u786e\u89e3\u6790\u8d77\u59cb\u7684solution\u4fe1\u606f", e);
            }
        }
    }

    private String findBootSolutionEntry() {
        for (String key : this.caches.keySet()) {
            if (!key.endsWith(".solution")) continue;
            return key;
        }
        return "[name].solution";
    }

    public synchronized void initSolution(SolutionInfo sln) throws IllegalArgumentException, IllegalStateException {
        if (this.engineState == 1) {
            throw new IllegalStateException("\u5f15\u64ce\u5df2\u7ecf\u88c5\u8f7d\u4e86\u5143\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21initSolution");
        }
        if (sln == null) {
            throw new IllegalArgumentException("initSolution\u4e2dSolutionInfo==null");
        }
        try {
            this.solutionName = sln.getName();
            this.localeNames = new HashSet<String>(3);
            LanguageCollection langs = sln.getLanguages();
            if (langs != null) {
                for (int i = 0; i < langs.size(); ++i) {
                    LanguageInfo lang = langs.get(i);
                    String sn = lang.getPostfix();
                    LocaleUtils.getLocale((String)sn);
                    LocaleUtils.addShortCode((Locale)lang.getOriginalLocale(), (String)sn);
                    this.localeNames.add(lang.getLocaleString());
                }
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("initSolution\u65e0\u6cd5\u627e\u5230\u6b63\u786e\u7684lang\u4fe1\u606f\u3002");
        }
        this.engineState = 1;
    }

    public SolutionInfo getSolution() throws MDNotFoundException {
        if (this.engineState != 1) {
            throw new MDNotFoundException("\u5143\u6570\u636e\u5f15\u64ce\u672a\u521d\u59cb\u5316\u5b8c\u6210\uff0c\u65e0\u6cd5\u88c5\u8f7d\u5143\u6570\u636e");
        }
        MetaDataPK pk = null;
        pk = this.solutionEntry != null ? MetaDataPK.create(Loader3.entryName2PK(this.solutionEntry)) : MetaDataPK.create(this.solutionName);
        return (SolutionInfo)this.loadMetadata(MetaDataTypeList.SOLUTION, pk);
    }

    private synchronized void initLocales(Document dom) {
        Element root = dom.getRootElement();
        this.solutionName = root.getChildTextTrim("name", root.getNamespace());
        this.localeNames = new HashSet<String>(3);
        List ls = root.getChild("languages", root.getNamespace()).getChildren("language", root.getNamespace());
        for (int i = 0; i < ls.size(); ++i) {
            Element lang = (Element)ls.get(i);
            String shortName = lang.getChildText("postfix", root.getNamespace()).toLowerCase();
            String longName = lang.getChildText("localeString", root.getNamespace());
            LocaleUtils.getLocale((String)shortName);
            LocaleUtils.addShortCode((Locale)LocaleUtils.getLocale((String)longName), (String)shortName);
            this.localeNames.add(longName);
        }
    }

    public synchronized Set getEntrys() {
        if (this.workSet != null) {
            return Collections.unmodifiableSet(this.workSet);
        }
        return Collections.unmodifiableSet(this.caches.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void tag(String entry) throws IOException, MDNotFoundException {
        if (this.engineState != 1) {
            throw new MDNotFoundException("\u5143\u6570\u636e\u5f15\u64ce\u672a\u521d\u59cb\u5316\u5b8c\u6210\uff0c\u65e0\u6cd5\u64cd\u4f5c\u5143\u6570\u636e");
        }
        ResEntry res = this.ensure(entry);
        if (res.f != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\u5143\u6570\u636e[" + entry + "]\u5df2\u7ecf\u662f\u4fee\u6539\u72b6\u6001"));
            }
            return;
        }
        res.f = this.workDir;
        OutputStream os = null;
        InputStream is = null;
        try {
            os = res.f.getOutputStream(entry);
            is = res.b.getInputStream(entry);
            Loader3.copyStream(os, is);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)"close InputStream error!", (Throwable)e);
            }
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)"close OutputStream error!", (Throwable)e);
            }
        }
        res.f.setEntryLastModified(entry, res.b.entryLastModified(entry));
        res.b = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void tag(String entry, Loader3 from) throws IOException, MDNotFoundException {
        ResEntry fres = from.ensure(entry);
        ResEntry tres = this.ensureTrue(entry);
        if (tres.f != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\u5143\u6570\u636e[" + entry + "]\u5df2\u7ecf\u662f\u4fee\u6539\u72b6\u6001"));
            }
            return;
        }
        tres.f = this.workDir;
        OutputStream os = null;
        InputStream is = null;
        try {
            os = tres.f.getOutputStream(entry);
            is = fres.f != null ? fres.f.getInputStream(entry) : fres.b.getInputStream(entry);
            Loader3.copyStream(os, is);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)"close InputStream error!", (Throwable)e);
            }
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)"close OutputStream error!", (Throwable)e);
            }
        }
        if (fres.f != null) {
            tres.f.setEntryLastModified(entry, fres.f.entryLastModified(entry));
        } else {
            tres.f.setEntryLastModified(entry, fres.b.entryLastModified(entry));
        }
        tres.b = null;
    }

    private static void copyStream(OutputStream os, InputStream is) throws IOException {
        int count = 0;
        while ((count = is.read(BUFF)) > 0) {
            os.write(BUFF, 0, count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFromLoader(String entry, Loader3 from, Loader3 to) throws IOException, MDNotFoundException {
        ResEntry fres = from.ensure(entry);
        ResEntry tres = to.ensureTrue(entry);
        tres.f = to.workDir;
        tres.b = null;
        InputStream is = null;
        OutputStream os = null;
        try {
            is = fres.f != null ? fres.f.getInputStream(entry) : fres.b.getInputStream(entry);
            os = tres.f.getOutputStream(entry);
            if (entry.endsWith(Utils.getMetaDataSuffix(MetaDataTypeList.UIOBJECT))) {
                Loader3.copyAndProcessEnum(entry, is, os);
            } else {
                Loader3.copyStream(os, is);
            }
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)"close InputStream error!", (Throwable)e);
            }
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)"close OutputStream error!", (Throwable)e);
            }
        }
        if (fres.f != null) {
            tres.f.setEntryLastModified(entry, fres.f.entryLastModified(entry));
        } else {
            tres.f.setEntryLastModified(entry, fres.b.entryLastModified(entry));
        }
    }

    private static void copyAndProcessEnum(String entry, InputStream is, OutputStream os) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, Charset.forName("UTF-8")));
        PrintWriter writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter(os, Charset.forName("UTF-8"))));
        String s = null;
        boolean replaced = false;
        while ((s = reader.readLine()) != null) {
            if (s.indexOf("com.kingdee.util.enum.") >= 0) {
                s = s.replaceAll("com.kingdee.util.enum.", "com.kingdee.util.enums.");
                replaced = true;
            }
            writer.println(s);
        }
        writer.flush();
        if (replaced) {
            logger.info((Object)(entry + "   replaced com.kingdee.util.enum. with com.kingdee.util.enums."));
        }
    }

    public static boolean modified(String entry, Loader3 from, Loader3 to) throws MDNotFoundException {
        ResEntry fres = from.ensure(entry);
        IResBase fbase = null;
        fbase = fres.f != null ? fres.f : fres.b;
        ResEntry tres = to.ensure(entry);
        IResBase tbase = null;
        tbase = tres.f != null ? tres.f : tres.b;
        if (fbase.entryLastModified(entry) != tbase.entryLastModified(entry)) {
            return true;
        }
        return fbase.entryLength(entry) != tbase.entryLength(entry);
    }

    public synchronized AbstractMetaDataValue loadMetadata(String entry) throws MDNotFoundException {
        return this.loadMetadata(Loader3.entryName2BOSType(entry), MetaDataPK.create(Loader3.entryName2PK(entry)));
    }

    public synchronized AbstractMetaDataValue loadMetadata(BOSObjectType type, IMetaDataPK pk) throws MDNotFoundException {
        Document dom;
        EntityObjectInfo meta;
        AbstractMetaDataValue vo;
        block13: {
            if (this.engineState != 1) {
                throw new MDNotFoundException("\u5143\u6570\u636e\u5f15\u64ce\u672a\u521d\u59cb\u5316\u5b8c\u6210\uff0c\u65e0\u6cd5\u88c5\u8f7d\u5143\u6570\u636e");
            }
            String entry = Loader3.entryName(type, pk);
            ResEntry res = this.ensure(entry);
            vo = res.obj;
            if (vo != null) {
                return vo;
            }
            meta = null;
            try {
                meta = this.metametaLoader.loadMeta(type);
            }
            catch (MissingDAOMetaDataException e) {
                throw new MDParseError("\u65e0\u6cd5\u88c5\u8f7d\u5143\u5143\u6570\u636e\u7c7b\u578b[" + type + "]");
            }
            dom = null;
            try {
                if (res.getState() == 0) {
                    dom = this.loadDOM(res.b, entry);
                    break block13;
                }
                if (res.getState() == 2) {
                    dom = this.loadDOM(res.f, entry);
                    break block13;
                }
                if (res.getState() == 3) {
                    throw new MDNotFoundException("\u5143\u6570\u636e[" + entry + "]\u65e0\u5bf9\u5e94\u7684\u4efb\u4f55\u8d44\u6e90\uff01");
                }
                if (res.getState() == 1) {
                    Document domFrag = this.loadDOM(res.f, entry);
                    Document domBase = this.loadDOM(res.b, entry);
                    dom = this.assembler.merge(this.metametaLoader.loadMeta(type), domBase, domFrag);
                    break block13;
                }
                throw new MDNotFoundException("\u5143\u6570\u636e[" + entry + "]\u5bf9\u5e94\u7684\u8d44\u6e90\u5728\u63d2\u4ef6\u76ee\u5f55\u51b2\u7a81\uff01");
            }
            catch (IOException e) {
                throw new MDNotFoundException("\u5143\u6570\u636e[" + entry + "]\u5bf9\u5e94\u7684\u8d44\u6e90[BaseDir=" + res.b + " FragDir=" + res.f + "]\u5b58\u53d6IO\u5f02\u5e38", e);
            }
            catch (JDOMException e) {
                throw new MDNotFoundException("\u5143\u6570\u636e[" + entry + "]\u5bf9\u5e94\u7684\u8d44\u6e90[BaseDir=" + res.b + " FragDir=" + res.f + "]\u89e3\u6790DOM\u5f02\u5e38", e);
            }
            catch (XMLException e) {
                throw new MDNotFoundException("\u5408\u5e76\u5143\u6570\u636e[" + entry + "]\u5bf9\u5e94\u7684\u8d44\u6e90[BaseDir=" + res.b + " FragDir=" + res.f + "]\u51fa\u73b0\u5f02\u5e38", e);
            }
            catch (MissingDAOMetaDataException e) {
                throw new MDNotFoundException("\u5143\u6570\u636e[" + entry + "]\u5bf9\u5e94\u7684\u8d44\u6e90[BaseDir=" + res.b + " FragDir=" + res.f + "]\u7684[BOSType=" + type + "]\u4e0d\u5b58\u5728\u5143\u5143\u6570\u636e", (Throwable)((Object)e));
            }
        }
        meta = this.typeHelper.getRealMeta(meta, dom.getRootElement().getName());
        res.obj = vo = (AbstractMetaDataValue)this.typeHelper.getRealVO(meta);
        this.parser.parseMDFromDOM(vo, meta, dom.getRootElement());
        return vo;
    }

    public synchronized boolean exist(BOSObjectType type, IMetaDataPK pk) {
        if (this.engineState != 1) {
            return false;
        }
        String entry = Loader3.entryName(type, pk);
        try {
            this.ensure(entry);
            return true;
        }
        catch (MDNotFoundException e) {
            return false;
        }
    }

    public synchronized boolean exist(String entryName) {
        if (this.engineState != 1) {
            return false;
        }
        try {
            this.ensure(entryName);
            return true;
        }
        catch (MDNotFoundException e) {
            return false;
        }
    }

    public synchronized void saveMetadata(String pathEntry, AbstractMetaDataValue metadata) throws MDSaveException {
        ResEntry res;
        MetaDataPK pk;
        if (this.engineState != 1) {
            throw new MDSaveException("\u5143\u6570\u636e\u5f15\u64ce\u672a\u521d\u59cb\u5316\u5b8c\u6210\uff0c\u65e0\u6cd5\u5b58\u50a8\u5143\u6570\u636e");
        }
        BOSObjectType type = metadata.getBOSType();
        String entry = Loader3.entryName(type, pk = MetaDataPK.create(metadata.getPackage(), metadata.getName()));
        if (!pathEntry.equals(entry)) {
            logger.fatal((Object)(pathEntry + ": file path does't match fullName: " + pk));
            this.mrWriter.println("fatal," + pathEntry + ",\"file path does't match fullName: " + pk + "\"");
            entry = pathEntry;
        }
        if ((res = (ResEntry)this.caches.get(entry)) == null) {
            if (MetaDataTypeList.SOLUTION.equals((Object)type)) {
                this.solutionEntry = entry;
            }
            res = new ResEntry();
            res.obj = metadata;
            this.caches.put(entry, res);
        }
        try {
            Document bigDom = this.saver.store(metadata);
            if (MergeModelEnum.PLUGIN.equals((Object)this.mergeModel)) {
                Document saveDom = null;
                Document baseDom = this.loadDOM(res.b, entry);
                res.f = this.workDir;
                saveDom = this.assembler.diff(this.metametaLoader.loadMeta(metadata.getBOSType()), bigDom, baseDom);
                if (saveDom != null) {
                    this.saveDOM(res.f, entry, saveDom);
                } else {
                    logger.info((Object)(entry + " needn't save plugin."));
                }
            } else {
                res.f = this.workDir;
                res.b = null;
                this.saveDOM(res.f, entry, bigDom);
            }
        }
        catch (Exception e) {
            throw new MDSaveException("\u5143\u6570\u636e[" + entry + "]\u5bf9\u5e94\u7684\u8d44\u6e90[BaseDir=" + res.b + " FragDir=" + res.f + "]\u5b58\u53d6IO\u5f02\u5e38", e);
        }
    }

    public synchronized void deleteMetadata(BOSObjectType type, IMetaDataPK pk) throws DevMDException, MDSaveException {
        String entry = Loader3.entryName(type, pk);
        ResEntry res = this.ensure(entry);
        try {
            if (res.f != null) {
                this.workDir.deleteEntry(entry);
                res.f = null;
                res.obj = null;
            }
        }
        catch (IOException e) {
            throw new MDSaveException("\u5220\u9664\u5143\u6570\u636e[" + entry + "]\u65f6\u51fa\u73b0IO\u5f02\u5e38\u3002");
        }
    }

    static String entryName(BOSObjectType type, IMetaDataPK pk) {
        String suffix = Utils.getMetaDataSuffix(type);
        String pkg = pk.getPackage();
        if (pkg == null || pkg.length() == 0) {
            return pk.getName() + suffix;
        }
        return pkg.replaceAll("\\.", "/") + "/" + pk.getName() + suffix;
    }

    public static BOSObjectType entryName2BOSType(String entry) {
        int pos = entry.lastIndexOf(".");
        if (pos != -1) {
            String suffix = entry.substring(pos + 1);
            return BOSObjectType.create((String)Utils.getBOSTypeBySuffix(suffix));
        }
        return null;
    }

    static String entryName2PK(String entry) {
        int pos = entry.lastIndexOf(".");
        if (pos != -1) {
            String pk = entry.substring(0, pos);
            return pk.replaceAll("/", "\\.");
        }
        return entry.replaceAll("/", "\\.");
    }

    public synchronized MetadataState getMetadataState(BOSObjectType type, IMetaDataPK pk) throws DevMDException {
        if (this.engineState != 1) {
            throw new MDLoaderException("\u5143\u6570\u636e\u5f15\u64ce\u672a\u521d\u59cb\u5316\u5b8c\u6210\uff0c\u65e0\u6cd5\u5b58\u50a8\u5143\u6570\u636e");
        }
        String entry = Loader3.entryName(type, pk);
        ResEntry res = this.ensure(entry);
        return new MetadataState(type, pk, res.getState());
    }

    public SortedMap getMetadataByPackage(String pkg, BOSObjectType[] including, BOSObjectType[] excluding, boolean deep) throws DevMDException {
        String key1 = null;
        String key2 = null;
        SortedMap subs = this.caches;
        if (pkg != null && pkg.length() > 0) {
            if (pkg.endsWith("/")) {
                key1 = pkg;
                key2 = pkg.substring(0, pkg.length() - 1) + "0";
            } else {
                key1 = pkg + "/";
                key2 = pkg + "0";
            }
            subs = subs.subMap(key1, key2);
        }
        return Collections.unmodifiableSortedMap(subs);
    }

    public synchronized void clear() {
        for (ResEntry item : this.caches.values()) {
            item.obj = null;
        }
    }

    public synchronized void rebase(File[] basePaths) throws IOException {
        this.caches.clear();
        this.bases = null;
        if (basePaths != null) {
            ArrayList<DirResBase> tempBase = new ArrayList<DirResBase>();
            for (int i = basePaths.length - 1; i >= 0; --i) {
                IResBase res;
                File base = basePaths[i];
                if (base.isDirectory()) {
                    res = new DirResBase(base);
                    tempBase.add((DirResBase)res);
                    this.processDir(base, res, false);
                    continue;
                }
                if (!base.isFile()) continue;
                res = new JarResBase(base);
                tempBase.add((DirResBase)res);
                this.processJar(base, res);
            }
            this.bases = tempBase.toArray(new IResBase[tempBase.size()]);
        }
        this.processDir(this.workDir.getBase(), this.workDir, true);
    }

    public synchronized boolean isExtendedMetadata(BOSObjectType type, IMetaDataPK pk) throws MDNotFoundException {
        String entry = Loader3.entryName(type, pk);
        ResEntry res = this.ensure(entry);
        return res.f != null;
    }

    public synchronized boolean isBaseMetadata(BOSObjectType type, IMetaDataPK pk) throws MDNotFoundException {
        return !this.isExtendedMetadata(type, pk);
    }

    public synchronized XMLLoader getMetametaLoader() {
        return this.metametaLoader;
    }

    public synchronized File getSaveDir() {
        return this.workDir.getBase();
    }

    public File[] getBasePaths() throws IllegalArgumentException, IllegalStateException {
        if (this.bases != null) {
            File[] rtv = new File[this.bases.length];
            for (int i = 0; i < rtv.length; ++i) {
                rtv[i] = this.bases[i].getBase();
            }
            return rtv;
        }
        return new File[0];
    }

    public ResEntry ensure(String entry) throws MDNotFoundException {
        ResEntry res = (ResEntry)this.caches.get(entry);
        if (res == null) {
            throw new MDNotFoundException("\u6574\u4e2a\u5143\u6570\u636e\u89e3\u51b3\u65b9\u6848\u4e2d\u6ca1\u6709\u5143\u6570\u636e[" + entry + "]\u5bf9\u5e94\u7684\u8d44\u6e90");
        }
        return res;
    }

    private ResEntry ensureTrue(String entry) {
        return this.ensureTrue(entry, false);
    }

    private ResEntry ensureTrue(String entry, boolean isFrag) {
        ResEntry res = (ResEntry)this.caches.get(entry);
        if (res == null) {
            res = new ResEntry();
            this.caches.put(entry, res);
        }
        if (isFrag && this.workSet != null) {
            this.workSet.add(entry);
        }
        return res;
    }

    private Document loadDOM(IResBase res, String entry) throws IOException, JDOMException {
        InputStream is = res.getInputStream(entry);
        Document dom = XMLParser.parseXML((InputStream)is);
        is.close();
        return dom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveDOM(IResBase res, String entry, Document dom) throws IOException {
        OutputStream os = null;
        try {
            os = res.getOutputStream(entry);
            XmlUtils.output(dom, os);
        }
        finally {
            if (os != null) {
                try {
                    os.flush();
                }
                catch (IOException e) {
                    logger.error((Object)"flush OutputStream os error!", (Throwable)e);
                }
                try {
                    os.close();
                }
                catch (IOException e) {
                    logger.error((Object)"close OutputStream os error!", (Throwable)e);
                }
            }
        }
    }

    public void setMergeModel(MergeModelEnum mergeModel) {
        this.mergeModel = mergeModel;
    }

    public void setWriter(PrintWriter mrWriter) {
        this.mrWriter = mrWriter;
    }
}

