/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bizunit.BizTemplateCtrl;
import com.kingdee.bos.metadata.bizunit.BizType;
import com.kingdee.bos.metadata.bizunit.BizUnitCtrl;
import com.kingdee.bos.metadata.bizunit.BizUnitInfo;
import com.kingdee.bos.metadata.entity.EntityObjectCollection;
import com.kingdee.bos.metadata.entity.EntityObjectCtrl;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.function.FunctionObjectCollection;
import com.kingdee.bos.metadata.function.FunctionObjectCtrl;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.function.OperationCollection;
import com.kingdee.bos.metadata.function.OperationInfo;
import com.kingdee.bos.metadata.query.JoinQueryCtrl;
import com.kingdee.bos.metadata.query.JoinQueryInfo;
import com.kingdee.bos.metadata.ui.UIObjectCtrl;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BizUnitGenerator {
    private static final Logger log = Logger.getLogger((String)"com.kingdee.bos.metadata.util.BizUnitGenerator");
    private String metadataRootPathName = null;
    private BizUnitCtrl bizUnitCtrl = null;
    private BizTemplateCtrl bizTemplateCtrl = null;
    private EntityObjectCtrl entityCtrl = null;
    private UIObjectCtrl uiCtrl = null;
    private JoinQueryCtrl queryCtrl = null;
    private FunctionObjectCtrl functionCtrl = null;
    private static String DATABASE = "com.kingdee.eas.framework.app.DataBase";
    private static String TREEBASE = "com.kingdee.eas.framework.app.TreeBase";
    private static String ISLINKEDTOGROUPENTITY = "isLinkedToGroupEntity";
    private static String BILLBASE = "com.kingdee.eas.framework.app.BillBase";
    private static String COREBILLBASE = "com.kingdee.eas.framework.app.CoreBillBase";
    private static String COREBILLENTRYBASE = "com.kingdee.eas.framework.app.CoreBillEntryBase";
    private static String BIMPACKAGE = "com.kingdee.eas.bim";
    private List treeEntityPKs = new ArrayList();
    private Map uiFunctions = new Hashtable();

    public static void main(String[] args) throws IOException {
        if (args == null || args.length == 0) {
            log.debug((Object)"\u8bf7\u8f93\u5165\u53c2\u6570\uff1a\u5143\u6570\u636e\u6839\u76ee\u5f55\u548c\u5305\u540d\uff0c\u5982BizUnitGenerator C:\\metadata com.kingdee.eas.basedata");
            return;
        }
        if (args.length == 1) {
            new BizUnitGenerator().update(args[0], null);
        } else {
            new BizUnitGenerator().update(args[0], args[1]);
        }
    }

    public void update(String metadataRootPathName, String packageName) throws IOException {
        File metadataRootPath = new File(metadataRootPathName);
        if (!metadataRootPath.exists()) {
            log.debug((Object)("\u5143\u6570\u636e\u6839\u76ee\u5f55" + metadataRootPathName + "\u4e0d\u5b58\u5728\uff01"));
            return;
        }
        this.metadataRootPathName = metadataRootPath.getAbsolutePath();
        try {
            this.bizUnitCtrl = new BizUnitCtrl(this.getContext());
            this.bizTemplateCtrl = new BizTemplateCtrl(this.getContext());
            this.entityCtrl = new EntityObjectCtrl(this.getContext());
            this.queryCtrl = new JoinQueryCtrl(this.getContext());
            this.uiCtrl = new UIObjectCtrl(this.getContext());
            this.functionCtrl = new FunctionObjectCtrl(this.getContext());
        }
        catch (Exception e) {
            log.debug((Object)("\u5143\u5143\u6570\u636e\u88c5\u8f7d\u5931\u8d25\uff01\u53ef\u80fd\u5f15\u7528\u7684\u7c7b\u8def\u5f84\u4e2d\u6ca1\u6709metametas.jar\u5305\u3002\n" + e.toString()));
            return;
        }
        log.debug((Object)"\u5f00\u59cb\u904d\u5386\u5143\u6570\u636e\u76ee\u5f55...");
        try {
            this.generateBizUnit(packageName);
        }
        catch (BOSException e) {
            log.debug((Object)("\u751f\u6210\u4e1a\u52a1\u5355\u5143\u5931\u8d25\uff01\n" + e.toString()));
            return;
        }
        log.debug((Object)"\u751f\u6210\u4e1a\u52a1\u5355\u5143\u5b8c\u6bd5\u3002");
    }

    private void generateBizUnit(EntityObjectInfo entity) throws BOSException {
        MetaDataPK bizUnitPK = BizUnitGenerator.getBizUnitPK(entity);
        String bimTemplateType = BizUnitGenerator.getBimTemplateType(entity);
        if (!StringUtils.isEmpty((String)bimTemplateType)) {
            EntityObjectInfo treeEntity;
            UIObjectInfo editUI;
            FunctionObjectInfo function;
            BizUnitInfo bizUnit = new BizUnitInfo();
            bizUnit.setPackage(bizUnitPK.getPackage());
            bizUnit.setName(bizUnitPK.getName());
            bizUnit.setAlias(entity.getAlias());
            bizUnit.setDescription(entity.getDescription());
            bizUnit.setBimTemplateType(bimTemplateType);
            bizUnit.setBizType(BizUnitGenerator.getBizType(bimTemplateType));
            bizUnit.setUserDefined(false);
            bizUnit.setGenImplementCode(false);
            bizUnit.setString("entityPK", entity.getFullName());
            JoinQueryInfo query = this.getQuery(entity);
            if (query != null && !this.isBIMPackage(query.getPackage())) {
                bizUnit.setString("queryPK", query.getFullName());
                UIObjectInfo listUI = this.getListUI(entity);
                if (listUI != null && !this.isBIMPackage(listUI.getPackage())) {
                    bizUnit.setString("listUIPK", listUI.getFullName());
                    if (this.uiFunctions.containsKey(listUI.getFullName())) {
                        function = (FunctionObjectInfo)this.uiFunctions.get(listUI.getFullName());
                        bizUnit.setString("listUIFunctionPK", function.getFullName());
                    }
                }
            }
            if ((editUI = this.getEditUI(entity)) != null && !this.isBIMPackage(editUI.getPackage())) {
                bizUnit.setString("editUIPK", editUI.getFullName());
                if (this.uiFunctions.containsKey(editUI.getFullName())) {
                    function = (FunctionObjectInfo)this.uiFunctions.get(editUI.getFullName());
                    bizUnit.setString("editUIFunctionPK", function.getFullName());
                }
            }
            if ("TreeDetail".equalsIgnoreCase(bimTemplateType) && (treeEntity = BizUnitGenerator.getTreeEntity(entity)) != null && !this.isBIMPackage(treeEntity.getPackage())) {
                UIObjectInfo treeEditUI;
                bizUnit.setString("relatedEntityPK", treeEntity.getFullName());
                if (treeEntity.getTable() != null) {
                    bizUnit.setString("relatedTablePK", treeEntity.getTable().getFullName());
                }
                if ((treeEditUI = this.getEditUI(treeEntity)) != null && !this.isBIMPackage(treeEditUI.getPackage())) {
                    bizUnit.setString("relatedEditUIPK", treeEditUI.getFullName());
                }
            }
            this.bizUnitCtrl.addnew(bizUnit);
        }
    }

    private void generateBizUnit(String packageName) throws BOSException {
        EntityObjectCollection entityCol = StringUtils.isEmpty((String)packageName) ? this.entityCtrl.getCollection() : this.entityCtrl.getCollection(packageName);
        this.getAllTreeEntityPKs(entityCol);
        FunctionObjectCollection functionCol = StringUtils.isEmpty((String)packageName) ? this.functionCtrl.getCollection() : this.functionCtrl.getCollection(packageName);
        this.getAllUIFunctions(functionCol);
        int n = entityCol.size();
        for (int i = 0; i < n; ++i) {
            EntityObjectInfo entity = entityCol.get(i);
            if (!StringUtils.isEmpty((String)entity.getBizUnitPK()) && this.existBizUnit(entity.getBizUnitPK()) || entity.isAbstract() || BizUnitGenerator.isEntryEntity(entity) || this.treeEntityPKs.contains(entity.getFullName())) continue;
            this.generateBizUnit(entity);
        }
    }

    private Context getContext() {
        Context ctx = new Context(null, "eas", "", BOSLocaleUtil.ZH_CN);
        ctx.put((Object)"current_mode", (Object)"DEBUG");
        ctx.put((Object)"METADATAPATH", (Object)this.metadataRootPathName);
        return ctx;
    }

    private static MetaDataPK getBizUnitPK(EntityObjectInfo entity) {
        String packageName = entity.getPackage();
        String name = entity.getName();
        if (StringUtils.isEmpty((String)packageName)) {
            return MetaDataPK.create(name);
        }
        if (packageName.endsWith(".app")) {
            packageName = packageName.substring(0, packageName.length() - 4);
        }
        return MetaDataPK.create(packageName + "." + name);
    }

    private JoinQueryInfo getQuery(EntityObjectInfo entity) {
        String queryPK = entity.getExtendedProperty("defaultF7Query");
        if (StringUtils.isEmpty((String)queryPK)) {
            return null;
        }
        try {
            return this.queryCtrl.getValue(MetaDataPK.create(queryPK));
        }
        catch (Exception e) {
            return null;
        }
    }

    private UIObjectInfo getEditUI(EntityObjectInfo entity) {
        String editUIPK = entity.getExtendedProperty("editUI");
        if (StringUtils.isEmpty((String)editUIPK)) {
            return null;
        }
        try {
            return this.uiCtrl.getValue(MetaDataPK.create(editUIPK));
        }
        catch (Exception e) {
            return null;
        }
    }

    private UIObjectInfo getListUI(EntityObjectInfo entity) {
        String listUIPK = entity.getExtendedProperty("listUI");
        if (StringUtils.isEmpty((String)listUIPK)) {
            return null;
        }
        try {
            return this.uiCtrl.getValue(MetaDataPK.create(listUIPK));
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String getBimTemplateType(EntityObjectInfo entity) {
        EntityObjectInfo baseEntity = entity.getBaseEntity();
        if (baseEntity == null) {
            return null;
        }
        if (DATABASE.equalsIgnoreCase(baseEntity.getFullName())) {
            if (BizUnitGenerator.getTreeEntity(entity) != null) {
                return "TreeDetail";
            }
            return "DataBase";
        }
        if (TREEBASE.equalsIgnoreCase(baseEntity.getFullName())) {
            return "TreeBase";
        }
        if (BILLBASE.equalsIgnoreCase(baseEntity.getFullName())) {
            return "BillBase";
        }
        if (COREBILLBASE.equalsIgnoreCase(baseEntity.getFullName())) {
            return "MCoreBillBase";
        }
        return BizUnitGenerator.getBimTemplateType(baseEntity);
    }

    private static BizType getBizType(String bimTemplateType) {
        if ("DataBase".equalsIgnoreCase(bimTemplateType)) {
            return BizType.BaseData;
        }
        if ("TreeBase".equalsIgnoreCase(bimTemplateType)) {
            return BizType.BaseData;
        }
        if ("TreeDetail".equalsIgnoreCase(bimTemplateType)) {
            return BizType.BaseData;
        }
        return BizType.BusinessBill;
    }

    private static boolean isEntryEntity(EntityObjectInfo entity) {
        EntityObjectInfo baseEntity;
        if (entity == null) {
            return false;
        }
        for (baseEntity = entity.getBaseEntity(); baseEntity != null && !COREBILLENTRYBASE.equalsIgnoreCase(baseEntity.getFullName()); baseEntity = baseEntity.getBaseEntity()) {
        }
        return baseEntity != null;
    }

    private static boolean isDataBase(EntityObjectInfo entity) {
        EntityObjectInfo baseEntity;
        if (entity == null) {
            return false;
        }
        for (baseEntity = entity.getBaseEntity(); baseEntity != null && !DATABASE.equalsIgnoreCase(baseEntity.getFullName()); baseEntity = baseEntity.getBaseEntity()) {
        }
        return baseEntity != null;
    }

    private boolean existBizUnit(String bizUnitPK) throws BOSException {
        MetaDataPK metadataPK = MetaDataPK.create(bizUnitPK);
        return this.bizUnitCtrl.exists(metadataPK) || this.bizTemplateCtrl.exists(metadataPK);
    }

    private static EntityObjectInfo getTreeEntity(EntityObjectInfo entity) {
        if (entity == null) {
            return null;
        }
        PropertyCollection propCol = entity.getProperties();
        int n = propCol.size();
        for (int i = 0; i < n; ++i) {
            if (!(propCol.get(i) instanceof LinkPropertyInfo) || !"true".equalsIgnoreCase(propCol.get(i).getExtendedProperty(ISLINKEDTOGROUPENTITY))) continue;
            return ((LinkPropertyInfo)propCol.get(i)).getRelationship().getSupplierObject();
        }
        return null;
    }

    private void getAllUIFunctions(FunctionObjectCollection functionCol) {
        int n = functionCol.size();
        for (int i = 0; i < n; ++i) {
            FunctionObjectInfo function = functionCol.get(i);
            UIObjectInfo uiObject = BizUnitGenerator.getUIObjectByFunction(function);
            if (uiObject == null) continue;
            this.uiFunctions.put(uiObject.getFullName(), function);
        }
    }

    private static UIObjectInfo getUIObjectByFunction(FunctionObjectInfo function) {
        OperationCollection operations = function.getOperation();
        int n = operations.size();
        for (int i = 0; i < n; ++i) {
            OperationInfo operation = operations.get(i);
            if (operation.getUiActionRef() == null) continue;
            return operation.getUiActionRef().getUIObjectRef();
        }
        return null;
    }

    private void getAllTreeEntityPKs(EntityObjectCollection entityCol) {
        int n = entityCol.size();
        for (int i = 0; i < n; ++i) {
            EntityObjectInfo treeEntity;
            EntityObjectInfo entity = entityCol.get(i);
            if (!BizUnitGenerator.isDataBase(entity) || (treeEntity = BizUnitGenerator.getTreeEntity(entity)) == null) continue;
            this.treeEntityPKs.add(treeEntity.getFullName());
        }
    }

    private boolean isBIMPackage(String packageName) {
        return !StringUtils.isEmpty((String)packageName) && packageName.startsWith(BIMPACKAGE);
    }
}

