/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.util;

import com.kingdee.bos.dao.xml.impl.AbstractMDValue;
import com.kingdee.bos.dao.xml.impl.AbstractProxyStateManager;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.util.ObjectUtils;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

public class CloneUtils {
    private static Logger logger = Logger.getLogger(CloneUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EntityObjectInfo clone(EntityObjectInfo entity) throws CloneNotSupportedException {
        if (entity.getStateManager() instanceof AbstractProxyStateManager) {
            ((AbstractProxyStateManager)entity.getStateManager()).getDelegate();
        }
        entity.setTrueClone(true);
        HashSet worked = new HashSet();
        HashSet tc = new HashSet();
        CloneUtils.deepTravelLinkedEntity(entity, worked, tc);
        try {
            EntityObjectInfo clone;
            EntityObjectInfo entityObjectInfo = clone = (EntityObjectInfo)ObjectUtils.createCopy((Object)entity);
            return entityObjectInfo;
        }
        finally {
            entity.setTrueClone(false);
            for (AbstractMDValue amd : tc) {
                amd.setTrueClone(false);
            }
        }
    }

    private static void deepTravelLinkedEntity(EntityObjectInfo mainEntity, Set worked, Set tc) throws CloneNotSupportedException {
        MetaDataPK pk = MetaDataPK.create(mainEntity.getPackage(), mainEntity.getName());
        if (worked.contains(pk)) {
            logger.error((Object)("Entity " + pk + " has processed! Entity and Entry is a circle!"), (Throwable)new Exception());
            return;
        }
        worked.add(pk);
        PropertyCollection pc = mainEntity.getProperties();
        if (pc != null) {
            Iterator iterator = pc.iterator();
            while (iterator.hasNext()) {
                PropertyInfo prop = (PropertyInfo)iterator.next();
                if (!(prop instanceof LinkPropertyInfo)) continue;
                LinkPropertyInfo lpi = (LinkPropertyInfo)prop;
                RelationshipInfo rsi = lpi.getRelationship();
                if (rsi == null) {
                    throw new CloneNotSupportedException("can't find property's relationship. entity:" + mainEntity.getFullName() + " property:" + lpi.getName());
                }
                CardinalityType ct = rsi.getSupplierCardinality();
                if (!CardinalityType.ONE_TO_UNBOUNDED.equals((Object)ct) && !CardinalityType.ZERO_TO_UNBOUNDED.equals((Object)ct)) continue;
                lpi.setTrueClone(true);
                rsi.setTrueClone(true);
                tc.add(lpi);
                tc.add(rsi);
                EntityObjectInfo entity = rsi.getSupplierObject();
                if (entity == null) {
                    throw new CloneNotSupportedException("can't find relationship's supplier. relationship:" + rsi.getFullName());
                }
                if (entity.getStateManager() instanceof AbstractProxyStateManager) {
                    ((AbstractProxyStateManager)entity.getStateManager()).getDelegate();
                    entity.setTrueClone(true);
                    tc.add(entity);
                }
                if (worked.contains(MetaDataPK.create(entity.getPackage(), entity.getName()))) continue;
                CloneUtils.deepTravelLinkedEntity(entity, worked, tc);
            }
        }
    }
}

