/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.ui.ActionInfo;
import com.kingdee.bos.metadata.ui.UIObjectCollection;
import com.kingdee.bos.metadata.ui.UIObjectCtrl;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;

public class CustomedUIActionSearcher {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.metadata.util.CustomedUIActionSearcher");
    private static final int STREAM_BUFF_LENGTH = 4096;
    private static final byte[] STREAM_BUFF = new byte[4096];
    private String serverPathName = null;
    private String metadataPathName = null;
    private String outputPathName = null;
    private String javaCodeFileName = null;
    private String metadataFileName = null;
    private List list = new ArrayList();
    private UIObjectCtrl uiCtrl = null;
    private static final String SEPARATOR = System.getProperty("file.separator");
    private static final String JAVACODEFILE = "lib" + SEPARATOR + "sp" + SEPARATOR + "eas_sp.jar";
    private static final String METADATAFILE = "metas" + SEPARATOR + "sp-bim-metas.jar";
    private static final String METASPATH = "metas";
    private static final String ALLJAR = "*.jar";
    private static final String UIACTIONSZIP = "UIActions.zip";

    public static void main(String[] args) throws IOException {
        if (args == null || args.length < 2) {
            System.out.println("\u8bf7\u8f93\u5165\u53c2\u6570\uff1a\u670d\u52a1\u7aef\u76ee\u5f55\u3001\u6587\u4ef6\u8f93\u51fa\u76ee\u5f55\u548c\u5305\u540d\uff08\u53ef\u9009\uff09\uff0c\u5982CustomedUIActionSearcher \\\\192.168.19.155\\EAS_Server\\eas\\server C:\\output com.kingdee.eas.basedata");
            return;
        }
        if (args.length == 2) {
            new CustomedUIActionSearcher().search(args[0], args[1], null);
        } else {
            new CustomedUIActionSearcher().search(args[0], args[1], args[2]);
        }
    }

    private String appendSubPath(String parentPath, String subPath) {
        if (StringUtils.isEmpty((String)parentPath)) {
            return subPath;
        }
        if (parentPath.endsWith(SEPARATOR)) {
            return parentPath + subPath;
        }
        return parentPath + SEPARATOR + subPath;
    }

    public void search(String serverPathName, String outputPathName, String packageName) throws IOException {
        File serverPath = new File(serverPathName);
        if (!serverPath.exists()) {
            System.out.println("\u670d\u52a1\u7aef\u76ee\u5f55" + serverPathName + "\u4e0d\u5b58\u5728\uff01");
            return;
        }
        this.serverPathName = serverPath.getAbsolutePath();
        this.metadataPathName = this.appendSubPath(this.serverPathName, METASPATH);
        File metadataPath = new File(this.metadataPathName);
        if (metadataPath == null || !metadataPath.exists()) {
            System.out.println("\u670d\u52a1\u7aef\u76ee\u5f55" + this.serverPathName + "\u7684\u5143\u6570\u636e\u76ee\u5f55metas\u4e0d\u5b58\u5728\uff01");
            return;
        }
        this.metadataPathName = metadataPath.getAbsolutePath();
        this.metadataPathName = this.appendSubPath(this.metadataPathName, "sp-bim-metas.jar") + ";" + this.appendSubPath(this.metadataPathName, ALLJAR);
        File outputPath = new File(outputPathName);
        if (!outputPath.exists()) {
            System.out.println("\u8f93\u51fa\u76ee\u5f55" + outputPathName + "\u4e0d\u5b58\u5728\uff01");
            return;
        }
        this.outputPathName = outputPath.getAbsolutePath();
        this.javaCodeFileName = this.appendSubPath(this.serverPathName, JAVACODEFILE);
        File javaCodeFile = new File(this.javaCodeFileName);
        if (!javaCodeFile.exists()) {
            System.out.println("\u627e\u4e0d\u5230\u4e8c\u6b21\u5f00\u53d1\u4ee3\u7801\u6587\u4ef6" + this.javaCodeFileName + "\uff01");
            return;
        }
        this.javaCodeFileName = javaCodeFile.getAbsolutePath();
        this.metadataFileName = this.appendSubPath(this.serverPathName, METADATAFILE);
        File metadataFile = new File(this.metadataFileName);
        if (!metadataFile.exists()) {
            System.out.println("\u627e\u4e0d\u5230\u4e8c\u6b21\u5f00\u53d1\u5143\u6570\u636e\u6587\u4ef6" + this.metadataFileName + "\uff01");
            return;
        }
        this.metadataFileName = metadataFile.getAbsolutePath();
        try {
            this.uiCtrl = new UIObjectCtrl(this.getContext());
        }
        catch (Exception e) {
            System.out.println("\u5143\u5143\u6570\u636e\u88c5\u8f7d\u5931\u8d25\uff01\u53ef\u80fd\u5f15\u7528\u7684\u7c7b\u8def\u5f84\u4e2d\u6ca1\u6709metametas.jar\u5305\u3002\n" + e.toString());
            return;
        }
        System.out.println("\u5f00\u59cb\u904d\u5386\u5143\u6570\u636e\u76ee\u5f55...");
        try {
            this.searchCustomedUIAction(packageName);
            this.packFiles(this.appendSubPath(this.outputPathName, UIACTIONSZIP));
        }
        catch (BOSException e) {
            System.out.println("\u641c\u7d22\u4e2a\u6027\u5316UIAction\u5931\u8d25\uff01\n" + e.toString());
            return;
        }
        System.out.println("\u641c\u7d22\u4e2a\u6027\u5316UIAction\u5b8c\u6bd5\uff0c\u6210\u529f\u751f\u6210UIActions.zip\u6587\u4ef6\u3002");
    }

    private void searchCustomedUIAction(String packageName) throws BOSException {
        UIObjectCollection uiCol = StringUtils.isEmpty((String)packageName) ? this.uiCtrl.getCollection() : this.uiCtrl.getCollection(packageName);
        int n = uiCol.size();
        for (int i = 0; i < n; ++i) {
            UIObjectInfo model = uiCol.get(i);
            this.searchCustomedUIAction(model);
        }
    }

    private void searchCustomedUIAction(UIObjectInfo model) throws BOSException {
        int n = model.getActions().size();
        for (int i = 0; i < n; ++i) {
            ActionInfo action = model.getActions().get(i);
            if (StringUtils.isEmpty((String)action.getActionPerformed())) continue;
            this.writeToLog("[UI]:" + model.getFullName() + "; [Action]:" + action.getName());
        }
    }

    private void writeToLog(String log) {
        this.list.add(log + "\n");
        System.out.println(log);
    }

    private Context getContext() {
        Context ctx = new Context(null, "eas", "", BOSLocaleUtil.ZH_CN);
        ctx.put((Object)"current_mode", (Object)"DEBUG");
        ctx.put((Object)"METADATAPATH", (Object)this.metadataPathName);
        return ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void packFiles(String zipFileName) throws IOException {
        ZipOutputStream zos = null;
        try {
            zos = new ZipOutputStream(new FileOutputStream(zipFileName));
            FileInputStream is = null;
            int readNum = 0;
            File javaCodeFile = new File(this.javaCodeFileName);
            ZipEntry entry = new ZipEntry("eas_sp.jar");
            entry.setTime(javaCodeFile.lastModified());
            zos.putNextEntry(entry);
            try {
                is = new FileInputStream(this.javaCodeFileName);
                while ((readNum = ((InputStream)is).read(STREAM_BUFF)) != -1) {
                    zos.write(STREAM_BUFF, 0, readNum);
                }
            }
            finally {
                try {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                }
                catch (IOException e) {
                    logger.error((Object)"close InputStream error!", (Throwable)e);
                }
            }
            File metadataFile = new File(this.metadataFileName);
            entry = new ZipEntry("sp-bim-metas.jar");
            entry.setTime(metadataFile.lastModified());
            zos.putNextEntry(entry);
            try {
                is = new FileInputStream(this.metadataFileName);
                while ((readNum = ((InputStream)is).read(STREAM_BUFF)) != -1) {
                    zos.write(STREAM_BUFF, 0, readNum);
                }
            }
            finally {
                try {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                }
                catch (IOException e) {
                    logger.error((Object)"close InputStream error!", (Throwable)e);
                }
            }
            entry = new ZipEntry("list.txt");
            entry.setTime(new Date().getTime());
            zos.putNextEntry(entry);
            int n = this.list.size();
            for (int i = 0; i < n; ++i) {
                zos.write(((String)this.list.get(i)).getBytes("UTF-8"));
            }
        }
        finally {
            if (zos != null) {
                try {
                    zos.finish();
                }
                catch (IOException e) {
                    logger.error((Object)"close InputStream error!", (Throwable)e);
                }
                try {
                    zos.close();
                }
                catch (IOException e) {
                    logger.error((Object)"close InputStream error!", (Throwable)e);
                }
            }
        }
    }
}

