/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.util;

import com.kingdee.bos.metadata.util.XmlUtils;
import com.kingdee.bos.util.XMLParser;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class FormatXmlUtil {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.metadata.util.FormatXmlUtil");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawOutFormatXml(File ui, String outDir) {
        FileInputStream fis0 = null;
        PrintWriter fw = null;
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            fis0 = new FileInputStream(ui);
            Document doc = XMLParser.parseXML((InputStream)fis0);
            Namespace ns = doc.getRootElement().getNamespace();
            Element resource = doc.getRootElement().getChild("resource", ns);
            List rsList = resource.getChildren();
            int i = 1;
            for (Element rs : rsList) {
                String key = rs.getAttributeValue("key");
                if (key.indexOf("formatXml") <= 0) continue;
                List langList = rs.getChildren();
                for (Element lang : langList) {
                    String locale = lang.getAttributeValue("locale");
                    if (!locale.equals("zh_CN")) continue;
                    String value = lang.getAttributeValue("value");
                    String fileName = outDir + "/formatXml_" + i++ + ".xml";
                    try {
                        fw = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), "utf-8")), false);
                        fw.println(value);
                        fis = new FileInputStream(fileName);
                        Document temp = XMLParser.parseXML((InputStream)fis);
                        fos = new FileOutputStream(fileName);
                        XmlUtils.output(temp, fos);
                    }
                    finally {
                        if (fw != null) {
                            fw.close();
                        }
                        try {
                            if (fis != null) {
                                fis.close();
                            }
                        }
                        catch (IOException e) {
                            logger.error((Object)"close FileInputStream error!", (Throwable)e);
                        }
                        try {
                            if (fos == null) continue;
                            fos.close();
                        }
                        catch (IOException e) {
                            logger.error((Object)"close FileOutputStream error!", (Throwable)e);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        finally {
            try {
                if (fis0 != null) {
                    fis0.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)"close FileInputStream error!", (Throwable)e);
            }
        }
    }

    public static void main(String[] args) {
        String file = "d:/jiuhe/workspace/jh/metadata/com/kingdee/eas/scm/sd/sale/client/SaleContractEditUI.ui";
        FormatXmlUtil.drawOutFormatXml(new File(file), "d:/temp");
    }
}

