/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.util;

import com.kingdee.bos.metadata.util.XmlUtils;
import com.kingdee.bos.util.XMLParser;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.log4j.Logger;
import org.jdom2.Content;
import org.jdom2.DefaultJDOMFactory;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMFactory;
import org.jdom2.Namespace;

public class IndustryUtil {
    private static Logger logger = Logger.getLogger(IndustryUtil.class);
    private static JDOMFactory jdfactory = new DefaultJDOMFactory();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateExtMDList(String industryBaseDir, String industryExtDir, String standardDir, String outXml) {
        File extDirc = new File(industryExtDir);
        if (!extDirc.exists()) {
            logger.error((Object)"industryExtDir not exist!");
            return;
        }
        File baseDirc = new File(industryBaseDir);
        if (!baseDirc.exists() || !baseDirc.isDirectory()) {
            logger.error((Object)"industryBaseDir not exist!");
            return;
        }
        File standardDirc = new File(standardDir);
        if (!standardDirc.exists() || !standardDirc.isDirectory()) {
            logger.error((Object)"standardDir not exist!");
            return;
        }
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory() || pathname.getName().endsWith(".bizunit") || pathname.getName().endsWith(".entity") || pathname.getName().endsWith(".facade") || pathname.getName().endsWith(".ui") || pathname.getName().endsWith(".function") || pathname.getName().endsWith(".query") || pathname.getName().endsWith(".rule") || pathname.getName().endsWith(".relation") || pathname.getName().endsWith(".table") || pathname.getName().endsWith(".enum") || pathname.getName().endsWith(".ruleset") || pathname.getName().endsWith(".botmapping") || pathname.getName().endsWith(".event") || pathname.getName().endsWith(".exception") || pathname.getName().endsWith(".package") || pathname.getName().endsWith(".kdwf");
            }
        };
        Element root = jdfactory.element("extMetadatas");
        IndustryUtil.generateExtMDList0(extDirc, baseDirc, standardDirc, root, filter);
        Document doc = jdfactory.document(root);
        File outFile = new File(outXml);
        if (!outFile.getParentFile().exists()) {
            outFile.getParentFile().mkdirs();
        }
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(outFile);
            XmlUtils.output(root.getDocument(), os);
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
        finally {
            try {
                if (os != null) {
                    ((OutputStream)os).close();
                }
            }
            catch (IOException e) {
                logger.error((Object)"close FileOutputStream error!", (Throwable)e);
            }
        }
    }

    private static void generateExtMDList0(File file, File baseDir, File standardDirc, Element ele, FileFilter filter) {
        File[] children = file.listFiles(filter);
        for (int i = 0; i < children.length; ++i) {
            File child = children[i];
            if (child.isDirectory()) {
                IndustryUtil.generateExtMDList0(child, baseDir, standardDirc, ele, filter);
                continue;
            }
            try {
                String path = child.getCanonicalPath();
                String pk = path.substring(path.indexOf(File.separator + "com" + File.separator) + 1);
                File base = new File(baseDir, pk);
                File standardBase = new File(standardDirc, pk);
                FileInputStream is = new FileInputStream(child);
                Element root = XMLParser.parseXML((InputStream)is).getRootElement();
                is.close();
                Namespace ns = root.getNamespace();
                String alias = root.getChildTextTrim("alias", ns);
                if (alias == null) {
                    alias = "";
                }
                Element childEle = jdfactory.element("metadata");
                childEle.setAttribute("pk", pk);
                childEle.setAttribute("extPath", path);
                childEle.setAttribute("basePath", base.getCanonicalPath());
                childEle.setAttribute("standardBasePath", standardBase.getCanonicalPath());
                childEle.setAttribute("alias", alias);
                childEle.setAttribute("remark", "");
                ele.addContent((Content)childEle);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
    }

    public static void main(String[] args) {
        if (args.length == 4) {
            IndustryUtil.generateExtMDList(args[0], args[1], args[2], args[3]);
        } else {
            System.out.println("args is error");
        }
    }
}

