/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.util;

import com.kingdee.bos.metadata.util.XmlUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Locale;
import org.jdom2.Content;
import org.jdom2.DefaultJDOMFactory;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMFactory;

public class MakeLibUtil {
    private static JDOMFactory jf = new DefaultJDOMFactory();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void makeLib(File libPath, File outFile) throws IOException {
        Element root = jf.element("eclipse-userlibraries");
        root.setAttribute("version", "2");
        MakeLibUtil.makeLib(root, libPath, "trd", false);
        MakeLibUtil.makeLib(root, libPath, "bos", true);
        MakeLibUtil.makeLib(root, libPath, "eas", true);
        MakeLibUtil.makeLib(root, libPath, "mri", true);
        Document doc = jf.document(root);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(outFile);
            XmlUtils.output(doc, fos);
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static void makeLib(Element root, File libPath, String libName, boolean linkSource) throws IOException {
        Element lib = jf.element("library");
        lib.setAttribute("name", libName + "_lib");
        lib.setAttribute("systemlibrary", "false");
        MakeLibUtil.makeArchive(libPath, "common", libName, linkSource, lib);
        MakeLibUtil.makeArchive(libPath, "server", libName, linkSource, lib);
        MakeLibUtil.makeArchive(libPath, "client", libName, linkSource, lib);
        root.addContent((Content)lib);
    }

    private static void makeArchive(File libPath, String subPath, String libName, boolean linkSource, Element lib) throws IOException {
        File f = new File(libPath, subPath + "/" + libName);
        if (f.exists()) {
            File[] jars = f.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isFile() && pathname.getName().toLowerCase(Locale.ENGLISH).endsWith(".jar");
                }
            });
            for (int i = 0; i < jars.length; ++i) {
                Element archive = jf.element("archive");
                String jarName = jars[i].getName();
                archive.setAttribute("path", jars[i].getCanonicalPath().replace('\\', '/'));
                if (linkSource && jarName.indexOf("_resource_") < 0) {
                    int index = jarName.indexOf("-server.jar");
                    if (index < 0) {
                        index = jarName.indexOf("-client.jar");
                    }
                    if (index < 0) {
                        index = jarName.indexOf(".jar");
                    }
                    String source = libPath + "/src/" + jarName.substring(0, index) + "-src.jar";
                    archive.setAttribute("source", source.replace('\\', '/'));
                }
                lib.addContent((Content)archive);
            }
        }
    }

    public static void main(String[] args) {
        File libPath = new File("G:/mking_work/workspace62_1/lib");
        File outFile = new File("D:/temp/621_lib.userlibraries");
        try {
            MakeLibUtil.makeLib(libPath, outFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

