/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.DataTableCtrl;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.entity.EntityObjectCollection;
import com.kingdee.bos.metadata.entity.EntityObjectCtrl;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;

public class TableUpdater {
    private static final Logger log = Logger.getLogger((String)"com.kingdee.bos.metadata.util.TableUpdater");
    private String metadataRootPathName = null;
    private EntityObjectCtrl entityCtrl = null;
    private DataTableCtrl tableCtrl = null;
    private static final String BASEENTITYNAME = "TreeBase";
    private static final String ADDCOLUMNNAME = "FDisplayName";

    public static void main(String[] args) throws IOException {
        if (args == null || args.length == 0) {
            log.debug((Object)"\u8bf7\u8f93\u5165\u53c2\u6570\uff1a\u5143\u6570\u636e\u6839\u76ee\u5f55\u548c\u5305\u540d\uff0c\u5982TableUpdater C:\\metadata com.kingdee.eas.basedata");
            return;
        }
        if (args.length == 1) {
            new TableUpdater().update(args[0], null);
        } else {
            new TableUpdater().update(args[0], args[1]);
        }
    }

    public void update(String metadataRootPathName, String packageName) throws IOException {
        File metadataRootPath = new File(metadataRootPathName);
        if (!metadataRootPath.exists()) {
            log.debug((Object)("\u5143\u6570\u636e\u6839\u76ee\u5f55" + metadataRootPathName + "\u4e0d\u5b58\u5728\uff01"));
            return;
        }
        this.metadataRootPathName = metadataRootPath.getAbsolutePath();
        try {
            this.entityCtrl = new EntityObjectCtrl(this.getContext());
            this.tableCtrl = new DataTableCtrl(this.getContext());
        }
        catch (Exception e) {
            log.debug((Object)("\u5143\u5143\u6570\u636e\u88c5\u8f7d\u5931\u8d25\uff01\u53ef\u80fd\u5f15\u7528\u7684\u7c7b\u8def\u5f84\u4e2d\u6ca1\u6709metametas.jar\u5305\u3002\n" + e.toString()));
            return;
        }
        log.debug((Object)"\u5f00\u59cb\u904d\u5386\u5143\u6570\u636e\u76ee\u5f55...");
        try {
            this.updateEntityTable(packageName);
        }
        catch (BOSException e) {
            log.debug((Object)("\u5b9e\u4f53\u8868\u66f4\u65b0\u5931\u8d25\uff01\n" + e.toString()));
            return;
        }
        log.debug((Object)"\u5b9e\u4f53\u8868\u66f4\u65b0\u5b8c\u6bd5\u3002");
    }

    private boolean isTreeBase(EntityObjectInfo entity) {
        for (EntityObjectInfo baseEntity = entity.getBaseEntity(); baseEntity != null; baseEntity = baseEntity.getBaseEntity()) {
            if (!BASEENTITYNAME.equalsIgnoreCase(baseEntity.getName())) continue;
            return true;
        }
        return false;
    }

    private void updateEntityTable(String packageName) throws BOSException {
        EntityObjectCollection entityCol = StringUtils.isEmpty((String)packageName) ? this.entityCtrl.getCollection() : this.entityCtrl.getCollection(packageName);
        int n = entityCol.size();
        for (int i = 0; i < n; ++i) {
            DataTableInfo table;
            EntityObjectInfo entity = entityCol.get(i);
            if (entity.getTable() == null || !this.isTreeBase(entity) || !this.addDisplayNameColumn(table = entity.getTable())) continue;
            this.tableCtrl.update(MetaDataPK.create(table.getFullName()), table);
        }
    }

    private boolean addDisplayNameColumn(DataTableInfo table) {
        if (table.getColumnByName(ADDCOLUMNNAME) != null) {
            return false;
        }
        ColumnInfo column = new ColumnInfo();
        column = new ColumnInfo();
        column.setName(ADDCOLUMNNAME);
        column.setAlias("\u663e\u793a\u540d\u79f0");
        column.setDescription("\u663e\u793a\u6253\u5370\u65f6\u4f7f\u7528\u7684\u957f\u540d\u79f0");
        column.setTypeName(SQLType.NVARCHAR);
        column.setLength(80);
        column.setNullable(true);
        column.setMultilingual(true);
        table.getColumns().add(column);
        return true;
    }

    private Context getContext() {
        Context ctx = new Context(null, "eas", "", BOSLocaleUtil.ZH_CN);
        ctx.put((Object)"current_mode", (Object)"DEBUG");
        ctx.put((Object)"METADATAPATH", (Object)this.metadataRootPathName);
        return ctx;
    }
}

