/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.util;

import com.kingdee.bos.util.XMLParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class XmlUtils {
    private static Logger logger = Logger.getLogger(XmlUtils.class);

    public static void output(Document dom, OutputStream os, boolean close) throws IOException {
        Format format = Format.getCompactFormat();
        format.setEncoding("UTF-8");
        format.setIndent("    ");
        format.setTextMode(Format.TextMode.TRIM_FULL_WHITE);
        XMLOutputter out = new XMLOutputter(format);
        out.output(dom, os);
        if (close) {
            try {
                os.close();
            }
            catch (IOException ioe) {
                logger.error((Object)ioe, (Throwable)ioe);
            }
        }
    }

    public static void output(Document dom, OutputStream os) throws IOException {
        XmlUtils.output(dom, os, true);
    }

    public static void verify(String xml) throws Exception {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(xml.getBytes("UTF-8"));
            XMLParser.parseXML((InputStream)bis);
        }
        catch (Exception e) {
            throw new Exception("xml format error", e);
        }
    }
}

