/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.validate;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.validate.CheckItem;
import com.kingdee.bos.metadata.validate.VerifyScene;
import com.kingdee.bos.metadata.validate.VerifyTargetType;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CheckItemSet {
    private Logger logger = Logger.getLogger((String)"com.kingdee.bos.metadata.validate.CheckItemSet");
    private static final String ITEM_TYPE = "type";
    protected static final String CHECK_ITEM = "checkitem";
    private static final String ITEM_NAME = "name";
    private static final String ITEM_DESCRIPTION = "description";
    private static final String ITEM_CLASSNAME = "class";
    private static final String ITEM_OBJECTS = "objects";
    private static final String ITEM_SCENES = "scenes";
    private static final String ITEM_OBJECT = "object";
    private static final String ITEM_SCENE = "scene";
    private static final String ITEM_ENABLED = "enabled";
    private static final String ITEM_LEVEL = "level";
    private List fItems = new ArrayList();
    private String fCheckTag;

    public CheckItemSet(String checkTag) {
        this.fCheckTag = checkTag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFromFile(File file, boolean allowDuplicates) throws BOSException {
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(file);
            this.addFromStream(stream, allowDuplicates, false);
        }
        catch (IOException e) {
            this.throwException(e);
        }
        finally {
            try {
                if (stream != null) {
                    ((InputStream)stream).close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public String getCheckTag() {
        return this.fCheckTag;
    }

    public void addFromStream(InputStream stream, boolean allowDuplicates, boolean doTranslations) throws BOSException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            factory.setExpandEntityReferences(false);
            DocumentBuilder parser = factory.newDocumentBuilder();
            Document document = parser.parse(new InputSource(stream));
            NodeList elements = document.getElementsByTagName(this.getCheckTag());
            ArrayList<VerifyTargetType> objects = new ArrayList<VerifyTargetType>();
            ArrayList<VerifyScene> scenes = new ArrayList<VerifyScene>();
            int count = elements.getLength();
            for (int i = 0; i != count; ++i) {
                String itemType = "OTHER";
                String itemName = "";
                String itemDescription = "";
                String itemClassName = "";
                int itemLevel = 1;
                boolean enabled = false;
                objects.clear();
                scenes.clear();
                Node item = elements.item(i);
                NodeList leafs = item.getChildNodes();
                int leafCount = leafs.getLength();
                for (int j = 0; j != leafCount; ++j) {
                    int k;
                    Node leaf = leafs.item(j);
                    if (leaf.getNodeName().equals(ITEM_NAME)) {
                        itemName = this.getNodeValue(leaf);
                        continue;
                    }
                    if (leaf.getNodeName().equals(ITEM_DESCRIPTION)) {
                        itemDescription = this.getNodeValue(leaf);
                        continue;
                    }
                    if (leaf.getNodeName().equals(ITEM_CLASSNAME)) {
                        itemClassName = this.getNodeValue(leaf);
                        continue;
                    }
                    if (leaf.getNodeName().equals(ITEM_TYPE)) {
                        itemType = this.getNodeValue(leaf);
                        continue;
                    }
                    if (leaf.getNodeName().equals(ITEM_ENABLED)) {
                        String sEnabled = this.getNodeValue(leaf);
                        enabled = sEnabled.equals("true");
                        continue;
                    }
                    if (leaf.getNodeName().equals(ITEM_LEVEL)) {
                        String sLevel = this.getNodeValue(leaf);
                        try {
                            itemLevel = Integer.parseInt(sLevel);
                        }
                        catch (NumberFormatException e) {
                            this.logger.debug((Object)"", (Throwable)e);
                            itemLevel = 1;
                        }
                        continue;
                    }
                    if (leaf.getNodeName().equals(ITEM_OBJECTS)) {
                        NodeList objectList = leaf.getChildNodes();
                        int objectCount = objectList.getLength();
                        for (k = 0; k != objectCount; ++k) {
                            Node object = objectList.item(k);
                            if (!object.getNodeName().equals(ITEM_OBJECT)) continue;
                            VerifyTargetType objectName = VerifyTargetType.getEnum(this.getNodeValue(object));
                            objects.add(objectName);
                        }
                        continue;
                    }
                    if (!leaf.getNodeName().equals(ITEM_SCENES)) continue;
                    NodeList sceneList = leaf.getChildNodes();
                    int sceneCount = sceneList.getLength();
                    for (k = 0; k != sceneCount; ++k) {
                        Node scene = sceneList.item(k);
                        if (!scene.getNodeName().equals(ITEM_SCENE)) continue;
                        VerifyScene sceneName = VerifyScene.getEnum(this.getNodeValue(scene));
                        scenes.add(sceneName);
                    }
                }
                CheckItem checkItem = new CheckItem(itemName, itemDescription, itemClassName, itemType, itemLevel, objects, scenes);
                checkItem.setEnabled(enabled);
                this.add(checkItem);
            }
        }
        catch (ParserConfigurationException e) {
            this.throwException(e);
        }
        catch (IOException e) {
            this.throwException(e);
        }
        catch (SAXException e) {
            this.throwException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToFile(File file) throws BOSException {
        FileOutputStream stream = null;
        try {
            stream = new FileOutputStream(file);
            this.saveToStream(stream);
        }
        catch (IOException e) {
            this.throwException(e);
        }
        finally {
            try {
                if (stream != null) {
                    ((OutputStream)stream).close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void saveToStream(OutputStream stream) throws BOSException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            factory.setExpandEntityReferences(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element root = document.createElement("checks");
            document.appendChild(root);
            for (int i = 0; i != this.fItems.size(); ++i) {
                Text leaf2;
                CheckItem checkItem = (CheckItem)this.fItems.get(i);
                Element node = document.createElement(this.getCheckTag());
                root.appendChild(node);
                Element root2 = node;
                node = document.createElement(ITEM_NAME);
                Node leaf = document.createTextNode(checkItem.getName());
                node.appendChild(leaf);
                root2.appendChild(node);
                node = document.createElement(ITEM_DESCRIPTION);
                leaf = document.createTextNode(checkItem.getDescription());
                node.appendChild(leaf);
                root2.appendChild(node);
                node = document.createElement(ITEM_CLASSNAME);
                leaf = document.createTextNode(checkItem.getClassName());
                node.appendChild(leaf);
                root2.appendChild(node);
                node = document.createElement(ITEM_TYPE);
                leaf = document.createTextNode(checkItem.getType());
                node.appendChild(leaf);
                root2.appendChild(node);
                node = document.createElement(ITEM_LEVEL);
                leaf = document.createTextNode(String.valueOf(checkItem.getLevel()));
                node.appendChild(leaf);
                root2.appendChild(node);
                if (!checkItem.getObjects().isEmpty()) {
                    node = document.createElement(ITEM_OBJECTS);
                    for (VerifyTargetType objectName : checkItem.getObjects()) {
                        leaf = document.createElement(ITEM_OBJECT);
                        leaf2 = document.createTextNode(objectName.getName());
                        leaf.appendChild(leaf2);
                        node.appendChild(leaf);
                    }
                    root2.appendChild(node);
                }
                if (!checkItem.getScenes().isEmpty()) {
                    node = document.createElement(ITEM_SCENES);
                    for (VerifyScene sceneName : checkItem.getScenes()) {
                        leaf = document.createElement(ITEM_SCENE);
                        leaf2 = document.createTextNode(sceneName.getName());
                        leaf.appendChild(leaf2);
                        node.appendChild(leaf);
                    }
                    root2.appendChild(node);
                }
                node = document.createElement(ITEM_ENABLED);
                leaf = checkItem.isEnabled() ? document.createTextNode("true") : document.createTextNode("false");
                node.appendChild(leaf);
                root2.appendChild(node);
            }
            TransformerFactory trfactory = TransformerFactory.newInstance();
            trfactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            trfactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            trfactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
            trfactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            trfactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            Transformer transformer = trfactory.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(stream);
            transformer.transform(source, result);
        }
        catch (ParserConfigurationException e) {
            this.throwException(e);
        }
        catch (TransformerException e) {
            this.throwException(e);
        }
    }

    private void throwException(Throwable t) throws BOSException {
        throw new BOSException(t);
    }

    public void add(CheckItem item) {
        if (this.exists(item)) {
            return;
        }
        this.fItems.add(item);
    }

    private boolean exists(CheckItem item) {
        for (CheckItem anotherItem : this.fItems) {
            if (!item.equals(anotherItem)) continue;
            return true;
        }
        return false;
    }

    public void remove(CheckItem item) {
        this.fItems.remove(item);
    }

    public void clear() {
        this.fItems.clear();
    }

    public CheckItem[] getItems() {
        return this.fItems.toArray(new CheckItem[this.fItems.size()]);
    }

    public CheckItem[] getItems(String name) {
        ArrayList<CheckItem> res = new ArrayList<CheckItem>();
        for (CheckItem curr : this.fItems) {
            if (!curr.getName().equals(name)) continue;
            res.add(curr);
        }
        return res.toArray(new CheckItem[res.size()]);
    }

    public CheckItem getFirstItem(String name) {
        for (CheckItem curr : this.fItems) {
            if (!curr.getName().equals(name)) continue;
            return curr;
        }
        return null;
    }

    private String getNodeValue(Node node) {
        if (node != null && (node = node.getFirstChild()) != null) {
            return node.getNodeValue();
        }
        return "";
    }
}

