/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.validate;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.validate.CheckItemSet;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;

public class CheckItems
extends CheckItemSet {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.bos.metadata.validate.CheckItems");
    private static final String DEFAULT_FILE = "default_checks.xml";
    public static final String CHECK_FILE = "checks.xml";
    private static CheckItems fgCheckItems;
    private File checkFile;

    public static void init(String fileName) {
        assert (fileName != null && fileName.length() > 0);
        if (fgCheckItems == null) {
            fgCheckItems = new CheckItems(new File(fileName));
        }
    }

    public static CheckItems getInstance() {
        if (fgCheckItems == null) {
            fgCheckItems = new CheckItems();
        }
        return fgCheckItems;
    }

    private CheckItems() {
        super("checkitem");
        InputStream is = null;
        try {
            is = CheckItems.getDefaultsAsStream();
            this.addFromStream(is, true, true);
        }
        catch (BOSException e) {
            logger.debug((Object)"", (Throwable)e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)"close InputStream error!", (Throwable)e);
            }
        }
    }

    private CheckItems(File file) {
        super("checkitem");
        this.checkFile = file;
        this.create(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void create(File file) {
        InputStream is = null;
        try {
            if (file.exists()) {
                this.addFromFile(file, true);
            } else {
                is = CheckItems.getDefaultsAsStream();
                this.addFromStream(is, true, true);
                this.saveToFile(file);
            }
        }
        catch (BOSException e) {
            logger.debug((Object)"", (Throwable)e);
            this.clear();
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)"close InputStream error!", (Throwable)e);
            }
        }
    }

    public void reset() throws BOSException {
        this.clear();
        this.addFromFile(this.getCheckFile(), true);
    }

    public void restoreDefaults() throws BOSException {
        this.clear();
        InputStream is = null;
        try {
            is = CheckItems.getDefaultsAsStream();
            this.addFromStream(is, true, true);
        }
        catch (BOSException e) {
            logger.debug((Object)"", (Throwable)e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)"close InputStream error!", (Throwable)e);
            }
        }
    }

    public void save() throws BOSException {
        this.saveToFile(this.getCheckFile());
    }

    private static InputStream getDefaultsAsStream() {
        return CheckItems.class.getResourceAsStream(DEFAULT_FILE);
    }

    private File getCheckFile() {
        return this.checkFile;
    }
}

