/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.validate.util;

import com.kingdee.bos.dao.xml.Utils;
import com.kingdee.util.SAXBuilderFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

public class FileFormatChecker {
    private static final Logger logger = Logger.getLogger(FileFormatChecker.class);
    private static final SAXBuilder builder = SAXBuilderFactory.create();

    public static List checkMetadataFileFormat(File root) {
        if (root == null || !root.exists()) {
            logger.error((Object)"Bad metadata path!");
            return null;
        }
        if (root.isDirectory()) {
            LinkedList result = new LinkedList();
            FileFormatChecker.innerCheckDir(root, result);
            return result;
        }
        return null;
    }

    private static void innerCheckDir(File dir, List result) {
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isFile()) {
                if (!FileFormatChecker.isMetaFile(files[i].getName()) || FileFormatChecker.checkXMLFormat(files[i])) continue;
                result.add(files[i]);
                continue;
            }
            if ("CVS".equalsIgnoreCase(files[i].getName())) continue;
            FileFormatChecker.innerCheckDir(files[i], result);
        }
    }

    private static boolean checkXMLFormat(File file) {
        try {
            builder.build(file);
            return true;
        }
        catch (JDOMException e) {
            logger.error((Object)"Metadata file format error!", (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)"Metadata file IOException!", (Throwable)e);
        }
        return false;
    }

    private static boolean isMetaFile(String fileName) {
        if (fileName == null || fileName.indexOf(46) == -1 || fileName.endsWith(".")) {
            return false;
        }
        String suffix = fileName.substring(fileName.lastIndexOf(46) + 1);
        if (suffix == null) {
            return false;
        }
        return (suffix = Utils.getBOSTypeBySuffix(suffix)) != null;
    }

    private static void log(Writer writer, String log) {
        if (writer != null) {
            try {
                writer.write(log + '\n');
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
        } else {
            logger.info((Object)log);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkMetadataFileFormat(String metadataPath, String logPath) {
        Writer os = null;
        try {
            logPath = logPath != null && !logPath.endsWith(File.separator) ? logPath + File.separator : "";
            os = new FileWriter(logPath + "fileformat_verify.log");
            FileFormatChecker.log(os, "Begin working.....");
            List result = FileFormatChecker.checkMetadataFileFormat(new File(metadataPath));
            if (result == null) {
                FileFormatChecker.log(os, "Bad metadata path or No supported file path.");
                return;
            }
            if (result.size() > 0) {
                FileFormatChecker.log(os, "The following files format is bad!");
            } else {
                FileFormatChecker.log(os, "All files format is good!");
            }
            for (File file : result) {
                FileFormatChecker.log(os, file.getPath());
            }
            FileFormatChecker.log(os, "End of the job");
        }
        catch (FileNotFoundException e) {
            logger.error((Object)"error", (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)"error", (Throwable)e);
        }
        finally {
            if (os != null) {
                try {
                    os.flush();
                }
                catch (IOException e) {
                    logger.error((Object)"flush Writer error!", (Throwable)e);
                }
                try {
                    os.close();
                }
                catch (IOException e) {
                    logger.error((Object)"close Writer error!", (Throwable)e);
                }
            }
        }
    }

    public static void main(String[] args) {
        if (args.length != 1 && args.length != 2) {
            FileFormatChecker.log(null, "Usage: java com.kingdee.bos.metadata.validate.util.FileFormatChecker <metadataPath> [log file path]");
            FileFormatChecker.log(null, "           result in {log file path}\fileformat_verify.log");
            FileFormatChecker.log(null, "           there is more detail in the log4j log file you specified");
            return;
        }
        String logPath = null;
        if (args.length == 2) {
            logPath = args[1];
        }
        FileFormatChecker.checkMetadataFileFormat(args[0], logPath);
    }
}

