/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.validate.util;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.xml.Utils;
import com.kingdee.bos.dao.xml.XMLAccessEngine;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.upgrade.MetaCtrlFactory;
import com.kingdee.bos.metadata.upgrade.Solution;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;

public class NameVerify {
    public static void main(String[] args) throws Exception {
        if (args.length != 1 && args.length != 2) {
            System.out.println("Usage: java com.kingdee.bos.metadata.validate.util.NameVerify <metadataPath> [log file path]");
            System.out.println("           result in {log file path}\name_verify.log");
            return;
        }
        String logPath = null;
        if (args.length == 2) {
            logPath = args[1];
        }
        NameVerify.checkName(args[0], logPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkName(String metadataPath, String logPath) {
        Writer os = null;
        try {
            logPath = logPath != null && !logPath.endsWith(File.separator) ? logPath + File.separator : "";
            os = new FileWriter(logPath + "name_verify.log");
            XMLAccessEngine.useBinaryMetadata = false;
            Solution s = new Solution(metadataPath);
            NameVerify.log(os, "# [Define in metadata package + name + bosType]  --  [storage location filename]");
            try {
                Enumeration en = s.getEntrys();
                while (en.hasMoreElements()) {
                    NameVerify.needReleaseMemory();
                    String entry = (String)en.nextElement();
                    if (StringUtils.isEmpty((String)entry) || entry.endsWith("/") || entry.indexOf("CVS/") != -1 || entry.endsWith(".properties") || entry.endsWith(".txt") || entry.endsWith("/MANIFEST.MF") || entry.indexOf("/.") != -1) continue;
                    try {
                        IObjectValue ov = s.getObjectValue(entry);
                        if (!(ov instanceof AbstractMetaDataValue)) continue;
                        AbstractMetaDataValue m = (AbstractMetaDataValue)ov;
                        String name = m.getFullName().replace('.', '/');
                        String suffix = Utils.getMetaDataSuffix(m.getBOSType());
                        if ((name = name + suffix).equals(entry)) continue;
                        NameVerify.log(os, name + "  --   " + entry);
                    }
                    catch (Exception e) {
                        NameVerify.log(null, "\n************* XML Loader Error entry = " + entry + " Detail:\n");
                    }
                }
            }
            catch (IOException e) {
                NameVerify.log(null, e.toString());
            }
            NameVerify.log(os, "End of the job");
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
        }
        finally {
            if (os != null) {
                try {
                    os.flush();
                }
                catch (IOException iOException) {}
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static boolean needReleaseMemory() {
        Runtime rt = Runtime.getRuntime();
        long total = rt.totalMemory();
        long free = rt.freeMemory();
        long max = rt.maxMemory();
        if (max - (total - free) < 0x800000L) {
            MetaCtrlFactory.clearCtrls();
            return true;
        }
        return false;
    }

    private static void log(Writer os, String str) {
        if (os != null) {
            try {
                os.write(str + "\n");
            }
            catch (Exception e) {
                System.out.println(str);
            }
        } else {
            System.out.println(str);
        }
    }
}

