/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.view;

import com.kingdee.bos.metadata.view.SubSystemUtils;
import com.kingdee.bos.util.XMLParser;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;

class FilterDocumentBuilder {
    private static Logger log = Logger.getLogger(FilterDocumentBuilder.class);
    private static final String FULLNAME = "fullname";
    private static final String ISLEAF = "isleaf";
    private final String filePath;
    private static final Map<String, FilterDocumentBuilder> builders = new HashMap<String, FilterDocumentBuilder>(2);
    private Document doc = null;

    private FilterDocumentBuilder(String filePath) {
        this.filePath = filePath;
    }

    static FilterDocumentBuilder getInstance(String filePath) {
        FilterDocumentBuilder b = builders.get(filePath);
        if (b == null) {
            b = new FilterDocumentBuilder(filePath);
            builders.put(filePath, b);
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized Document getDocument() {
        if (this.doc != null) {
            return this.doc;
        }
        String[] paths = this.filePath.split(";");
        int index = 0;
        for (int i = 0; i < paths.length; ++i) {
            if (paths[i] != null && new File(paths[i]).exists()) {
                index = i;
                break;
            }
            log.warn((Object)(paths[i] + " not exists!"));
        }
        try {
            this.doc = new SAXBuilder().build(new File(paths[index]));
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        if (paths.length > 1) {
            for (int i = index + 1; i < paths.length; ++i) {
                try {
                    File file = new File(paths[i]);
                    if (file.exists()) {
                        Document temp = new SAXBuilder().build(file);
                        if (this.doc == null) {
                            this.doc = temp;
                            continue;
                        }
                        if (temp == null) continue;
                        this.mergeDocument(this.doc, temp);
                        continue;
                    }
                    log.warn((Object)(paths[i] + " not exists!"));
                    continue;
                }
                catch (Exception e) {
                    log.error((Object)e, (Throwable)e);
                }
            }
        }
        if (this.doc == null) {
            return null;
        }
        String ssf = System.getProperty("subSystemIndustry");
        InputStream is = null;
        if (ssf != null && new File(ssf).exists()) {
            try {
                is = new FileInputStream(ssf);
            }
            catch (FileNotFoundException e1) {
                log.error((Object)e1, (Throwable)e1);
            }
        } else {
            is = SubSystemUtils.class.getClassLoader().getResourceAsStream("SubSystem_industry.xml");
        }
        if (is == null) {
            is = SubSystemUtils.class.getClassLoader().getResourceAsStream("com/kingdee/eas/common/filters/industry/SubSystem_industry.xml");
        }
        if (is == null) {
            log.info((Object)"Can't find SubSystem_industry.xml.");
            this.checkParent(this.doc);
            return this.doc;
        }
        Element docRoot = this.doc.getRootElement();
        try {
            Element add;
            Document industryDoc = XMLParser.parseXML((InputStream)is);
            Element root = industryDoc.getRootElement();
            Element delete = root.getChild("delete");
            if (delete != null) {
                List rows = delete.getChildren();
                for (Element ele : rows) {
                    String fn = ele.getAttributeValue(FULLNAME);
                    String tmp = fn + ".";
                    List children = docRoot.getChildren();
                    Iterator iterator2 = children.iterator();
                    while (iterator2.hasNext()) {
                        ele = (Element)iterator2.next();
                        String fn2 = ele.getAttributeValue(FULLNAME);
                        if (!fn2.equalsIgnoreCase(fn) && !fn2.startsWith(tmp)) continue;
                        iterator2.remove();
                    }
                }
            }
            if ((add = root.getChild("add")) != null) {
                List rows = add.getChildren();
                block21: for (Element ele : rows) {
                    Element ele2;
                    int i;
                    String before;
                    String tmp = ele.getAttributeValue("before");
                    if (!StringUtils.isEmpty((String)tmp)) {
                        before = tmp;
                    } else {
                        Element last = (Element)docRoot.getChildren().get(docRoot.getChildren().size() - 1);
                        before = last.getAttributeValue(FULLNAME);
                    }
                    for (i = 0; i < docRoot.getChildren().size(); ++i) {
                        ele2 = (Element)docRoot.getChildren().get(i);
                        if (!ele.getAttributeValue(FULLNAME).equalsIgnoreCase(ele2.getAttributeValue(FULLNAME))) continue;
                        docRoot.removeAttribute(ele2.getAttributeValue(FULLNAME));
                        log.info((Object)("duplicate row in SubSystem_industry.xml  : " + ele2.getAttributeValue(FULLNAME)));
                        break;
                    }
                    for (i = 0; i < docRoot.getChildren().size(); ++i) {
                        ele2 = (Element)docRoot.getChildren().get(i);
                        if (!before.equalsIgnoreCase(ele2.getAttributeValue(FULLNAME))) continue;
                        Element clone = ele.clone();
                        docRoot.getChildren().add(i + 1, clone);
                        continue block21;
                    }
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                log.error((Object)e, (Throwable)e);
            }
        }
        this.checkParent(this.doc);
        return this.doc;
    }

    private void checkParent(Document doc) {
        Element root = doc.getRootElement();
        List rows = root.getChildren();
        try {
            for (int i = 0; i < rows.size(); ++i) {
                Element row2;
                int j;
                Element row = (Element)rows.get(i);
                String parent = row.getAttributeValue("parent");
                if (StringUtils.isEmpty((String)parent) || "com.kingdee.eas".equals(parent)) continue;
                for (j = 0; j < rows.size() && !parent.equals((row2 = (Element)rows.get(j)).getAttributeValue(FULLNAME)); ++j) {
                }
                if (j == rows.size() || j <= i) continue;
                Element rowj = (Element)rows.get(j);
                log.info((Object)("exchange place: " + row.getAttributeValue(FULLNAME) + "    " + rowj.getAttributeValue(FULLNAME)));
                rows.remove(i);
                rows.remove(j - 1);
                rows.add(i, rowj);
                rows.add(j, row);
            }
        }
        catch (Exception e) {
            log.warn((Object)e, (Throwable)e);
        }
    }

    private void mergeDocument(Document source, Document target) {
        Element rootSource = source.getRootElement();
        List rows = rootSource.getChildren();
        HashSet<String> set = new HashSet<String>();
        for (Element row : rows) {
            set.add(row.getAttributeValue(FULLNAME));
        }
        Element rootTarget = target.getRootElement();
        rows = rootTarget.getChildren();
        for (Element row : rows) {
            if (!set.contains(row.getAttributeValue(FULLNAME))) {
                Element clone = row.clone();
                rootSource.getChildren().add(clone);
                continue;
            }
            log.warn((Object)("duplicate row: " + row.getAttributeValue(FULLNAME)));
        }
    }
}

