/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.view;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.xml.impl.AbstractMDElement;
import com.kingdee.bos.dao.xml.impl.DocumentProxyStateManager;
import com.kingdee.bos.dao.xml.impl.IStateManager;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.StringUtils;
import java.util.Locale;
import org.apache.log4j.Logger;

public class MetaDataBriefInfo
extends AbstractMDElement {
    private static Logger logger = Logger.getLogger(MetaDataBriefInfo.class);
    private transient IObjectValue meta = null;
    private transient String package0;
    private transient String name0;
    private transient boolean hasParsedName;

    public MetaDataBriefInfo() {
    }

    public MetaDataBriefInfo(Locale current, Locale[] supportedLocale, AbstractMetaDataValue meta) {
        this(current, supportedLocale, meta, false);
    }

    public MetaDataBriefInfo(Locale current, Locale[] supportedLocale, AbstractMetaDataValue meta, boolean runtime) {
        this.meta = meta;
        this.setPackageName(meta.getPackage());
        this.setName(meta.getName());
        this.setMetaDataType(meta.getBOSType());
        IStateManager sm = meta.getStateManager();
        if (!runtime && sm instanceof DocumentProxyStateManager) {
            ((DocumentProxyStateManager)sm).setMdbview(true);
        }
        for (int j = 0; j < supportedLocale.length; ++j) {
            if (supportedLocale[j].toString().equalsIgnoreCase(current.toString())) {
                this.setAlias(meta.getAlias());
                this.setDescription(meta.getDescription());
                continue;
            }
            this.setAlias(meta.getAlias(supportedLocale[j]), supportedLocale[j]);
            this.setDescription(meta.getDescription(supportedLocale[j]), supportedLocale[j]);
        }
        if (MetaDataTypeList.ENTITY.equals((Object)meta.getBOSType()) || MetaDataTypeList.FACADE.equals((Object)meta.getBOSType())) {
            if (meta.getString("bosType") != null) {
                this.setBOType(BOSObjectType.create((String)meta.getString("bosType")));
            } else {
                logger.error((Object)("bosType is null: " + meta.getFullName()));
            }
        }
    }

    @Override
    public BOSObjectType getBOSType() {
        return BOSObjectType.create((String)"mobi");
    }

    public BOSObjectType getMetaDataType() {
        return BOSObjectType.create((String)this.getString("metaDataType"));
    }

    public void setMetaDataType(BOSObjectType metaDataType) {
        this.setString("metaDataType", metaDataType.toString());
    }

    private synchronized void parseName() {
        String fn = this.getString("name");
        if (!this.hasParsedName && !StringUtils.isEmpty((String)fn)) {
            int pos = fn.lastIndexOf(46);
            if (pos != -1) {
                this.package0 = fn.substring(0, pos);
            }
            this.name0 = fn.substring(pos + 1);
            this.hasParsedName = true;
        }
    }

    private synchronized void compName() {
        String fn = null;
        fn = StringUtils.isEmpty((String)this.package0) ? this.name0 : this.package0 + "." + this.name0;
        this.setString("name", fn);
    }

    public String getPackgeName() {
        this.parseName();
        return this.package0;
    }

    public void setPackageName(String pkName) {
        this.parseName();
        this.package0 = pkName;
        this.compName();
    }

    public String getName() {
        this.parseName();
        return this.name0;
    }

    public void setName(String name) {
        this.parseName();
        this.name0 = name;
        this.compName();
    }

    public String getAlias() {
        return this.getString("alias");
    }

    public void setAlias(String alias) {
        this.setString("alias", alias);
    }

    public String getAlias(Locale locale) {
        return (String)this.get("alias", locale);
    }

    public void setAlias(String alias, Locale locale) {
        this.put("alias", alias, locale);
    }

    public String getDescription() {
        return this.getString("description");
    }

    public String getDescription(Locale locale) {
        return (String)this.get("description", locale);
    }

    public void setDescription(String description) {
        this.put("description", description);
    }

    public void setDescription(String description, Locale locale) {
        this.put("description", description, locale);
    }

    public IMetaDataPK getMetaDataPK() {
        return MetaDataPK.create(this.getPackgeName(), this.getName());
    }

    public void setBOType(BOSObjectType boType) {
        this.setString("boType", boType == null ? "" : boType.toString());
    }

    public BOSObjectType getBOType() {
        if (MetaDataTypeList.ENTITY.equals((Object)this.getMetaDataType()) || MetaDataTypeList.FACADE.equals((Object)this.getMetaDataType())) {
            String tmp = this.getString("boType");
            if (tmp != null) {
                return BOSObjectType.create((String)tmp);
            }
            return null;
        }
        return null;
    }

    public boolean isPackage() {
        return this.getMetaDataType().equals((Object)MetaDataTypeList.PACKAGE);
    }

    public IObjectValue getMetaData(IMetaDataLoader loader) {
        if (this.meta != null) {
            return this.meta;
        }
        this.meta = loader.get(this.getMetaDataType(), this.getMetaDataPK());
        return this.meta;
    }

    @Override
    public String toString() {
        String tmp = "[" + this.getMetaDataType() + "]";
        if (!StringUtils.isEmpty((String)this.getAlias())) {
            return this.getAlias() + tmp;
        }
        return this.getName() + tmp;
    }

    public String getParent() {
        return this.getString("parent");
    }

    public void setParent(String parent) {
        this.setString("parent", parent);
    }

    public String getFullName() {
        return this.getString("name");
    }

    public boolean isConfigured() {
        return this.getBoolean("configured");
    }

    public void setConfigured(boolean configured) {
        this.put("configured", configured);
    }
}

