/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.view;

import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.view.AbstractMetaDataBriefViewBuilder;
import com.kingdee.bos.metadata.view.BriefViewTreeNode;
import com.kingdee.bos.metadata.view.ChangeParentDocumentBuilder;
import com.kingdee.bos.metadata.view.FilterDocumentBuilder;
import com.kingdee.bos.metadata.view.IBriefViewTreeNode;
import com.kingdee.bos.metadata.view.IMetaDataBriefViewFilter;
import com.kingdee.bos.metadata.view.MetaDataBriefCollection;
import com.kingdee.bos.metadata.view.MetaDataBriefInfo;
import com.kingdee.bos.metadata.view.MetaDataBriefViewFilter;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.jdom2.Element;

public class MetaDataBriefViewBuilder
extends AbstractMetaDataBriefViewBuilder {
    private static Logger log = Logger.getLogger(MetaDataBriefViewBuilder.class);
    static final String FULLNAME = "fullname";
    private static final String ISLEAF = "isleaf";
    static final String HIDE = "hide";
    private String subSystemXmlFilePath = null;
    private String otherFileName = null;
    private boolean isOnlyPackage = false;

    private String getNewPath() {
        File file = new File(this.subSystemXmlFilePath);
        return file.getParent() + "\\" + this.otherFileName;
    }

    public MetaDataBriefViewBuilder(IMetaDataLoader loader) {
        super(loader);
    }

    private String getXmlFilePath() {
        if (this.otherFileName != null && this.otherFileName.trim().length() != 0) {
            if (this.otherFileName.toLowerCase().indexOf("eas_base_subsystem") >= 0) {
                return this.subSystemXmlFilePath;
            }
            try {
                File file = new File(this.getNewPath());
                if (file.canRead()) {
                    return this.getNewPath();
                }
                return this.subSystemXmlFilePath;
            }
            catch (Exception e) {
                log.info((Object)("\u627e\u4e0d\u5230\u81ea\u5b9a\u4e49\u5b50\u7cfb\u7edfxml\u6587\u4ef6\uff1a" + this.getNewPath() + "\uff0c\u4f7f\u7528\u7f3a\u7701\u6587\u4ef6" + this.subSystemXmlFilePath));
                return this.subSystemXmlFilePath;
            }
        }
        return this.subSystemXmlFilePath;
    }

    public MetaDataBriefViewBuilder(String xmlFilePath, String newFileName) {
        this.subSystemXmlFilePath = xmlFilePath;
        if (newFileName != null && newFileName.trim().length() != 0) {
            this.otherFileName = newFileName;
        }
    }

    public MetaDataBriefViewBuilder(String xmlFilePath) {
        this.subSystemXmlFilePath = xmlFilePath;
    }

    public void setIsOnlyPackage(boolean value) {
        this.isOnlyPackage = value;
    }

    public boolean getIsOnlyPackage() {
        return this.isOnlyPackage;
    }

    private MetaDataBriefInfo getMetaDataBriefInfoByElement(Element element) {
        String shortCode;
        String hide = element.getAttributeValue(HIDE);
        if (hide != null && "true".equals(hide)) {
            return null;
        }
        MetaDataBriefInfo info = new MetaDataBriefInfo();
        String fn = element.getAttributeValue(FULLNAME);
        String s = fn.substring(fn.lastIndexOf(46) + 1);
        info.setPackageName(fn);
        String name = element.getAttributeValue("name");
        if (StringUtils.isEmpty((String)name)) {
            name = s;
        }
        info.setName(name);
        Locale[] locales = BOSLocaleUtil.getSupportedOriginLocales();
        int n = locales.length;
        for (int i = 0; i < n; ++i) {
            shortCode = BOSLocaleUtil.getShortCode(locales[i]);
            if (StringUtils.isEmpty((String)shortCode)) continue;
            String alias = element.getAttributeValue("alias_" + shortCode);
            if (StringUtils.isEmpty((String)alias)) {
                alias = s;
            }
            info.setAlias(alias, locales[i]);
        }
        shortCode = BOSLocaleUtil.getShortCode(LocaleUtils.getDefaultOriginLocale());
        String alias = element.getAttributeValue("alias_" + shortCode);
        if (StringUtils.isEmpty((String)alias)) {
            alias = s;
        }
        info.setAlias(alias);
        info.setMetaDataType(MetaDataTypeList.PACKAGE);
        info.put(ISLEAF, element.getAttributeValue(ISLEAF));
        String parent = element.getAttributeValue("parent");
        if (!StringUtils.isEmpty((String)parent)) {
            info.setParent(parent);
        }
        return info;
    }

    private MetaDataBriefInfo getMetaDataBriefRootInfo() {
        MetaDataBriefInfo info = new MetaDataBriefInfo();
        info.setName("eas");
        info.setPackageName("com.kingdee.eas");
        Locale[] locales = BOSLocaleUtil.getSupportedOriginLocales();
        int n = locales.length;
        for (int i = 0; i < n; ++i) {
            info.setAlias("EAS", locales[i]);
        }
        info.setAlias("EAS");
        info.setMetaDataType(MetaDataTypeList.PACKAGE);
        info.put(ISLEAF, "0");
        return info;
    }

    private BriefViewTreeNode getParent(BriefViewTreeNode node, int levelInteval) {
        if (levelInteval == 0) {
            return (BriefViewTreeNode)node.getParent();
        }
        return this.getParent((BriefViewTreeNode)node.getParent(), levelInteval - 1);
    }

    private BriefViewTreeNode getParentPackageNode(String parent, Map<String, BriefViewTreeNode> allNodes) {
        if (allNodes.get(parent) == null || allNodes.get(parent).toString().length() == 0) {
            return this.getParentPackageNode(parent.substring(0, parent.lastIndexOf(".")), allNodes);
        }
        return allNodes.get(parent);
    }

    private IBriefViewTreeNode buildSubSystem(MetaDataBriefCollection c) {
        log.info((Object)"\u5f00\u59cb\u6784\u9020\u5b50\u7cfb\u7edf\u6811\u8282\u70b9......\u4f7f\u7528\u65b0\u65b9\u6cd5\u6784\u9020");
        MetaDataBriefInfo info = this.getMetaDataBriefRootInfo();
        BriefViewTreeNode root = new BriefViewTreeNode(info);
        HashMap<String, BriefViewTreeNode> leafNodeList = new HashMap<String, BriefViewTreeNode>();
        HashMap<String, BriefViewTreeNode> allNodeList = new HashMap<String, BriefViewTreeNode>();
        allNodeList.put(root.getPackageName(), root);
        int NodeCount = 0;
        List children = FilterDocumentBuilder.getInstance(this.getXmlFilePath()).getDocument().getRootElement().getChildren();
        ArrayList<MetaDataBriefInfo> datas = new ArrayList<MetaDataBriefInfo>();
        for (int i = 0; i < children.size(); ++i) {
            MetaDataBriefInfo info1 = this.getMetaDataBriefInfoByElement((Element)children.get(i));
            if (info1 == null) continue;
            datas.add(info1);
            allNodeList.put(info1.getPackgeName(), new BriefViewTreeNode(info1));
        }
        Object[] arras = datas.toArray();
        Arrays.sort(arras, new Comparator(){

            public int compare(Object o1, Object o2) {
                MetaDataBriefInfo m1 = (MetaDataBriefInfo)o1;
                MetaDataBriefInfo m2 = (MetaDataBriefInfo)o2;
                return m1.getPackgeName().compareTo(m2.getPackgeName());
            }
        });
        log.info(Arrays.asList(arras));
        BriefViewTreeNode curNode = root;
        BriefViewTreeNode tmpNode = null;
        MetaDataBriefInfo tmpInfo = null;
        log.info((Object)"\u5f00\u59cb\u904d\u5386\u5b50\u7cfb\u7edf\u6811xml...");
        for (Object obj : arras) {
            MetaDataBriefInfo mdbInfo = (MetaDataBriefInfo)obj;
            if (mdbInfo == null) continue;
            tmpNode = (BriefViewTreeNode)allNodeList.get(mdbInfo.getPackgeName());
            leafNodeList.put(String.valueOf(NodeCount), tmpNode);
            ++NodeCount;
            try {
                if ("com.kingdee.eas.eas".equals(mdbInfo.getFullName())) {
                    root.setUserObject(mdbInfo);
                    continue;
                }
                BriefViewTreeNode parent = null;
                String p = mdbInfo.getParent();
                if (!StringUtils.isEmpty((String)p)) {
                    parent = p.equalsIgnoreCase(info.getPackgeName()) ? root : (BriefViewTreeNode)allNodeList.get(p);
                }
                if (p == null) {
                    log.error((Object)("parent is null, mdbInfo is " + mdbInfo.toString() + ", fullName is " + mdbInfo.getFullName() + ", packgeName is " + mdbInfo.getPackgeName()));
                }
                if (parent == null) {
                    parent = this.getParentPackageNode(p, allNodeList);
                }
                parent.add(tmpNode);
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
            }
            curNode = tmpNode;
            if (!curNode.getFullName().equals("com.kingdee.eas.base.botp")) continue;
            MetaDataBriefInfo botpInfo = new MetaDataBriefInfo();
            botpInfo.setName("BOTMapping");
            botpInfo.setPackageName("com.kingdee.bos.metadata.bot.app");
            botpInfo.setMetaDataType(MetaDataTypeList.ENTITY);
            curNode.add(new BriefViewTreeNode(botpInfo));
        }
        log.info((Object)("\u904d\u5386\u5b50\u7cfb\u7edf\u6811xml...\u7ed3\u675f\uff0c\u5171\u6709" + NodeCount + "\u5b50\u7cfb\u7edf"));
        Map<String, String> cpMap = ChangeParentDocumentBuilder.getChangeParentMap();
        log.info((Object)"\u5f00\u59cb\u5c06\u5143\u6570\u636e\u8282\u70b9\u52a0\u5230\u5b50\u7cfb\u7edf\u6811\u4e0a....");
        int dataCount = 0;
        int n = c.size();
        block4: for (int i = 0; i < n; ++i) {
            tmpInfo = c.get(i);
            if (tmpInfo.getMetaDataType().equals((Object)MetaDataTypeList.PACKAGE)) continue;
            String fn = tmpInfo.getFullName();
            for (int j = NodeCount - 1; j >= 0; --j) {
                tmpNode = (BriefViewTreeNode)leafNodeList.get(String.valueOf(j));
                if (cpMap.get(fn) != null) {
                    if (!cpMap.get(fn).equals(tmpNode.getPackageName())) continue;
                    tmpNode.add(new BriefViewTreeNode(tmpInfo));
                    ++dataCount;
                    continue block4;
                }
                if (fn.indexOf(tmpNode.getPackageName()) < 0) continue;
                tmpNode.add(new BriefViewTreeNode(tmpInfo));
                ++dataCount;
                continue block4;
            }
        }
        log.info((Object)("\u6570\u636e\u8282\u70b9\u52a0\u5230\u5b50\u7cfb\u7edf\u6811\u4e0a\u5b8c\u6210\uff0c\u5171\u6709\u8282\u70b9" + dataCount + "\u52a0\u5230\u6811\u4e0a"));
        log.info((Object)"\u6784\u9020\u5b50\u7cfb\u7edf\u6811\u8282\u70b9\u5b8c\u6210\uff01");
        return root;
    }

    public IBriefViewTreeNode innerBuild() {
        HashMap<String, BriefViewTreeNode> tree = new HashMap<String, BriefViewTreeNode>();
        MetaDataBriefInfo info = new MetaDataBriefInfo();
        info.setName("");
        info.setAlias("root");
        info.setMetaDataType(MetaDataTypeList.PACKAGE);
        BriefViewTreeNode root = new BriefViewTreeNode(info);
        tree.put("root", root);
        String pkgName = null;
        BriefViewTreeNode node = null;
        BriefViewTreeNode tmpNode = null;
        BriefViewTreeNode parent = null;
        MetaDataBriefInfo tmpInfo = null;
        MetaDataBriefCollection briefs = null;
        briefs = this.getAcceptedMetaDatas();
        int size = briefs.size();
        for (int i = 0; i < size; ++i) {
            info = briefs.get(i);
            pkgName = info.getPackgeName();
            if (pkgName == null) {
                if (!info.getMetaDataType().equals((Object)MetaDataTypeList.PACKAGE)) {
                    node = new BriefViewTreeNode(info);
                    root.add(node);
                    tree.put(info.getName(), node);
                } else {
                    root.setUserObject(info);
                }
            }
            if (pkgName == null) continue;
            parent = root;
            StringTokenizer token = new StringTokenizer(pkgName, ".");
            int count = token.countTokens();
            int j = 1;
            String tmp = null;
            String tmpPKName = null;
            while (token.hasMoreTokens() && !(tmp = token.nextToken()).equals("app") && !tmp.equals("client") && !tmp.equals("test")) {
                tmpPKName = ((MetaDataBriefInfo)parent.getUserObject()).getPackgeName();
                tmpPKName = !StringUtils.isEmpty((String)tmpPKName) ? tmpPKName + "." + tmp : tmp;
                tmpNode = (BriefViewTreeNode)tree.get(tmpPKName);
                if (tmpNode == null) {
                    tmpInfo = new MetaDataBriefInfo();
                    tmpInfo.setPackageName(tmpPKName);
                    tmpInfo.setName(tmp);
                    tmpInfo.setMetaDataType(MetaDataTypeList.PACKAGE);
                    tmpNode = new BriefViewTreeNode(tmpInfo);
                    tree.put(tmpPKName, tmpNode);
                    parent.add(tmpNode);
                }
                parent = tmpNode;
                if (j == count && info.getMetaDataType().equals((Object)MetaDataTypeList.PACKAGE)) {
                    tmpNode.setUserObject(info);
                }
                ++j;
            }
        }
        return (IBriefViewTreeNode)root.getChildAt(0);
    }

    @Override
    public MetaDataBriefCollection getAcceptedMetaDatas(String pkg) {
        log.info((Object)"\u4ece\u5143\u6570\u636e\u68c0\u7d22\u6570\u636e\u5f00\u59cb......");
        MetaDataBriefCollection mbfCol = super.getAcceptedMetaDatas(pkg);
        log.info((Object)("\u521d\u59cb\u6570\u636e\u4e3a" + mbfCol.size() + "\u6761"));
        MetaDataBriefCollection newCol = new MetaDataBriefCollection();
        MetaDataBriefInfo mdbf = null;
        int j = mbfCol.size();
        for (int i = 0; i < j; ++i) {
            mdbf = mbfCol.get(i);
            if (!this.isAvaliableFullName(mdbf.getFullName())) continue;
            newCol.add(mdbf);
        }
        log.info((Object)("\u7ed3\u675f\u4ece\u5143\u6570\u636e\u68c0\u7d22\u6570\u636e\uff01\u5171\u6709" + newCol.size() + "\u6761\u6570\u636e\u6ee1\u8db3\u8981\u6c42\uff01"));
        return newCol;
    }

    private boolean isAvaliableFullName(String fullName) {
        boolean rtn = false;
        List list = FilterDocumentBuilder.getInstance(this.getXmlFilePath()).getDocument().getRootElement().getChildren();
        Map<String, String> cp = ChangeParentDocumentBuilder.getChangeParentMap();
        for (int i = list.size() - 1; i >= 0; --i) {
            String fn = ((Element)list.get(i)).getAttributeValue(FULLNAME);
            if (fullName.indexOf(fn) < 0 && (cp.get(fullName) == null || !cp.get(fullName).equals(fn))) continue;
            rtn = true;
            break;
        }
        return rtn;
    }

    @Override
    public IBriefViewTreeNode build() {
        return this.build(null);
    }

    @Override
    public IBriefViewTreeNode build(String pkg) {
        if (!this.isOnlyPackage) {
            return this.buildSubSystem(this.getAcceptedMetaDatas(pkg));
        }
        return this.innerBuild();
    }

    @Override
    public void setMetaDataBriefViewFilter(IMetaDataBriefViewFilter filter) {
        super.setMetaDataBriefViewFilter(filter);
        this.otherFileName = ((MetaDataBriefViewFilter)filter).getViewName() + ".xml";
    }
}

