/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.view;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.xml.Utils;
import com.kingdee.bos.dao.xml.XMLAccessEngine;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataClassLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.util.XmlUtils;
import com.kingdee.bos.metadata.util.ZipFileUtils;
import com.kingdee.bos.metadata.view.AbstractMetaDataBriefViewBuilder;
import com.kingdee.bos.metadata.view.BusinessObjectBriefViewGenerator;
import com.kingdee.bos.metadata.view.DefaultSubSystemFilter;
import com.kingdee.bos.metadata.view.GeneratorConfig;
import com.kingdee.bos.metadata.view.ISubSystemFilter;
import com.kingdee.bos.metadata.view.MetaDataBriefViewBuilder;
import com.kingdee.bos.metadata.view.MetaDataBriefViewFilter;
import com.kingdee.bos.metadata.view.SubSystemHideFilter;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.XMLParser;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.LowTimer;
import com.kingdee.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;

public class SubSystemUtils {
    private static final Logger logger = Logger.getLogger(SubSystemUtils.class);
    public static final String BASE_MDB_VIEW_NAME = "eas_base_subsystem";
    public static final String DEFAULT_METADATA_PATH = "w:/apusic/metas";
    public static final String RESOURCE_NAME = "MetaDataPath.properties";
    private static IMetaDataLoader loader;
    private static final String ROW = "row";
    public static final String SUBSYSTEM_INDUSTRY = "subSystemIndustry";
    public static final String SUBSYSTEM_CHANGEPARENT = "subSystemChangeParent";
    public static final String SUBSYSTEM_CHANGEPARENT_INDUSTRY = "subSystemChangeParentIndustry";
    private static Properties props;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMetaDataPath() {
        InputStream in = null;
        try {
            in = SubSystemUtils.class.getResourceAsStream(RESOURCE_NAME);
            InputStreamReader ireader = new InputStreamReader(in);
            BufferedReader reader = new BufferedReader(ireader);
            String path = reader.readLine();
            reader.close();
            String string = path;
            return string;
        }
        catch (IOException e) {
            logger.error((Object)e, (Throwable)e);
            String string = DEFAULT_METADATA_PATH;
            return string;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)"close InputStream eroor!", (Throwable)e);
            }
        }
    }

    public static IMetaDataLoader getMetaDataLoader() {
        if (loader != null) {
            return loader;
        }
        loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        return loader;
    }

    public static IMetaDataLoader getMetaDataLoader(Context ctx) {
        if (loader != null) {
            return loader;
        }
        loader = ctx == null ? MetaDataLoaderFactory.getRemoteMetaDataLoader() : MetaDataLoaderFactory.getLocalMetaDataLoader(ctx);
        return loader;
    }

    public static MetaDataBriefViewFilter getGeneratedSubSystemFilter() {
        MetaDataBriefViewFilter filter = SubSystemUtils.getSubSystemFilter();
        filter.addMetaDataTypeFilter(MetaDataTypeList.ENTITY);
        filter.addMetaDataTypeFilter(MetaDataTypeList.FACADE);
        filter.addMetaDataTypeFilter(MetaDataTypeList.UIOBJECT);
        filter.addMetaDataTypeFilter(MetaDataTypeList.DATATABLE);
        filter.addMetaDataTypeFilter(MetaDataTypeList.JOINQUERY);
        filter.addMetaDataTypeFilter(MetaDataTypeList.FUNCTION);
        return filter;
    }

    private static MetaDataBriefViewFilter getSubSystemFilter() {
        MetaDataBriefViewFilter filter = new MetaDataBriefViewFilter();
        filter.setViewName(BASE_MDB_VIEW_NAME);
        filter.setPackagePrefix("com.kingdee.eas");
        filter.addMetaDataTypeFilter(MetaDataTypeList.PACKAGE);
        return filter;
    }

    public static void generateView(AbstractMetaDataBriefViewBuilder builder, MetaDataBriefViewFilter filter, String metadataPath, String xmlPath) throws BOSException {
        SubSystemUtils.generateView(builder, filter, metadataPath, xmlPath, null, null);
    }

    public static void generateView(AbstractMetaDataBriefViewBuilder builder, MetaDataBriefViewFilter filter, String metadataPath, String xmlPath, String pkgName, String updatePkg) throws BOSException {
        SubSystemUtils.generateView(builder, filter, new GeneratorConfig(metadataPath, xmlPath, pkgName, updatePkg));
    }

    public static void generateView(AbstractMetaDataBriefViewBuilder builder, MetaDataBriefViewFilter filter, String metadataPath, String xmlPath, String pkgName, String updatePkg, String hidePath) throws BOSException {
        SubSystemUtils.generateView(builder, filter, new GeneratorConfig(metadataPath, xmlPath, pkgName, updatePkg, hidePath));
    }

    public static void generateView(AbstractMetaDataBriefViewBuilder builder, MetaDataBriefViewFilter filter, GeneratorConfig config) throws BOSException {
        String updatePkg;
        String hidePath;
        String metadataPath = config.getMetadataPath();
        if (metadataPath == null) {
            metadataPath = SubSystemUtils.getMetaDataPath();
        }
        BusinessObjectBriefViewGenerator generator = BusinessObjectBriefViewGenerator.getInstance(metadataPath);
        if (builder == null) {
            builder = new MetaDataBriefViewBuilder(config.getXmlPath());
            builder.setMetaDataBriefViewFilter(filter);
            if (filter.getProperty("is_only_package") != null) {
                ((MetaDataBriefViewBuilder)builder).setIsOnlyPackage(true);
            }
            builder.setName(filter.getViewName());
            builder.setPackage(config.getPackageName());
        }
        if (!StringUtils.isEmpty((String)(hidePath = config.getHidePath()))) {
            builder.getMetaDataBriefViewFilter().addSubSystemHideFilter(SubSystemHideFilter.getInstance(hidePath));
        }
        if ((updatePkg = config.getUpdatePackage()) == null || updatePkg.indexOf(";") < 0) {
            generator.generate(updatePkg, builder);
        } else {
            String[] pkgs = updatePkg.split(";");
            if (pkgs.length <= 5) {
                for (int i = 0; i < pkgs.length; ++i) {
                    generator.generate(pkgs[i], builder);
                }
            } else {
                generator.generate(builder);
            }
        }
    }

    public static void generateView(AbstractMetaDataBriefViewBuilder builder, MetaDataBriefViewFilter filter, String xmlPath) throws BOSException {
        SubSystemUtils.generateView(builder, filter, null, xmlPath);
    }

    public static void generateView(MetaDataBriefViewFilter filter, String metadataPath, String xmlPath, String updatePkg) throws BOSException {
        SubSystemUtils.generateView(null, filter, metadataPath, xmlPath, null, updatePkg);
    }

    public static void generateView(MetaDataBriefViewFilter filter, String xmlPath) throws BOSException {
        SubSystemUtils.generateView(null, filter, xmlPath);
    }

    public static void generateView(ISubSystemFilter filter, String[] args) throws BOSException {
        MetaDataBriefViewFilter f = filter.getBriefViewFilter();
        logger.info((Object)("Generate View  " + f.getViewName() + " Begin"));
        if (args != null) {
            if (args.length > 2) {
                if (!StringUtils.isEmpty((String)args[2])) {
                    try {
                        SubSystemUtils.copyMdbviewFiles(args[0]);
                    }
                    catch (Exception e) {
                        throw new BOSException((Throwable)e);
                    }
                }
                if (args.length > 3) {
                    SubSystemUtils.generateView(null, f, new GeneratorConfig(args[0], args[1], null, args[2], args[3]));
                } else {
                    SubSystemUtils.generateView(f, args[0], args[1], args[2]);
                }
            } else if (args.length > 1) {
                SubSystemUtils.generateView(f, args[0], args[1], null);
            } else if (args.length > 0) {
                SubSystemUtils.generateView(f, args[0]);
            }
        }
        logger.info((Object)("Generate View  " + f.getViewName() + " end"));
    }

    private static void copyMdbviewFiles(String metadataPath) throws Exception {
        Context ctx = new Context();
        ctx.put((Object)"METADATAPATH", (Object)metadataPath);
        String[] paths = Utils.getMetadataPath(ctx);
        FileFilter ff = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getName().endsWith("mdbview");
            }
        };
        File[] mdbviewFiles = new File(paths[0]).listFiles(ff);
        if (mdbviewFiles == null || mdbviewFiles.length == 0) {
            int i;
            for (i = 1; i < paths.length; ++i) {
                if (!paths[i].endsWith("sp-bim-metas.jar")) continue;
                ZipFileUtils.unZipFile(paths[i], paths[0], "mdbview");
                mdbviewFiles = new File(paths[0]).listFiles(ff);
                if (mdbviewFiles == null || mdbviewFiles.length <= 0) continue;
                return;
            }
            for (i = 1; i < paths.length; ++i) {
                if (!paths[i].endsWith("mdbview-metas.jar")) continue;
                ZipFileUtils.unZipFile(paths[i], paths[0], "mdbview");
                return;
            }
        }
    }

    public static ArrayList<String> getFilterClasses() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("com.kingdee.bos.metadata.view.filters.BaseSubSystemFilter");
        list.add("com.kingdee.bos.metadata.view.filters.ParamBaseDataTypeFilter");
        list.add("com.kingdee.bos.metadata.view.filters.CodingRuleFilter");
        list.add("com.kingdee.bos.metadata.view.filters.BotpBillFilter");
        list.add("com.kingdee.bos.metadata.view.filters.PackageFilter");
        list.add("com.kingdee.bos.metadata.view.filters.VerifyCenterFilter");
        list.add("com.kingdee.bos.metadata.view.filters.CacheFilter");
        list.add("com.kingdee.bos.metadata.view.filters.ParamFilter");
        list.add("com.kingdee.bos.metadata.view.filters.SubSystemEntityFilter");
        list.add("com.kingdee.bos.metadata.view.filters.ForeWarnFilter");
        list.add("com.kingdee.bos.metadata.view.filters.PermissionFilter");
        list.add("com.kingdee.bos.metadata.view.filters.FieldPermissionFilter");
        list.add("com.kingdee.bos.metadata.view.filters.QueryFilter");
        list.add("com.kingdee.bos.metadata.view.filters.BizUnitFilter");
        return list;
    }

    private static void doAnOddOperationGivenByCharseWang(String metadataPath) {
        Context ctx = new Context();
        ctx.put((Object)"METADATAPATH", (Object)metadataPath);
        Locale locale = LocaleUtils.getDefaultOriginLocale();
        try {
            XMLAccessEngine.getXMLLoader(ctx).getContext().setLocale(locale);
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            System.exit(-1);
        }
    }

    public static void generateViewFile(String[] args) throws BOSException {
        SubSystemUtils.doAnOddOperationGivenByCharseWang(args[0]);
        ArrayList<String> strList = SubSystemUtils.getFilterClasses();
        ISubSystemFilter[] filters = new ISubSystemFilter[strList.size()];
        int size = strList.size();
        for (int i = 0; i < size; ++i) {
            try {
                filters[i] = (ISubSystemFilter)Class.forName(strList.get(i)).newInstance();
            }
            catch (InstantiationException e) {
                logger.error((Object)e, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                logger.error((Object)e, (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                logger.error((Object)e, (Throwable)e);
            }
            SubSystemUtils.generateView(filters[i], args);
        }
        List<ISubSystemFilter> fromXml = SubSystemUtils.getSubSystemFilterFromXml();
        Iterator<ISubSystemFilter> iter = fromXml.iterator();
        while (iter.hasNext()) {
            SubSystemUtils.generateView(iter.next(), args);
        }
        logger.info((Object)"generate mdbView end");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ISubSystemFilter> getSubSystemFilterFromXml() {
        ArrayList<ISubSystemFilter> ret = new ArrayList<ISubSystemFilter>();
        String ssf = System.getProperty("subSystemFilter");
        InputStream is = null;
        if (ssf != null && new File(ssf).exists()) {
            logger.info((Object)("+++ begin load filter from xml file, file is :" + ssf));
            try {
                is = new FileInputStream(ssf);
            }
            catch (FileNotFoundException e1) {
                logger.error((Object)e1, (Throwable)e1);
            }
        } else {
            logger.info((Object)("+++ begin load filter from xml file, classloader load file :" + SubSystemUtils.class.getClassLoader().getResource("SubSystemFilter.xml")));
            is = SubSystemUtils.class.getClassLoader().getResourceAsStream("SubSystemFilter.xml");
        }
        if (is == null) {
            String filterXml = "com/kingdee/bos/metadata/view/filters/SubSystemFilter.xml";
            logger.info((Object)("+++ begin load filter from xml file, classloader load file :" + SubSystemUtils.class.getClassLoader().getResource(filterXml)));
            is = SubSystemUtils.class.getClassLoader().getResourceAsStream(filterXml);
        }
        if (is == null) {
            logger.warn((Object)"Warn : Can't find SubSystemFilter.xml in class path and  com/kingdee/bos/metadata/view/filters path");
        } else {
            try {
                Document doc;
                try {
                    doc = XMLParser.parseXML((InputStream)is);
                }
                finally {
                    is.close();
                }
                List subSystemFilters = doc.getRootElement().getChildren("subSystemFilter");
                for (Element filterEle : subSystemFilters) {
                    String s = filterEle.getChildText("name");
                    DefaultSubSystemFilter filter = new DefaultSubSystemFilter();
                    filter.setViewName(s);
                    List tmpList = filterEle.getChild("metaDataTypes").getChildren("metaDataType");
                    Iterator iterator = tmpList.iterator();
                    while (iterator.hasNext()) {
                        filter.addMetaDataTypeFilter(BOSObjectType.create((String)((Element)iterator.next()).getText()));
                    }
                    Element tmpEle2 = filterEle.getChild("extendedPropertys");
                    if (tmpEle2 != null) {
                        tmpList = tmpEle2.getChildren("extendedProperty");
                        for (Element tmpEle2 : tmpList) {
                            filter.addExtendedPropertyFilter(BOSObjectType.create((String)tmpEle2.getChildText("type")), tmpEle2.getChildText("name"), tmpEle2.getChildText("value"));
                        }
                    }
                    if (!StringUtils.isEmpty((String)(s = filterEle.getChildText("entityChain")))) {
                        filter.setEntityChainFilter(s);
                    }
                    if (!StringUtils.isEmpty((String)(s = filterEle.getChildText("package")))) {
                        filter.setPackagePrefix(s);
                    }
                    ret.add(filter);
                }
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
        return ret;
    }

    public static void main(String[] args) {
        try {
            for (int i = 0; i < args.length; ++i) {
                logger.info((Object)("args[" + i + "]: " + args[i]));
            }
            String sysProp = System.getProperty(SUBSYSTEM_INDUSTRY);
            if (!StringUtils.isEmpty((String)sysProp)) {
                logger.info((Object)("-DsubSystemIndustry: " + sysProp));
                SubSystemUtils.loadConfig(sysProp);
            }
            if (!StringUtils.isEmpty((String)(sysProp = System.getProperty(SUBSYSTEM_CHANGEPARENT)))) {
                logger.info((Object)("-DsubSystemChangeParent: " + sysProp));
            }
            if (!StringUtils.isEmpty((String)(sysProp = System.getProperty(SUBSYSTEM_CHANGEPARENT_INDUSTRY)))) {
                logger.info((Object)("-DsubSystemChangeParentIndustry: " + sysProp));
            }
            LowTimer time = new LowTimer();
            SubSystemUtils.generateViewFile(args);
            logger.info((Object)("waitting for store subsystem and time spend : " + (int)time.Value() + " seconds"));
            BusinessObjectBriefViewGenerator.pool.shutdown();
            try {
                BusinessObjectBriefViewGenerator.pool.awaitTermination(Long.MAX_VALUE, TimeUnit.MINUTES);
            }
            catch (InterruptedException e) {
                logger.error((Object)e);
            }
            logger.info((Object)("generate subsystem time spend : " + (int)time.Value() + " seconds"));
            MetaDataClassLoader.closeAll();
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadConfig(String sysProp) {
        block10: {
            try {
                File f = new File(sysProp);
                f = new File(f.getParent() + File.separator + "SubSystem.property");
                if (!f.exists()) break block10;
                props = new Properties();
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(f);
                    props.load(fis);
                }
                finally {
                    try {
                        if (fis != null) {
                            fis.close();
                        }
                    }
                    catch (IOException e) {
                        logger.error((Object)"close FileInputStream eroor!", (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
    }

    public static String getProperty(String propertyName) {
        if (props != null) {
            return props.getProperty(propertyName);
        }
        return null;
    }

    public static String getProperty(String propertyName, String _default) {
        String value = SubSystemUtils.getProperty(propertyName);
        if (value == null || value.trim().length() < 1) {
            value = _default;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mergeSubSystem(String standard, String customer, String out) throws Exception {
        String hide;
        String fullname;
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(standard));
        Document sdoc = XMLParser.parseXML((InputStream)is);
        ((InputStream)is).close();
        Element sroot = sdoc.getRootElement();
        HashMap<String, Element> fnSet = new HashMap<String, Element>();
        HashMap<String, Element> toHide = new HashMap<String, Element>();
        List rows = sroot.getChildren(ROW);
        for (Element row : rows) {
            fullname = row.getAttributeValue("fullname");
            hide = row.getAttributeValue("hide");
            if (hide != null && "true".equals(hide)) {
                toHide.put(fullname, row);
                continue;
            }
            fnSet.put(fullname, row);
        }
        boolean add = false;
        InputStream cis = null;
        try {
            cis = new BufferedInputStream(new FileInputStream(customer));
            Document cdoc = XMLParser.parseXML((InputStream)cis);
            Element croot = cdoc.getRootElement();
            List crows = croot.getChildren(ROW);
            for (Element row : crows) {
                Element element;
                fullname = row.getAttributeValue("fullname");
                hide = row.getAttributeValue("hide");
                if (hide != null && "true".equals(hide)) {
                    element = (Element)fnSet.remove(fullname);
                    if (element == null) continue;
                    element.setAttribute("hide", "true");
                    toHide.put(fullname, element);
                    add = true;
                    continue;
                }
                element = (Element)toHide.remove(fullname);
                if (element != null) {
                    sroot.removeContent((Content)element);
                    element = SubSystemUtils.getElementCopy(row, fullname);
                    sroot.addContent((Content)element);
                    fnSet.put(fullname, element);
                    add = true;
                    continue;
                }
                if (fnSet.containsKey(fullname)) continue;
                element = SubSystemUtils.getElementCopy(row, fullname);
                sroot.addContent((Content)element);
                add = true;
            }
        }
        finally {
            try {
                if (cis != null) {
                    cis.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)"close InputStream error!", (Throwable)e);
            }
        }
        if (add) {
            File outFile = new File(out);
            if (!outFile.getParentFile().exists()) {
                outFile.getParentFile().mkdirs();
            }
            if (outFile.exists()) {
                File bak = new File(outFile.getParentFile(), outFile.getName() + ".bak");
                outFile.renameTo(bak);
            }
            FilterOutputStream os = null;
            try {
                os = new BufferedOutputStream(new FileOutputStream(out));
                XmlUtils.output(sdoc, os);
            }
            finally {
                try {
                    if (os != null) {
                        os.close();
                    }
                }
                catch (IOException e) {
                    logger.error((Object)"close BufferedOutputStream error!", (Throwable)e);
                }
            }
        }
    }

    private static Element getElementCopy(Element row, String fullname) {
        Element element = row.clone();
        if (element.getAttributeValue("parent") == null) {
            String parent = fullname.substring(0, fullname.lastIndexOf("."));
            if (StringUtils.isEmpty((String)parent)) {
                parent = "com.kingdee.eas";
            }
            element.setAttribute("parent", parent);
        }
        return element;
    }

    static {
        props = null;
    }
}

