/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.view.listeners;

import com.kingdee.bos.dao.xml.impl.MetaDataPK2;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.configure.Project;
import com.kingdee.bos.metadata.view.ISubSystemFilter;
import com.kingdee.bos.metadata.view.MetaDataBriefViewInfo;
import com.kingdee.bos.metadata.view.SubSystemUtils;
import com.kingdee.bos.metadata.view.listeners.MdbviewListener;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class MdbviewListenerManager {
    private static Logger logger = Logger.getLogger(MdbviewListenerManager.class);
    private static List listeners = new ArrayList();

    private static void initListeners() {
        ArrayList<String> filters = SubSystemUtils.getFilterClasses();
        for (String lisName : filters) {
            MdbviewListenerManager.register(lisName);
        }
        List<ISubSystemFilter> fromXml = SubSystemUtils.getSubSystemFilterFromXml();
        for (MdbviewListener mdbviewListener : fromXml) {
            MdbviewListenerManager.register(mdbviewListener);
        }
    }

    public static synchronized void register(MdbviewListener listener) {
        listeners.add(listener);
    }

    public static synchronized void unregister(MdbviewListener listener) {
        listeners.remove(listener);
    }

    public static synchronized void register(Class clazz) {
        try {
            MdbviewListener listener = (MdbviewListener)clazz.newInstance();
            listeners.add(listener);
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    public static synchronized void register(String className) {
        try {
            Class<?> c = Class.forName(className);
            MdbviewListenerManager.register(c);
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    public static void addNew(IMetaDataPK pk, MetaDataBriefViewInfo mdbv, MetaDataPK2[] pks, Project.Projects depends) {
        if (pks == null || pks.length == 0) {
            return;
        }
        for (MdbviewListener listener : listeners) {
            listener.addNew(pk, mdbv, pks, depends);
        }
    }

    public static void modify(IMetaDataPK pk, MetaDataBriefViewInfo mdbv, MetaDataPK2[] pks, Project.Projects depends) {
        if (pks == null || pks.length == 0) {
            return;
        }
        for (MdbviewListener listener : listeners) {
            listener.modify(pk, mdbv, pks, depends);
        }
    }

    static {
        try {
            MdbviewListenerManager.initListeners();
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
    }
}

