/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.webui.transfer;

import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.PropertyInfo;
import com.kingdee.bos.metadata.webui.ScriptInfo;
import com.kingdee.bos.metadata.webui.WebUIObjectInfo;
import com.kingdee.bos.metadata.webui.transfer.Component2XmlHelper;
import com.kingdee.bos.metadata.webui.transfer.ResourceBundleList;
import com.kingdee.bos.metadata.webui.transfer.Xml2ComponentHelper;
import com.kingdee.bos.metadata.webui.xhtml.WebTag;
import com.kingdee.bos.metadata.webui.xhtml.WebTagHelper;
import com.kingdee.bos.metadata.webui.xhtml.WebTags;
import com.kingdee.bos.ui.dtp.ControlDefaultSizeManager;
import com.kingdee.util.StringUtils;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jdom2.Element;

public class WebUIModelMapper {
    public static final MetaDataPK BaseEditUI = MetaDataPK.create("com.kingdee.eas.framework.web.EditUI");
    public static final MetaDataPK BaseListUI = MetaDataPK.create("com.kingdee.eas.framework.web.ListUI");
    public static MetaDataPK BaseBillEditUI = MetaDataPK.create("com.kingdee.eas.framework.web.BillEditUI");
    public static MetaDataPK BaseBillListUI = MetaDataPK.create("com.kingdee.eas.framework.web.BillListUI");
    public static final MetaDataPK BaseCommonQueryUI = MetaDataPK.create("com.kingdee.eas.framework.web.FilterUI");
    private static Map tag2ControlTypeMap = new HashMap();
    private static Map controlType2TagMap = new HashMap();
    private static Map uiClass = new HashMap();
    private static Set ctrlNeedResize = new HashSet();
    private static final String[] JS_KEYWORDS = new String[]{"delete", "function", "case", "do", "if", "switch", "var", "catch", "else", "in", "this", "void", "continue", "false", "instanceof", "throw", "while", "debugger", "finally", "new", "true", "with", "default", "for", "null", "try", "abstract", "double", "goto", "native", "static", "boolean", "enum", "implements", "package", "super", "byte", "export", "import", "private", "synchronized", "char", "extends", "int", "protected", "throws", "class", "final", "interface", "public", "transient", "const", "float", "long", "short", "volatile"};
    private WebUIObjectInfo model;
    private Component2XmlHelper control2XmlHelper = null;
    private Xml2ComponentHelper xml2ControlHelper = null;
    private ResourceBundleList bundleMap = null;

    public static String getUIClass(String componentType) {
        Object clazz = uiClass.get(componentType);
        if (clazz != null) {
            return (String)clazz;
        }
        return null;
    }

    public static String getUIClass(ComponentInfo component) {
        if (component == null) {
            return null;
        }
        if (!uiClass.containsKey(component.getClassType())) {
            return null;
        }
        return (String)uiClass.get(component.getClassType());
    }

    public static String getComponentType(WebTag webTag) {
        if (!WebTagHelper.isSupportedWebTag(webTag)) {
            return null;
        }
        Object type = tag2ControlTypeMap.get(webTag);
        if (type != null) {
            return (String)type;
        }
        return null;
    }

    public static boolean isCtrlNeedResize(String name) {
        return ctrlNeedResize.contains(name);
    }

    public static boolean isJsIdentifier(String s) {
        if (StringUtils.isEmpty((String)s)) {
            return false;
        }
        char[] chars = s.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (Character.isJavaIdentifierPart(chars[i]) && (i != 0 || Character.isJavaIdentifierStart(chars[i]))) continue;
            return false;
        }
        return !Arrays.asList(JS_KEYWORDS).contains(s);
    }

    public static WebTag getWebTag(String componentType) {
        Object webTag = controlType2TagMap.get(componentType);
        if (webTag != null) {
            return (WebTag)webTag;
        }
        return null;
    }

    public static boolean isSupportSetGet(ComponentInfo component, PropertyInfo property) {
        return true;
    }

    public WebUIModelMapper(WebUIObjectInfo model) {
        this.model = model;
    }

    public WebUIModelMapper(WebUIObjectInfo model, ResourceBundleList bundleMap) {
        this.model = model;
        this.bundleMap = bundleMap;
    }

    private Component2XmlHelper getControl2XmlHelper() {
        if (this.control2XmlHelper == null) {
            this.control2XmlHelper = new Component2XmlHelper(this.model);
        }
        return this.control2XmlHelper;
    }

    private Xml2ComponentHelper getXml2ControlHelper() {
        if (this.xml2ControlHelper == null) {
            this.xml2ControlHelper = new Xml2ComponentHelper(this.model, this.bundleMap);
        }
        return this.xml2ControlHelper;
    }

    public static ScriptInfo parseScript(Element element) {
        if (!"script".equals(element.getName())) {
            return null;
        }
        ScriptInfo script = new ScriptInfo();
        script.setName(element.getAttributeValue("name"));
        script.setType(element.getAttributeValue("type"));
        script.setReference(element.getAttributeValue("src"));
        script.setScript(element.getText());
        return script;
    }

    public static boolean isScript(WebTag webTag) {
        return WebTags.SCRIPT.equals(webTag);
    }

    public static boolean isComponent(WebTag webTag) {
        return tag2ControlTypeMap.containsKey(webTag);
    }

    public static boolean isTitle(WebTag webTag) {
        return WebTags.TITLE.equals(webTag);
    }

    public static boolean isDefined(WebTag webTag) {
        return WebTags.DEFINE.equals(webTag);
    }

    public static boolean isIgnored(Element element) {
        WebTag webTag = WebTag.create(element);
        if (WebTags.STYLE.equals(webTag)) {
            return true;
        }
        if (WebTags.DIV.equals(webTag)) {
            return true;
        }
        if (WebTags.WHEAD.equals(webTag) || WebTags.HEAD.equals(webTag)) {
            return true;
        }
        if (WebTags.FORM.equals(webTag)) {
            return true;
        }
        if (WebTags.TABLE.equals(webTag)) {
            return true;
        }
        if (WebTags.TR.equals(webTag)) {
            return true;
        }
        if (WebTags.TD.equals(webTag)) {
            return true;
        }
        return WebTags.KDCONTAINER.equals(webTag);
    }

    private static boolean isWebTag(Element element, WebTag webTag) {
        if (element == null || webTag == null) {
            return false;
        }
        WebTag tag = WebTag.create(element);
        return webTag.equals(tag);
    }

    public static WebTag getElementWebTag(ComponentInfo component) {
        if (!controlType2TagMap.containsKey(component.getClassType())) {
            return null;
        }
        return (WebTag)controlType2TagMap.get(component.getClassType());
    }

    public static WebTag getElementWebTag(String classType) {
        if (!controlType2TagMap.containsKey(classType)) {
            return null;
        }
        return (WebTag)controlType2TagMap.get(classType);
    }

    public Element createElement(ComponentInfo component) {
        this.getControl2XmlHelper().clearSmartLayoutScript();
        return this.getControl2XmlHelper().buildElementTree(component);
    }

    public Element getSmartLayoutScriptElement() {
        return this.getControl2XmlHelper().getSmartLayoutScript();
    }

    public ComponentInfo parseComponent(Element element) {
        return this.getXml2ControlHelper().parseComponent(element);
    }

    public ComponentInfo parseComponent(Element element, ComponentInfo component) {
        return this.getXml2ControlHelper().parseComponent(element, component);
    }

    public static Dimension getComponentSize(ComponentInfo component) {
        int width = 0;
        int height = 0;
        if (component.getConstraint() != null && component.getConstraint() instanceof Rectangle) {
            width = ((Rectangle)component.getConstraint()).width;
            height = ((Rectangle)component.getConstraint()).height;
        }
        if (width == 0 || height == 0) {
            Dimension dim = ControlDefaultSizeManager.getDefaultSize(component.getClassType());
            if (dim == null) {
                dim = new Dimension(270, 19);
            }
            if (width == 0) {
                width = dim.width;
            }
            if (height == 0) {
                height = dim.height;
            }
        }
        return new Dimension(width, height);
    }

    static {
        tag2ControlTypeMap.put(WebTags.KDLABELCCONTAINER, "com.kingdee.bos.ctrl.web.LabelContainer");
        tag2ControlTypeMap.put(WebTags.BUTTON, "com.kingdee.bos.ctrl.web.Button");
        tag2ControlTypeMap.put(WebTags.HCOMMANDLINK, "com.kingdee.bos.ctrl.web.CommandLink");
        tag2ControlTypeMap.put(WebTags.COMBO, "com.kingdee.bos.ctrl.web.ComboBox");
        tag2ControlTypeMap.put(WebTags.CHECKBOX, "com.kingdee.bos.ctrl.web.CheckBox");
        tag2ControlTypeMap.put(WebTags.TEXTFIELD, "com.kingdee.bos.ctrl.web.TextField");
        tag2ControlTypeMap.put(WebTags.TEXTAREA, "com.kingdee.bos.ctrl.web.TextArea");
        tag2ControlTypeMap.put(WebTags.KDENUMCOMBO, "com.kingdee.bos.ctrl.web.EnumCombo");
        tag2ControlTypeMap.put(WebTags.DATEFIELD, "com.kingdee.bos.ctrl.web.DateField");
        tag2ControlTypeMap.put(WebTags.DATETIMEFIELD, "com.kingdee.bos.ctrl.web.DateTimeField");
        tag2ControlTypeMap.put(WebTags.KDPROMPTBOX, "com.kingdee.bos.ctrl.web.PromptBox");
        tag2ControlTypeMap.put(WebTags.KDCONTAINER, "com.kingdee.bos.ctrl.web.Container");
        tag2ControlTypeMap.put(WebTags.KDCOMPOSITE, "com.kingdee.bos.ctrl.web.Composite");
        tag2ControlTypeMap.put(WebTags.KDMULTILANGUAGE, "com.kingdee.bos.ctrl.web.Multilanguage");
        tag2ControlTypeMap.put(WebTags.KDMSGAREA, "com.kingdee.bos.ctrl.web.MsgArea");
        tag2ControlTypeMap.put(WebTags.KDATTACHMENT, "com.kingdee.bos.ctrl.web.Attachment");
        tag2ControlTypeMap.put(WebTags.KDTITLESECTION, "com.kingdee.bos.ctrl.web.TitleSection");
        tag2ControlTypeMap.put(WebTags.KDLINE, "com.kingdee.bos.ctrl.web.Line");
        tag2ControlTypeMap.put(WebTags.CALCNUMBERFIELD, "com.kingdee.bos.ctrl.web.CalcNumberField");
        tag2ControlTypeMap.put(WebTags.CALENDAR, "com.kingdee.bos.ctrl.web.CheckBoxGroup");
        tag2ControlTypeMap.put(WebTags.CHECKBOXGROUP, "com.kingdee.bos.ctrl.web.CheckBoxGroup");
        tag2ControlTypeMap.put(WebTags.CHECKMENUITEM, "com.kingdee.bos.ctrl.web.CheckMenuItem");
        tag2ControlTypeMap.put(WebTags.COMMANDMENUITEM, "com.kingdee.bos.ctrl.web.CommandMenuItem");
        tag2ControlTypeMap.put(WebTags.CONTEXTMENU, "com.kingdee.bos.ctrl.web.ContextMenu");
        tag2ControlTypeMap.put(WebTags.DATAGRID, "com.kingdee.bos.ctrl.web.DataGrid");
        tag2ControlTypeMap.put(WebTags.DATEMENU, "com.kingdee.bos.ctrl.web.Menu");
        tag2ControlTypeMap.put(WebTags.DRAWIMAGE, "com.kingdee.bos.ctrl.web.DrawImage");
        tag2ControlTypeMap.put(WebTags.EDITDATAGRID, "com.kingdee.bos.ctrl.web.EditDataGrid");
        tag2ControlTypeMap.put(WebTags.FILEUPLOADDIALOG, "com.kingdee.bos.ctrl.web.FileUploadDialog");
        tag2ControlTypeMap.put(WebTags.FILEUPLOAD, "com.kingdee.bos.ctrl.web.Fileupload");
        tag2ControlTypeMap.put(WebTags.FILEUPLOADPROGRESS, "com.kingdee.bos.ctrl.web.FileUploadProgressBar");
        tag2ControlTypeMap.put(WebTags.FORM, "com.kingdee.bos.ctrl.web.Form");
        tag2ControlTypeMap.put(WebTags.IFRAME, "com.kingdee.bos.ctrl.web.Iframe");
        tag2ControlTypeMap.put(WebTags.LINKMENUITEM, "com.kingdee.bos.ctrl.web.LinkMenuItem");
        tag2ControlTypeMap.put(WebTags.MENU, "com.kingdee.bos.ctrl.web.Menu");
        tag2ControlTypeMap.put(WebTags.MENUBAR, "com.kingdee.bos.ctrl.web.MenuBar");
        tag2ControlTypeMap.put(WebTags.MENUITEM, "com.kingdee.bos.ctrl.web.MenuItem");
        tag2ControlTypeMap.put(WebTags.NUMBERFIELD, "com.kingdee.bos.ctrl.web.NumberField");
        tag2ControlTypeMap.put(WebTags.PAGINGTOOLBAR, "com.kingdee.bos.ctrl.web.ToolBar");
        tag2ControlTypeMap.put(WebTags.PROGRESSBAR, "com.kingdee.bos.ctrl.web.ProgressBar");
        tag2ControlTypeMap.put(WebTags.RADIOGROUP, "com.kingdee.bos.ctrl.web.RadioGroup");
        tag2ControlTypeMap.put(WebTags.RADIOMENUITEM, "com.kingdee.bos.ctrl.web.RadioMenuItem");
        tag2ControlTypeMap.put(WebTags.SEPARATOR, "com.kingdee.bos.ctrl.web.Separator");
        tag2ControlTypeMap.put(WebTags.SIMPLEHTMLEDITOR, "com.kingdee.bos.ctrl.web.SimpleHtmlEditor");
        tag2ControlTypeMap.put(WebTags.SLIDER, "com.kingdee.bos.ctrl.web.Slider");
        tag2ControlTypeMap.put(WebTags.TIMEFIELD, "com.kingdee.bos.ctrl.web.TimeField");
        tag2ControlTypeMap.put(WebTags.TOOLBAR, "com.kingdee.bos.ctrl.web.ToolBar");
        tag2ControlTypeMap.put(WebTags.TREE, "com.kingdee.bos.ctrl.web.Tree");
        tag2ControlTypeMap.put(WebTags.TREENODE, "com.kingdee.bos.ctrl.web.TreeNode");
        tag2ControlTypeMap.put(WebTags.USEBEAN, "com.kingdee.bos.ctrl.web.UseBean");
        tag2ControlTypeMap.put(WebTags.LOGGER, "com.kingdee.bos.ctrl.web.AjaxLogger");
        tag2ControlTypeMap.put(WebTags.SCRIPTER, "com.kingdee.bos.ctrl.web.AjaxScripter");
        tag2ControlTypeMap.put(WebTags.TIMER, "com.kingdee.bos.ctrl.web.AjaxTimer");
        tag2ControlTypeMap.put(WebTags.PROGRESS, "com.kingdee.bos.ctrl.web.AjaxProgress");
        tag2ControlTypeMap.put(WebTags.UPDATER, "com.kingdee.bos.ctrl.web.AjaxUpdater");
        tag2ControlTypeMap.put(WebTags.STATUS, "com.kingdee.bos.ctrl.web.AjaxStatus");
        tag2ControlTypeMap.put(WebTags.RENDERGROUP, "com.kingdee.bos.ctrl.web.AjaxRenderGroup");
        tag2ControlTypeMap.put(WebTags.IDCOLUMN, "com.kingdee.bos.ctrl.web.EditableColumn");
        tag2ControlTypeMap.put(WebTags.OUTPUTCOLUMN, "com.kingdee.bos.ctrl.web.EditableColumn");
        tag2ControlTypeMap.put(WebTags.ACCORDIONLAYOUT, "com.kingdee.bos.ctrl.web.AccordionPane");
        tag2ControlTypeMap.put(WebTags.KDROOTLAYOUT, "com.kingdee.bos.ctrl.web.KDRootLayout");
        tag2ControlTypeMap.put(WebTags.KDLAYOUT, "com.kingdee.bos.ctrl.web.KDLayout");
        tag2ControlTypeMap.put(WebTags.KDLAYOUTPANEL, "com.kingdee.bos.ctrl.web.KDLayoutPanel");
        controlType2TagMap.put("com.kingdee.bos.ctrl.web.LabelContainer", WebTags.KDLABELCCONTAINER);
        controlType2TagMap.put("com.kingdee.bos.ctrl.web.Button", WebTags.BUTTON);
        controlType2TagMap.put("com.kingdee.bos.ctrl.web.CommandLink", WebTags.HCOMMANDLINK);
        controlType2TagMap.put("com.kingdee.bos.ctrl.web.ComboBox", WebTags.COMBO);
        controlType2TagMap.put("com.kingdee.bos.ctrl.web.CheckBox", WebTags.CHECKBOX);
        controlType2TagMap.put("com.kingdee.bos.ctrl.web.TextField", WebTags.TEXTFIELD);
        controlType2TagMap.put("com.kingdee.bos.ctrl.web.TextArea", WebTags.TEXTAREA);
        controlType2TagMap.put("com.kingdee.bos.ctrl.web.EnumCombo", WebTags.KDENUMCOMBO);
        controlType2TagMap.put("com.kingdee.bos.ctrl.web.DateTimeField", WebTags.DATETIMEFIELD);
        controlType2TagMap.put("com.kingdee.bos.ctrl.web.DateField", WebTags.DATEFIELD);
        controlType2TagMap.put("com.kingdee.bos.ctrl.web.PromptBox", WebTags.KDPROMPTBOX);
        controlType2TagMap.put("com.kingdee.bos.ctrl.web.Container", WebTags.KDCONTAINER);
        controlType2TagMap.put("com.kingdee.bos.ctrl.web.Composite", WebTags.KDCOMPOSITE);
        controlType2TagMap.put("com.kingdee.bos.ctrl.web.Multilanguage", WebTags.KDMULTILANGUAGE);
        controlType2TagMap.put("com.kingdee.bos.ctrl.web.MsgArea", WebTags.KDMSGAREA);
        controlType2TagMap.put("com.kingdee.bos.ctrl.web.Attachment", WebTags.KDATTACHMENT);
        controlType2TagMap.put("com.kingdee.bos.ctrl.web.TitleSection", WebTags.KDTITLESECTION);
        controlType2TagMap.put("com.kingdee.bos.ctrl.web.Line", WebTags.KDLINE);
        controlType2TagMap.put("com.kingdee.bos.ctrl.web.CalcNumberField", WebTags.CALCNUMBERFIELD);
        controlType2TagMap.put("com.kingdee.bos.ctrl.web.CheckBoxGroup", WebTags.CHECKBOXGROUP);
        controlType2TagMap.put("com.kingdee.bos.ctrl.web.CheckMenuItem", WebTags.CHECKMENUITEM);
        controlType2TagMap.put("com.kingdee.bos.ctrl.web.CommandMenuItem", WebTags.COMMANDMENUITEM);
        controlType2TagMap.put("com.kingdee.bos.ctrl.web.ContextMenu", WebTags.CONTEXTMENU);
        controlType2TagMap.put("com.kingdee.bos.ctrl.web.DataGrid", WebTags.DATAGRID);
        controlType2TagMap.put("com.kingdee.bos.ctrl.web.EditDataGrid", WebTags.EDITDATAGRID);
        controlType2TagMap.put("com.kingdee.bos.ctrl.web.Menu", WebTags.DATEMENU);
        controlType2TagMap.put("com.kingdee.bos.ctrl.web.DrawImage", WebTags.DRAWIMAGE);
        controlType2TagMap.put("com.kingdee.bos.ctrl.web.EditDataGrid", WebTags.EDITDATAGRID);
        controlType2TagMap.put("com.kingdee.bos.ctrl.web.FileUploadDialog", WebTags.FILEUPLOADDIALOG);
        controlType2TagMap.put("com.kingdee.bos.ctrl.web.Fileupload", WebTags.FILEUPLOAD);
        controlType2TagMap.put("com.kingdee.bos.ctrl.web.FileUploadProgressBar", WebTags.FILEUPLOADPROGRESS);
        controlType2TagMap.put("com.kingdee.bos.ctrl.web.Form", WebTags.FORM);
        controlType2TagMap.put("com.kingdee.bos.ctrl.web.Iframe", WebTags.IFRAME);
        controlType2TagMap.put("com.kingdee.bos.ctrl.web.LinkMenuItem", WebTags.LINKMENUITEM);
        controlType2TagMap.put("com.kingdee.bos.ctrl.web.Menu", WebTags.MENU);
        controlType2TagMap.put("com.kingdee.bos.ctrl.web.MenuBar", WebTags.MENUBAR);
        controlType2TagMap.put("com.kingdee.bos.ctrl.web.MenuItem", WebTags.MENUITEM);
        controlType2TagMap.put("com.kingdee.bos.ctrl.web.NumberField", WebTags.NUMBERFIELD);
        controlType2TagMap.put("com.kingdee.bos.ctrl.web.ToolBar", WebTags.PAGINGTOOLBAR);
        controlType2TagMap.put("com.kingdee.bos.ctrl.web.ProgressBar", WebTags.PROGRESSBAR);
        controlType2TagMap.put("com.kingdee.bos.ctrl.web.RadioGroup", WebTags.RADIOGROUP);
        controlType2TagMap.put("com.kingdee.bos.ctrl.web.RadioMenuItem", WebTags.RADIOMENUITEM);
        controlType2TagMap.put("com.kingdee.bos.ctrl.web.Separator", WebTags.SEPARATOR);
        controlType2TagMap.put("com.kingdee.bos.ctrl.web.SimpleHtmlEditor", WebTags.SIMPLEHTMLEDITOR);
        controlType2TagMap.put("com.kingdee.bos.ctrl.web.Slider", WebTags.SLIDER);
        controlType2TagMap.put("com.kingdee.bos.ctrl.web.TimeField", WebTags.TIMEFIELD);
        controlType2TagMap.put("com.kingdee.bos.ctrl.web.ToolBar", WebTags.TOOLBAR);
        controlType2TagMap.put("com.kingdee.bos.ctrl.web.Tree", WebTags.TREE);
        controlType2TagMap.put("com.kingdee.bos.ctrl.web.TreeNode", WebTags.TREENODE);
        controlType2TagMap.put("com.kingdee.bos.ctrl.web.RootPane", WebTags.PAGE);
        controlType2TagMap.put("com.kingdee.bos.ctrl.web.TablePanel", WebTags.TABLE);
        controlType2TagMap.put("com.kingdee.bos.ctrl.web.Label", WebTags.OUTPUT_TEXT);
        controlType2TagMap.put("com.kingdee.bos.ctrl.web.UseBean", WebTags.USEBEAN);
        controlType2TagMap.put("com.kingdee.bos.ctrl.web.ListBox", WebTags.SELECT_MANY_LISTBOX);
        controlType2TagMap.put("com.kingdee.bos.ctrl.web.AjaxLogger", WebTags.LOGGER);
        controlType2TagMap.put("com.kingdee.bos.ctrl.web.AjaxScripter", WebTags.SCRIPTER);
        controlType2TagMap.put("com.kingdee.bos.ctrl.web.AjaxTimer", WebTags.TIMER);
        controlType2TagMap.put("com.kingdee.bos.ctrl.web.AjaxProgress", WebTags.PROGRESS);
        controlType2TagMap.put("com.kingdee.bos.ctrl.web.AjaxUpdater", WebTags.UPDATER);
        controlType2TagMap.put("com.kingdee.bos.ctrl.web.AjaxStatus", WebTags.STATUS);
        controlType2TagMap.put("com.kingdee.bos.ctrl.web.AjaxRenderGroup", WebTags.RENDERGROUP);
        controlType2TagMap.put("com.kingdee.bos.ctrl.web.TabbedPane", WebTags.TABLAYOUT);
        controlType2TagMap.put("com.kingdee.bos.ctrl.web.AccordionPane", WebTags.ACCORDIONLAYOUT);
        controlType2TagMap.put("com.kingdee.bos.ctrl.web.Panel", WebTags.PANEL);
        controlType2TagMap.put("com.kingdee.bos.ctrl.web.BorderLayoutPanel", WebTags.PANEL);
        controlType2TagMap.put("com.kingdee.bos.ctrl.web.Splitcontainer", WebTags.BORDERLAYOUT);
        controlType2TagMap.put("com.kingdee.bos.ctrl.web.BorderLayout", WebTags.BORDERLAYOUT);
        controlType2TagMap.put("com.kingdee.bos.ctrl.web.EditableColumn", WebTags.OUTPUTCOLUMN);
        controlType2TagMap.put("com.kingdee.bos.ctrl.web.Column", WebTags.OUTPUTCOLUMN);
        controlType2TagMap.put("com.kingdee.bos.ctrl.web.KDRootLayout", WebTags.KDROOTLAYOUT);
        controlType2TagMap.put("com.kingdee.bos.ctrl.web.KDLayout", WebTags.KDLAYOUT);
        controlType2TagMap.put("com.kingdee.bos.ctrl.web.KDLayoutPanel", WebTags.KDLAYOUTPANEL);
        uiClass.put("com.kingdee.bos.ctrl.web.LabelContainer", "com.kingdee.bos.web.components.panel.impl.UILabelContainer");
        uiClass.put("com.kingdee.bos.ctrl.web.Container", "com.kingdee.bos.web.components.panel.impl.UIContainer");
        uiClass.put("com.kingdee.bos.ctrl.web.Composite", "com.kingdee.bos.web.components.panel.impl.UIComposite");
        uiClass.put("com.kingdee.bos.ctrl.web.EnumCombo", "com.kingdee.bos.web.components.widget.impl.UIEnumCombo");
        uiClass.put("com.kingdee.bos.ctrl.web.PromptBox", "com.kingdee.bos.web.components.widget.impl.UIPromptBox");
        uiClass.put("com.kingdee.bos.ctrl.web.Button", "org.operamasks.faces.component.widget.UIButton");
        uiClass.put("com.kingdee.bos.ctrl.web.ComboBox", "org.operamasks.faces.component.form.impl.UICombo");
        uiClass.put("com.kingdee.bos.ctrl.web.CheckBox", "org.operamasks.faces.component.form.impl.UICheckBox");
        uiClass.put("com.kingdee.bos.ctrl.web.CheckMenuItem", "org.operamasks.faces.component.widget.menu.UICheckMenuItem");
        uiClass.put("com.kingdee.bos.ctrl.web.TextField", "org.operamasks.faces.component.form.impl.UITextField");
        uiClass.put("com.kingdee.bos.ctrl.web.TextArea", "org.operamasks.faces.component.form.impl.UITextArea");
        uiClass.put("com.kingdee.bos.ctrl.web.DateTimeField", "org.operamasks.faces.component.form.impl.UIDateTimeField");
        uiClass.put("com.kingdee.bos.ctrl.web.DateField", "org.operamasks.faces.component.form.impl.UIDateField");
        uiClass.put("com.kingdee.bos.ctrl.web.CalcNumberField", "org.operamasks.faces.component.form.impl.UICalcNumberField");
        uiClass.put("com.kingdee.bos.ctrl.web.CheckBoxGroup", "org.operamasks.faces.component.form.impl.UICheckBoxGroup");
        uiClass.put("com.kingdee.bos.ctrl.web.LinkMenuItem", "org.operamasks.faces.component.widget.menu.UILinkMenuItem");
        uiClass.put("com.kingdee.bos.ctrl.web.MenuItem", "org.operamasks.faces.component.widget.menu.UITextMenuItem");
        uiClass.put("com.kingdee.bos.ctrl.web.MenuBar", "org.operamasks.faces.component.widget.menu.UIMenu");
        uiClass.put("com.kingdee.bos.ctrl.web.Menu", "org.operamasks.faces.component.widget.menu.UIMenu");
        uiClass.put("com.kingdee.bos.ctrl.web.ToolBar", "org.operamasks.faces.component.widget.UIToolBar");
        uiClass.put("com.kingdee.bos.ctrl.web.ContextMenu", "org.operamasks.faces.component.widget.menu.UIMenu");
        uiClass.put("com.kingdee.bos.ctrl.web.DataGrid", "org.operamasks.faces.component.grid.impl.UIDataGrid");
        uiClass.put("com.kingdee.bos.ctrl.web.EditDataGrid", "org.operamasks.faces.component.grid.impl.UIEditDataGrid");
        uiClass.put("com.kingdee.bos.ctrl.web.DrawImage", "org.operamasks.faces.component.widget.UIDrawImage");
        uiClass.put("com.kingdee.bos.ctrl.web.FileUploadDialog", "org.operamasks.faces.component.widget.fileupload.impl.UIFileUploadDialog");
        uiClass.put("com.kingdee.bos.ctrl.web.Fileupload", "org.operamasks.faces.component.widget.UIFileUpload");
        uiClass.put("com.kingdee.bos.ctrl.web.FileUploadProgressBar", "org.operamasks.faces.component.widget.UIFileUploadProgress");
        uiClass.put("com.kingdee.bos.ctrl.web.Form", "org.operamasks.faces.component.widget.UIForm");
        uiClass.put("com.kingdee.bos.ctrl.web.Iframe", "org.operamasks.faces.component.html.impl.UIIFrame");
        uiClass.put("com.kingdee.bos.ctrl.web.NumberField", "org.operamasks.faces.component.form.impl.UINumberField");
        uiClass.put("com.kingdee.bos.ctrl.web.ProgressBar", "org.operamasks.faces.component.widget.UIProgressBar");
        uiClass.put("com.kingdee.bos.ctrl.web.RadioGroup", "org.operamasks.faces.component.form.impl.UIRadioGroup");
        uiClass.put("com.kingdee.bos.ctrl.web.RadioMenuItem", "org.operamasks.faces.component.widget.menu.UIRadioMenuItem");
        uiClass.put("com.kingdee.bos.ctrl.web.Separator", "org.operamasks.faces.component.widget.UISeparator");
        uiClass.put("com.kingdee.bos.ctrl.web.SimpleHtmlEditor", "org.operamasks.faces.component.form.impl.UISimpleHtmlEditor");
        uiClass.put("com.kingdee.bos.ctrl.web.Slider", "org.operamasks.faces.component.widget.UISlider");
        uiClass.put("com.kingdee.bos.ctrl.web.TimeField", "org.operamasks.faces.component.form.impl.UITimeField");
        uiClass.put("com.kingdee.bos.ctrl.web.Tree", "org.operamasks.faces.component.tree.impl.UITree");
        uiClass.put("com.kingdee.bos.ctrl.web.TreeNode", "org.operamasks.faces.component.tree.impl.UITreeNode");
        uiClass.put("com.kingdee.bos.ctrl.web.Label", "javax.faces.component.html.HtmlOutputText");
        uiClass.put("com.kingdee.bos.ctrl.web.CommandLink", "javax.faces.component.html.HtmlCommandLink");
        uiClass.put("com.kingdee.bos.ctrl.web.ListBox", "javax.faces.component.html.HtmlSelectManyListbox");
        uiClass.put("com.kingdee.bos.ctrl.web.Multilanguage", "com.kingdee.bos.web.components.widget.impl.UIMultiLangBox");
        uiClass.put("com.kingdee.bos.ctrl.web.AjaxLogger", "org.operamasks.faces.component.ajax.AjaxLogger");
        uiClass.put("com.kingdee.bos.ctrl.web.AjaxScripter", "org.operamasks.faces.component.ajax.AjaxScripter");
        uiClass.put("com.kingdee.bos.ctrl.web.AjaxTimer", "org.operamasks.faces.component.ajax.AjaxTimer");
        uiClass.put("com.kingdee.bos.ctrl.web.AjaxProgress", "org.operamasks.faces.component.ajax.AjaxProgress");
        uiClass.put("com.kingdee.bos.ctrl.web.AjaxUpdater", "org.operamasks.faces.component.ajax.AjaxUpdater");
        uiClass.put("com.kingdee.bos.ctrl.web.AjaxStatus", "org.operamasks.faces.component.ajax.AjaxStatus");
        uiClass.put("com.kingdee.bos.ctrl.web.AjaxRenderGroup", "javax.faces.component.html.HtmlPanelGroup");
        uiClass.put("com.kingdee.bos.ctrl.web.TabbedPane", "org.operamasks.faces.component.layout.impl.UITabLayout");
        uiClass.put("com.kingdee.bos.ctrl.web.AccordionPane", "org.operamasks.faces.component.layout.impl.UIAccordionLayout");
        uiClass.put("com.kingdee.bos.ctrl.web.Panel", "org.operamasks.faces.component.layout.impl.UIPanel");
        uiClass.put("com.kingdee.bos.ctrl.web.FreePanel", "com.kingdee.bos.web.components.layout.impl.UIKDLayout");
        uiClass.put("com.kingdee.bos.ctrl.web.BorderLayoutPanel", "org.operamasks.faces.component.layout.impl.UIPanel");
        uiClass.put("com.kingdee.bos.ctrl.web.Splitcontainer", "org.operamasks.faces.component.layout.impl.UIBorderLayout");
        uiClass.put("com.kingdee.bos.ctrl.web.BorderLayout", "org.operamasks.faces.component.layout.impl.UIBorderLayout");
        uiClass.put("com.kingdee.bos.ctrl.web.EditableColumn", "org.operamasks.faces.component.grid.UIOutputColumn");
        uiClass.put("com.kingdee.bos.ctrl.web.Column", "org.operamasks.faces.component.grid.UIOutputColumn");
        uiClass.put("com.kingdee.bos.ctrl.web.MsgArea", "com.kingdee.bos.web.components.widget.impl.UIMsgArea");
        uiClass.put("com.kingdee.bos.ctrl.web.Attachment", "com.kingdee.bos.web.components.widget.impl.UIAttachment");
        uiClass.put("com.kingdee.bos.ctrl.web.TitleSection", "com.kingdee.bos.web.components.panel.impl.UITitleSection");
        uiClass.put("com.kingdee.bos.ctrl.web.Line", "com.kingdee.bos.web.components.panel.impl.UILine");
        uiClass.put("com.kingdee.bos.ctrl.web.Div", "com.kingdee.bos.web.components.panel.impl.UIDiv");
        uiClass.put("com.kingdee.bos.ctrl.web.AjaxAction", "org.operamasks.faces.component.ajax.AjaxAction");
        uiClass.put("com.kingdee.bos.ctrl.web.RootPane", "org.operamasks.faces.component.html.HtmlPage");
        uiClass.put("com.kingdee.bos.ctrl.web.SelectItem", "javax.faces.component.UISelectItem");
        uiClass.put("com.kingdee.bos.ctrl.web.SelectItems", "javax.faces.component.UISelectItems");
        uiClass.put("com.kingdee.bos.ctrl.web.Image", "javax.faces.component.html.HtmlGraphicImage");
        uiClass.put("com.kingdee.bos.ctrl.web.KDRootLayout", "com.kingdee.bos.web.components.layout.impl.UIKDRootLayout");
        uiClass.put("com.kingdee.bos.ctrl.web.KDLayout", "com.kingdee.bos.web.components.layout.impl.UIKDLayout");
        uiClass.put("com.kingdee.bos.ctrl.web.KDLayoutPanel", "com.kingdee.bos.web.components.panel.impl.UIKDLayoutPanel");
        ctrlNeedResize.add("com.kingdee.bos.ctrl.web.LabelContainer");
        ctrlNeedResize.add("com.kingdee.bos.ctrl.web.Button");
        ctrlNeedResize.add("com.kingdee.bos.ctrl.web.TextField");
        ctrlNeedResize.add("com.kingdee.bos.ctrl.web.TextArea");
        ctrlNeedResize.add("com.kingdee.bos.ctrl.web.ComboBox");
        ctrlNeedResize.add("com.kingdee.bos.ctrl.web.CalcNumberField");
        ctrlNeedResize.add("com.kingdee.bos.ctrl.web.CheckBox");
        ctrlNeedResize.add("com.kingdee.bos.ctrl.web.DataGrid");
        ctrlNeedResize.add("com.kingdee.bos.ctrl.web.DateField");
        ctrlNeedResize.add("com.kingdee.bos.ctrl.web.DateTimeField");
        ctrlNeedResize.add("com.kingdee.bos.ctrl.web.EditDataGrid");
        ctrlNeedResize.add("com.kingdee.bos.ctrl.web.NumberField");
        ctrlNeedResize.add("com.kingdee.bos.ctrl.web.RadioButton");
        ctrlNeedResize.add("com.kingdee.bos.ctrl.web.TimeField");
    }
}

