/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.webui.transfer;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.code.CodeFactory;
import com.kingdee.bos.metadata.code.webui.XHTMLGenerator;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.query.JoinQueryInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.ui.ComponentCollection;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.DataObjectInfo;
import com.kingdee.bos.metadata.ui.PropertyInfo;
import com.kingdee.bos.metadata.util.ContextManager;
import com.kingdee.bos.metadata.webui.ScriptInfo;
import com.kingdee.bos.metadata.webui.WebUIObjectAssembler;
import com.kingdee.bos.metadata.webui.WebUIObjectCtrl;
import com.kingdee.bos.metadata.webui.WebUIObjectInfo;
import com.kingdee.bos.metadata.webui.transfer.ComponentNameGenerator;
import com.kingdee.bos.metadata.webui.transfer.IWebUILayoutStrategy;
import com.kingdee.bos.metadata.webui.transfer.ResourceBundleList;
import com.kingdee.bos.metadata.webui.transfer.UIType;
import com.kingdee.bos.metadata.webui.transfer.UnSupportedUITypeException;
import com.kingdee.bos.metadata.webui.transfer.WebUILayoutStrategyFactory;
import com.kingdee.bos.metadata.webui.transfer.WebUIModelMapper;
import com.kingdee.bos.metadata.webui.xhtml.WebTag;
import com.kingdee.bos.metadata.webui.xhtml.WebTagHelper;
import com.kingdee.bos.metadata.webui.xhtml.WebTags;
import com.kingdee.bos.ui.bizunitproxy.UIProxyHelper;
import com.kingdee.bos.util.XMLParser;
import com.kingdee.util.StringUtils;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PropertyResourceBundle;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class XHTMLParser {
    private static Logger logger = Logger.getLogger(XHTMLParser.class);

    private static boolean hasEditDataGridComponent(Element parent) {
        List list = parent.getChildren(WebTags.EDITDATAGRID.getTagName(), WebTags.EDITDATAGRID.getNs());
        if (list.size() > 0) {
            return true;
        }
        list = parent.getChildren();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            if (!XHTMLParser.hasEditDataGridComponent((Element)list.get(i))) continue;
            return true;
        }
        return false;
    }

    private static MetaDataPK getBaseUIPK(UIType uiType, Document doc) throws UnSupportedUITypeException {
        if (doc == null || doc.getRootElement() == null) {
            return null;
        }
        if (UIType.EDITUI.equals((Object)uiType)) {
            return WebUIModelMapper.BaseEditUI;
        }
        if (UIType.LISTUI.equals((Object)uiType)) {
            return WebUIModelMapper.BaseListUI;
        }
        if (UIType.COMMONQUERYUI.equals((Object)uiType)) {
            return WebUIModelMapper.BaseCommonQueryUI;
        }
        throw new UnSupportedUITypeException("\u4e0d\u652f\u6301\u754c\u9762\u7c7b\u578b\uff1a" + (Object)((Object)uiType));
    }

    public static ComponentInfo findInnerWindowUserTag(WebUIObjectInfo model) {
        ComponentInfo main;
        if (model != null && (main = model.getMainPanelComponent()) != null) {
            return XHTMLParser.findComponentInfoByNameAndType(main.getComponents(), "innerWindowUserTag", "com.kingdee.bos.ctrl.web.UserTag");
        }
        return null;
    }

    private static ComponentInfo findComponentInfoByNameAndType(ComponentCollection col, String name, String type) {
        if (col != null) {
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                ComponentInfo child;
                ComponentInfo cInfo = col.get(i);
                if (name.equals(cInfo.getName()) && type.equals(cInfo.getClassType())) {
                    return cInfo;
                }
                if (!cInfo.isContainer() || (child = XHTMLParser.findComponentInfoByNameAndType(cInfo.getComponents(), name, type)) == null) continue;
                return child;
            }
        }
        return null;
    }

    private static void setInnerWindowUserTag(WebUIObjectInfo model) {
        ComponentInfo innerWindow = XHTMLParser.findInnerWindowUserTag(model);
        if (innerWindow != null) {
            PropertyInfo pInfo = innerWindow.getPropertyByName("attributes");
            String shortName = CodeFactory.getWebUIShortPackage(model.getPackage());
            pInfo.setValue("beanName=#{" + shortName + "." + model.getName() + "Bean}");
            pInfo.setOverride(true);
        }
    }

    public static WebUIObjectInfo parse(InputStream is, Map resources, String fullName, UIType uiType, MetaDataPK baseUIPK) throws IOException, JDOMException, BOSException {
        ResourceBundleList bundleMap = XHTMLParser.loadResources(resources);
        Document doc = XHTMLParser.createDocument(is);
        WebUIObjectInfo model = baseUIPK == null ? XHTMLParser.createWebUIObject(new MetaDataPK(fullName), XHTMLParser.getBaseUIPK(uiType, doc)) : XHTMLParser.createWebUIObject(new MetaDataPK(fullName), baseUIPK);
        IWebUILayoutStrategy layoutStrategy = WebUILayoutStrategyFactory.create(uiType, model);
        layoutStrategy.initMainPanel(model);
        WebUIModelMapper mapper = new WebUIModelMapper(model, bundleMap);
        XHTMLParser.parseUI(model, model.getMainPanelComponent(), doc.getRootElement(), layoutStrategy, mapper);
        layoutStrategy.updateModel();
        XHTMLParser.generateComponentNames(model.getMainPanelComponent(), new ComponentNameGenerator(model));
        XHTMLParser.setInnerWindowUserTag(model);
        return model;
    }

    public static WebUIObjectInfo parse(InputStream is, Map resources, String fullName, UIType uiType, MetaDataPK baseUIPK, EntityObjectInfo entity) throws IOException, JDOMException, BOSException {
        ResourceBundleList bundleMap = XHTMLParser.loadResources(resources);
        Document doc = XHTMLParser.createDocument(is);
        WebUIObjectInfo model = baseUIPK == null ? XHTMLParser.createWebUIObject(new MetaDataPK(fullName), XHTMLParser.getBaseUIPK(uiType, doc), entity) : XHTMLParser.createWebUIObject(new MetaDataPK(fullName), baseUIPK, entity);
        IWebUILayoutStrategy layoutStrategy = WebUILayoutStrategyFactory.create(uiType, model);
        layoutStrategy.initMainPanel(model);
        WebUIModelMapper mapper = new WebUIModelMapper(model, bundleMap);
        XHTMLParser.parseUI(model, model.getMainPanelComponent(), doc.getRootElement(), layoutStrategy, mapper);
        layoutStrategy.updateModel();
        XHTMLParser.generateComponentNames(model.getMainPanelComponent(), new ComponentNameGenerator(model));
        XHTMLParser.setInnerWindowUserTag(model);
        return model;
    }

    public static WebUIObjectInfo parse(InputStream is, Map resources, String fullName, UIType uiType, MetaDataPK baseUIPK, JoinQueryInfo query) throws IOException, JDOMException, BOSException {
        ResourceBundleList bundleMap = XHTMLParser.loadResources(resources);
        Document doc = XHTMLParser.createDocument(is);
        WebUIObjectInfo model = baseUIPK == null ? XHTMLParser.createWebUIObject(new MetaDataPK(fullName), XHTMLParser.getBaseUIPK(uiType, doc), query) : XHTMLParser.createWebUIObject(new MetaDataPK(fullName), baseUIPK, query);
        IWebUILayoutStrategy layoutStrategy = WebUILayoutStrategyFactory.create(uiType, model);
        layoutStrategy.initMainPanel(model);
        WebUIModelMapper mapper = new WebUIModelMapper(model, bundleMap);
        XHTMLParser.parseUI(model, model.getMainPanelComponent(), doc.getRootElement(), layoutStrategy, mapper);
        layoutStrategy.updateModel();
        XHTMLParser.generateComponentNames(model.getMainPanelComponent(), new ComponentNameGenerator(model));
        XHTMLParser.setInnerWindowUserTag(model);
        return model;
    }

    public static WebUIObjectInfo createWebUIObject(MetaDataPK pk, MetaDataPK baseUIPK) throws BOSException, UnSupportedUITypeException {
        WebUIObjectInfo model = new WebUIObjectInfo();
        model.setPackage(pk.getPackage());
        model.setName(pk.getName());
        model.setReleasePackage(pk.getPackage());
        model.setReleaseClass(pk.getName());
        model = XHTMLParser.setBaseUI(model, baseUIPK);
        return model;
    }

    public static WebUIObjectInfo createWebUIObject(MetaDataPK pk, MetaDataPK baseUIPK, EntityObjectInfo entity) throws BOSException, UnSupportedUITypeException {
        WebUIObjectInfo model = XHTMLParser.createWebUIObject(pk, baseUIPK);
        XHTMLParser.setDataObject(model, entity);
        return model;
    }

    public static WebUIObjectInfo createWebUIObject(MetaDataPK pk, MetaDataPK baseUIPK, JoinQueryInfo query) throws BOSException, UnSupportedUITypeException {
        WebUIObjectInfo model = XHTMLParser.createWebUIObject(pk, baseUIPK);
        XHTMLParser.setDataObject(model, query);
        return model;
    }

    private static WebUIObjectInfo setBaseUI(WebUIObjectInfo model, MetaDataPK baseUIPK) throws BOSException, UnSupportedUITypeException {
        model.setParent(XHTMLParser.getBaseUI(baseUIPK));
        return WebUIObjectAssembler.assembleUI(ContextManager.getContext(), model, true);
    }

    private static WebUIObjectInfo getBaseUI(MetaDataPK pk) throws BOSException {
        WebUIObjectCtrl ctrl = new WebUIObjectCtrl(ContextManager.getContext());
        WebUIObjectInfo model = ctrl.getAllValue(pk);
        return model;
    }

    private static void setDataObject(WebUIObjectInfo model, EntityObjectInfo entity) {
        if (entity != null) {
            DataObjectInfo dataObj = new DataObjectInfo();
            dataObj.setName("editData");
            dataObj.setObjectType(MetaDataTypeList.ENTITY.toString());
            dataObj.setType(entity.getFullName());
            dataObj.setOverride(true);
            model.getDataObjects().add(dataObj);
        }
    }

    private static void setDataObject(WebUIObjectInfo model, QueryInfo query) {
        if (query != null) {
            DataObjectInfo dataObj = new DataObjectInfo();
            dataObj.setName("mainQuery");
            dataObj.setObjectType(MetaDataTypeList.JOINQUERY.toString());
            dataObj.setType(query.getFullName());
            dataObj.setOverride(true);
            model.getDataObjects().add(dataObj);
        }
    }

    private static Document createDocument(InputStream is) throws UnSupportedUITypeException, IOException, JDOMException {
        return XMLParser.parseXML((InputStream)is);
    }

    private static String getControlShortName(String classType) {
        String shortName = classType;
        if (shortName.indexOf(".") > 0) {
            shortName = shortName.substring(shortName.lastIndexOf(".") + 1);
        }
        return StringUtils.headCharLowerCase((String)shortName);
    }

    private static void generateComponentNames(ComponentInfo parent, ComponentNameGenerator nameGenerator) {
        if (StringUtils.isEmpty((String)parent.getName())) {
            String shortName = XHTMLParser.getControlShortName(parent.getClassType());
            parent.setName(nameGenerator.generateName(shortName));
        }
        ComponentCollection components = parent.getComponents();
        int n = components.size();
        for (int i = 0; i < n; ++i) {
            XHTMLParser.generateComponentNames(components.get(i), nameGenerator);
        }
    }

    private static void parseUI(WebUIObjectInfo model, ComponentInfo container, Element element, IWebUILayoutStrategy layoutStrategy, WebUIModelMapper mapper) {
        if (model == null || container == null || element == null || layoutStrategy == null) {
            return;
        }
        WebTag webTag = WebTag.create(element);
        if (WebTagHelper.isSupportedWebTag(webTag)) {
            if (WebUIModelMapper.isDefined(webTag)) {
                ComponentInfo component = layoutStrategy.getDefinedComponent(element.getAttributeValue("name"));
                if (component == null) {
                    component = container;
                }
                List list = element.getChildren();
                int n = list.size();
                for (int i = 0; i < n; ++i) {
                    XHTMLParser.parseUI(model, component, (Element)list.get(i), layoutStrategy, mapper);
                }
            } else if (WebUIModelMapper.isIgnored(element)) {
                List list = element.getChildren();
                int n = list.size();
                for (int i = 0; i < n; ++i) {
                    XHTMLParser.parseUI(model, container, (Element)list.get(i), layoutStrategy, mapper);
                }
            } else if (WebUIModelMapper.isTitle(webTag)) {
                model.setTitle(element.getText());
            } else if (WebUIModelMapper.isScript(webTag)) {
                ScriptInfo script = WebUIModelMapper.parseScript(element);
                if (script != null) {
                    model.getScripts().add(script);
                }
            } else if (WebUIModelMapper.isComponent(webTag)) {
                ComponentInfo component = null;
                String id = element.getAttributeValue("id");
                if (!StringUtils.isEmpty((String)id)) {
                    component = UIProxyHelper.findControlByName(model.getMainPanelComponent(), id);
                }
                if (component != null) {
                    component = mapper.parseComponent(element, component);
                } else {
                    component = mapper.parseComponent(element);
                    if (component != null) {
                        component = layoutStrategy.addComponent(container, component, WebUIModelMapper.getComponentSize(component));
                    }
                }
                if (component != null && component.isContainer()) {
                    List list = element.getChildren();
                    int n = list.size();
                    for (int i = 0; i < n; ++i) {
                        XHTMLParser.parseUI(model, component, (Element)list.get(i), layoutStrategy, mapper);
                    }
                }
            } else {
                List list = element.getChildren();
                int n = list.size();
                for (int i = 0; i < n; ++i) {
                    XHTMLParser.parseUI(model, container, (Element)list.get(i), layoutStrategy, mapper);
                }
            }
        } else {
            logger.debug((Object)("un supported web tag:" + element.getName()));
        }
    }

    private static Element findDefineElementByName(Element parent, String name) {
        List list = parent.getChildren("define", WebTags.UINS);
        if (list != null && list.size() > 0) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                Element element = (Element)list.get(i);
                if (element.getAttribute("name") == null || !name.equalsIgnoreCase(element.getAttribute("name").getValue())) continue;
                return element;
            }
        }
        return null;
    }

    private static ResourceBundleList loadResources(Map resources) throws IOException {
        HashMap<String, PropertyResourceBundle> bundleMap = new HashMap<String, PropertyResourceBundle>();
        if (resources != null && !resources.isEmpty()) {
            for (String key : resources.keySet()) {
                Object obj = resources.get(key);
                if (obj == null || !(obj instanceof InputStream)) continue;
                PropertyResourceBundle bundle = new PropertyResourceBundle((InputStream)obj);
                bundleMap.put(key, bundle);
            }
        }
        return new ResourceBundleList(bundleMap);
    }

    public static void main(String[] args) {
        WebUIObjectInfo model = XHTMLParser.testParser();
        XHTMLParser.testGenerator(model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static WebUIObjectInfo testParser() {
        FileInputStream is = null;
        HashMap<String, FileInputStream> resources = new HashMap<String, FileInputStream>();
        FileInputStream properties1 = null;
        FileInputStream properties2 = null;
        try {
            is = new FileInputStream("C:\\test\\otherExpenseBillEdit.xhtml");
            properties1 = new FileInputStream("C:\\test\\LocalStrings.properties");
            resources.put("msgs", properties1);
            properties2 = new FileInputStream("C:\\test\\PageDisplayStrings.properties");
            resources.put("extraMsgs", properties2);
        }
        catch (FileNotFoundException e) {
            logger.error((Object)e);
        }
        finally {
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException e) {
                logger.error((Object)"close InputStream error!", (Throwable)e);
            }
        }
        WebUIObjectInfo model = null;
        if (is != null) {
            try {
                model = XHTMLParser.parse(is, resources, "com.kingdee.eas.cp.bc.webui.OtherExpenseBillEditUI", UIType.EDITUI, null);
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (JDOMException e) {
                logger.error((Object)e);
            }
            if (model != null) {
                logger.info((Object)model.toString());
            }
        }
        try {
            if (is != null) {
                ((InputStream)is).close();
            }
            if (properties1 != null) {
                properties1.close();
            }
            if (properties2 != null) {
                properties2.close();
            }
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
        return model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testGenerator(WebUIObjectInfo model) {
        XHTMLGenerator generator = new XHTMLGenerator(model);
        Document doc = generator.generate();
        Format format = Format.getCompactFormat();
        format.setEncoding("utf-8");
        format.setIndent("  ");
        format.setTextMode(Format.TextMode.TRIM_FULL_WHITE);
        format.setOmitDeclaration(true);
        XMLOutputter output = new XMLOutputter(format);
        FileOutputStream os = null;
        try {
            os = new FileOutputStream("C:\\test\\test.xhtml");
            output.output(doc, (OutputStream)os);
        }
        catch (FileNotFoundException e) {
            logger.error((Object)e);
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)"close FileOutputStream error!", (Throwable)e);
            }
        }
    }
}

