/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.webui.transfer.strategy;

import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.LayoutInfo;
import com.kingdee.bos.metadata.ui.PropertyInfo;
import com.kingdee.bos.metadata.webui.WebLayoutDataConverter;
import com.kingdee.bos.metadata.webui.WebUIObjectInfo;
import com.kingdee.bos.ui.dtp.model.layout.TableLayout;
import com.kingdee.bos.ui.dtp.weblayout.WebLayoutData;
import java.awt.Dimension;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.XMLOutputter;

public class TablePanelManager {
    private ComponentInfo tablePanel = null;
    private WebUIObjectInfo model = null;
    private int currentRow = 0;
    private int currentCol = 0;
    private int columnCount = 2;
    private int rowCount = 1;
    private List mergedRows = new ArrayList();
    private static Namespace NS_TABLE = Namespace.getNamespace((String)"t", (String)"com.kingdee.bos.ui.tablelayout");
    private static final int WIDTH = 300;
    private static final int HEIGHT = 30;

    public TablePanelManager(WebUIObjectInfo model, ComponentInfo tablePanel, int columnCount) {
        this.model = model;
        this.tablePanel = tablePanel;
        this.columnCount = columnCount;
    }

    public void addComponent(ComponentInfo component, Dimension dim, boolean occupyWholeRow) {
        if (occupyWholeRow) {
            while (this.currentCol != 0) {
                this.getCurrentCellConstraint();
            }
            this.mergedRows.add(this.currentRow);
        }
        String constraint = "width=" + dim.width + ";height=" + dim.height + ";newLine=false" + this.getCurrentCellConstraint();
        component.setConstraint(constraint, false);
        this.tablePanel.addChild(this.model, component);
    }

    private String getCurrentCellConstraint() {
        String constraint = "#row=" + this.currentRow + ",column=" + this.currentCol;
        ++this.currentCol;
        if (this.currentCol == this.columnCount) {
            this.currentCol = 0;
            ++this.currentRow;
            ++this.rowCount;
        }
        return constraint;
    }

    public void updateFormatXml() {
        Element table;
        Document doc;
        String xml = "<?xml version=\"1.0\" encoding=\"UNICODE\"?><DocRoot xmlns:t=\"com.kingdee.bos.ui.tablelayout\">\t\t<t:table></t:table></DocRoot>";
        SAXBuilder sb = new SAXBuilder();
        try {
            doc = sb.build((Reader)new StringReader(xml));
            table = doc.getRootElement().getChild("table", NS_TABLE);
        }
        catch (Exception e) {
            return;
        }
        table.setAttribute("rows", String.valueOf(this.rowCount));
        table.setAttribute("columns", String.valueOf(this.columnCount));
        table.setAttribute("cellspacing", "0");
        boolean recordWidth = false;
        for (int i = 0; i < this.rowCount; ++i) {
            Element tr = new Element("tr", NS_TABLE);
            tr.setAttribute("height", String.valueOf(30));
            table.addContent((Content)tr);
            if (this.isMerge(i)) {
                Element td = new Element("td", NS_TABLE);
                td.setAttribute("colspan", String.valueOf(this.columnCount));
                tr.addContent((Content)td);
                continue;
            }
            for (int j = 0; j < this.columnCount; ++j) {
                Element td = new Element("td", NS_TABLE);
                if (!recordWidth) {
                    td.setAttribute("width", "300px");
                    td.setAttribute("widthHint", String.valueOf(300));
                    td.setAttribute("widthType", "0");
                }
                tr.addContent((Content)td);
            }
            recordWidth = true;
        }
        XMLOutputter out = new XMLOutputter();
        PropertyInfo prop = new PropertyInfo();
        prop.setName("formatXML");
        prop.setType(String.class.getName());
        prop.setValue(out.outputString(doc));
        this.tablePanel.getProperties().add(prop);
        LayoutInfo layout = new LayoutInfo();
        layout.setType("TableLayout");
        TableLayout tl = new TableLayout();
        tl.setRows(this.rowCount);
        tl.setColumns(this.columnCount);
        tl.setCellSpacing(0);
        layout.setValue(tl.getLayoutInfoValue());
        this.tablePanel.setLayoutInfo(layout);
        Dimension size = new Dimension(this.columnCount * 300 + 2 * (this.columnCount + 1), this.rowCount * 30 + 2 * (this.rowCount + 1));
        Object con = this.tablePanel.getConstraint();
        if (con instanceof String) {
            String s = (String)con;
            try {
                WebLayoutDataConverter oldWld = WebLayoutDataConverter.parse(s);
                this.tablePanel.setConstraint(WebLayoutDataConverter.parse(new WebLayoutData(WebLayoutData.Unit.absolute(size.width), size.height, true), oldWld.getRows(), oldWld.getColumns()), false);
            }
            catch (IllegalArgumentException ex) {
                this.tablePanel.setConstraint(new WebLayoutData(WebLayoutData.Unit.absolute(size.width), size.height, true), false);
            }
        } else {
            this.tablePanel.setConstraint(new WebLayoutData(WebLayoutData.Unit.absolute(size.width), size.height, true), false);
        }
        prop.setOverride(true);
        layout.setOverride(true);
        this.tablePanel.setHerited(true);
        this.tablePanel.setOverrideConstraint(true);
    }

    private boolean isMerge(int index) {
        int size = this.mergedRows.size();
        for (int i = 0; i < size; ++i) {
            Integer in = (Integer)this.mergedRows.get(i);
            if (in != index) continue;
            return true;
        }
        return false;
    }
}

