/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.webui.xhtml;

import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class WebTag {
    private String tagName;
    private Namespace ns;
    private static Map map = new HashMap();

    private WebTag(String tagName, Namespace ns) {
        this.tagName = tagName;
        this.ns = ns;
    }

    public static WebTag create(Element element) {
        if (element == null) {
            return null;
        }
        return WebTag.create(element.getName(), element.getNamespace());
    }

    public static WebTag create(String tagName, Namespace ns) {
        String tagKey = WebTag.getTagKey(tagName, ns);
        Object webTag = map.get(tagKey);
        if (webTag == null) {
            webTag = new WebTag(tagName, ns);
            map.put(tagKey, webTag);
        }
        return (WebTag)webTag;
    }

    private String getTagKey() {
        return WebTag.getTagKey(this.tagName, this.ns);
    }

    private static String getTagKey(String tagName, Namespace ns) {
        if (ns == null || StringUtils.isEmpty((String)ns.getPrefix())) {
            return tagName;
        }
        return ns.getPrefix() + ":" + tagName;
    }

    public Namespace getNs() {
        return this.ns;
    }

    public String getTagName() {
        return this.tagName;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof WebTag)) {
            return false;
        }
        return this.getTagKey().equals(((WebTag)obj).getTagKey());
    }

    public int hashCode() {
        return super.hashCode();
    }
}

