/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.orm.impl.server;

import com.kingdee.bos.ORMRPCObjectFactory;
import com.kingdee.bos.orm.IObjectFactory;
import com.kingdee.bos.rpc.security.RSA;
import com.kingdee.bos.rpcwrapper.IServer;
import com.kingdee.bos.rpcwrapper.RPCEngineFactory;
import com.kingdee.bos.rpcwrapper.ServerManager;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.log4j.Logger;

public class ORMRPCServer
implements ServletContextListener {
    private IServer server;
    private IServer sslServer;
    private int port;
    private static final Logger logger = Logger.getLogger(ORMRPCServer.class);

    public ORMRPCServer() {
        ServerManager sm = ServerManager.getInstance();
        try {
            RPCEngineFactory.registerObjectFactory((IObjectFactory)new ORMRPCObjectFactory());
            this.server = sm.newTCPServer();
            this.port = com.kingdee.bos.rpc.io.server.ServerManager.getConfig((String)"default").tcpConnectionPort;
            if (sm.supportSSL()) {
                this.sslServer = sm.newSSLServer("ssl");
            }
            RSA.init();
        }
        catch (Exception e) {
            throw new RuntimeException("cannot create rpc server", e);
        }
    }

    public void contextInitialized(ServletContextEvent arg0) {
        if (this.server != null) {
            this.server.start();
            logger.info((Object)("RPC Server[" + this.port + "] started "));
        }
        if (this.sslServer != null) {
            this.sslServer.start();
            logger.info((Object)("RPC SSL Server[" + ORMRPCServer.getDefaultSSLPort() + "] started "));
        }
    }

    public void contextDestroyed(ServletContextEvent arg0) {
        if (this.server != null) {
            this.server.shutdown();
            logger.info((Object)("RPC Server[" + this.port + "] showdown "));
        }
        if (this.sslServer != null) {
            this.sslServer.shutdown();
            logger.info((Object)("RPC SSL Server[" + ORMRPCServer.getDefaultSSLPort() + "] showdown "));
        }
    }

    private static final int getDefaultSSLPort() {
        return ServerManager.getInstance().getDefaultSSLPort();
    }
}

