/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.orm.trace;

import com.kingdee.bos.orm.trace.TraceClassInfo;
import com.kingdee.bos.orm.trace.TraceCodeBuildException;
import com.kingdee.bos.orm.trace.TraceMethodInfo;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import com.tool.classfile.sc;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

class InnerTraceCodeBuilder {
    InnerTraceCodeBuilder() {
    }

    public static String build(String logName, String pkgName, String clsName, Map traceObjs, int methodCount) throws IOException, TraceCodeBuildException {
        return InnerTraceCodeBuilder.build(InnerTraceCodeBuilder.buildTraceClassInfo(logName, pkgName, clsName), traceObjs, methodCount);
    }

    private static TraceClassInfo buildTraceClassInfo(String logName, String pkgName, String clsName) throws TraceCodeBuildException {
        ObjectInputStream is = null;
        TraceClassInfo traceClassInfo = null;
        try {
            is = new ObjectInputStream(new FileInputStream(logName));
            traceClassInfo = new TraceClassInfo(pkgName, clsName);
            TraceMethodInfo traceMethodInfo = null;
            while (is.available() > 0) {
                long ref = is.readLong();
                String methodSig = (String)is.readObject();
                traceMethodInfo = new TraceMethodInfo(methodSig);
                traceMethodInfo.setObjID(ref);
                if (methodSig.equals("createRemoteObject(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Class;)Lcom/kingdee/bos/orm/IORMModel;")) {
                    String serverUrl = (String)is.readObject();
                    String objectName = (String)is.readObject();
                    String modelName = (String)is.readObject();
                    int count = is.readInt();
                    Class[] initArgTypes = new Class[count];
                    Object[] initArg = new Object[count];
                    for (int i = 0; i < count; ++i) {
                        initArgTypes[i] = Class.forName((String)is.readObject());
                        initArg[i] = is.readObject();
                    }
                    traceMethodInfo.getArgValues()[0] = objectName;
                    traceMethodInfo.getArgValues()[1] = modelName;
                    traceMethodInfo.getArgValues()[2] = initArgTypes;
                    traceMethodInfo.getArgValues()[3] = initArg;
                    traceClassInfo.getTraceMethods().add(traceMethodInfo);
                    int index = traceClassInfo.getObjUrls().indexOf(serverUrl);
                    if (index != -1) {
                        traceMethodInfo.setUrlID(index);
                        continue;
                    }
                    traceClassInfo.getObjUrls().add(serverUrl);
                    index = traceClassInfo.getObjUrls().indexOf(serverUrl);
                    traceMethodInfo.setUrlID(index);
                    continue;
                }
                int index = methodSig.indexOf("(");
                String methodDes = methodSig.substring(index);
                String[] params = sc.methodParameters((String)methodDes);
                String javaType = null;
                for (int i = 0; i < params.length; ++i) {
                    javaType = sc.javaType((String)params[i]);
                    if (sc.isPrimitive((String)sc.classDescriptor((String)javaType))) {
                        if ((javaType = sc.classDescriptor((String)javaType)).equalsIgnoreCase("B")) {
                            traceMethodInfo.getArgValues()[i] = new Byte(is.readByte());
                            continue;
                        }
                        if (javaType.equalsIgnoreCase("S")) {
                            traceMethodInfo.getArgValues()[i] = new Short(is.readShort());
                            continue;
                        }
                        if (javaType.equalsIgnoreCase("I")) {
                            traceMethodInfo.getArgValues()[i] = is.readInt();
                            continue;
                        }
                        if (javaType.equalsIgnoreCase("F")) {
                            traceMethodInfo.getArgValues()[i] = new Float(is.readFloat());
                            continue;
                        }
                        if (javaType.equalsIgnoreCase("Z")) {
                            traceMethodInfo.getArgValues()[i] = is.readBoolean();
                            continue;
                        }
                        if (javaType.equalsIgnoreCase("D")) {
                            traceMethodInfo.getArgValues()[i] = new Double(is.readDouble());
                            continue;
                        }
                        if (javaType.equalsIgnoreCase("C")) {
                            traceMethodInfo.getArgValues()[i] = new Character(is.readChar());
                            continue;
                        }
                        if (!javaType.equalsIgnoreCase("J")) continue;
                        traceMethodInfo.getArgValues()[i] = is.readLong();
                        continue;
                    }
                    traceMethodInfo.getArgValues()[i] = is.readObject();
                }
                traceClassInfo.getTraceMethods().add(traceMethodInfo);
            }
            TraceClassInfo traceClassInfo2 = traceClassInfo;
            return traceClassInfo2;
        }
        catch (IOException ioe) {
            throw new TraceCodeBuildException(ioe);
        }
        catch (ClassNotFoundException cnfe) {
            throw new TraceCodeBuildException(cnfe);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static String build(TraceClassInfo traceClassInfo, Map objectVars, int methodCount) throws IOException {
        int i;
        InnerTraceCodeBuilder.preProcess(traceClassInfo);
        StringBuffer sb = new StringBuffer();
        if (!StringUtils.isEmpty((String)traceClassInfo.getPkgName())) {
            sb.append("package " + traceClassInfo.getPkgName() + ";\n\n");
        }
        Iterator importIt = traceClassInfo.getImportSet().iterator();
        String importStr = null;
        while (importIt.hasNext()) {
            importStr = (String)importIt.next();
            sb.append("import " + importStr + ";\n");
        }
        sb.append("import com.kingdee.util.LowTimer;\n");
        sb.append("import com.kingdee.bos.orm.trace.BaseTraceTest;\n");
        sb.append("import com.kingdee.bos.orm.trace.TraceObjectLoader;\n");
        sb.append("import com.kingdee.bos.BOSObjectFactory;\n");
        sb.append("import org.apache.log4j.Logger;\n");
        sb.append("\n");
        sb.append("public class " + traceClassInfo.getClsName() + " extends BaseTraceTest {\n");
        Iterator objIdIt = traceClassInfo.getObjectRefs().keySet().iterator();
        Long key = null;
        while (objIdIt.hasNext()) {
            key = (Long)objIdIt.next();
            sb.append(InnerTraceCodeBuilder.getTabString(1) + "private " + InnerTraceCodeBuilder.getObjectShortName(traceClassInfo, key) + " ");
            sb.append(InnerTraceCodeBuilder.getObjectVarName(traceClassInfo, key) + " = null;\n");
        }
        sb.append("\n");
        sb.append(InnerTraceCodeBuilder.getTabString(1) + "private static final Logger logger = \n");
        sb.append(InnerTraceCodeBuilder.getTabString(2) + "Logger.getLogger(" + traceClassInfo.getClsName() + ".class);\n");
        sb.append(InnerTraceCodeBuilder.getTabString(2) + "private TraceObjectLoader traceObjectLoader = null;\n");
        Vector urls = traceClassInfo.getObjUrls();
        sb.append("\n");
        int len = urls.size();
        for (int i2 = 0; i2 < len; ++i2) {
            sb.append(InnerTraceCodeBuilder.getTabString(1) + "public String rpcURL" + i2 + " = getServerUrl();\n");
        }
        sb.append("\n");
        sb.append(InnerTraceCodeBuilder.getTabString(1) + "public " + traceClassInfo.getClsName() + "(String arg) {\n");
        sb.append(InnerTraceCodeBuilder.getTabString(2) + "super(arg);\n");
        sb.append(InnerTraceCodeBuilder.getTabString(1) + "}\n");
        sb.append(InnerTraceCodeBuilder.getTabString(1) + "public void setUp() throws Exception {\n");
        sb.append(InnerTraceCodeBuilder.getTabString(2) + "super.setUp();\n");
        sb.append(InnerTraceCodeBuilder.getTabString(2) + "traceObjectLoader = new TraceObjectLoader(getClass());\n");
        sb.append(InnerTraceCodeBuilder.getTabString(1) + "}\n");
        sb.append(InnerTraceCodeBuilder.getTabString(1) + "public void tearDown() throws Exception {\n");
        sb.append(InnerTraceCodeBuilder.getTabString(2) + "super.tearDown();\n");
        sb.append(InnerTraceCodeBuilder.getTabString(2) + "traceObjectLoader.clear();\n");
        sb.append(InnerTraceCodeBuilder.getTabString(1) + "}\n");
        sb.append("\n");
        sb.append(InnerTraceCodeBuilder.getTabString(1) + "//Empty method for debug!\n");
        sb.append(InnerTraceCodeBuilder.getTabString(1) + "private void nop(){\n");
        sb.append(InnerTraceCodeBuilder.getTabString(1) + "}\n");
        Vector methods = traceClassInfo.getTraceMethods();
        TraceMethodInfo traceMethodInfo = null;
        sb.append("\n");
        sb.append(InnerTraceCodeBuilder.getTabString(1) + "public void testTrace() {\n");
        sb.append(InnerTraceCodeBuilder.getTabString(2) + "LowTimer t = new LowTimer();\n");
        int count = methods.size() / methodCount;
        sb.append(InnerTraceCodeBuilder.getTabString(2) + "innerTestTrace0();\n");
        for (i = 1; i <= count; ++i) {
            sb.append(InnerTraceCodeBuilder.getTabString(2) + "innerTestTrace" + i + "();\n");
        }
        sb.append(InnerTraceCodeBuilder.getTabString(2) + "logger.info(\"testTrace runtime: \" + t.msValue());\n");
        sb.append(InnerTraceCodeBuilder.getTabString(1) + "}\n");
        sb.append("\n");
        int size = methods.size();
        for (i = 0; i < size; ++i) {
            String methodSig;
            if (i == 0 || i % methodCount == 0) {
                if (i != 0) {
                    sb.append(InnerTraceCodeBuilder.getTabString(1) + "}\n");
                }
                sb.append("\n");
                sb.append(InnerTraceCodeBuilder.getTabString(1) + "public void innerTestTrace" + i / methodCount + "() {\n");
            }
            if ((methodSig = (traceMethodInfo = (TraceMethodInfo)methods.get(i)).getMethodSig().intern()).equals("createRemoteObject(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Class;)Lcom/kingdee/bos/orm/IORMModel;")) {
                sb.append(InnerTraceCodeBuilder.buildCreateObjectMethod(objectVars, traceClassInfo, traceMethodInfo, 2));
                if (i != methods.size() - 1 && (i + 1) % methodCount != 0) {
                    sb.append("\n");
                }
            } else if (methodSig.equals("finalize()V")) {
                if (InnerTraceCodeBuilder.isRefAvailable(traceClassInfo, traceMethodInfo.getObjID())) {
                    sb.append(InnerTraceCodeBuilder.buildReleaseObjectMethod(objectVars, traceClassInfo, traceMethodInfo, 2));
                } else {
                    sb.append(InnerTraceCodeBuilder.getTabString(2) + "//");
                    sb.append(traceMethodInfo.getMethodSig() + " method for refid [" + traceMethodInfo.getObjID() + "] ignore here!");
                    sb.append("\n");
                }
                if (i != methods.size() - 1 && (i + 1) % methodCount != 0) {
                    sb.append("\n");
                }
            } else if (methodSig.equals("traceComment(Ljava/lang/String;)V") && traceMethodInfo.getObjID() == -1L) {
                sb.append(InnerTraceCodeBuilder.getTabString(2) + "/*\n");
                sb.append(InnerTraceCodeBuilder.getTabString(1) + " * " + traceMethodInfo.getArgValues()[0]);
                sb.append("\n");
                sb.append(InnerTraceCodeBuilder.getTabString(2) + " */\n");
            } else {
                if (InnerTraceCodeBuilder.isRefAvailable(traceClassInfo, traceMethodInfo.getObjID())) {
                    sb.append(InnerTraceCodeBuilder.buildCommonObjectMethod(objectVars, traceClassInfo, traceMethodInfo, 2));
                } else {
                    sb.append(InnerTraceCodeBuilder.getTabString(2) + "//");
                    sb.append(traceMethodInfo.getMethodSig() + " method for refid [" + traceMethodInfo.getObjID() + "] ignore here!");
                    sb.append("\n");
                }
                if (i != methods.size() - 1 && (i + 1) % methodCount != 0) {
                    sb.append("\n");
                }
            }
            if (i != methods.size() - 1) continue;
            sb.append(InnerTraceCodeBuilder.getTabString(1) + "}\n");
        }
        sb.append("}");
        return sb.toString();
    }

    private static String buildCreateObjectMethod(Map objectVars, TraceClassInfo traceClassInfo, TraceMethodInfo traceMethodInfo, int tab) throws IOException {
        assert (traceMethodInfo.getMethodSig().intern().equals("createRemoteObject(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Class;)Lcom/kingdee/bos/orm/IORMModel;")) : "Invalidate state";
        StringBuffer sb = new StringBuffer();
        sb.append(InnerTraceCodeBuilder.getTabString(tab) + "try {\n");
        sb.append(InnerTraceCodeBuilder.getTabString(tab + 1) + "String objectName = \"" + traceMethodInfo.getArgValues()[0] + "\";\n");
        sb.append(InnerTraceCodeBuilder.getTabString(tab + 1) + "Class interfaceClass = " + traceMethodInfo.getArgValues()[1] + ".class;\n");
        String interfaceName = InnerTraceCodeBuilder.getObjectShortName(traceClassInfo, traceMethodInfo.getObjID());
        String varName = InnerTraceCodeBuilder.getObjectVarName(traceClassInfo, traceMethodInfo.getObjID());
        String objName = (String)traceMethodInfo.getArgValues()[0];
        String urlName = "rpcURL" + traceMethodInfo.getUrlID();
        Class[] clz = (Class[])traceMethodInfo.getArgValues()[2];
        if (clz == null || clz.length == 0) {
            sb.append(InnerTraceCodeBuilder.getTabString(tab + 1) + varName + "=\n");
            if (objName.startsWith("$bosobj$")) {
                sb.append(InnerTraceCodeBuilder.getTabString(tab + 3) + "(" + interfaceName + ")BOSObjectFactory.createRemoteBOSObject(" + urlName);
            } else {
                sb.append(InnerTraceCodeBuilder.getTabString(tab + 3) + "(" + interfaceName + ")BOSObjectFactory.createRemoteObject(" + urlName);
            }
            sb.append(", objectName, interfaceClass);\n");
        } else {
            Object[] objs = (Object[])traceMethodInfo.getArgValues()[3];
            Uuid uuid = Uuid.create();
            objectVars.put(uuid, clz);
            sb.append(InnerTraceCodeBuilder.getTabString(tab + 1) + "Class[] initArgTypes = traceObjectLoader.getObject(\"" + uuid.toString() + "\");\n");
            uuid = Uuid.create();
            objectVars.put(uuid, objs);
            sb.append(InnerTraceCodeBuilder.getTabString(tab + 1) + "Object[] initArgValues = traceObjectLoader.getObject(\"" + uuid.toString() + "\")\n");
            sb.append(interfaceName + " " + varName + "= (" + interfaceName + ")");
            if (objName.startsWith("$bosobj$")) {
                sb.append(")BOSObjectFactory.createRemoteBOSObject(" + urlName);
            } else {
                sb.append(")BOSObjectFactory.createRemoteBOSObject(" + urlName);
            }
            sb.append(", objectName, interfaceClass, initArgTypes, initArgValues);\n");
        }
        sb.append(InnerTraceCodeBuilder.getTabString(tab + 1) + "nop();\n");
        sb.append(InnerTraceCodeBuilder.getTabString(tab) + "} catch(Throwable e) {\n");
        sb.append(InnerTraceCodeBuilder.getTabString(tab + 1) + "logger.error(\"ERROR\" ,e);\n");
        sb.append(InnerTraceCodeBuilder.getTabString(tab) + "}\n");
        return sb.toString();
    }

    private static String buildCommonObjectMethod(Map objectVars, TraceClassInfo traceClassInfo, TraceMethodInfo traceMethodInfo, int tab) {
        StringBuffer sb = new StringBuffer();
        String[] argTypes = traceMethodInfo.getArgTypes();
        String methodSig = traceMethodInfo.getMethodSig();
        sb.append(InnerTraceCodeBuilder.getTabString(tab) + "try {\n");
        int size = argTypes.length;
        for (int i = 0; i < size && !"void".equals(argTypes[i]); ++i) {
            if (sc.isPrimitive((String)sc.classDescriptor((String)argTypes[i]))) {
                sb.append(InnerTraceCodeBuilder.getTabString(tab + 1) + argTypes[i] + " arg" + i + " = (" + argTypes[i] + ")" + traceMethodInfo.getArgValues()[i] + ";\n");
                continue;
            }
            if ("String".equals(argTypes[i])) {
                sb.append(InnerTraceCodeBuilder.getTabString(tab + 1) + "String arg" + i + " = \"" + traceMethodInfo.getArgValues()[i] + "\";\n");
                continue;
            }
            String typeName = InnerTraceCodeBuilder.getObjectShortName(argTypes[i]);
            Uuid uuid = Uuid.create();
            objectVars.put(uuid.toString(), traceMethodInfo.getArgValues()[i]);
            sb.append(InnerTraceCodeBuilder.getTabString(tab + 1) + typeName + " arg" + i + " = (" + typeName + ")traceObjectLoader.getObject\n");
            sb.append(InnerTraceCodeBuilder.getTabString(tab + 3) + "(\"" + uuid.toString() + "\");\n");
        }
        String returnType = traceMethodInfo.getReturnType();
        String objName = InnerTraceCodeBuilder.getObjectVarName(traceClassInfo, traceMethodInfo.getObjID());
        String methodName = methodSig.substring(0, methodSig.indexOf("("));
        String typeName = null;
        if ("void".equals(returnType)) {
            sb.append(InnerTraceCodeBuilder.getTabString(tab + 1) + objName + "." + methodName + "(");
        } else {
            typeName = InnerTraceCodeBuilder.getObjectShortName(returnType);
            if (sc.isPrimitive((String)sc.classDescriptor((String)returnType))) {
                sb.append(InnerTraceCodeBuilder.getTabString(tab + 1) + typeName + " ret;\n");
            } else {
                sb.append(InnerTraceCodeBuilder.getTabString(tab + 1) + typeName + " ret= null;\n");
            }
            sb.append(InnerTraceCodeBuilder.getTabString(tab + 1) + "ret = " + objName + "." + methodName + "(");
        }
        if (argTypes.length > 0 && !"void".equals(argTypes[0])) {
            sb.append("arg0");
        }
        int len = argTypes.length;
        for (int i = 1; i < len; ++i) {
            sb.append(" ,arg" + i);
        }
        sb.append(");\n");
        sb.append(InnerTraceCodeBuilder.getTabString(tab + 1) + "nop();\n");
        sb.append(InnerTraceCodeBuilder.getTabString(tab) + "} catch(Throwable e) {\n");
        sb.append(InnerTraceCodeBuilder.getTabString(tab + 1) + "logger.error(\"ERROR\" ,e);\n");
        sb.append(InnerTraceCodeBuilder.getTabString(tab) + "}\n");
        return sb.toString();
    }

    private static String buildReleaseObjectMethod(Map objectVars, TraceClassInfo traceClassInfo, TraceMethodInfo traceMethodInfo, int tab) {
        StringBuffer sb = new StringBuffer();
        String interfaceName = (String)traceClassInfo.getObjectRefs().get(new Long(traceMethodInfo.getObjID()));
        if ((interfaceName = InnerTraceCodeBuilder.getObjectShortName(interfaceName)) == null) {
            return null;
        }
        String varName = interfaceName.substring(0, 1).toLowerCase() + interfaceName.substring(1, interfaceName.length()) + traceMethodInfo.getObjID();
        sb.append(InnerTraceCodeBuilder.getTabString(tab) + varName + "= null;\n");
        return sb.toString();
    }

    private static void preProcess(TraceClassInfo traceClassInfo) {
        Vector methods = traceClassInfo.getTraceMethods();
        TraceMethodInfo traceMethodInfo = null;
        int size = methods.size();
        for (int i = 0; i < size; ++i) {
            traceMethodInfo = (TraceMethodInfo)methods.get(i);
            String returnType = traceMethodInfo.getReturnType();
            traceClassInfo.addImportType(returnType);
            int len = traceMethodInfo.getArgTypes().length;
            for (int j = 0; j < len; ++j) {
                traceClassInfo.addImportType(traceMethodInfo.getArgTypes()[j]);
            }
            if (!traceMethodInfo.getMethodSig().intern().equals("createRemoteObject(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Class;)Lcom/kingdee/bos/orm/IORMModel;")) continue;
            traceClassInfo.getObjectRefs().put(new Long(traceMethodInfo.getObjID()), traceMethodInfo.getReturnType());
        }
    }

    private static String getObjectShortName(String fullName) {
        if (fullName == null) {
            return null;
        }
        String tmp = fullName;
        if (fullName.lastIndexOf(46) != -1) {
            tmp = fullName.substring(fullName.lastIndexOf(46) + 1, fullName.length());
        }
        return tmp;
    }

    private static boolean isRefAvailable(TraceClassInfo traceClassInfo, long id) {
        return traceClassInfo.getObjectRefs().containsKey(new Long(id));
    }

    private static String getObjectShortName(TraceClassInfo traceClassInfo, long id) {
        String fullName = (String)traceClassInfo.getObjectRefs().get(new Long(id));
        if (fullName != null) {
            fullName = InnerTraceCodeBuilder.getObjectShortName(fullName);
        }
        return fullName;
    }

    private static String getObjectVarName(TraceClassInfo traceClassInfo, long id) {
        String interfaceName = InnerTraceCodeBuilder.getObjectShortName(traceClassInfo, id);
        if (interfaceName == null) {
            return null;
        }
        String varName = interfaceName.substring(0, 1).toLowerCase() + interfaceName.substring(1, interfaceName.length()) + id;
        return varName;
    }

    private static String getTabString(int tab) {
        String tmp = "";
        for (int i = 1; i <= tab; ++i) {
            tmp = tmp + "    ";
        }
        return tmp;
    }

    public static void main(String[] args) throws Exception {
        TraceClassInfo traceClassInfo = InnerTraceCodeBuilder.buildTraceClassInfo("D:\\eclipse2.1\\workspace\\DemoBuilder\\ormrpc_trace\\log\\ormrpc_20040601103906.trace", "test", "test");
        System.out.println(InnerTraceCodeBuilder.build(traceClassInfo, new HashMap(), 10));
    }
}

