/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.orm.trace;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.util.XmlUtils;
import com.kingdee.bos.orm.trace.compatible.CompatibleHelper;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.util.Base64Encoder;
import com.kingdee.util.SAXBuilderFactory;
import com.kingdee.util.Uuid;
import com.kingdee.util.enums.Enum;
import com.kingdee.util.enums.EnumUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.DefaultJDOMFactory;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.JDOMFactory;
import org.jdom2.input.SAXBuilder;

public final class XMLHelper {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.orm.trace.XMLHelper");
    private static final String OBJECTVALUE = "objectValue";
    private static final String OBJECTCOLLECTION = "objectCollection";
    private static final String USEROBJECT = "userObject";
    private static final String CLASSNAME = "className";
    private static final String HASHCODE = "hashCode";
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String TYPE = "type";
    private static final String VALUE = "value";
    private static final String REFOBJECT = "refObj";
    private static final String ENTITY = "entity";
    private static final String COLLECTION = "collection";
    private static final String OWNPROPERTY = "ownProperty";
    private static final String ROOT = "root";
    private static final String NULL = "_~^NULL";
    private static final String COLLECTION_AGENT_CLASSNAME = "com.kingdee.bos.framework.agent.IObjectCollectionAgent";
    private static final String AGENT_CLASSNAME = "com.kingdee.bos.framework.agent.IObjectValueAgent";
    private static final String AGENT = "agent";
    private static final String STATE = "state";
    private static final String COLLECTIONAGENT = "collectionAgent";
    private static final String AGENT_STATE_CALSSNAME = "com.kingdee.bos.framework.agent.AgentState";
    private static final String COM_KINGDEE_BOS_UTIL_BOSOBJECTTYPE = "com.kingdee.bos.util.BOSObjectType";
    private static final String COM_KINGDEE_BOS_UTIL_BOSUUID = "com.kingdee.bos.util.BOSUuid";
    private static final String COM_KINGDEE_BOS_DAO_ORMAPPING_OBJECTUUIDPK = "com.kingdee.bos.dao.ormapping.ObjectUuidPK";
    private static final String COM_KINGDEE_BOS_METADATA_METADATAPK = "com.kingdee.bos.metadata.MetaDataPK";

    public static XMLHelper getInstance() {
        return new XMLHelper();
    }

    public Element obj2Xml(String key, Object value) {
        assert (key != null && value != null) : "Key & Value cannot be null!";
        if (!(value instanceof IObjectValue) || !(value instanceof IObjectCollection)) assert (false) : "Not supported object type!";
        Element root = null;
        HashSet refObjs = new HashSet();
        if (value instanceof IObjectValue) {
            root = this.createElement(OBJECTVALUE);
            root.setAttribute(this.createAttribute(ID, key));
            root.setAttribute(this.createAttribute(CLASSNAME, value.getClass().getName()));
            root.setAttribute(this.createAttribute(HASHCODE, Integer.toString(System.identityHashCode(value))));
            if (XMLHelper.isAgent(value)) {
                root.setAttribute(this.createAttribute(AGENT, "true"));
                root.setAttribute(this.createAttribute(STATE, this.getAgentState(value)));
            }
            this.buildElement(root, value, refObjs);
        } else if (value instanceof IObjectCollection) {
            root = this.createElement(OBJECTCOLLECTION);
            root.setAttribute(this.createAttribute(ID, key));
            root.setAttribute(this.createAttribute(CLASSNAME, value.getClass().getName()));
            root.setAttribute(this.createAttribute(HASHCODE, Integer.toString(System.identityHashCode(value))));
            this.buildElement(root, value, refObjs);
        } else {
            root = this.createElement(USEROBJECT);
            root.setAttribute(this.createAttribute(ID, key));
            root.setAttribute(this.createAttribute(CLASSNAME, value.getClass().getName()));
            this.buildUserObjectElement(root, value);
        }
        return root;
    }

    public Object[] xml2Obj(Element elem) throws Exception {
        assert (elem != null) : "Element cannot be null!";
        String key = elem.getAttributeValue(ID);
        Object value = null;
        if (elem.getName().equals(OBJECTVALUE) || elem.getName().equals(OBJECTCOLLECTION)) {
            value = this.buildObject(elem);
        } else if (elem.getName().equals(USEROBJECT)) {
            value = this.buildUserObject(elem);
        } else assert (false) : "Unsupported elem[" + elem.getName() + "]!";
        return new Object[]{key, value};
    }

    public void loadObjects(InputStream is, Map objects) throws IOException, JDOMException, Exception {
        SAXBuilder builder = SAXBuilderFactory.create();
        Element root = builder.build(is).getRootElement();
        Iterator it = root.getChildren().iterator();
        Element elem = null;
        Object[] objs = null;
        while (it.hasNext()) {
            elem = (Element)it.next();
            try {
                objs = this.xml2Obj(elem);
            }
            catch (Throwable t) {
                logger.error((Object)(elem.getAttribute(ID) + ": " + elem.getAttributeValue(CLASSNAME)), t);
            }
            objects.put(objs[0], objs[1]);
        }
    }

    public void storeObjects(Map xmlObjs, OutputStream os) throws IOException {
        Element root = this.getJDOMFactory().element(ROOT);
        Document doc = this.getJDOMFactory().document(root);
        Iterator objIt = xmlObjs.entrySet().iterator();
        Object key = null;
        Object value = null;
        Element elem = null;
        while (objIt.hasNext()) {
            Map.Entry entry = objIt.next();
            key = entry.getKey();
            value = entry.getValue();
            if (value == null) continue;
            elem = this.obj2Xml(key, value);
            root.addContent((Content)elem);
        }
        XmlUtils.output(doc, os);
    }

    private void buildUserObjectElement(Element root, Object value) {
        block10: {
            try {
                if (value.getClass().getName().equals(COM_KINGDEE_BOS_DAO_ORMAPPING_OBJECTUUIDPK)) {
                    root.setText(value.toString());
                } else if (value.getClass().getName().equals(COM_KINGDEE_BOS_UTIL_BOSOBJECTTYPE)) {
                    root.setText(value.toString());
                } else if (value.getClass().getName().equals(COM_KINGDEE_BOS_UTIL_BOSUUID)) {
                    root.setText(value.toString());
                } else if (value.getClass().getName().equals(COM_KINGDEE_BOS_METADATA_METADATAPK)) {
                    root.setText(((MetaDataPK)value).getFullName());
                } else {
                    String strValue = null;
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    ObjectOutputStream oos = new ObjectOutputStream(bos);
                    oos.writeObject(value);
                    byte[] buffer = bos.toByteArray();
                    strValue = Base64Encoder.byteArrayToBase64((byte[])buffer);
                    root.setText(strValue);
                }
            }
            catch (Exception e) {
                if ($assertionsDisabled) break block10;
                throw new AssertionError((Object)e.getMessage());
            }
        }
    }

    private Object buildUserObject(Element root) throws Exception {
        String clzName = root.getAttributeValue(CLASSNAME);
        String text = root.getText();
        Class<?> clz = Class.forName(clzName);
        if (clzName.equals(COM_KINGDEE_BOS_DAO_ORMAPPING_OBJECTUUIDPK) || clzName.equals(COM_KINGDEE_BOS_UTIL_BOSOBJECTTYPE) || clzName.equals(COM_KINGDEE_BOS_METADATA_METADATAPK)) {
            Constructor<?> constructor = clz.getConstructor(String.class);
            return constructor.newInstance(text);
        }
        if (clzName.equals(COM_KINGDEE_BOS_UTIL_BOSUUID)) {
            Method method = clz.getMethod("create", String.class);
            return method.invoke(null, text);
        }
        byte[] buffer = Base64Encoder.base64ToByteArray((String)root.getText());
        ByteArrayInputStream bis = new ByteArrayInputStream(buffer);
        ObjectInputStream ois = new ObjectInputStream(bis);
        Object obj = ois.readObject();
        return obj;
    }

    private void buildElement(Element root, Object refObj, Set refObjs) {
        if (refObjs.contains(Integer.toString(System.identityHashCode(refObj)))) {
            return;
        }
        refObjs.add(Integer.toString(System.identityHashCode(refObj)));
        if (refObj instanceof IObjectValue) {
            IObjectValue ov = (IObjectValue)refObj;
            Enumeration e = ov.keys();
            Object tmpKey = null;
            Object tmpValue = null;
            Element entity = this.createElement(ENTITY);
            entity.setAttribute(this.createAttribute(CLASSNAME, ov.getClass().getName()));
            entity.setAttribute(this.createAttribute(HASHCODE, Integer.toString(System.identityHashCode(ov))));
            if (XMLHelper.isAgent(refObj)) {
                entity.setAttribute(this.createAttribute(AGENT, "true"));
                entity.setAttribute(this.createAttribute(STATE, this.getAgentState(refObj)));
            }
            root.addContent((Content)entity);
            while (e.hasMoreElements()) {
                tmpKey = e.nextElement();
                tmpValue = ov.get(tmpKey);
                if (tmpValue == null) {
                    this.buildProperty(entity, tmpKey, NULL);
                    continue;
                }
                if (tmpValue instanceof IObjectValue || tmpValue instanceof IObjectCollection) {
                    Element refObjElem = this.createElement(REFOBJECT);
                    refObjElem.setAttribute(this.createAttribute(NAME, tmpKey));
                    refObjElem.setAttribute(this.createAttribute(CLASSNAME, tmpValue.getClass().getName()));
                    refObjElem.setAttribute(this.createAttribute(HASHCODE, Integer.toString(System.identityHashCode(tmpValue))));
                    entity.addContent((Content)refObjElem);
                    this.buildElement(root, tmpValue, refObjs);
                    continue;
                }
                this.buildProperty(entity, tmpKey, tmpValue);
            }
        } else if (refObj instanceof IObjectCollection) {
            Element collection = this.createElement(COLLECTION);
            collection.setAttribute(this.createAttribute(CLASSNAME, refObj.getClass().getName()));
            collection.setAttribute(this.createAttribute(HASHCODE, Integer.toString(System.identityHashCode(refObj))));
            root.addContent((Content)collection);
            IObjectCollection oc = (IObjectCollection)refObj;
            IObjectValue tmpValue = null;
            int size = oc.size();
            for (int i = 0; i < size; ++i) {
                tmpValue = oc.getObject(i);
                Element tmpElem = this.createElement(REFOBJECT);
                tmpElem.setAttribute(this.createAttribute(CLASSNAME, tmpValue.getClass().getName()));
                tmpElem.setAttribute(this.createAttribute(HASHCODE, Integer.toString(System.identityHashCode(tmpValue))));
                collection.addContent((Content)tmpElem);
                this.buildElement(root, tmpValue, refObjs);
            }
        } else assert (false) : "Unsupported object type!" + refObj.getClass().getName();
    }

    private void buildProperty(Element entity, String tmpKey, Object tmpValue) {
        String type;
        String strValue;
        Element prop;
        block32: {
            prop = this.createElement(OWNPROPERTY);
            strValue = tmpValue.toString();
            type = null;
            if (tmpValue instanceof Byte) {
                type = DataType.BYTE.getName();
            } else if (tmpValue instanceof Short) {
                type = DataType.SHORT.getName();
            } else if (tmpValue instanceof Integer) {
                type = DataType.INTEGER.getName();
            } else if (tmpValue instanceof Long) {
                type = DataType.LONG.getName();
            } else if (tmpValue instanceof Float) {
                type = DataType.FLOAT.getName();
            } else if (tmpValue instanceof Double) {
                type = DataType.DOUBLE.getName();
            } else if (tmpValue instanceof Time) {
                strValue = Long.toString(((Time)tmpValue).getTime());
                type = DataType.TIME.getName();
            } else if (tmpValue instanceof Date) {
                strValue = Long.toString(((Date)tmpValue).getTime());
                type = DataType.DATE.getName();
            } else if (tmpValue instanceof Timestamp) {
                strValue = Long.toString(((Timestamp)tmpValue).getTime());
                type = DataType.TIMESTAMP.getName();
            } else if (tmpValue instanceof Character) {
                type = DataType.CHAR.getName();
            } else if (tmpValue instanceof BigDecimal) {
                type = DataType.DECIMAL.getName();
            } else if (tmpValue instanceof Boolean) {
                type = DataType.BOOLEAN.getName();
            } else if (tmpValue instanceof String) {
                type = DataType.STRING.getName();
            } else if (tmpValue instanceof BOSUuid) {
                type = DataType.STRING.getName();
            } else if (tmpValue instanceof Uuid) {
                type = DataType.UUID.getName();
            } else {
                type = "Serializable";
                try {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    ObjectOutputStream oos = new ObjectOutputStream(bos);
                    oos.writeObject(tmpValue);
                    byte[] buffer = bos.toByteArray();
                    strValue = Base64Encoder.byteArrayToBase64((byte[])buffer);
                }
                catch (Exception e) {
                    if ($assertionsDisabled) break block32;
                    throw new AssertionError((Object)e.getMessage());
                }
            }
        }
        prop.setAttribute(this.createAttribute(NAME, tmpKey));
        prop.setAttribute(this.createAttribute(VALUE, strValue));
        prop.setAttribute(this.createAttribute(TYPE, type));
        entity.addContent((Content)prop);
    }

    private Object buildObject(Element root) throws Exception {
        Object mainObject = null;
        Iterator it = root.getChildren().iterator();
        if (root.getAttributeValue(AGENT) != null && root.getAttributeValue(AGENT).equalsIgnoreCase("true")) {
            mainObject = this.createAgent(root.getAttributeValue(CLASSNAME));
            this.setAgentState(mainObject, root.getAttributeValue(STATE));
        } else {
            mainObject = Class.forName(root.getAttributeValue(CLASSNAME)).newInstance();
        }
        HashMap<String, Object> objectsMap = new HashMap<String, Object>();
        objectsMap.put(root.getAttributeValue(HASHCODE), mainObject);
        Element elem = null;
        while (it.hasNext()) {
            Object refObj;
            elem = (Element)it.next();
            if (elem.getName().equals(ENTITY)) {
                IObjectValue tmpOV = (IObjectValue)objectsMap.get(elem.getAttributeValue(HASHCODE));
                if (tmpOV == null) {
                    if (elem.getAttributeValue(AGENT) != null && root.getAttributeValue(AGENT).equalsIgnoreCase("true")) {
                        mainObject = this.createAgent(elem.getAttributeValue(CLASSNAME));
                        this.setAgentState(tmpOV, elem.getAttributeValue(STATE));
                    } else {
                        tmpOV = (IObjectValue)Class.forName(elem.getAttributeValue(CLASSNAME)).newInstance();
                    }
                    objectsMap.put(elem.getAttributeValue(HASHCODE), tmpOV);
                }
                Iterator entityIt = elem.getChildren().iterator();
                Element propElem = null;
                while (entityIt.hasNext()) {
                    propElem = (Element)entityIt.next();
                    if (propElem.getName().equals(OWNPROPERTY)) {
                        this.buildObjectProperty(tmpOV, propElem);
                        continue;
                    }
                    if (!propElem.getName().equals(REFOBJECT)) continue;
                    refObj = objectsMap.get(propElem.getAttributeValue(HASHCODE));
                    if (refObj == null) {
                        refObj = Class.forName(propElem.getAttributeValue(CLASSNAME)).newInstance();
                        objectsMap.put(propElem.getAttributeValue(HASHCODE), refObj);
                    }
                    tmpOV.put(propElem.getAttributeValue(NAME), refObj);
                }
                XMLHelper.tryCompatible(tmpOV, elem);
                continue;
            }
            if (elem.getName().equals(COLLECTION)) {
                IObjectCollection tmpOC = (IObjectCollection)objectsMap.get(elem.getAttributeValue(HASHCODE));
                if (tmpOC == null) {
                    tmpOC = (IObjectCollection)Class.forName(elem.getAttributeValue(CLASSNAME)).newInstance();
                    objectsMap.put(elem.getAttributeValue(HASHCODE), tmpOC);
                }
                Iterator refObjIt = elem.getChildren().iterator();
                Element refElem = null;
                while (refObjIt.hasNext()) {
                    refElem = (Element)refObjIt.next();
                    if (refElem.getName().equals(REFOBJECT)) {
                        refObj = objectsMap.get(refElem.getAttributeValue(HASHCODE));
                        if (refObj == null) {
                            refObj = Class.forName(refElem.getAttributeValue(CLASSNAME)).newInstance();
                            objectsMap.put(refElem.getAttributeValue(HASHCODE), refObj);
                        }
                        tmpOC.addObject((IObjectValue)refObj);
                        continue;
                    }
                    assert (false) : "Unsupported elem[" + elem.getName() + "]!";
                }
                continue;
            }
            assert (false) : "Unsupported elem[" + elem.getName() + "]!";
        }
        return mainObject;
    }

    private void buildObjectProperty(IObjectValue parent, Element propElem) {
        String name = propElem.getAttributeValue(NAME);
        String type = propElem.getAttributeValue(TYPE);
        String strValue = propElem.getAttributeValue(VALUE);
        if (NULL.equals(strValue)) {
            parent.put(name, null);
            return;
        }
        if (type.equals(DataType.BOOLEAN.getName())) {
            parent.put(name, Boolean.valueOf(strValue));
        } else if (type.equals(DataType.BYTE.getName())) {
            parent.put(name, new Byte(strValue));
        } else if (type.equals(DataType.CHAR.getName())) {
            parent.put(name, new Character(strValue.charAt(0)));
        } else if (type.equals(DataType.SHORT.getName())) {
            parent.put(name, new Short(strValue));
        } else if (type.equals(DataType.INTEGER.getName())) {
            parent.put(name, new Integer(strValue));
        } else if (type.equals(DataType.LONG.getName())) {
            parent.put(name, new Long(strValue));
        } else if (type.equals(DataType.FLOAT.getName())) {
            parent.put(name, new Float(strValue));
        } else if (type.equals(DataType.DOUBLE.getName())) {
            parent.put(name, new Double(strValue));
        } else if (type.equals(DataType.DECIMAL.getName())) {
            parent.put(name, new BigDecimal(strValue));
        } else if (type.equals(DataType.TIME.getName())) {
            parent.put(name, new Time(Long.valueOf(strValue)));
        } else if (type.equals(DataType.DATE.getName())) {
            parent.put(name, new Date(Long.valueOf(strValue)));
        } else if (type.equals(DataType.TIMESTAMP.getName())) {
            parent.put(name, new Timestamp(Long.valueOf(strValue)));
        } else if (type.equals(DataType.STRING.getName())) {
            parent.put(name, strValue);
        } else if (type.equals(DataType.BOSUUID.getName())) {
            parent.put(name, BOSUuid.read((String)strValue));
        } else if (type.equals(DataType.UUID.getName())) {
            parent.put(name, Uuid.read((String)strValue));
        } else if (type.equals("Serializable")) {
            try {
                byte[] buffer = Base64Encoder.base64ToByteArray((String)strValue);
                ByteArrayInputStream bis = new ByteArrayInputStream(buffer);
                ObjectInputStream ois = new ObjectInputStream(bis);
                Object obj = ois.readObject();
                parent.put(name, obj);
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
                assert (false) : e.getMessage();
            }
        } else assert (false) : "Unsupported data type " + type + "!";
    }

    private JDOMFactory getJDOMFactory() {
        return new DefaultJDOMFactory();
    }

    private Element createElement(String name) {
        return this.getJDOMFactory().element(name);
    }

    private Attribute createAttribute(String name, String value) {
        return this.getJDOMFactory().attribute(name, value);
    }

    public static boolean needRefreashRecord(IObjectValue ov, Element entityElem) {
        if (!CompatibleHelper.isEntity(ov.getBOSType())) {
            return false;
        }
        String policy = System.getProperty("rpctrace.loader.compatibility");
        if ("force".equalsIgnoreCase(policy)) {
            return true;
        }
        if ("ignore".equalsIgnoreCase(policy)) {
            return false;
        }
        Iterator entityIt = entityElem.getChildren().iterator();
        Element propElem = null;
        while (entityIt.hasNext()) {
            propElem = (Element)entityIt.next();
            if (propElem.getName().equals(OWNPROPERTY)) {
                String name = propElem.getAttributeValue(NAME);
                String type = propElem.getAttributeValue(TYPE);
                int c = CompatibleHelper.onwerPropertyExist(ov.getBOSType(), name, type);
                switch (c) {
                    case -1: 
                    case 1: 
                    case 2: {
                        return true;
                    }
                    case 0: {
                        break;
                    }
                }
                continue;
            }
            if (!propElem.getName().equals(REFOBJECT)) continue;
        }
        if (CompatibleHelper.hasNewProperty(ov.getBOSType(), entityElem)) {
            return true;
        }
        logger.info((Object)"ov\u6ca1\u6709\u5c5e\u6027\u6539\u53d8");
        try {
            if (!CompatibleHelper.dataExistByPK(ov)) {
                return true;
            }
        }
        catch (BOSException e) {
            logger.error((Object)"\u67e5\u627e\u6570\u636e\u7684\u65f6\u5019\u51fa\u9519!", (Throwable)e);
            return false;
        }
        return false;
    }

    public static IObjectValue tryCompatible(IObjectValue ov, Element entityElem) {
        if (XMLHelper.needRefreashRecord(ov, entityElem)) {
            try {
                ov = CompatibleHelper.refreshRecored(ov);
            }
            catch (BOSException e) {
                logger.error((Object)"\u8bd5\u56fe\u5237\u65b0\u8bb0\u5f55\u65f6\u51fa\u9519", (Throwable)e);
            }
        }
        return ov;
    }

    static boolean isAgent(Object value) {
        Class<?> IObjectValueAgentClass = null;
        try {
            IObjectValueAgentClass = Class.forName(AGENT_CLASSNAME);
            return IObjectValueAgentClass.isInstance(value);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)"Cannot load IObjectValueAgent Class", (Throwable)e);
            return false;
        }
    }

    static boolean isCollectionAgent(Object value) {
        Class<?> IObjectCollectionAgentClass = null;
        try {
            IObjectCollectionAgentClass = Class.forName(COLLECTION_AGENT_CLASSNAME);
            return IObjectCollectionAgentClass.isInstance(value);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)"Cannot load IObjectValueAgent Class", (Throwable)e);
            return false;
        }
    }

    private Object createAgent(String className) {
        try {
            Class<?> agentCLass = Class.forName(className);
            Method createMethod = agentCLass.getMethod("create", new Class[0]);
            return createMethod.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            logger.error((Object)("create agent for " + className + " error!"), (Throwable)e);
            return null;
        }
    }

    private String getAgentState(Object agent) {
        String className = agent.getClass().getName();
        try {
            Class<?> agentCLass = Class.forName(className);
            Method getAgentStateMethod = agentCLass.getMethod("getAgentState", new Class[0]);
            Enum agentStateEnum = (Enum)getAgentStateMethod.invoke(agent, new Object[0]);
            return agentStateEnum.getName();
        }
        catch (Exception e) {
            logger.error((Object)("get agent state for " + className + " error!"), (Throwable)e);
            return null;
        }
    }

    private void setAgentState(Object agent, String state) {
        if (agent == null) {
            return;
        }
        String className = agent.getClass().getName();
        try {
            Class<?> agentCLass = Class.forName(className);
            Class<?> agentStateClass = Class.forName(AGENT_STATE_CALSSNAME);
            Method setAgentStateMethod = agentCLass.getMethod("setAgentState", agentStateClass);
            Enum agentStateEnum = EnumUtils.getEnum(agentStateClass, (String)state);
            setAgentStateMethod.invoke(agent, agentStateEnum);
        }
        catch (Exception e) {
            logger.error((Object)("get agent state for " + className + " error!"), (Throwable)e);
        }
    }
}

