/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.service.AbstractServiceManager;
import com.kingdee.bos.service.IServiceAdapter;
import com.kingdee.bos.service.IServiceContext;
import com.kingdee.bos.service.binding.ConcreteServiceBinder;
import com.kingdee.bos.service.binding.IServiceBinder;
import com.kingdee.bos.service.binding.LogServiceItem;
import com.kingdee.bos.service.binding.ServiceBindItem;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.profile.ProfileConfig;
import com.kingdee.util.profile.ThreadProfileContext;
import java.util.ArrayList;
import java.util.List;

public class BOSServiceManager
extends AbstractServiceManager {
    @Override
    protected void doService(IServiceAdapter adapter, IServiceContext svcCtx) throws BOSException {
        if (!this.isEnable(adapter)) {
            return;
        }
        if (ProfileConfig.getInstance().logService) {
            ThreadProfileContext.getInstance().enter(adapter.getClass().getName(), "execute", svcCtx.getExecutionMode() == 0 ? "before" : "after");
        }
        try {
            if (adapter.getName() == "LOG_SERVICE") {
                this.doLogService(adapter, svcCtx);
            } else if (adapter.getName() == "MUTEX_SERVICE") {
                this.doMutexService(adapter, svcCtx);
            } else if (adapter.getName() == "PERMISSION_SERVICE") {
                this.doPermissionService(adapter, svcCtx);
            } else {
                adapter.execute(svcCtx);
            }
        }
        finally {
            if (ProfileConfig.getInstance().logService) {
                ThreadProfileContext.getInstance().exit();
            }
        }
    }

    protected void doLogService(IServiceAdapter adapter, IServiceContext svcCtx) throws BOSException {
        ServiceBindItem[] bind = this.getServiceBinder(svcCtx.getContext()).getServiceBindings(svcCtx.getMetaType(), svcCtx.getBoType(), svcCtx.getOperationPK());
        if (bind != null && bind.length > 0) {
            ArrayList<String> items = new ArrayList<String>();
            int len = bind.length;
            for (int i = 0; i < len; ++i) {
                if (bind[i].getType() != 1) continue;
                items.add(bind[i].getName());
            }
            if (items.size() > 0) {
                this.fillLogServiceParameter(svcCtx, items);
            }
        }
        adapter.execute(svcCtx);
    }

    protected void doMutexService(IServiceAdapter adapter, IServiceContext svcCtx) throws BOSException {
        IServiceBinder binder = this.getServiceBinder(svcCtx.getContext());
        ServiceBindItem[] bind = binder.getServiceBindings(svcCtx.getMetaType(), svcCtx.getUiOrFunctionPK(), svcCtx.getOperationPK());
        if (bind == null || bind.length <= 0) {
            return;
        }
        ArrayList<String> items = new ArrayList<String>();
        int len = bind.length;
        for (int i = 0; i < len; ++i) {
            if (bind[i].getType() != 2) continue;
            items.add(bind[i].getName());
        }
        if (items.size() == 0) {
            return;
        }
        svcCtx.setServiceParameter("MUTEX_SERVICE", "MUTEX_ITEMS", items.toArray(new String[0]));
        adapter.execute(svcCtx);
    }

    protected void doPermissionService(IServiceAdapter adapter, IServiceContext svcCtx) throws BOSException {
        ServiceBindItem[] bind = null;
        bind = svcCtx.getMetaType() == MetaDataTypeList.BASEQUERY ? this.getServiceBinder(svcCtx.getContext()).getServiceBindings(svcCtx.getMetaType(), svcCtx.getUiOrFunctionPK()) : (svcCtx.getMetaType() == MetaDataTypeList.UIOBJECT ? this.getServiceBinder(svcCtx.getContext()).getServiceBindings(svcCtx.getMetaType(), svcCtx.getBoType(), svcCtx.getUiOrFunctionPK()) : this.getServiceBinder(svcCtx.getContext()).getServiceBindings(svcCtx.getMetaType(), svcCtx.getBoType(), svcCtx.getOperationPK()));
        if (bind == null || bind.length <= 0) {
            return;
        }
        ArrayList<String> items = new ArrayList<String>();
        int len = bind.length;
        for (int i = 0; i < len; ++i) {
            if (bind[i].getType() != 0) continue;
            items.add(bind[i].getName());
        }
        if (items.size() == 0) {
            return;
        }
        svcCtx.setServiceParameter("PERMISSION_SERVICE", "PERMISSION_ITEMS", items.toArray(new String[0]));
        adapter.execute(svcCtx);
    }

    @Override
    public IServiceBinder getRemoteServiceBinder(String slnName) {
        Context ctx = new Context(slnName);
        return ConcreteServiceBinder.getServiceBinder(ctx);
    }

    @Override
    public IServiceBinder getServiceBinder(Context ctx) {
        return ConcreteServiceBinder.getServiceBinder(ctx);
    }

    @Override
    public void clearServiceBinder(Context ctx) {
        ConcreteServiceBinder.clearServiceBinder(ctx);
    }

    private void fillLogServiceParameter(IServiceContext svcCtx, List<String> list) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader(svcCtx.getContext());
        BOSObjectType boType = svcCtx.getBoType();
        BusinessObjectInfo boInfo = null;
        if (svcCtx.getMetaType().equals((Object)MetaDataTypeList.ENTITY)) {
            boInfo = loader.getEntity(boType);
        } else if (svcCtx.getMetaType().equals((Object)MetaDataTypeList.FACADE)) {
            boInfo = loader.getFacade(boType);
        }
        String alias = LogServiceItem.getMethodAlias(boInfo, svcCtx.getOperationPK().toString());
        if (alias != null) {
            svcCtx.setServiceParameter("LOG_SERVICE", "LOG_METHOD_ALIAS", alias);
        }
        svcCtx.setServiceParameter("LOG_SERVICE", "LOG_ITEMS", list.toArray(new String[0]));
    }
}

