/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.binding;

import com.kingdee.bos.dao.xml.impl.MetadataCleaner;
import com.kingdee.bos.dao.xml.impl.MetadataClearListener;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.service.binding.IServiceItem;
import com.kingdee.bos.service.log.define.MethodRefInfo;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class LogServiceItem
implements IServiceItem {
    private int methodInvokeMode = 0;
    private static final Map<String, String> methodAlias = new LRUMap();

    LogServiceItem() {
    }

    static LogServiceItem createInstance(MethodRefInfo method) {
        if (method == null) {
            return null;
        }
        LogServiceItem item = new LogServiceItem();
        item.methodInvokeMode = method.getInvokeMode();
        return item;
    }

    public int getMethodInvokeMode() {
        return this.methodInvokeMode;
    }

    public static synchronized String getMethodAlias(BusinessObjectInfo bo, String methodInnerID) {
        String alias = methodAlias.get(methodInnerID);
        if (alias == null) {
            Iterator it = bo.getMethods().iterator();
            while (it.hasNext()) {
                MethodInfo method = (MethodInfo)it.next();
                if (!method.getInnerID().equals(methodInnerID)) continue;
                String tmp = method.getAlias();
                if (tmp == null) {
                    tmp = method.getName();
                }
                alias = tmp;
                methodAlias.put(methodInnerID, alias);
                break;
            }
        }
        return alias;
    }

    static {
        MetadataCleaner.registerListener(new MetadataClearListener(){

            @Override
            public void clear(String key) {
            }

            @Override
            public void clearAll() {
                methodAlias.clear();
            }
        });
    }

    private static class LRUMap
    extends LinkedHashMap<String, String> {
        private static final int MAX = 2000;

        private LRUMap() {
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, String> eldest) {
            return this.size() > 2000;
        }
    }
}

