/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.log.define;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.xml.CheckReportFilter;
import com.kingdee.bos.dao.xml.CheckReportItem;
import com.kingdee.bos.dao.xml.ICheckReport;
import com.kingdee.bos.metadata.AbstractMetaDataCtrl;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.management.DeployOptionInfo;
import com.kingdee.bos.service.log.define.ILogCtrl;
import com.kingdee.bos.service.log.define.LogBizRefCollection;
import com.kingdee.bos.service.log.define.LogBizRefInfo;
import com.kingdee.bos.service.log.define.LogCollection;
import com.kingdee.bos.service.log.define.LogInfo;
import com.kingdee.bos.service.log.define.LogItemCollection;
import com.kingdee.bos.service.log.define.LogItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.StringUtils;
import java.io.OutputStream;

public class LogCtrl
extends AbstractMetaDataCtrl
implements ILogCtrl {
    Context ctx = null;

    public LogCtrl() {
        super.registerInterface(ILogCtrl.class, (Object)this);
        this.loadSelfMetametaData(MetaDataPK.create("metametadata.service.log", "log"));
    }

    public LogCtrl(Context ctx) {
        super(ctx);
        super.registerInterface(ILogCtrl.class, (Object)this);
        this.loadSelfMetametaData(MetaDataPK.create("metametadata.service.log", "log"));
        this.ctx = ctx;
    }

    @Override
    public void addnew(IMetaDataPK pk, LogInfo logInfo) throws BOSException {
        this.getDAO().addnew(pk, logInfo);
    }

    @Override
    public IMetaDataPK addnew(LogInfo logInfo) throws BOSException {
        return (IMetaDataPK)this.getDAO().addnew(logInfo);
    }

    @Override
    public void update(IMetaDataPK metaType, LogInfo logInfo) throws BOSException {
        this.getDAO().update(metaType, logInfo);
    }

    @Override
    public LogInfo getValue(IMetaDataPK metaType) throws BOSException {
        if (metaType != null) {
            return (LogInfo)this.getDAO().getValue(metaType);
        }
        return this.getValue();
    }

    @Override
    public LogInfo getValue() throws BOSException {
        return this.getValue(MetaDataPK.create(null, "service"));
    }

    public LogInfo getUnionValue() throws BOSException {
        LogCollection logs = this.getCollection();
        LogInfo log = new LogInfo();
        log.setName("log");
        int n = logs.size();
        for (int i = 0; i < n; ++i) {
            log.getLogItems().addObjectCollection(logs.get(i).getLogItems());
        }
        return log;
    }

    public LogCollection getCollection() throws BOSException {
        return (LogCollection)this.getDAO().getCollection();
    }

    @Override
    public LogItemCollection getAllLogItems() throws BOSException {
        LogInfo log = this.getValue();
        return log.getLogItems();
    }

    @Override
    public LogItemInfo getLogItem(LogInfo log, String logItemName) throws BOSException {
        LogItemCollection logItemCol = log.getLogItems();
        LogItemInfo logItemInfo = null;
        int length = logItemCol.size();
        for (int i = 0; i < length; ++i) {
            if (!StringUtils.equalsIgnoreCase((String)logItemCol.get(i).getName(), (String)logItemName)) continue;
            logItemInfo = logItemCol.get(i);
            break;
        }
        if (logItemInfo == null) {
            throw new BOSException("Can't found LogItem");
        }
        return logItemInfo;
    }

    @Override
    public BOSObjectType getType() {
        return MetaDataTypeList.LOG;
    }

    @Override
    public void deploy(IMetaDataPK pk, DeployOptionInfo options) throws BOSException {
        super.deploy(pk, options);
    }

    @Override
    public void check(IMetaDataPK pk, CheckReportFilter filter, ICheckReport report, OutputStream os) throws BOSException {
        super.check(pk, filter, report, os);
        LogInfo info = this.getValue(pk);
        LogItemCollection items = info.getLogItems();
        assert (items != null);
        int len = items.size();
        for (int i = 0; i < len; ++i) {
            LogItemInfo item = items.get(i);
            if (item.getName() == null) {
                new CheckReportItem(2, pk, MetaDataTypeList.LOG, pk.toString(), 1, new String[]{"Name of this Permission Item is null"});
            }
            LogBizRefCollection bizRefs = item.getLogBizRefCollection();
            int size = bizRefs.size();
            for (int j = 0; j < size; ++j) {
                LogBizRefInfo bizRef = bizRefs.get(j);
                bizRef.getMetadataRef();
                bizRef.getMethodRefCollection();
            }
        }
    }
}

