/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ui.bizunitproxy;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bizunit.BizDataType;
import com.kingdee.bos.metadata.bizunit.BizFieldCollection;
import com.kingdee.bos.metadata.bizunit.BizFieldInfo;
import com.kingdee.bos.metadata.bizunit.BizFieldViewInfo;
import com.kingdee.bos.metadata.bizunit.BizGroupFieldInfo;
import com.kingdee.bos.metadata.bizunit.BizUnitInfo;
import com.kingdee.bos.metadata.bizunit.DataSourceType;
import com.kingdee.bos.metadata.bizunit.HorizontalAlignmentType;
import com.kingdee.bos.metadata.bizunit.ObjectStateType;
import com.kingdee.bos.metadata.bizunit.ViewType;
import com.kingdee.bos.metadata.bizunit.proxy.ConvertUtils;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.ui.AbstractUIObjectInfo;
import com.kingdee.bos.metadata.ui.ComponentCollection;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.DataObjectInfo;
import com.kingdee.bos.metadata.ui.PropertyBindingCollection;
import com.kingdee.bos.metadata.ui.PropertyBindingInfo;
import com.kingdee.bos.metadata.ui.PropertyCollection;
import com.kingdee.bos.metadata.ui.PropertyInfo;
import com.kingdee.bos.metadata.ui.StatusCollection;
import com.kingdee.bos.metadata.ui.StatusInfo;
import com.kingdee.bos.metadata.ui.StatusItemCollection;
import com.kingdee.bos.metadata.ui.StatusItemInfo;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.metadata.util.ContextManager;
import com.kingdee.bos.metadata.webui.WebUIObjectInfo;
import com.kingdee.bos.ui.bizunitproxy.UIProxyHelper;
import com.kingdee.bos.ui.dtp.ControlConstant;
import com.kingdee.bos.ui.dtp.kdtable.CellInfo;
import com.kingdee.bos.ui.dtp.kdtable.ColumnInfo;
import com.kingdee.bos.ui.dtp.kdtable.HeaderInfo;
import com.kingdee.bos.ui.dtp.kdtable.KDTableDesignerHelper;
import com.kingdee.bos.ui.dtp.kdtable.TableInfo;
import com.kingdee.bos.ui.dtp.model.layout.LabelContainerLayout;
import com.kingdee.bos.ui.dtp.model.layout.LayoutConverter;
import com.kingdee.bos.ui.dtp.model.layout.SameGridLayout;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public class EditUIProxyHelper {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.ui.bizunitproxy.EditUIProxyHelper");
    private static final String ROOT_PANEL = "root_panel";
    private UIProxyHelper uiProxyHelper;
    private Hashtable controlMap = new Hashtable();
    private static double MaxFloat = 3.4028234663852886E38;
    private static double MinFloat = -3.4028234663852886E38;

    EditUIProxyHelper(UIProxyHelper uiProxyHelper) {
        this.initControlMap();
        this.uiProxyHelper = uiProxyHelper;
    }

    public void createEditUI(UIObjectInfo model, BizUnitInfo bizUnit, String dataObjName) {
        if (model == null || bizUnit == null) {
            return;
        }
        BizFieldCollection fields = bizUnit.getFields();
        if (fields == null || fields.size() == 0) {
            return;
        }
        ComponentCollection collection = model.getComponents();
        if (collection == null || collection.size() == 0) {
            return;
        }
        ComponentInfo container = collection.get(0);
        Vector<BizFieldInfo> newBizFields = new Vector<BizFieldInfo>();
        Vector<BizFieldInfo> newGroupBizFields = new Vector<BizFieldInfo>();
        int n = fields.size();
        for (int i = 0; i < n; ++i) {
            BizFieldInfo bizField = fields.get(i);
            if (!ObjectStateType.NEW.equals((Object)bizField.getObjectState())) continue;
            if (bizField instanceof BizGroupFieldInfo) {
                newGroupBizFields.add(bizField);
                continue;
            }
            newBizFields.add(bizField);
        }
        BizFieldInfo[] tempFields = new BizFieldInfo[newBizFields.size()];
        System.arraycopy(newBizFields.toArray(), 0, tempFields, 0, newBizFields.size());
        this.createHearderControls(bizUnit, container, tempFields, dataObjName);
        BizGroupFieldInfo[] tempGroupFields = new BizGroupFieldInfo[newGroupBizFields.size()];
        System.arraycopy(newGroupBizFields.toArray(), 0, tempFields, 0, newGroupBizFields.size());
        this.createDetailsControl(bizUnit, model, tempGroupFields, dataObjName);
    }

    public void updateEditUI(UIObjectInfo model, BizUnitInfo bizUnit, String dataObjName) {
        BizFieldInfo[] tempFields;
        if (model == null || bizUnit == null) {
            return;
        }
        BizFieldCollection fields = bizUnit.getFields();
        if (fields == null || fields.size() == 0) {
            return;
        }
        Vector<BizFieldInfo> newBizFields = new Vector<BizFieldInfo>();
        Vector<BizFieldInfo> updBizFields = new Vector<BizFieldInfo>();
        Vector<BizFieldInfo> delBizFields = new Vector<BizFieldInfo>();
        Vector<BizFieldInfo> groupBizFields = new Vector<BizFieldInfo>();
        int n = fields.size();
        for (int i = 0; i < n; ++i) {
            BizFieldInfo bizField = fields.get(i);
            if (bizField instanceof BizGroupFieldInfo) {
                groupBizFields.add(bizField);
                continue;
            }
            if ((ObjectStateType.NEW.equals((Object)bizField.getObjectState()) || ObjectStateType.NEWCONTROL.equals((Object)bizField.getObjectState())) && (bizField.getEffectUI() & 2) != 0) {
                newBizFields.add(bizField);
                continue;
            }
            if (ObjectStateType.CHANGED.equals((Object)bizField.getObjectState())) {
                updBizFields.add(bizField);
                continue;
            }
            if (!ObjectStateType.DELETING.equals((Object)bizField.getObjectState()) && !ObjectStateType.DELETEDCONTROL.equals((Object)bizField.getObjectState()) || (bizField.getEffectUI() & 2) == 0) continue;
            delBizFields.add(bizField);
        }
        if (newBizFields.size() == 0 && updBizFields.size() == 0 && delBizFields.size() == 0 && groupBizFields.size() == 0) {
            return;
        }
        ComponentCollection collection = model.getComponents();
        if (collection == null || collection.size() == 0) {
            return;
        }
        ComponentInfo container = collection.get(0);
        int size = delBizFields.size();
        if (size > 0) {
            tempFields = new BizFieldInfo[size];
            System.arraycopy(delBizFields.toArray(), 0, tempFields, 0, size);
            this.deleteHeaderControl(model, tempFields);
        }
        if ((size = updBizFields.size()) > 0) {
            tempFields = new BizFieldInfo[updBizFields.size()];
            System.arraycopy(updBizFields.toArray(), 0, tempFields, 0, updBizFields.size());
            this.updateHeaderControls(bizUnit, container, tempFields, dataObjName);
        }
        if ((size = newBizFields.size()) > 0) {
            tempFields = new BizFieldInfo[newBizFields.size()];
            System.arraycopy(newBizFields.toArray(), 0, tempFields, 0, newBizFields.size());
            this.createHearderControls(bizUnit, container, tempFields, dataObjName);
        }
        if ((size = groupBizFields.size()) > 0) {
            BizGroupFieldInfo[] tempGroupFields = new BizGroupFieldInfo[groupBizFields.size()];
            System.arraycopy(groupBizFields.toArray(), 0, tempGroupFields, 0, groupBizFields.size());
            this.updateDetailsControl(bizUnit, model, tempGroupFields, dataObjName);
        }
    }

    private void addDelBizFields(Vector delBizFields, BizGroupFieldInfo groupField) {
        delBizFields.add(groupField.getControlName());
        BizFieldCollection fields = groupField.getFields();
        int n = fields.size();
        for (int i = 0; i < n; ++i) {
            if (!(fields.get(i) instanceof BizGroupFieldInfo)) continue;
            this.addDelBizFields(delBizFields, (BizGroupFieldInfo)fields.get(i));
        }
    }

    private void updateDetailsControl(BizUnitInfo bizUnit, UIObjectInfo model, BizGroupFieldInfo[] groupFields, String dataObjName) {
        int i;
        EntityObjectInfo entity = bizUnit.getEntity();
        if (entity == null) {
            return;
        }
        Vector<BizGroupFieldInfo> newBizFields = new Vector<BizGroupFieldInfo>();
        Vector<BizGroupFieldInfo> updBizFields = new Vector<BizGroupFieldInfo>();
        Vector delBizFields = new Vector();
        for (BizGroupFieldInfo bizField : groupFields) {
            if (bizField == null) continue;
            if ((ObjectStateType.NEW.equals((Object)bizField.getObjectState()) || ObjectStateType.NEWCONTROL.equals((Object)bizField.getObjectState())) && (bizField.getEffectUI() & 2) != 0) {
                newBizFields.add(bizField);
                continue;
            }
            if ((ObjectStateType.DELETING.equals((Object)bizField.getObjectState()) || ObjectStateType.DELETEDCONTROL.equals((Object)bizField.getObjectState())) && (bizField.getEffectUI() & 2) != 0) {
                this.addDelBizFields(delBizFields, bizField);
                continue;
            }
            updBizFields.add(bizField);
        }
        ComponentInfo mainPanel = model.getComponents().get(0);
        if (delBizFields.size() > 0) {
            this.deleteControl(model, mainPanel, new HashSet(delBizFields), false);
        }
        int j = newBizFields.size();
        for (i = 0; i < j; ++i) {
            BizFieldViewInfo viewInfo;
            BizGroupFieldInfo groupBizField = (BizGroupFieldInfo)newBizFields.get(i);
            com.kingdee.bos.metadata.entity.PropertyInfo prop = entity.getPropertyByName(groupBizField.getPropertyName());
            if (prop == null || (viewInfo = groupBizField.getFieldView()) == null) continue;
            ComponentInfo container = this.uiProxyHelper.findParentControl(mainPanel, groupBizField);
            if (container == null) {
                container = mainPanel;
            }
            this.createKDTableForEntity(model, container, groupBizField, dataObjName, prop.getName());
        }
        j = updBizFields.size();
        for (i = 0; i < j; ++i) {
            UIObjectInfo realModel = model;
            BizGroupFieldInfo groupBizField = (BizGroupFieldInfo)updBizFields.get(i);
            com.kingdee.bos.metadata.entity.PropertyInfo prop = entity.getPropertyByName(groupBizField.getPropertyName());
            if (prop == null) continue;
            Object[] tempFields = groupBizField.getFields().toArray();
            BizFieldInfo[] tempBizFields = new BizFieldInfo[tempFields.length];
            System.arraycopy(tempFields, 0, tempBizFields, 0, tempFields.length);
            BizFieldViewInfo viewInfo = groupBizField.getFieldView();
            if (viewInfo == null) continue;
            ComponentInfo container = null;
            ComponentInfo table = UIProxyHelper.findControlByName(mainPanel, groupBizField.getControlName());
            container = table != null && table.getParent() != null ? table.getParent() : mainPanel;
            if (table == null || !"com.kingdee.bos.ctrl.kdf.table.KDTable".equals(table.getClassType())) {
                logger.error((Object)("Cann't find the KDTable named " + groupBizField.getOldValue("controlName")));
                continue;
            }
            this.updateKDTableForEntity(realModel, container, table, groupBizField, dataObjName, prop.getName());
        }
    }

    private void updateKDTableForEntity(UIObjectInfo model, ComponentInfo parent, ComponentInfo kdTable, BizGroupFieldInfo groupField, String dataObjName, String linkPropName) {
        PropertyBindingInfo propertyBindingInfo;
        ComponentInfo container = parent;
        ComponentInfo mainPanel = model.getComponents().get(0);
        container = kdTable.getParent() != null && kdTable.getParent().equals(container) ? parent : (kdTable.getParent() != null ? kdTable.getParent() : mainPanel);
        if (container == null || groupField == null || kdTable == null) {
            return;
        }
        EntityObjectInfo entity = groupField.getEntityObject();
        if (entity == null) {
            return;
        }
        PropertyInfo property = kdTable.getProperties().get("formatXml");
        if (property == null) {
            this.createKDTableForEntity(model, container, groupField, dataObjName, linkPropName);
            return;
        }
        this.setControlTabIndex(kdTable, groupField.getFieldView());
        ComponentCollection collection = container.getComponents();
        if (collection == null || collection.size() == 0) {
            return;
        }
        TableInfo tableInfo = KDTableDesignerHelper.getTableInfoFrom(property.getValue());
        BizFieldCollection fields = groupField.getFields();
        if (fields == null || fields.size() == 0) {
            return;
        }
        Vector<BizFieldInfo> newBizFields = new Vector<BizFieldInfo>();
        Vector<BizFieldInfo> delBizFields = new Vector<BizFieldInfo>();
        Vector<BizFieldInfo> updBizFields = new Vector<BizFieldInfo>();
        Vector delGroupFields = new Vector();
        int n = fields.size();
        for (int i = 0; i < n; ++i) {
            BizFieldInfo bizField = fields.get(i);
            if (!bizField.isGenControl()) continue;
            if ((ObjectStateType.NEW.equals((Object)bizField.getObjectState()) || ObjectStateType.NEWCONTROL.equals((Object)bizField.getObjectState())) && (bizField.getEffectUI() & 2) != 0) {
                if (bizField instanceof BizGroupFieldInfo) {
                    this.createKDTableForEntity(model, container, (BizGroupFieldInfo)bizField, dataObjName, linkPropName + "." + bizField.getPropertyName());
                    continue;
                }
                newBizFields.add(bizField);
                continue;
            }
            if ((ObjectStateType.DELETING.equals((Object)bizField.getObjectState()) || ObjectStateType.DELETEDCONTROL.equals((Object)bizField.getObjectState())) && (bizField.getEffectUI() & 2) != 0) {
                if (bizField instanceof BizGroupFieldInfo) {
                    this.addDelBizFields(delGroupFields, (BizGroupFieldInfo)bizField);
                    continue;
                }
                delBizFields.add(bizField);
                continue;
            }
            if (ObjectStateType.CHANGED.equals((Object)bizField.getObjectState())) {
                if (bizField instanceof BizGroupFieldInfo) {
                    this.updateKDTableForEntity(model, container, UIProxyHelper.findControlByName(mainPanel, bizField.getControlName()), (BizGroupFieldInfo)bizField, dataObjName, linkPropName + "." + bizField.getPropertyName());
                    continue;
                }
                updBizFields.add(bizField);
                continue;
            }
            if (!ObjectStateType.UNCHANGE.equals((Object)bizField.getObjectState()) || !(bizField instanceof BizGroupFieldInfo)) continue;
            this.updateKDTableForEntity(model, container, UIProxyHelper.findControlByName(mainPanel, bizField.getControlName()), (BizGroupFieldInfo)bizField, dataObjName, linkPropName + "." + bizField.getPropertyName());
        }
        if (delGroupFields.size() > 0) {
            this.deleteControl(model, mainPanel, new HashSet(delGroupFields), false);
        }
        BizFieldInfo[] tempFields = new BizFieldInfo[delBizFields.size()];
        System.arraycopy(delBizFields.toArray(), 0, tempFields, 0, delBizFields.size());
        this.uiProxyHelper.delKDTableColumn(model, kdTable, tableInfo, tempFields, true);
        tempFields = new BizFieldInfo[updBizFields.size()];
        System.arraycopy(updBizFields.toArray(), 0, tempFields, 0, updBizFields.size());
        this.updKDTableColumn(entity, kdTable, tableInfo, tempFields, dataObjName, linkPropName);
        tempFields = new BizFieldInfo[newBizFields.size()];
        System.arraycopy(newBizFields.toArray(), 0, tempFields, 0, newBizFields.size());
        this.addKDTableColumn(entity, kdTable, tableInfo, tempFields, dataObjName, linkPropName);
        if (delBizFields.size() + updBizFields.size() + newBizFields.size() > 0) {
            property.setValue(KDTableDesignerHelper.getXmlFrom(tableInfo));
            property.setOverride(true);
        }
        if ((propertyBindingInfo = kdTable.getPropertyBindings().get("userObject")) == null) {
            propertyBindingInfo = new PropertyBindingInfo();
            propertyBindingInfo.setPropertyName("userObject");
            propertyBindingInfo.setPropertyType(Object.class.getName());
            propertyBindingInfo.setAccessType(2);
            propertyBindingInfo.setAutoMode(false);
            propertyBindingInfo.setBindingObject(dataObjName);
            propertyBindingInfo.setBingdingField(groupField.getPropertyName());
            propertyBindingInfo.setFieldType(groupField.getEntityObject().getBusinessImplName() + "Collection");
            propertyBindingInfo.setOverride(true);
            kdTable.getPropertyBindings().add(propertyBindingInfo);
        }
        this.uiProxyHelper.updateComponentRules(model, kdTable, groupField);
    }

    private void resetColumnIndex(TableInfo tableInfo, BizFieldCollection bizFields) {
        int i;
        if (tableInfo.getHeaderCount() < 1) {
            return;
        }
        HeaderInfo headerInfo = (HeaderInfo)tableInfo.getHeaders().get(0);
        List columns = tableInfo.getColumns();
        ArrayList cells = headerInfo.getCells();
        if (columns.size() > cells.size()) {
            return;
        }
        Hashtable<String, Integer> listItemNames = new Hashtable<String, Integer>();
        int n = bizFields.size();
        for (int i2 = 0; i2 < n; ++i2) {
            BizFieldInfo field = bizFields.get(i2);
            String listItemName = field.getControlName();
            if (StringUtils.isEmpty((String)listItemName)) continue;
            listItemNames.put(listItemName, new Integer(field.getFieldView().getTabIndex()));
        }
        int[] listIndexs = new int[columns.size()];
        int n2 = columns.size();
        for (i = 0; i < n2; ++i) {
            ColumnInfo column = (ColumnInfo)columns.get(i);
            String columnName = column.getName();
            listIndexs[i] = listItemNames.containsKey(columnName) ? (Integer)listItemNames.get(columnName) : 0;
        }
        n2 = listIndexs.length;
        for (i = 0; i < n2; ++i) {
            for (int j = i + 1; j < n2; ++j) {
                if (listIndexs[j] >= listIndexs[i]) continue;
                int index = listIndexs[j];
                listIndexs[j] = listIndexs[i];
                listIndexs[i] = index;
                String temp = ((ColumnInfo)columns.get(j)).getName();
                ((ColumnInfo)columns.get(j)).setName(((ColumnInfo)columns.get(i)).getName());
                ((ColumnInfo)columns.get(i)).setName(temp);
                temp = ((ColumnInfo)columns.get(j)).getFormatString();
                ((ColumnInfo)columns.get(j)).setFormatString(((ColumnInfo)columns.get(i)).getFormatString());
                ((ColumnInfo)columns.get(i)).setFormatString(temp);
                temp = ((CellInfo)cells.get(j)).getName();
                ((CellInfo)cells.get(j)).setName(((CellInfo)cells.get(i)).getName());
                ((CellInfo)cells.get(i)).setName(temp);
                boolean hide = ((ColumnInfo)columns.get(j)).isHide();
                ((ColumnInfo)columns.get(j)).setHide(((ColumnInfo)columns.get(i)).isHide());
                ((ColumnInfo)columns.get(i)).setHide(hide);
                boolean isLock = ((ColumnInfo)columns.get(j)).isLock();
                ((ColumnInfo)columns.get(j)).setLock(((ColumnInfo)columns.get(i)).isLock());
                ((ColumnInfo)columns.get(i)).setLock(isLock);
                int width = ((ColumnInfo)columns.get(j)).getWidth();
                ((ColumnInfo)columns.get(j)).setWidth(((ColumnInfo)columns.get(i)).getWidth());
                ((ColumnInfo)columns.get(i)).setWidth(width);
                boolean isRequired = ((ColumnInfo)columns.get(j)).isRequired();
                ((ColumnInfo)columns.get(j)).setRequired(((ColumnInfo)columns.get(i)).isRequired());
                ((ColumnInfo)columns.get(i)).setRequired(isRequired);
                String align = ((ColumnInfo)columns.get(j)).getHorizonAlign();
                ((ColumnInfo)columns.get(j)).setHorizonAlign(((ColumnInfo)columns.get(i)).getHorizonAlign());
                ((ColumnInfo)columns.get(i)).setHorizonAlign(align);
            }
        }
    }

    private void updKDTableColumn(EntityObjectInfo entity, ComponentInfo kdTable, TableInfo tableInfo, BizFieldInfo[] updBizFields, String dataObjName, String linkPropName) {
        if (kdTable == null || tableInfo == null || updBizFields == null || StringUtils.isEmpty((String)dataObjName)) {
            return;
        }
        List columns = tableInfo.getColumns();
        for (int i = 0; i < updBizFields.length; ++i) {
            com.kingdee.bos.metadata.entity.PropertyInfo prop;
            int[] indexs;
            BizFieldInfo field = updBizFields[i];
            BizFieldViewInfo fieldView = field.getFieldView();
            String name = field.getControlName();
            String oldColName = name;
            ColumnInfo column = UIProxyHelper.findColumn(columns, oldColName, indexs = new int[]{-1});
            if (column != null && fieldView != null && tableInfo.getHeaderCount() > 0) {
                String text = field.getEditLabelText();
                if (StringUtils.isEmpty((String)text)) {
                    text = field.getAlias();
                }
                HeaderInfo headerInfo = (HeaderInfo)tableInfo.getHeaders().get(0);
                int columnIndex = columns.indexOf(column);
                if (headerInfo.getCells().size() > columnIndex) {
                    ((CellInfo)headerInfo.getCells().get(columnIndex)).setName(text);
                }
            }
            if ((prop = entity.getPropertyByName(name)) == null || !(prop instanceof OwnPropertyInfo)) continue;
            PropertyBindingInfo propertyBindingInfo = kdTable.getPropertyBindings().get(oldColName + ".text");
            if (propertyBindingInfo != null) {
                propertyBindingInfo.setBindingObject(dataObjName);
                propertyBindingInfo.setBingdingField(linkPropName + "." + prop.getName());
                propertyBindingInfo.setFieldType(((OwnPropertyInfo)prop).getJavaType());
                propertyBindingInfo.setOverride(true);
                continue;
            }
            propertyBindingInfo = new PropertyBindingInfo();
            propertyBindingInfo.setPropertyName(oldColName + ".text");
            propertyBindingInfo.setPropertyType(Object.class.getName());
            propertyBindingInfo.setAccessType(2);
            propertyBindingInfo.setAutoMode(false);
            propertyBindingInfo.setBindingObject(dataObjName);
            propertyBindingInfo.setBingdingField(linkPropName + "." + prop.getName());
            propertyBindingInfo.setFieldType(((OwnPropertyInfo)prop).getJavaType());
            propertyBindingInfo.setOverride(true);
            kdTable.getPropertyBindings().add(propertyBindingInfo);
        }
    }

    private void updateHeaderControls(BizUnitInfo bizUnit, ComponentInfo container, BizFieldInfo[] bizFields, String dataObjName) {
        if (container == null || bizFields == null || bizFields.length == 0) {
            return;
        }
        for (int i = 0; i < bizFields.length; ++i) {
            BizFieldInfo bizFieldInfo = bizFields[i];
            String controlName = bizFieldInfo.getControlName();
            ComponentInfo control = UIProxyHelper.findControlByName(container, controlName);
            if (control == null) continue;
            this.updateControl(bizUnit, control, bizFieldInfo, dataObjName);
        }
    }

    private void updateControl(BizUnitInfo bizUnit, ComponentInfo control, BizFieldInfo bizFieldInfo, String dataObjName) {
        assert (control != null && bizFieldInfo != null);
        this.updateCommonControl(bizUnit, control, bizFieldInfo);
    }

    private void updateCommonControl(BizUnitInfo bizUnit, ComponentInfo control, BizFieldInfo bizField) {
        BizFieldViewInfo viewInfo = bizField.getFieldView();
        this.setControlTabIndex(control, viewInfo);
        control.setAlias(bizField.getAlias());
        this.uiProxyHelper.updateComponentRules(bizUnit.getEditUI(), control, bizField);
    }

    private void deleteHeaderControl(UIObjectInfo model, BizFieldInfo[] bizFields) {
        if (model == null || bizFields == null || bizFields.length == 0) {
            return;
        }
        HashSet<String> controlName = new HashSet<String>();
        for (int i = 0; i < bizFields.length; ++i) {
            controlName.add(bizFields[i].getControlName());
        }
        ComponentInfo container = model.getComponents().get(0);
        this.deleteControl(model, container, controlName, true);
    }

    private void deleteControl(UIObjectInfo model, ComponentInfo container, Set needDelCtrlName, boolean delLabContainer) {
        if (container == null || needDelCtrlName.isEmpty()) {
            return;
        }
        Iterator iter = needDelCtrlName.iterator();
        while (iter.hasNext()) {
            String controlName;
            ComponentInfo control = UIProxyHelper.findControlByName(container, (String)iter.next());
            if (control == null) continue;
            ComponentInfo regionControl = control;
            ComponentInfo parent = control.getParent();
            if (parent == null) continue;
            if (delLabContainer) {
                if ("com.kingdee.bos.ctrl.swing.KDTextArea".equals(control.getClassType()) && "com.kingdee.bos.ctrl.swing.KDScrollPane".equals(control.getParent().getClassType())) {
                    control = control.getParent();
                    parent = control.getParent();
                }
                if ("com.kingdee.bos.ctrl.swing.KDLabelContainer".equals(parent.getClassType())) {
                    control = control.getParent();
                    parent = control.getParent();
                }
            } else if ("com.kingdee.bos.ctrl.swing.KDTextArea".equals(control.getClassType()) && "com.kingdee.bos.ctrl.swing.KDScrollPane".equals(control.getParent().getClassType())) {
                control = control.getParent();
                parent = control.getParent();
            }
            if (parent != null && control != null) {
                parent.removeChild(model, control);
                control.setParent(null);
            }
            if (StringUtils.isEmpty((String)(controlName = regionControl.getName()))) continue;
            StatusCollection statuses = model.getStatuses();
            int n = statuses.size();
            for (int i = 0; i < n; ++i) {
                StatusInfo status = statuses.get(i);
                StatusItemCollection items = status.getStatusItems();
                for (int j = items.size() - 1; j >= 0; --j) {
                    StatusItemInfo statusItem = items.get(j);
                    if (!controlName.equals(statusItem.getName())) continue;
                    items.removeObject(j);
                }
            }
        }
    }

    private void createHearderControls(BizUnitInfo bizUnit, ComponentInfo container, BizFieldInfo[] bizFields, String dataObjName) {
        if (container == null || bizFields == null || bizFields.length == 0) {
            return;
        }
        for (int i = 0; i < bizFields.length; ++i) {
            BizFieldInfo bizFieldInfo = bizFields[i];
            if (!bizFieldInfo.isGenControl()) continue;
            BizFieldViewInfo viewInfo = bizFieldInfo.getFieldView();
            ViewType viewType = viewInfo.getViewType();
            ComponentInfo parent = this.uiProxyHelper.findParentControl(container, bizFieldInfo);
            if (parent != null) {
                container = parent;
            }
            if (ViewType.CHECKBOX.equals((Object)viewType)) {
                this.createCheckBox(bizUnit, container, bizFieldInfo, dataObjName);
                continue;
            }
            if (ViewType.DATEPICKER.equals((Object)viewType)) {
                this.createDatePicker(bizUnit, container, bizFieldInfo, dataObjName);
                continue;
            }
            if (ViewType.TIMEPICKER.equals((Object)viewType)) {
                this.createTimePicker(bizUnit, container, bizFieldInfo, dataObjName);
                continue;
            }
            if (ViewType.F7SELECTOR.equals((Object)viewType)) {
                this.createBizPromptBox(bizUnit, container, bizFieldInfo, dataObjName);
                continue;
            }
            if (ViewType.RADIOBUTTON.equals((Object)viewType)) {
                this.createRadioButton(bizUnit, container, bizFieldInfo, dataObjName);
                continue;
            }
            if (ViewType.TEXTAREA.equals((Object)viewType)) {
                this.createTextArea(bizUnit, container, bizFieldInfo, dataObjName);
                continue;
            }
            if (ViewType.TEXTFIELD.equals((Object)viewType)) {
                this.createTextField(bizUnit, container, bizFieldInfo, dataObjName);
                continue;
            }
            if (ViewType.FORMATTEXTFIELD.equals((Object)viewType)) {
                this.createFormattedTextField(bizUnit, container, bizFieldInfo, dataObjName);
                continue;
            }
            if (!ViewType.COMBOBOX.equals((Object)viewType)) continue;
            this.createComboBox(bizUnit, container, bizFieldInfo, dataObjName);
        }
    }

    private void createDetailsControl(BizUnitInfo bizUnit, UIObjectInfo model, BizGroupFieldInfo[] bizFields, String dataObjName) {
        if (bizUnit == null || model == null || bizFields == null || bizFields.length == 0) {
            return;
        }
        ComponentInfo container = model.getComponents().get(0);
        EntityObjectInfo entity = bizUnit.getEntity();
        if (entity == null) {
            return;
        }
        for (int i = 0; i < bizFields.length; ++i) {
            com.kingdee.bos.metadata.entity.PropertyInfo prop = entity.getPropertyByName(bizFields[i].getPropertyName());
            if (prop == null) continue;
            this.createKDTableForEntity(model, container, bizFields[i], dataObjName, prop.getName());
        }
    }

    private void createKDTableForEntity(UIObjectInfo model, ComponentInfo container, BizGroupFieldInfo groupField, String dataObjName, String linkPropName) {
        if (container == null || groupField == null) {
            return;
        }
        String fieldName = groupField.getName();
        String baseName = fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
        String tabName = "kdt" + baseName;
        ComponentInfo kdtControl = new ComponentInfo("com.kingdee.bos.ctrl.kdf.table.KDTable");
        kdtControl.setName(tabName);
        kdtControl.setConstraint(this.createContraint(container, new Rectangle(0, 0, 600, 170)));
        container.addChild(model, kdtControl);
        kdtControl.setExtendedProperty("buildDetail", "true");
        groupField.setControlName(kdtControl.getName());
        BizFieldCollection fields = groupField.getFields();
        if (fields == null || fields.size() == 0) {
            return;
        }
        Vector<BizFieldInfo> newBizFields = new Vector<BizFieldInfo>();
        int n = fields.size();
        for (int i = 0; i < n; ++i) {
            BizFieldInfo bizField = fields.get(i);
            if (!ObjectStateType.NEW.equals((Object)bizField.getObjectState()) && !ObjectStateType.NEWCONTROL.equals((Object)bizField.getObjectState()) || (bizField.getEffectUI() & 2) == 0 || bizField instanceof BizGroupFieldInfo) continue;
            newBizFields.add(bizField);
        }
        BizFieldInfo[] tempFields = new BizFieldInfo[newBizFields.size()];
        System.arraycopy(newBizFields.toArray(), 0, tempFields, 0, newBizFields.size());
        this.createKDTableProperty(groupField, tempFields, dataObjName, kdtControl, linkPropName);
        PropertyBindingInfo propertyBindingInfo = new PropertyBindingInfo();
        propertyBindingInfo.setPropertyName("userObject");
        propertyBindingInfo.setPropertyType(Object.class.getName());
        propertyBindingInfo.setAccessType(2);
        propertyBindingInfo.setAutoMode(false);
        propertyBindingInfo.setBindingObject(dataObjName);
        propertyBindingInfo.setBingdingField(linkPropName);
        propertyBindingInfo.setFieldType(groupField.getEntityObject().getBusinessImplName() + "Collection");
        propertyBindingInfo.setOverride(true);
        kdtControl.getPropertyBindings().add(propertyBindingInfo);
        this.uiProxyHelper.updateComponentRules(model, kdtControl, groupField);
    }

    private void createKDTableProperty(BizGroupFieldInfo groupField, BizFieldInfo[] infos, String dataObjName, ComponentInfo kdtControl, String linkPropName) {
        EntityObjectInfo entity = groupField.getEntityObject();
        if (entity == null) {
            return;
        }
        TableInfo tableInfo = new TableInfo();
        HeaderInfo headerInfo = new HeaderInfo();
        headerInfo.setName("header");
        tableInfo.addHeader(headerInfo);
        this.addKDTableColumn(entity, kdtControl, tableInfo, infos, dataObjName, linkPropName);
        PropertyInfo propInfo = new PropertyInfo();
        propInfo.setName("formatXml");
        propInfo.setType(String.class.getName());
        propInfo.setMultiLanguage(true);
        propInfo.setValue(KDTableDesignerHelper.getXmlFrom(tableInfo));
        kdtControl.getProperties().add(propInfo);
    }

    public static String getNumberFormat(int precision) {
        String format = "0.";
        for (int i = 0; i < precision; ++i) {
            format = format + "0";
        }
        return format;
    }

    private void addKDTableColumn(EntityObjectInfo entity, ComponentInfo kdTable, TableInfo tableInfo, BizFieldInfo[] newBizFields, String dataObjName, String linkPropName) {
        HeaderInfo headerInfo;
        if (kdTable == null || tableInfo == null || newBizFields == null || StringUtils.isEmpty((String)dataObjName)) {
            return;
        }
        if (tableInfo.getHeaderCount() == 0) {
            headerInfo = new HeaderInfo();
            headerInfo.setName("header");
            tableInfo.addHeader(headerInfo);
        } else {
            headerInfo = (HeaderInfo)tableInfo.getHeaders().get(0);
        }
        for (int i = 0; i < newBizFields.length; ++i) {
            CardinalityType cardinal;
            BizFieldInfo field = newBizFields[i];
            String propName = field.getPropertyName();
            com.kingdee.bos.metadata.entity.PropertyInfo prop = null;
            if (StringUtils.isEmpty((String)propName)) {
                if (!DataSourceType.BASEDATAEXT.equals((Object)field.getDataSourceType()) || StringUtils.isEmpty((String)field.getDataField())) continue;
                propName = field.getDataField();
                prop = EditUIProxyHelper.getPropertyByName(entity, StringUtils.replace((String)field.getDataField(), (String)(linkPropName + "."), (String)""));
            } else {
                prop = EditUIProxyHelper.getPropertyByName(entity, propName);
                propName = linkPropName + "." + propName;
            }
            if (prop == null || (prop instanceof LinkPropertyInfo ? !CardinalityType.ONE.equals((Object)(cardinal = ((LinkPropertyInfo)prop).getRelationship().getSupplierCardinality())) && !CardinalityType.ZERO_TO_ONE.equals((Object)cardinal) : !(prop instanceof OwnPropertyInfo))) continue;
            String colName = field.getName();
            ColumnInfo column = new ColumnInfo();
            column.setName(colName);
            BizFieldViewInfo fieldView = field.getFieldView();
            if (fieldView != null) {
                column.setHide(!fieldView.isVisible());
                column.setWidth(-1);
                column.setLock(!fieldView.isEnable());
            }
            if (field.getBizDataType() == BizDataType.DECIMAL || field.getBizDataType() == BizDataType.AMOUNT || field.getBizDataType() == BizDataType.PRICE || field.getBizDataType() == BizDataType.QUANTITY) {
                column.setFormatString("&double");
            } else if (field.getBizDataType() == BizDataType.INTEGER) {
                column.setFormatString("&int");
            } else if (field.getBizDataType() == BizDataType.DATE) {
                column.setFormatString("&date");
            } else if (field.getBizDataType() == BizDataType.TIME) {
                column.setFormatString("&time");
            }
            field.setControlName(colName);
            tableInfo.addColumn(column);
            CellInfo cell = new CellInfo();
            String cellName = field.getAlias();
            if (StringUtils.isEmpty((String)cellName)) {
                cell.setName(field.getName());
            } else {
                cell.setName(cellName);
            }
            cell.setColSpan(0);
            cell.setRowSpan(0);
            headerInfo.addCell(cell);
            PropertyBindingInfo propertyBindingInfo = new PropertyBindingInfo();
            propertyBindingInfo.setPropertyName(colName + ".text");
            propertyBindingInfo.setPropertyType(Object.class.getName());
            propertyBindingInfo.setAccessType(2);
            propertyBindingInfo.setAutoMode(false);
            propertyBindingInfo.setBindingObject(dataObjName);
            propertyBindingInfo.setBingdingField(propName);
            propertyBindingInfo.setOverride(true);
            if (prop instanceof OwnPropertyInfo) {
                propertyBindingInfo.setFieldType(((OwnPropertyInfo)prop).getJavaType());
            } else if (prop instanceof LinkPropertyInfo) {
                propertyBindingInfo.setFieldType(Object.class.getName());
            }
            kdTable.getPropertyBindings().add(propertyBindingInfo);
        }
    }

    private void createCheckBox(BizUnitInfo bizUnit, ComponentInfo container, BizFieldInfo bizField, String dataObjName) {
        assert (container != null && bizField != null);
        BizFieldViewInfo viewInfo = bizField.getFieldView();
        if (viewInfo == null) {
            logger.warn((Object)("The BizFieldViewInfo of BizFieldInfo " + bizField.getName() + " is null!"));
            return;
        }
        ComponentInfo checkBox = new ComponentInfo("com.kingdee.bos.ctrl.swing.KDCheckBox");
        checkBox.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        checkBox.setName(this.getPrefix(viewInfo.getViewType()) + bizField.getName());
        checkBox.setConstraint(this.createContraint(container, null));
        this.setControlTabIndex(checkBox, viewInfo);
        container.addChild(bizUnit.getEditUI(), checkBox);
        PropertyCollection props = checkBox.getProperties();
        props.add(this.createLabelTextProperty(viewInfo));
        props.add(this.createVisibleProperty(viewInfo));
        props.add(this.createHorizonalAlignmentProperty(viewInfo));
        props.add(this.createForeColorProperty(viewInfo));
        props.add(this.createBGColorProperty(viewInfo));
        props.add(this.createFontProperty(viewInfo));
        PropertyBindingCollection pbs = checkBox.getPropertyBindings();
        pbs.add(this.createSelectedPropBinding(bizUnit.getEntity(), dataObjName, bizField));
        bizField.setControlName(checkBox.getName());
        this.uiProxyHelper.updateComponentRules(bizUnit.getEditUI(), checkBox, bizField);
    }

    private void createRadioButton(BizUnitInfo bizUnit, ComponentInfo container, BizFieldInfo bizField, String dataObjName) {
        assert (container != null && bizField != null);
        BizFieldViewInfo viewInfo = bizField.getFieldView();
        if (viewInfo == null) {
            logger.warn((Object)("The BizFieldViewInfo of BizFieldInfo " + bizField.getName() + " is null!"));
            return;
        }
        ComponentInfo radioBtn = new ComponentInfo("com.kingdee.bos.ctrl.swing.KDRadioButton");
        radioBtn.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        radioBtn.setName(this.getPrefix(viewInfo.getViewType()) + bizField.getName());
        radioBtn.setConstraint(this.createContraint(container, null));
        this.setControlTabIndex(radioBtn, viewInfo);
        container.addChild(bizUnit.getEditUI(), radioBtn);
        PropertyCollection props = radioBtn.getProperties();
        props.add(this.createLabelTextProperty(viewInfo));
        props.add(this.createVisibleProperty(viewInfo));
        props.add(this.createHorizonalAlignmentProperty(viewInfo));
        props.add(this.createForeColorProperty(viewInfo));
        props.add(this.createBGColorProperty(viewInfo));
        props.add(this.createFontProperty(viewInfo));
        bizField.setControlName(radioBtn.getName());
        this.uiProxyHelper.updateComponentRules(bizUnit.getEditUI(), radioBtn, bizField);
    }

    private void createTextField(BizUnitInfo bizUnit, ComponentInfo container, BizFieldInfo bizField, String dataObjName) {
        assert (container != null && bizField != null);
        BizFieldViewInfo viewInfo = bizField.getFieldView();
        if (viewInfo == null) {
            logger.warn((Object)("The BizFieldViewInfo of BizFieldInfo " + bizField.getName() + " is null!"));
            return;
        }
        ComponentInfo labelContainer = this.createLabelContainer(bizUnit, container, bizField);
        if (labelContainer == null) {
            return;
        }
        this.createTextFieldForLabelContainer(bizUnit, labelContainer, bizField, dataObjName);
    }

    private void createTextArea(BizUnitInfo bizUnit, ComponentInfo container, BizFieldInfo bizField, String dataObjName) {
        assert (container != null && bizField != null);
        BizFieldViewInfo viewInfo = bizField.getFieldView();
        if (viewInfo == null) {
            logger.warn((Object)("The BizFieldViewInfo of BizFieldInfo " + bizField.getName() + " is null!"));
            return;
        }
        ComponentInfo labelContainer = this.createLabelContainer(bizUnit, container, bizField);
        if (labelContainer == null) {
            return;
        }
        ComponentInfo scrollPane = new ComponentInfo("com.kingdee.bos.ctrl.swing.KDScrollPane");
        scrollPane.setName("scrollPane" + bizField.getName());
        scrollPane.setConstraint(String.valueOf(7));
        scrollPane.setContainer(true);
        scrollPane.setLayoutInfo(LayoutConverter.convertToInfo(new SameGridLayout(1, 1)));
        labelContainer.addChild(bizUnit.getEditUI(), scrollPane);
        this.createTextAreaForLabelContainer(bizUnit, scrollPane, bizField, dataObjName);
    }

    private void createFormattedTextField(BizUnitInfo bizUnit, ComponentInfo container, BizFieldInfo bizField, String dataObjName) {
        assert (container != null && bizField != null);
        BizFieldViewInfo viewInfo = bizField.getFieldView();
        if (viewInfo == null) {
            logger.warn((Object)("The BizFieldViewInfo of BizFieldInfo " + bizField.getName() + " is null!"));
            return;
        }
        ComponentInfo labelContainer = this.createLabelContainer(bizUnit, container, bizField);
        if (labelContainer == null) {
            return;
        }
        this.createFormattedTextFieldForLabelContainer(bizUnit, labelContainer, bizField, dataObjName);
    }

    private void createDatePicker(BizUnitInfo bizUnit, ComponentInfo container, BizFieldInfo bizField, String dataObjName) {
        assert (container != null && bizField != null);
        BizFieldViewInfo viewInfo = bizField.getFieldView();
        if (viewInfo == null) {
            logger.warn((Object)("The BizFieldViewInfo of BizFieldInfo " + bizField.getName() + " is null!"));
            return;
        }
        ComponentInfo labelContainer = this.createLabelContainer(bizUnit, container, bizField);
        if (labelContainer == null) {
            return;
        }
        this.createDatePickerForLabelContainer(bizUnit, labelContainer, bizField, dataObjName);
    }

    private void createTimePicker(BizUnitInfo bizUnit, ComponentInfo container, BizFieldInfo bizField, String dataObjName) {
        assert (container != null && bizField != null);
        BizFieldViewInfo viewInfo = bizField.getFieldView();
        if (viewInfo == null) {
            logger.warn((Object)("The BizFieldViewInfo of BizFieldInfo " + bizField.getName() + " is null!"));
            return;
        }
        ComponentInfo labelContainer = this.createLabelContainer(bizUnit, container, bizField);
        if (labelContainer == null) {
            return;
        }
        this.createTimePickerForLabelContainer(bizUnit, labelContainer, bizField, dataObjName);
    }

    private void createComboBox(BizUnitInfo bizUnit, ComponentInfo container, BizFieldInfo bizField, String dataObjName) {
        assert (container != null && bizField != null);
        BizFieldViewInfo viewInfo = bizField.getFieldView();
        if (viewInfo == null) {
            logger.warn((Object)("The BizFieldViewInfo of BizFieldInfo " + bizField.getName() + " is null!"));
            return;
        }
        ComponentInfo labelContainer = this.createLabelContainer(bizUnit, container, bizField);
        if (labelContainer == null) {
            return;
        }
        this.createComboBoxForLabelContainer(bizUnit, labelContainer, bizField, dataObjName);
    }

    private void createBizPromptBox(BizUnitInfo bizUnit, ComponentInfo container, BizFieldInfo bizField, String dataObjName) {
        assert (container != null && bizField != null);
        BizFieldViewInfo viewInfo = bizField.getFieldView();
        if (viewInfo == null) {
            logger.warn((Object)("The BizFieldViewInfo of BizFieldInfo " + bizField.getName() + " is null!"));
            return;
        }
        ComponentInfo labelContainer = this.createLabelContainer(bizUnit, container, bizField);
        if (labelContainer == null) {
            return;
        }
        this.createBizPromptBoxForLabelContainer(bizUnit, labelContainer, bizField, dataObjName);
    }

    private ComponentInfo createLabelContainer(BizUnitInfo bizUnit, ComponentInfo container, BizFieldInfo bizField) {
        assert (container != null && bizField != null);
        BizFieldViewInfo viewInfo = bizField.getFieldView();
        if (viewInfo == null) {
            logger.warn((Object)("The BizFieldViewInfo of BizFieldInfo " + bizField.getName() + " is null!"));
            return null;
        }
        ComponentInfo labelContainer = new ComponentInfo("com.kingdee.bos.ctrl.swing.KDLabelContainer");
        labelContainer.setName("cont" + bizField.getName());
        labelContainer.setConstraint(this.createContraint(container, null));
        labelContainer.setContainer(true);
        labelContainer.setLayoutInfo(LayoutConverter.convertToInfo(new LabelContainerLayout()));
        container.addChild(bizUnit.getEditUI(), labelContainer);
        PropertyCollection props = labelContainer.getProperties();
        props.add(this.createBoundLabelTextProperty(bizField));
        props.add(this.createBoundLabelLengthProperty());
        props.add(this.createBoundLabelUnderlineProperty());
        props.add(this.createVisibleProperty(viewInfo));
        props.add(this.createForeColorProperty(viewInfo));
        props.add(this.createBGColorProperty(viewInfo));
        props.add(this.createFontProperty(viewInfo));
        labelContainer.setParent(container);
        return labelContainer;
    }

    private void createTextFieldForLabelContainer(BizUnitInfo bizUnit, ComponentInfo container, BizFieldInfo bizField, String dataObjName) {
        assert (container != null && bizField != null);
        BizFieldViewInfo viewInfo = bizField.getFieldView();
        if (viewInfo == null) {
            logger.warn((Object)("The BizFieldViewInfo of BizFieldInfo " + bizField.getName() + " is null!"));
            return;
        }
        ComponentInfo text = new ComponentInfo("com.kingdee.bos.ctrl.swing.KDTextField");
        text.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        text.setName(this.getPrefix(viewInfo.getViewType()) + bizField.getName());
        text.setConstraint(String.valueOf(3));
        this.setControlTabIndex(text, viewInfo);
        container.addChild(bizUnit.getEditUI(), text);
        PropertyCollection props = text.getProperties();
        props.add(this.createVisibleProperty(viewInfo));
        props.add(this.createHorizonalAlignmentProperty(viewInfo));
        props.add(this.createTextProperty(bizField));
        props.add(this.createForeColorProperty(viewInfo));
        props.add(this.createBGColorProperty(viewInfo));
        props.add(this.createMaxLengthProperty(bizField.getLength()));
        props.add(this.createFontProperty(viewInfo));
        props.add(this.createRequiredProperty(bizField.isRequired()));
        PropertyBindingCollection pbs = text.getPropertyBindings();
        pbs.add(this.createTextPropBinding(bizUnit.getEntity(), dataObjName, bizField));
        bizField.setControlName(text.getName());
        this.uiProxyHelper.updateComponentRules(bizUnit.getEditUI(), text, bizField);
    }

    private void createTextAreaForLabelContainer(BizUnitInfo bizUnit, ComponentInfo container, BizFieldInfo bizField, String dataObjName) {
        assert (container != null && bizField != null);
        BizFieldViewInfo viewInfo = bizField.getFieldView();
        if (viewInfo == null) {
            logger.warn((Object)("The BizFieldViewInfo of BizFieldInfo " + bizField.getName() + " is null!"));
            return;
        }
        ComponentInfo text = new ComponentInfo("com.kingdee.bos.ctrl.swing.KDTextArea");
        text.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        text.setName(this.getPrefix(viewInfo.getViewType()) + bizField.getName());
        text.setConstraint("0,0,1,1");
        this.setControlTabIndex(text, viewInfo);
        container.addChild(bizUnit.getEditUI(), text);
        PropertyCollection props = text.getProperties();
        props.add(this.createVisibleProperty(viewInfo));
        props.add(this.createTextProperty(bizField));
        props.add(this.createForeColorProperty(viewInfo));
        props.add(this.createBGColorProperty(viewInfo));
        props.add(this.createFontProperty(viewInfo));
        props.add(this.createRequiredProperty(bizField.isRequired()));
        props.add(this.createMaxLengthProperty(bizField.getLength()));
        PropertyBindingCollection pbs = text.getPropertyBindings();
        pbs.add(this.createTextPropBinding(bizUnit.getEntity(), dataObjName, bizField));
        bizField.setControlName(text.getName());
        this.uiProxyHelper.updateComponentRules(bizUnit.getEditUI(), text, bizField);
    }

    private void createFormattedTextFieldForLabelContainer(BizUnitInfo bizUnit, ComponentInfo container, BizFieldInfo bizField, String dataObjName) {
        assert (container != null && bizField != null);
        BizFieldViewInfo viewInfo = bizField.getFieldView();
        if (viewInfo == null) {
            logger.warn((Object)("The BizFieldViewInfo of BizFieldInfo " + bizField.getName() + " is null!"));
            return;
        }
        ComponentInfo text = new ComponentInfo("com.kingdee.bos.ctrl.swing.KDFormattedTextField");
        text.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        text.setName(this.getPrefix(viewInfo.getViewType()) + bizField.getName());
        text.setConstraint(String.valueOf(7));
        this.setControlTabIndex(text, viewInfo);
        container.addChild(bizUnit.getEditUI(), text);
        PropertyCollection props = text.getProperties();
        props.add(this.createVisibleProperty(viewInfo));
        props.add(this.createHorizonalAlignmentProperty(viewInfo));
        props.add(this.createDataTypeProperty(bizField));
        props.add(this.createForeColorProperty(viewInfo));
        props.add(this.createBGColorProperty(viewInfo));
        props.add(this.createFontProperty(viewInfo));
        props.add(this.createSupportedEmptyProperty(true));
        if (bizField.getBizDataType() == BizDataType.DECIMAL || bizField.getBizDataType() == BizDataType.QUANTITY || bizField.getBizDataType() == BizDataType.PRICE || bizField.getBizDataType() == BizDataType.AMOUNT) {
            props.add(this.createMinimumValueProperty(bizField.getLength(), bizField.getScale()));
            props.add(this.createMaximumValueProperty(bizField.getLength(), bizField.getScale()));
            if (bizField.getFieldView().getDecimalLength() > 0) {
                props.add(this.createPrecisionProperty(bizField.getFieldView().getDecimalLength()));
            } else {
                props.add(this.createPrecisionProperty(bizField.getScale()));
            }
        }
        PropertyBindingCollection pbs = text.getPropertyBindings();
        pbs.add(this.createValuePropBinding(bizUnit.getEntity(), dataObjName, bizField));
        props.add(this.createRequiredProperty(bizField.isRequired()));
        bizField.setControlName(text.getName());
        this.uiProxyHelper.updateComponentRules(bizUnit.getEditUI(), text, bizField);
    }

    private void createDatePickerForLabelContainer(BizUnitInfo bizUnit, ComponentInfo container, BizFieldInfo bizField, String dataObjName) {
        assert (container != null && bizField != null);
        BizFieldViewInfo viewInfo = bizField.getFieldView();
        if (viewInfo == null) {
            logger.warn((Object)("The BizFieldViewInfo of BizFieldInfo " + bizField.getName() + " is null!"));
            return;
        }
        ComponentInfo picker = new ComponentInfo("com.kingdee.bos.ctrl.swing.KDDatePicker");
        picker.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        picker.setName(this.getPrefix(viewInfo.getViewType()) + bizField.getName());
        picker.setConstraint(String.valueOf(7));
        this.setControlTabIndex(picker, viewInfo);
        picker.setExtendedProperty("addedByBIM", "true");
        container.addChild(bizUnit.getEditUI(), picker);
        PropertyCollection props = picker.getProperties();
        props.add(this.createVisibleProperty(viewInfo));
        props.add(this.createForeColorProperty(viewInfo));
        props.add(this.createBGColorProperty(viewInfo));
        props.add(this.createFontProperty(viewInfo));
        props.add(this.createRequiredProperty(bizField.isRequired()));
        PropertyBindingCollection pbs = picker.getPropertyBindings();
        pbs.add(this.createValuePropBinding(bizUnit.getEntity(), dataObjName, bizField));
        bizField.setControlName(picker.getName());
        this.uiProxyHelper.updateComponentRules(bizUnit.getEditUI(), picker, bizField);
    }

    private void createTimePickerForLabelContainer(BizUnitInfo bizUnit, ComponentInfo container, BizFieldInfo bizField, String dataObjName) {
        assert (container != null && bizField != null);
        BizFieldViewInfo viewInfo = bizField.getFieldView();
        if (viewInfo == null) {
            logger.warn((Object)("The BizFieldViewInfo of BizFieldInfo " + bizField.getName() + " is null!"));
            return;
        }
        ComponentInfo picker = new ComponentInfo("com.kingdee.bos.ctrl.swing.KDTimePicker");
        picker.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        picker.setName(this.getPrefix(viewInfo.getViewType()) + bizField.getName());
        picker.setConstraint(String.valueOf(7));
        this.setControlTabIndex(picker, viewInfo);
        container.addChild(bizUnit.getEditUI(), picker);
        PropertyCollection props = picker.getProperties();
        props.add(this.createVisibleProperty(viewInfo));
        props.add(this.createForeColorProperty(viewInfo));
        props.add(this.createBGColorProperty(viewInfo));
        props.add(this.createFontProperty(viewInfo));
        PropertyBindingCollection pbs = picker.getPropertyBindings();
        pbs.add(this.createValuePropBinding(bizUnit.getEntity(), dataObjName, bizField));
        bizField.setControlName(picker.getName());
        this.uiProxyHelper.updateComponentRules(bizUnit.getEditUI(), picker, bizField);
    }

    private void createListForLabelContainer(BizUnitInfo bizUnit, ComponentInfo container, BizFieldInfo bizField, String dataObjName) {
        assert (container != null && bizField != null);
        BizFieldViewInfo viewInfo = bizField.getFieldView();
        if (viewInfo == null) {
            logger.warn((Object)("The BizFieldViewInfo of BizFieldInfo " + bizField.getName() + " is null!"));
            return;
        }
        ComponentInfo list = new ComponentInfo("com.kingdee.bos.ctrl.swing.KDList");
        list.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        list.setName(this.getPrefix(viewInfo.getViewType()) + bizField.getName());
        list.setConstraint(String.valueOf(7));
        this.setControlTabIndex(list, viewInfo);
        container.addChild(bizUnit.getEditUI(), list);
        PropertyCollection props = list.getProperties();
        props.add(this.createVisibleProperty(viewInfo));
        props.add(this.createForeColorProperty(viewInfo));
        props.add(this.createBGColorProperty(viewInfo));
        props.add(this.createFontProperty(viewInfo));
        props.add(this.createItemsProperty(bizUnit.getEntity(), bizField));
        PropertyBindingCollection pbs = list.getPropertyBindings();
        pbs.add(this.createSelectedItemPropBinding(bizUnit.getEntity(), dataObjName, bizField));
        bizField.setControlName(list.getName());
        this.uiProxyHelper.updateComponentRules(bizUnit.getEditUI(), list, bizField);
    }

    private void createComboBoxForLabelContainer(BizUnitInfo bizUnit, ComponentInfo container, BizFieldInfo bizField, String dataObjName) {
        assert (container != null && bizField != null);
        BizFieldViewInfo viewInfo = bizField.getFieldView();
        if (viewInfo == null) {
            logger.warn((Object)("The BizFieldViewInfo of BizFieldInfo " + bizField.getName() + " is null!"));
            return;
        }
        ComponentInfo combo = new ComponentInfo("com.kingdee.bos.ctrl.swing.KDComboBox");
        combo.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        combo.setName(this.getPrefix(viewInfo.getViewType()) + bizField.getName());
        combo.setConstraint(String.valueOf(7));
        this.setControlTabIndex(combo, viewInfo);
        container.addChild(bizUnit.getEditUI(), combo);
        PropertyCollection props = combo.getProperties();
        props.add(this.createVisibleProperty(viewInfo));
        props.add(this.createForeColorProperty(viewInfo));
        props.add(this.createBGColorProperty(viewInfo));
        props.add(this.createFontProperty(viewInfo));
        props.add(this.createItemsProperty(bizUnit.getEntity(), bizField));
        props.add(this.createRequiredProperty(bizField.isRequired()));
        PropertyBindingCollection pbs = combo.getPropertyBindings();
        pbs.add(this.createSelectedItemPropBinding(bizUnit.getEntity(), dataObjName, bizField));
        bizField.setControlName(combo.getName());
        this.uiProxyHelper.updateComponentRules(bizUnit.getEditUI(), combo, bizField);
    }

    private void createBizPromptBoxForLabelContainer(BizUnitInfo bizUnit, ComponentInfo container, BizFieldInfo bizField, String dataObjName) {
        assert (container != null && bizField != null);
        BizFieldViewInfo viewInfo = bizField.getFieldView();
        if (viewInfo == null) {
            logger.warn((Object)("The BizFieldViewInfo of BizFieldInfo " + bizField.getName() + " is null!"));
            return;
        }
        ComponentInfo f7 = new ComponentInfo("com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox");
        f7.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        f7.setName(this.getPrefix(viewInfo.getViewType()) + bizField.getName());
        f7.setConstraint(String.valueOf(7));
        this.setControlTabIndex(f7, viewInfo);
        container.addChild(bizUnit.getEditUI(), f7);
        PropertyCollection props = f7.getProperties();
        PropertyInfo prop = this.createQueryInfoProperty(viewInfo);
        if (prop != null) {
            props.add(prop);
        }
        props.add(this.createVisibleProperty(viewInfo));
        props.add(this.createEditableProperty(viewInfo));
        props.add(this.createForeColorProperty(viewInfo));
        props.add(this.createBGColorProperty(viewInfo));
        props.add(this.createFontProperty(viewInfo));
        props.add(this.createEditableProperty(viewInfo));
        props.add(this.createDisplayFormatProperty(bizField));
        props.add(this.createEditFormatProperty(viewInfo));
        props.add(this.createCommitFormatProperty(viewInfo));
        props.add(this.createRequiredProperty(bizField.isRequired()));
        PropertyBindingCollection pbs = f7.getPropertyBindings();
        pbs.add(this.createF7DataPropBinding(bizUnit.getEntity(), dataObjName, bizField));
        bizField.setControlName(f7.getName());
        this.uiProxyHelper.updateComponentRules(bizUnit.getEditUI(), f7, bizField);
    }

    private Object createContraint(ComponentInfo parent, Rectangle rect) {
        assert (parent != null);
        if (rect == null) {
            rect = new Rectangle(0, 0, 270, 19);
        }
        return UIProxyHelper.getConstraintByLayout(LayoutConverter.convertToLayoutObj(parent.getLayoutInfo()), rect);
    }

    private PropertyInfo createLabelTextProperty(BizFieldViewInfo viewInfo) {
        assert (viewInfo != null);
        String text = viewInfo.getDisplayText();
        if (StringUtils.isEmpty((String)text)) {
            return null;
        }
        PropertyInfo prop = new PropertyInfo();
        prop.setName("text");
        prop.setType(String.class.getName());
        prop.setMultiLanguage(true);
        prop.setValue(text);
        prop.setOverride(true);
        return prop;
    }

    private PropertyInfo createTextProperty(BizFieldInfo bizFieldInfo) {
        assert (bizFieldInfo != null);
        String text = bizFieldInfo.getDefaultValue();
        if (text == null) {
            return null;
        }
        PropertyInfo prop = new PropertyInfo();
        prop.setName("text");
        prop.setType(String.class.getName());
        prop.setMultiLanguage(true);
        prop.setValue(text);
        prop.setOverride(true);
        return prop;
    }

    private PropertyInfo createBoundLabelTextProperty(BizFieldInfo field) {
        assert (field != null);
        BizFieldViewInfo viewInfo = field.getFieldView();
        String text = "";
        if (viewInfo != null) {
            text = viewInfo.getDisplayText();
        }
        if (StringUtils.isEmpty((String)text)) {
            text = field.getAlias();
        }
        if (StringUtils.isEmpty((String)text)) {
            return null;
        }
        PropertyInfo prop = new PropertyInfo();
        prop.setName("boundLabelText");
        prop.setType(String.class.getName());
        prop.setMultiLanguage(true);
        prop.setValue(text);
        prop.setOverride(true);
        return prop;
    }

    private PropertyInfo createBoundLabelLengthProperty() {
        PropertyInfo prop = new PropertyInfo();
        prop.setName("boundLabelLength");
        prop.setType("int");
        prop.setValue(String.valueOf(100));
        prop.setOverride(true);
        return prop;
    }

    private PropertyInfo createBoundLabelUnderlineProperty() {
        PropertyInfo prop = new PropertyInfo();
        prop.setName("boundLabelUnderline");
        prop.setType("boolean");
        prop.setValue(String.valueOf(true));
        prop.setOverride(true);
        return prop;
    }

    private PropertyInfo createQueryInfoProperty(BizFieldViewInfo viewInfo) {
        assert (viewInfo != null);
        if (StringUtils.isEmpty((String)viewInfo.getF7QueryPK())) {
            return null;
        }
        PropertyInfo prop = new PropertyInfo();
        prop.setName("queryInfo");
        prop.setType(String.class.getName());
        prop.setValue(viewInfo.getF7QueryPK());
        prop.setOverride(true);
        return prop;
    }

    private PropertyInfo createRequiredProperty(boolean isRequired) {
        PropertyInfo prop = new PropertyInfo();
        prop.setName("required");
        prop.setType("boolean");
        prop.setValue(String.valueOf(isRequired));
        prop.setOverride(true);
        return prop;
    }

    private PropertyInfo createVisibleProperty(BizFieldViewInfo viewInfo) {
        assert (viewInfo != null);
        PropertyInfo prop = new PropertyInfo();
        prop.setName("visible");
        prop.setType("boolean");
        prop.setValue(String.valueOf(viewInfo.isVisible()));
        prop.setOverride(true);
        return prop;
    }

    private PropertyInfo createEditableProperty(BizFieldViewInfo viewInfo) {
        assert (viewInfo != null);
        PropertyInfo prop = new PropertyInfo();
        prop.setName("editable");
        prop.setType("boolean");
        prop.setValue(String.valueOf(viewInfo.isEnable()));
        prop.setOverride(true);
        return prop;
    }

    private PropertyInfo createDisplayFormatProperty(BizFieldInfo fieldInfo) {
        assert (fieldInfo != null);
        String sDataField = fieldInfo.getDataField();
        PropertyInfo prop = new PropertyInfo();
        prop.setName("displayFormat");
        prop.setType(String.class.getName());
        if (StringUtils.isEmpty((String)sDataField)) {
            prop.setValue("$name$");
        } else {
            prop.setValue(this.parseStrToDisplayField(sDataField));
        }
        prop.setOverride(true);
        return prop;
    }

    private String parseStrToDisplayField(String sDisField) {
        String strFirst = "";
        String strLeft = "";
        String strSecond = "";
        String strRight = "";
        String strTemp = "";
        String sDisplayFormat = "";
        int iPos = sDisField.indexOf("+");
        if (iPos > 0) {
            strFirst = sDisField.substring(0, iPos).trim();
            strTemp = sDisField.substring(iPos + 2);
            sDisplayFormat = "$" + strFirst + "$";
            if (sDisField.trim().length() > iPos && strTemp.trim().length() > 0 && (iPos = strTemp.indexOf("+")) > 0) {
                strLeft = strTemp.substring(0, iPos);
                strLeft = strLeft.replaceAll("\"", "");
                sDisplayFormat = sDisplayFormat + strLeft;
                if (strTemp.trim().length() > iPos + 1 && (strTemp = strTemp.substring(iPos + 2)).trim().length() > 0 && (iPos = strTemp.indexOf("+")) > 0) {
                    strSecond = strTemp.substring(0, iPos);
                    sDisplayFormat = sDisplayFormat + "$" + strSecond.trim() + "$";
                    if (strTemp.length() > iPos + 1) {
                        strRight = strTemp.substring(iPos + 2);
                        strRight = strRight.replaceAll("\"", "");
                        sDisplayFormat = sDisplayFormat + strRight;
                    }
                }
            }
        } else {
            strFirst = sDisField.trim();
            sDisplayFormat = "$" + strFirst + "$";
        }
        return sDisplayFormat;
    }

    private PropertyInfo createEditFormatProperty(BizFieldViewInfo viewInfo) {
        assert (viewInfo != null);
        PropertyInfo prop = new PropertyInfo();
        prop.setName("editFormat");
        prop.setType(String.class.getName());
        prop.setValue("$number$");
        prop.setOverride(true);
        return prop;
    }

    private PropertyInfo createCommitFormatProperty(BizFieldViewInfo viewInfo) {
        assert (viewInfo != null);
        PropertyInfo prop = new PropertyInfo();
        prop.setName("commitFormat");
        prop.setType(String.class.getName());
        prop.setValue("$number$");
        prop.setOverride(true);
        return prop;
    }

    private PropertyInfo createForeColorProperty(BizFieldViewInfo viewInfo, boolean is4Label) {
        assert (viewInfo != null);
        String color = null;
        color = is4Label ? viewInfo.getForeColor4Label() : viewInfo.getForeColor();
        if (StringUtils.isEmpty((String)color)) {
            return null;
        }
        PropertyInfo prop = new PropertyInfo();
        prop.setName("foreground");
        prop.setMultiLanguage(false);
        prop.setType(Color.class.getName());
        prop.setValue(color);
        prop.setOverride(true);
        return prop;
    }

    private PropertyInfo createForeColorProperty(BizFieldViewInfo viewInfo) {
        return this.createForeColorProperty(viewInfo, false);
    }

    private PropertyInfo createBGColorProperty(BizFieldViewInfo viewInfo, boolean is4Label) {
        assert (viewInfo != null);
        String color = null;
        color = is4Label ? viewInfo.getBackgroundColor4Label() : viewInfo.getBackgroundColor();
        if (StringUtils.isEmpty((String)color)) {
            return null;
        }
        PropertyInfo prop = new PropertyInfo();
        prop.setName("background");
        prop.setType(Color.class.getName());
        prop.setValue(color);
        prop.setMultiLanguage(false);
        prop.setOverride(true);
        return prop;
    }

    private PropertyInfo createBGColorProperty(BizFieldViewInfo viewInfo) {
        return this.createBGColorProperty(viewInfo, false);
    }

    private PropertyInfo createSupportedEmptyProperty(boolean isSupportedEmpty) {
        PropertyInfo prop = new PropertyInfo();
        prop.setName("supportedEmpty");
        prop.setType("boolean");
        prop.setValue(String.valueOf(isSupportedEmpty));
        prop.setOverride(true);
        return prop;
    }

    private PropertyInfo createFontProperty(BizFieldViewInfo viewInfo) {
        assert (viewInfo != null);
        String font = viewInfo.getFontString();
        if (StringUtils.isEmpty((String)font)) {
            return null;
        }
        PropertyInfo prop = new PropertyInfo();
        prop.setName("font");
        prop.setType(Font.class.getName());
        prop.setValue(font);
        prop.setOverride(true);
        return prop;
    }

    private PropertyInfo createMaxLengthProperty(int length) {
        PropertyInfo prop = new PropertyInfo();
        prop.setName("maxLength");
        prop.setType("int");
        prop.setValue(String.valueOf(length));
        prop.setOverride(true);
        return prop;
    }

    public static String getMininumValue(int length, int scale) {
        int i;
        if (length <= scale) {
            return null;
        }
        int realLength = length - scale;
        String format = "-";
        double minValue = MinFloat;
        for (i = 0; i < realLength; ++i) {
            format = format + "9";
        }
        if (scale > 0) {
            format = format + ".";
            for (i = 0; i < scale; ++i) {
                format = format + "9";
            }
        }
        try {
            if (Double.parseDouble(format) > minValue) {
                minValue = Double.parseDouble(format);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return String.valueOf(minValue);
    }

    public static String getMaximumValue(int length, int scale) {
        int i;
        if (length <= scale) {
            return null;
        }
        int realLength = length - scale;
        String format = "";
        double maxValue = MaxFloat;
        for (i = 0; i < realLength; ++i) {
            format = format + "9";
        }
        if (scale > 0) {
            format = format + ".";
            for (i = 0; i < scale; ++i) {
                format = format + "9";
            }
        }
        try {
            if (Double.parseDouble(format) < maxValue) {
                maxValue = Double.parseDouble(format);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return String.valueOf(maxValue);
    }

    private PropertyInfo createMinimumValueProperty(int length, int scale) {
        if (length <= scale) {
            return null;
        }
        String format = EditUIProxyHelper.getMininumValue(length, scale);
        format = "\"" + format + "\"";
        PropertyInfo prop = new PropertyInfo();
        prop.setName("minimumValue");
        prop.setType(BigDecimal.class.getName());
        prop.setValue(format);
        prop.setOverride(true);
        return prop;
    }

    private PropertyInfo createMaximumValueProperty(int length, int scale) {
        if (length <= scale) {
            return null;
        }
        String format = EditUIProxyHelper.getMaximumValue(length, scale);
        format = "\"" + format + "\"";
        PropertyInfo prop = new PropertyInfo();
        prop.setName("maximumValue");
        prop.setType(BigDecimal.class.getName());
        prop.setValue(format);
        prop.setOverride(true);
        return prop;
    }

    private PropertyInfo createPrecisionProperty(int precision) {
        PropertyInfo prop = new PropertyInfo();
        prop.setName("precision");
        prop.setType("int");
        prop.setValue(String.valueOf(precision));
        prop.setOverride(true);
        return prop;
    }

    private PropertyInfo createHorizonalAlignmentProperty(BizFieldViewInfo viewInfo) {
        assert (viewInfo != null);
        HorizontalAlignmentType type = viewInfo.getHorizontalAlignment();
        if (type == null) {
            return null;
        }
        int value = this.uiProxyHelper.getSwingHorizontalAlignment(type);
        PropertyInfo prop = new PropertyInfo();
        prop.setName("horizontalAlignment");
        prop.setType("int");
        prop.setValue(String.valueOf(value));
        prop.setOverride(true);
        return prop;
    }

    private PropertyInfo createDataTypeProperty(BizFieldInfo info) {
        assert (info != null);
        PropertyInfo prop = new PropertyInfo();
        prop.setName("dataType");
        prop.setType("int");
        prop.setOverride(true);
        BizDataType type = info.getBizDataType();
        if (BizDataType.AMOUNT.equals((Object)type) || BizDataType.DECIMAL.equals((Object)type) || BizDataType.PRICE.equals((Object)type) || BizDataType.QUANTITY.equals((Object)type)) {
            prop.setValue(String.valueOf(1));
        } else if (BizDataType.INTEGER.equals((Object)type)) {
            prop.setValue(String.valueOf(0));
        } else {
            return null;
        }
        return prop;
    }

    private void setControlTabIndex(ComponentInfo control, BizFieldViewInfo viewInfo) {
        assert (control != null && viewInfo != null);
        int oldIndex = control.getTabIndex();
        control.setTabIndex(viewInfo.getTabIndex());
        if (oldIndex == control.getTabIndex()) {
            control.setOverrideTabIndex(true);
        }
    }

    public static com.kingdee.bos.metadata.entity.PropertyInfo getPropertyByName(EntityObjectInfo entity, String propertyName) {
        if (entity == null || StringUtils.isEmpty((String)propertyName)) {
            return null;
        }
        String[] propertys = StringUtils.split((String)propertyName, (String)".");
        com.kingdee.bos.metadata.entity.PropertyInfo prop = null;
        EntityObjectInfo subEntity = entity;
        int n = propertys.length;
        for (int i = 0; i < n && (prop = subEntity.getPropertyByName(propertys[i], true)) != null; ++i) {
            if (prop instanceof OwnPropertyInfo) {
                if (i == n - 1) break;
                prop = null;
                break;
            }
            RelationshipInfo relation = ((LinkPropertyInfo)prop).getRelationship();
            subEntity = relation.getSupplierObject();
            if (subEntity != null) continue;
            prop = null;
            break;
        }
        return prop;
    }

    private PropertyBindingInfo createTextPropBinding(EntityObjectInfo entity, String dataObjName, BizFieldInfo bizField) {
        com.kingdee.bos.metadata.entity.PropertyInfo propInfo;
        if (StringUtils.isEmpty((String)dataObjName) || bizField == null || entity == null) {
            return null;
        }
        String propName = bizField.getPropertyName();
        if (StringUtils.isEmpty((String)propName)) {
            if (DataSourceType.BASEDATAEXT.equals((Object)bizField.getDataSourceType()) && !StringUtils.isEmpty((String)bizField.getDataField())) {
                propName = bizField.getDataField();
            } else {
                return null;
            }
        }
        if ((propInfo = EditUIProxyHelper.getPropertyByName(entity, propName)) == null || !(propInfo instanceof OwnPropertyInfo)) {
            return null;
        }
        PropertyBindingInfo pb = new PropertyBindingInfo();
        pb.setPropertyName("text");
        pb.setPropertyType(String.class.getName());
        pb.setBindingObject(dataObjName);
        pb.setBingdingField(propName);
        pb.setFieldType(((OwnPropertyInfo)propInfo).getJavaType());
        pb.setAccessType(2);
        pb.setAutoMode(false);
        pb.setOverride(true);
        return pb;
    }

    private PropertyBindingInfo createValuePropBinding(EntityObjectInfo entity, String dataObjName, BizFieldInfo bizField) {
        if (StringUtils.isEmpty((String)dataObjName) || bizField == null || entity == null) {
            return null;
        }
        String propName = bizField.getPropertyName();
        if (StringUtils.isEmpty((String)propName)) {
            return null;
        }
        com.kingdee.bos.metadata.entity.PropertyInfo propInfo = entity.getPropertyByName(propName);
        if (propInfo == null || !(propInfo instanceof OwnPropertyInfo)) {
            return null;
        }
        propName = propInfo.getName();
        PropertyBindingInfo pb = new PropertyBindingInfo();
        pb.setPropertyName("value");
        pb.setPropertyType(Object.class.getName());
        pb.setBindingObject(dataObjName);
        pb.setBingdingField(propName);
        pb.setFieldType(((OwnPropertyInfo)propInfo).getJavaType());
        pb.setAccessType(2);
        pb.setAutoMode(false);
        pb.setOverride(true);
        return pb;
    }

    private PropertyInfo createItemsProperty(EntityObjectInfo entity, BizFieldInfo bizField) {
        if (bizField == null || entity == null) {
            return null;
        }
        BizEnumInfo bizEnum = null;
        if (BizDataType.ENUM.equals((Object)bizField.getBizDataType()) && bizField.getEnumType() != null) {
            bizEnum = bizField.getEnumType();
        } else {
            String propName = bizField.getPropertyName();
            if (StringUtils.isEmpty((String)propName)) {
                return null;
            }
            com.kingdee.bos.metadata.entity.PropertyInfo propInfo = entity.getPropertyByName(propName);
            if (propInfo == null || !(propInfo instanceof OwnPropertyInfo)) {
                return null;
            }
            if (((OwnPropertyInfo)propInfo).getEnumType() == null) {
                return null;
            }
            bizEnum = ((OwnPropertyInfo)propInfo).getEnumType();
        }
        PropertyInfo conPropInfo = new PropertyInfo();
        conPropInfo.setName("items");
        conPropInfo.setType(String.class.getName());
        conPropInfo.setMultiLanguage(true);
        String value = "[Enum]";
        if (!StringUtils.isEmpty((String)bizEnum.getPackage())) {
            value = value + bizEnum.getPackage() + ".";
        }
        value = value + bizEnum.getName();
        conPropInfo.setValue(value);
        return conPropInfo;
    }

    private PropertyBindingInfo createSelectedItemPropBinding(EntityObjectInfo entity, String dataObjName, BizFieldInfo bizField) {
        if (StringUtils.isEmpty((String)dataObjName) || bizField == null || entity == null) {
            return null;
        }
        String propName = bizField.getPropertyName();
        if (StringUtils.isEmpty((String)propName)) {
            return null;
        }
        com.kingdee.bos.metadata.entity.PropertyInfo propInfo = entity.getPropertyByName(propName);
        if (propInfo == null || !(propInfo instanceof OwnPropertyInfo)) {
            return null;
        }
        if (((OwnPropertyInfo)propInfo).getEnumType() == null) {
            return null;
        }
        propName = propInfo.getName();
        PropertyBindingInfo pb = new PropertyBindingInfo();
        pb.setPropertyName("selectedItem");
        pb.setPropertyType(Object.class.getName());
        pb.setBindingObject(dataObjName);
        pb.setBingdingField(propName);
        pb.setFieldType(((OwnPropertyInfo)propInfo).getEnumType().getClassName());
        pb.setAccessType(2);
        pb.setAutoMode(false);
        pb.setOverride(true);
        return pb;
    }

    private PropertyBindingInfo createF7DataPropBinding(EntityObjectInfo entity, String dataObjName, BizFieldInfo bizField) {
        if (StringUtils.isEmpty((String)dataObjName) || bizField == null || entity == null) {
            return null;
        }
        String propName = bizField.getPropertyName();
        if (StringUtils.isEmpty((String)propName)) {
            return null;
        }
        com.kingdee.bos.metadata.entity.PropertyInfo propInfo = entity.getPropertyByName(propName);
        if (propInfo == null || !(propInfo instanceof LinkPropertyInfo)) {
            return null;
        }
        propName = propInfo.getName();
        PropertyBindingInfo pb = new PropertyBindingInfo();
        pb.setPropertyName("data");
        pb.setPropertyType(Object.class.getName());
        pb.setBindingObject(dataObjName);
        pb.setBingdingField(propName);
        pb.setFieldType(((LinkPropertyInfo)propInfo).getRelationship().getSupplierObject().getObjectValueClass());
        pb.setAccessType(2);
        pb.setAutoMode(false);
        pb.setOverride(true);
        return pb;
    }

    private PropertyBindingInfo createSelectedPropBinding(EntityObjectInfo entity, String dataObjName, BizFieldInfo bizField) {
        if (StringUtils.isEmpty((String)dataObjName) || bizField == null || entity == null) {
            return null;
        }
        String propName = bizField.getPropertyName();
        if (StringUtils.isEmpty((String)propName)) {
            return null;
        }
        com.kingdee.bos.metadata.entity.PropertyInfo propInfo = entity.getPropertyByName(propName);
        if (propInfo == null || !(propInfo instanceof OwnPropertyInfo)) {
            return null;
        }
        propName = propInfo.getName();
        PropertyBindingInfo propertyBindingInfo = new PropertyBindingInfo();
        propertyBindingInfo.setPropertyName("selected");
        propertyBindingInfo.setPropertyType("boolean");
        propertyBindingInfo.setAccessType(2);
        propertyBindingInfo.setAutoMode(false);
        propertyBindingInfo.setBindingObject(dataObjName);
        propertyBindingInfo.setBingdingField(propName);
        propertyBindingInfo.setFieldType(((OwnPropertyInfo)propInfo).getJavaType());
        propertyBindingInfo.setOverride(true);
        return propertyBindingInfo;
    }

    private String getPrefix(ViewType type) {
        if (type == null) {
            return "";
        }
        String classType = (String)this.controlMap.get((Object)type);
        if (StringUtils.isEmpty((String)classType)) {
            return "";
        }
        String value = ControlConstant.getControlNamePrefix(classType);
        if (value == null) {
            return "";
        }
        return value;
    }

    private String getPrefix(String classType) {
        if (StringUtils.isEmpty((String)classType)) {
            return "";
        }
        String value = ControlConstant.getControlNamePrefix(classType);
        if (value == null) {
            return "";
        }
        return value;
    }

    private void initControlMap() {
        this.controlMap.put(ViewType.BUTTON, "com.kingdee.bos.ctrl.swing.KDButton");
        this.controlMap.put(ViewType.CHECKBOX, "com.kingdee.bos.ctrl.swing.KDCheckBox");
        this.controlMap.put(ViewType.DATEPICKER, "com.kingdee.bos.ctrl.swing.KDDatePicker");
        this.controlMap.put(ViewType.LABEL, "com.kingdee.bos.ctrl.swing.KDLabel");
        this.controlMap.put(ViewType.LISTBOX, "com.kingdee.bos.ctrl.swing.KDList");
        this.controlMap.put(ViewType.MENUITEM, "com.kingdee.bos.ctrl.swing.KDMenuItem");
        this.controlMap.put(ViewType.RADIOBUTTON, "com.kingdee.bos.ctrl.swing.KDRadioButton");
        this.controlMap.put(ViewType.BUTTONGROUP, "com.kingdee.bos.ctrl.swing.KDButtonGroup");
        this.controlMap.put(ViewType.KDSEPARATOR, "com.kingdee.bos.ctrl.swing.KDSeparator");
        this.controlMap.put(ViewType.TABCONTROL, "com.kingdee.bos.ctrl.swing.KDTabbedPane");
        this.controlMap.put(ViewType.TABLEVIEW, "com.kingdee.bos.ctrl.kdf.table.KDTable");
        this.controlMap.put(ViewType.TEXTFIELD, "com.kingdee.bos.ctrl.swing.KDTextField");
        this.controlMap.put(ViewType.TEXTAREA, "com.kingdee.bos.ctrl.swing.KDTextArea");
        this.controlMap.put(ViewType.FORMATTEXTFIELD, "com.kingdee.bos.ctrl.swing.KDFormattedTextField");
        this.controlMap.put(ViewType.TOOLBARBUTTON, "com.kingdee.bos.ctrl.swing.KDToolButton");
        this.controlMap.put(ViewType.TREEVIEW, "com.kingdee.bos.ctrl.swing.KDTreeView");
        this.controlMap.put(ViewType.F7SELECTOR, "com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox");
    }

    public static com.kingdee.bos.metadata.entity.PropertyInfo getColumnBindProperty(UIObjectInfo model, ComponentInfo cInfo, String columnName) {
        return EditUIProxyHelper.getColumnBindProperty(model, cInfo, columnName, false);
    }

    public static com.kingdee.bos.metadata.entity.PropertyInfo getColumnBindProperty(UIObjectInfo model, ComponentInfo cInfo, String columnName, boolean isRuntime) {
        if (model == null || cInfo == null || StringUtils.isEmpty((String)columnName)) {
            return null;
        }
        String bindObjectName = "";
        String tableColumnName = "";
        IMetaDataLoader loader = null;
        if (isRuntime) {
            loader = MetaDataLoaderFactory.getMetaDataLoader(ContextManager.getContext());
        }
        int n = cInfo.getPropertyBindings().size();
        for (int j = 0; j < n; ++j) {
            PropertyBindingInfo pbInfo = cInfo.getPropertyBindings().get(j);
            if (pbInfo.getPropertyName().indexOf(".text") < 0 || !(tableColumnName = StringUtils.replace((String)pbInfo.getPropertyName(), (String)".text", (String)"")).equalsIgnoreCase(columnName)) continue;
            bindObjectName = pbInfo.getBindingObject();
            String sbindField = pbInfo.getBingdingField();
            int m = model.getDataObjects().size();
            for (int i = 0; i < m; ++i) {
                DataObjectInfo dataObject = model.getDataObjects().get(i);
                if (!dataObject.getName().equals(bindObjectName)) continue;
                IObjectValue objectValue = null;
                if (MetaDataTypeList.ENTITY.toString().equals(dataObject.getObjectType())) {
                    objectValue = isRuntime ? loader.getEntity(MetaDataPK.create(dataObject.getType())) : dataObject.getInstance();
                }
                if (objectValue == null || !(objectValue instanceof EntityObjectInfo)) continue;
                EntityObjectInfo entity = (EntityObjectInfo)objectValue;
                return EditUIProxyHelper.getPropertyByName(entity, sbindField);
            }
        }
        return null;
    }

    public static com.kingdee.bos.metadata.entity.PropertyInfo getColumnBindProperty(EntityObjectInfo entity, ComponentInfo cInfo, String columnName) {
        if (entity == null || cInfo == null || StringUtils.isEmpty((String)columnName)) {
            return null;
        }
        String tableColumnName = "";
        int n = cInfo.getPropertyBindings().size();
        for (int j = 0; j < n; ++j) {
            PropertyBindingInfo pbInfo = cInfo.getPropertyBindings().get(j);
            if (pbInfo.getPropertyName().indexOf(".text") < 0 || !(tableColumnName = StringUtils.replace((String)pbInfo.getPropertyName(), (String)".text", (String)"")).equalsIgnoreCase(columnName)) continue;
            String sbindField = pbInfo.getBingdingField();
            return EditUIProxyHelper.getPropertyByName(entity, sbindField);
        }
        return null;
    }

    public static String getColumnBindQueryPK(UIObjectInfo model, ComponentInfo cInfo, String columnName) {
        String sQueryPK;
        RelationshipInfo relationShip;
        EntityObjectInfo supplyEntityInfo;
        if (model == null || cInfo == null || StringUtils.isEmpty((String)columnName)) {
            return null;
        }
        com.kingdee.bos.metadata.entity.PropertyInfo prop = EditUIProxyHelper.getColumnBindProperty(model, cInfo, columnName);
        if (prop != null && prop instanceof LinkPropertyInfo && (supplyEntityInfo = (relationShip = ((LinkPropertyInfo)prop).getRelationship()).getSupplierObject()) != null && !StringUtils.isEmpty((String)(sQueryPK = supplyEntityInfo.getExtendedProperty("defaultF7Query")))) {
            return sQueryPK;
        }
        return null;
    }

    public static String getColumnBindQueryPK(EntityObjectInfo entity, ComponentInfo cInfo, String columnName) {
        String sQueryPK;
        RelationshipInfo relationShip;
        EntityObjectInfo supplyEntityInfo;
        if (entity == null || cInfo == null || StringUtils.isEmpty((String)columnName)) {
            return null;
        }
        com.kingdee.bos.metadata.entity.PropertyInfo prop = EditUIProxyHelper.getColumnBindProperty(entity, cInfo, columnName);
        if (prop != null && prop instanceof LinkPropertyInfo && (supplyEntityInfo = (relationShip = ((LinkPropertyInfo)prop).getRelationship()).getSupplierObject()) != null && !StringUtils.isEmpty((String)(sQueryPK = supplyEntityInfo.getExtendedProperty("defaultF7Query")))) {
            return sQueryPK;
        }
        return null;
    }

    private static String getBindFieldName(PropertyBindingCollection propBindings, String propertyName) {
        int n = propBindings.size();
        for (int i = 0; i < n; ++i) {
            if (!propertyName.equalsIgnoreCase(propBindings.get(i).getPropertyName())) continue;
            return propBindings.get(i).getBingdingField();
        }
        return null;
    }

    public static com.kingdee.bos.metadata.entity.PropertyInfo getBindingProperty(UIObjectInfo model, ComponentInfo control, String propertyName) {
        return EditUIProxyHelper.getBindingProperty(model, control, propertyName, false);
    }

    public static com.kingdee.bos.metadata.entity.PropertyInfo getBindingProperty(UIObjectInfo model, ComponentInfo control, String propertyName, boolean isRuntime) {
        String bindFieldName;
        if (model == null || control == null || control.getClassType() == null) {
            return null;
        }
        if (!StringUtils.isEmpty((String)propertyName) && !StringUtils.isEmpty((String)(bindFieldName = EditUIProxyHelper.getBindFieldName(control.getPropertyBindings(), propertyName))) && model.getDataObjects() != null && model.getDataObjects().size() > 0 && model.getDataObjects().get(0).getObjectType().equals(MetaDataTypeList.ENTITY.toString())) {
            EntityObjectInfo entity = null;
            if (isRuntime) {
                IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader(ContextManager.getContext());
                entity = loader.getEntity(MetaDataPK.create(model.getDataObjects().get(0).getType()));
            } else {
                entity = (EntityObjectInfo)model.getDataObjects().get(0).getInstance();
            }
            if (entity != null) {
                return EditUIProxyHelper.getPropertyByName(entity, bindFieldName);
            }
        }
        return null;
    }

    public static com.kingdee.bos.metadata.entity.PropertyInfo getBindingProperty(AbstractUIObjectInfo model, ComponentInfo control, String propertyName) {
        if (model instanceof UIObjectInfo) {
            return EditUIProxyHelper.getBindingProperty((UIObjectInfo)model, control, propertyName);
        }
        return EditUIProxyHelper.getBindingProperty((WebUIObjectInfo)model, control, propertyName);
    }

    public static com.kingdee.bos.metadata.entity.PropertyInfo getBindingProperty(WebUIObjectInfo model, ComponentInfo control, String propertyName) {
        EntityObjectInfo entity;
        String bindFieldName;
        if (model == null || control == null || control.getClassType() == null) {
            return null;
        }
        if (!StringUtils.isEmpty((String)propertyName) && !StringUtils.isEmpty((String)(bindFieldName = EditUIProxyHelper.getBindFieldName(control.getPropertyBindings(), propertyName))) && model.getDataObjects() != null && model.getDataObjects().size() > 0 && model.getDataObjects().get(0).getObjectType().equals(MetaDataTypeList.ENTITY.toString()) && (entity = (EntityObjectInfo)model.getDataObjects().get(0).getInstance()) != null) {
            return EditUIProxyHelper.getPropertyByName(entity, bindFieldName);
        }
        return null;
    }

    public static com.kingdee.bos.metadata.entity.PropertyInfo getBindingProperty(AbstractUIObjectInfo model, ComponentInfo control) {
        return EditUIProxyHelper.getBindingProperty((UIObjectInfo)model, control);
    }

    public static com.kingdee.bos.metadata.entity.PropertyInfo getBindingProperty(UIObjectInfo model, ComponentInfo control) {
        return EditUIProxyHelper.getBindingProperty(model, control, false);
    }

    public static com.kingdee.bos.metadata.entity.PropertyInfo getBindingProperty(UIObjectInfo model, ComponentInfo control, boolean isRuntime) {
        if (model == null || control == null || control.getClassType() == null) {
            return null;
        }
        String propertyName = "";
        if ("com.kingdee.bos.ctrl.swing.KDTextField".equalsIgnoreCase(control.getClassType()) || "com.kingdee.bos.ctrl.swing.KDTextArea".equalsIgnoreCase(control.getClassType())) {
            propertyName = "text";
        } else if ("com.kingdee.bos.ctrl.swing.KDMultiLangBox".equalsIgnoreCase(control.getClassType()) || "com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox".equalsIgnoreCase(control.getClassType()) || "com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangArea".equalsIgnoreCase(control.getClassType())) {
            propertyName = "_multiLangItem";
        } else if ("com.kingdee.bos.ctrl.swing.KDFormattedTextField".equalsIgnoreCase(control.getClassType())) {
            propertyName = "value";
        } else if ("com.kingdee.bos.ctrl.swing.KDDatePicker".equalsIgnoreCase(control.getClassType())) {
            propertyName = "value";
        } else if ("com.kingdee.bos.ctrl.swing.KDTimePicker".equalsIgnoreCase(control.getClassType())) {
            propertyName = "value";
        } else if ("com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox".equalsIgnoreCase(control.getClassType())) {
            propertyName = "data";
        } else if ("com.kingdee.bos.ctrl.swing.KDComboBox".equalsIgnoreCase(control.getClassType())) {
            propertyName = "selectedItem";
        } else if ("com.kingdee.bos.ctrl.swing.KDCheckBox".equalsIgnoreCase(control.getClassType())) {
            propertyName = "selected";
        } else if ("com.kingdee.bos.ctrl.kdf.table.KDTable".equalsIgnoreCase(control.getClassType())) {
            propertyName = "userObject";
        } else if ("com.kingdee.bos.ctrl.swing.KDSpinner".equalsIgnoreCase(control.getClassType())) {
            propertyName = "value";
        } else if ("com.kingdee.bos.ctrl.swing.KDFilterTextField".equalsIgnoreCase(control.getClassType())) {
            propertyName = "stringValue";
        }
        if (!StringUtils.isEmpty((String)propertyName)) {
            return EditUIProxyHelper.getBindingProperty(model, control, propertyName, isRuntime);
        }
        return null;
    }
}

