/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ui.bizunitproxy;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.xml.impl.MetaDataPK2;
import com.kingdee.bos.metadata.bizunit.BizDataType;
import com.kingdee.bos.metadata.bizunit.BizFieldCollection;
import com.kingdee.bos.metadata.bizunit.BizFieldInfo;
import com.kingdee.bos.metadata.bizunit.BizFieldViewInfo;
import com.kingdee.bos.metadata.bizunit.BizGroupFieldInfo;
import com.kingdee.bos.metadata.bizunit.BizUnitInfo;
import com.kingdee.bos.metadata.bizunit.ObjectStateType;
import com.kingdee.bos.metadata.query.QueryCtrl;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.ui.ComponentCollection;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.PropertyBindingInfo;
import com.kingdee.bos.metadata.ui.PropertyInfo;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.metadata.util.ContextManager;
import com.kingdee.bos.ui.bizunitproxy.UIProxyHelper;
import com.kingdee.bos.ui.dtp.kdtable.CellInfo;
import com.kingdee.bos.ui.dtp.kdtable.ColumnInfo;
import com.kingdee.bos.ui.dtp.kdtable.HeaderInfo;
import com.kingdee.bos.ui.dtp.kdtable.KDTableDesignerHelper;
import com.kingdee.bos.ui.dtp.kdtable.TableInfo;
import com.kingdee.util.StringUtils;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

public class ListUIProxyHelper {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.ui.bizunitproxy.ListUIProxyHelper");
    private UIProxyHelper uiProxyHelper;

    ListUIProxyHelper(UIProxyHelper uiProxyHelper) {
        this.uiProxyHelper = uiProxyHelper;
    }

    void createKDTableForQuery(UIObjectInfo model, BizUnitInfo bizUnit, String dataObjName) {
        if (model == null || bizUnit == null) {
            return;
        }
        String baseName = dataObjName.substring(0, 1).toUpperCase() + dataObjName.substring(1);
        String tabName = "kdt" + baseName;
        ComponentInfo kdtControl = new ComponentInfo("com.kingdee.bos.ctrl.kdf.table.KDTable");
        kdtControl.setName(tabName);
        Dimension dsize = new Dimension(700, 500);
        kdtControl.setConstraint(new Rectangle(10, 10, dsize.width, dsize.height), false);
        ComponentInfo parent = model.getComponents().get(0);
        parent.addChild(kdtControl);
        BizFieldCollection fields = bizUnit.getFields();
        if (fields == null || fields.size() == 0) {
            return;
        }
        Vector<BizFieldInfo> newBizFields = new Vector<BizFieldInfo>();
        int n = fields.size();
        for (int i = 0; i < n; ++i) {
            BizFieldInfo bizField = fields.get(i);
            if (!bizField.isGenControl() || !ObjectStateType.NEW.equals((Object)bizField.getObjectState())) continue;
            if (bizField instanceof BizGroupFieldInfo) {
                this.uiProxyHelper.visitGroupField((BizGroupFieldInfo)bizField, newBizFields, true, ObjectStateType.NEW, false);
                continue;
            }
            newBizFields.add(bizField);
        }
        BizFieldInfo[] tempFields = new BizFieldInfo[newBizFields.size()];
        System.arraycopy(newBizFields.toArray(), 0, tempFields, 0, newBizFields.size());
        ListUIProxyHelper.bindingKDTableProperty(bizUnit, tempFields, dataObjName, kdtControl);
    }

    void updateKDTableForQuery(UIObjectInfo model, BizUnitInfo bizUnit, String dataObjName, boolean needAdd) {
        if (model == null || bizUnit == null) {
            return;
        }
        BizFieldCollection fields = bizUnit.getFields();
        if (fields == null || fields.size() == 0) {
            return;
        }
        Vector<BizFieldInfo> newBizFields = new Vector<BizFieldInfo>();
        Vector<BizFieldInfo> updBizFields = new Vector<BizFieldInfo>();
        Vector<BizFieldInfo> delBizFields = new Vector<BizFieldInfo>();
        int n = fields.size();
        for (int i = 0; i < n; ++i) {
            BizFieldInfo bizField = fields.get(i);
            if (!bizField.isGenControl()) continue;
            if (bizField instanceof BizGroupFieldInfo) {
                if ((ObjectStateType.DELETING.equals((Object)bizField.getObjectState()) || ObjectStateType.DELETEDCONTROL.equals((Object)bizField.getObjectState())) && (bizField.getEffectUI() & 2) != 0) {
                    delBizFields.add(bizField);
                    continue;
                }
                if (bizUnit.getEntryUI() != null || ((BizGroupFieldInfo)bizField).getQuery() != null) continue;
                this.uiProxyHelper.visitGroupField((BizGroupFieldInfo)bizField, newBizFields, true, ObjectStateType.NEW, false);
                this.uiProxyHelper.visitGroupField((BizGroupFieldInfo)bizField, updBizFields, true, ObjectStateType.CHANGED, false);
                this.uiProxyHelper.visitGroupField((BizGroupFieldInfo)bizField, delBizFields, true, ObjectStateType.DELETING, false);
                continue;
            }
            if ((ObjectStateType.NEW.equals((Object)bizField.getObjectState()) || ObjectStateType.NEWCONTROL.equals((Object)bizField.getObjectState())) && (bizField.getEffectUI() & 2) != 0) {
                newBizFields.add(bizField);
                continue;
            }
            if (ObjectStateType.CHANGED.equals((Object)bizField.getObjectState())) {
                updBizFields.add(bizField);
                continue;
            }
            if (!ObjectStateType.DELETING.equals((Object)bizField.getObjectState()) && !ObjectStateType.DELETEDCONTROL.equals((Object)bizField.getObjectState()) || (bizField.getEffectUI() & 2) == 0) continue;
            delBizFields.add(bizField);
        }
        if (newBizFields.size() == 0 && updBizFields.size() == 0 && delBizFields.size() == 0) {
            return;
        }
        ComponentCollection collection = model.getComponents();
        if (collection == null || collection.size() == 0) {
            return;
        }
        ComponentInfo kdTable = this.uiProxyHelper.findBindingKDTable(collection.get(0), dataObjName);
        if (kdTable == null) {
            if (needAdd) {
                this.createKDTableForQuery(model, bizUnit, dataObjName);
            }
            return;
        }
        PropertyInfo property = kdTable.getProperties().get("formatXml");
        if (property == null) {
            if (needAdd) {
                this.createKDTableForQuery(model, bizUnit, dataObjName);
            }
            return;
        }
        TableInfo tableInfo = KDTableDesignerHelper.getTableInfoFrom(property.getValue());
        BizFieldInfo[] tempFields = new BizFieldInfo[delBizFields.size()];
        System.arraycopy(delBizFields.toArray(), 0, tempFields, 0, delBizFields.size());
        this.uiProxyHelper.delKDTableColumn(model, kdTable, tableInfo, tempFields, false);
        tempFields = new BizFieldInfo[updBizFields.size()];
        System.arraycopy(updBizFields.toArray(), 0, tempFields, 0, updBizFields.size());
        ListUIProxyHelper.updKDTableColumn(bizUnit, kdTable, tableInfo, tempFields, dataObjName);
        tempFields = new BizFieldInfo[newBizFields.size()];
        System.arraycopy(newBizFields.toArray(), 0, tempFields, 0, newBizFields.size());
        ListUIProxyHelper.addKDTableColumn(bizUnit, kdTable, tableInfo, tempFields, dataObjName);
        property.setValue(KDTableDesignerHelper.getXmlFrom(tableInfo));
        property.setOverride(true);
    }

    public static void bindingKDTableProperty(BizUnitInfo bizUnit, BizFieldInfo[] infos, String dataObjName, ComponentInfo kdtControl) {
        TableInfo tableInfo = new TableInfo();
        HeaderInfo headerInfo = new HeaderInfo();
        headerInfo.setName("header");
        tableInfo.addHeader(headerInfo);
        ListUIProxyHelper.addKDTableColumn(bizUnit, kdtControl, tableInfo, infos, dataObjName);
        PropertyInfo propInfo = new PropertyInfo();
        propInfo.setName("formatXml");
        propInfo.setType(String.class.getName());
        propInfo.setMultiLanguage(true);
        propInfo.setValue(KDTableDesignerHelper.getXmlFrom(tableInfo));
        propInfo.setOverride(true);
        kdtControl.getProperties().add(propInfo);
    }

    public static void addKDTableColumn(BizUnitInfo bizUnit, ComponentInfo kdTable, TableInfo tableInfo, BizFieldInfo[] newBizFields, String dataObjName) {
        HeaderInfo headerInfo;
        if (kdTable == null || tableInfo == null || newBizFields == null || StringUtils.isEmpty((String)dataObjName)) {
            return;
        }
        if (tableInfo.getHeaderCount() == 0) {
            headerInfo = new HeaderInfo();
            headerInfo.setName("header");
            tableInfo.addHeader(headerInfo);
        } else {
            headerInfo = (HeaderInfo)tableInfo.getHeaders().get(0);
        }
        for (int i = 0; i < newBizFields.length; ++i) {
            BizFieldInfo field = newBizFields[i];
            String name = field.getQueryFieldName();
            String tempQueryFieldName = field.getQueryFieldName();
            if (StringUtils.isEmpty((String)tempQueryFieldName)) continue;
            String colName = name;
            ColumnInfo column = new ColumnInfo();
            column.setName(colName);
            BizFieldViewInfo fieldView = field.getFieldView();
            if (fieldView != null) {
                column.setHide(!fieldView.isListVisible());
            }
            if (field.getBizDataType() == BizDataType.DECIMAL || field.getBizDataType() == BizDataType.AMOUNT || field.getBizDataType() == BizDataType.PRICE || field.getBizDataType() == BizDataType.QUANTITY) {
                column.setFormatString("&double");
            } else if (field.getBizDataType() == BizDataType.INTEGER) {
                column.setFormatString("&int");
            } else if (field.getBizDataType() == BizDataType.DATE) {
                column.setFormatString("&date");
            } else if (field.getBizDataType() == BizDataType.TIME) {
                column.setFormatString("&time");
            }
            field.setListItemName(colName);
            tableInfo.addColumn(column);
            CellInfo cell = new CellInfo();
            String cellName = field.getAlias();
            if (StringUtils.isEmpty((String)cellName)) {
                cell.setName(name);
            } else {
                cell.setName(cellName);
            }
            cell.setColSpan(0);
            cell.setRowSpan(0);
            headerInfo.addCell(cell);
            PropertyBindingInfo propertyBindingInfo = new PropertyBindingInfo();
            propertyBindingInfo.setPropertyName(colName + ".text");
            propertyBindingInfo.setPropertyType(Object.class.getName());
            propertyBindingInfo.setAccessType(2);
            propertyBindingInfo.setAutoMode(false);
            propertyBindingInfo.setBindingObject(dataObjName);
            propertyBindingInfo.setBingdingField(tempQueryFieldName);
            propertyBindingInfo.setFieldType(String.class.getName());
            propertyBindingInfo.setOverride(true);
            kdTable.getPropertyBindings().add(propertyBindingInfo);
        }
    }

    public static void updKDTableColumn(BizUnitInfo bizUnit, ComponentInfo kdTable, TableInfo tableInfo, BizFieldInfo[] updBizFields, String dataObjName) {
        if (kdTable == null || tableInfo == null || updBizFields == null || StringUtils.isEmpty((String)dataObjName)) {
            return;
        }
        List columns = tableInfo.getColumns();
        for (int i = 0; i < updBizFields.length; ++i) {
            PropertyBindingInfo propertyBindingInfo;
            int[] indexs;
            ColumnInfo column;
            BizFieldInfo field = updBizFields[i];
            String name = field.getListItemName();
            String oldColName = name;
            if (StringUtils.isEmpty((String)oldColName) || (column = UIProxyHelper.findColumn(columns, oldColName, indexs = new int[]{-1})) == null) continue;
            String text = field.getListLabelText();
            if (StringUtils.isEmpty((String)text)) {
                text = field.getAlias();
            }
            if (tableInfo.getHeaderCount() > 0) {
                HeaderInfo headerInfo = (HeaderInfo)tableInfo.getHeaders().get(0);
                ((CellInfo)headerInfo.getCells().get(columns.indexOf(column))).setName(text);
            }
            if ((propertyBindingInfo = kdTable.getPropertyBindings().get(oldColName + ".text")) != null) {
                propertyBindingInfo.setBindingObject(dataObjName);
                propertyBindingInfo.setBingdingField(field.getQueryFieldName());
                continue;
            }
            String tempFieldName = field.getQueryFieldName();
            if (StringUtils.isEmpty((String)tempFieldName)) continue;
            propertyBindingInfo = new PropertyBindingInfo();
            propertyBindingInfo.setPropertyName(oldColName + ".text");
            propertyBindingInfo.setPropertyType(Object.class.getName());
            propertyBindingInfo.setAccessType(2);
            propertyBindingInfo.setAutoMode(false);
            propertyBindingInfo.setBindingObject(dataObjName);
            propertyBindingInfo.setBingdingField(tempFieldName);
            propertyBindingInfo.setFieldType(String.class.getName());
            propertyBindingInfo.setOverride(true);
            kdTable.getPropertyBindings().add(propertyBindingInfo);
        }
    }

    public static QueryInfo getQueryInfo(String queryPK) {
        if (queryPK == null || queryPK.trim().length() < 1) {
            return null;
        }
        QueryCtrl queryCtrl = new QueryCtrl(ContextManager.getContext());
        try {
            return queryCtrl.getValue(MetaDataPK2.create(queryPK));
        }
        catch (BOSException e) {
            logger.error((Object)("query get error. pk" + queryPK), (Throwable)e);
            return null;
        }
    }
}

