/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ui.bizunitproxy;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bizrule.ConditionRuleCollection;
import com.kingdee.bos.metadata.bizrule.common.RuleCollection;
import com.kingdee.bos.metadata.bizunit.BizFieldCollection;
import com.kingdee.bos.metadata.bizunit.BizFieldInfo;
import com.kingdee.bos.metadata.bizunit.BizFieldViewInfo;
import com.kingdee.bos.metadata.bizunit.BizGroupFieldInfo;
import com.kingdee.bos.metadata.bizunit.BizMethodCollection;
import com.kingdee.bos.metadata.bizunit.BizMethodInfo;
import com.kingdee.bos.metadata.bizunit.BizTemplateInfo;
import com.kingdee.bos.metadata.bizunit.BizUnitInfo;
import com.kingdee.bos.metadata.bizunit.HorizontalAlignmentType;
import com.kingdee.bos.metadata.bizunit.ObjectStateType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.query.JoinQueryInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.metadata.ui.AbstractUIObjectInfo;
import com.kingdee.bos.metadata.ui.ActionCollection;
import com.kingdee.bos.metadata.ui.ActionExtendPropertyHelper;
import com.kingdee.bos.metadata.ui.ActionInfo;
import com.kingdee.bos.metadata.ui.ComponentCollection;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.DataObjectCollection;
import com.kingdee.bos.metadata.ui.DataObjectInfo;
import com.kingdee.bos.metadata.ui.LayoutInfo;
import com.kingdee.bos.metadata.ui.PropertyBindingCollection;
import com.kingdee.bos.metadata.ui.PropertyBindingInfo;
import com.kingdee.bos.metadata.ui.PropertyInfo;
import com.kingdee.bos.metadata.ui.StatusCollection;
import com.kingdee.bos.metadata.ui.StatusInfo;
import com.kingdee.bos.metadata.ui.StatusItemCollection;
import com.kingdee.bos.metadata.ui.StatusItemInfo;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.metadata.webui.WebUIObjectInfo;
import com.kingdee.bos.ui.bizunitproxy.EditUIProxyHelper;
import com.kingdee.bos.ui.bizunitproxy.ListUIProxyHelper;
import com.kingdee.bos.ui.bizunitproxy.ServiceItemConstants;
import com.kingdee.bos.ui.dtp.ActionServicePropertyHelper;
import com.kingdee.bos.ui.dtp.ControlConstant;
import com.kingdee.bos.ui.dtp.EventInfoHelper;
import com.kingdee.bos.ui.dtp.ServiceItem;
import com.kingdee.bos.ui.dtp.kdlayout.KDLayoutConstraint;
import com.kingdee.bos.ui.dtp.kdtable.CellInfo;
import com.kingdee.bos.ui.dtp.kdtable.ColumnInfo;
import com.kingdee.bos.ui.dtp.kdtable.HeaderInfo;
import com.kingdee.bos.ui.dtp.kdtable.TableInfo;
import com.kingdee.bos.ui.dtp.model.layout.KDLayout;
import com.kingdee.bos.ui.dtp.model.layout.Layout;
import com.kingdee.bos.ui.dtp.model.layout.LayoutConverter;
import com.kingdee.bos.ui.dtp.model.layout.SmartLayout;
import com.kingdee.bos.ui.dtp.model.layout.WebLayout;
import com.kingdee.bos.ui.dtp.model.layout.XYLayout;
import com.kingdee.bos.ui.dtp.smartlayout.SmartLayoutData;
import com.kingdee.bos.ui.dtp.weblayout.WebLayoutData;
import com.kingdee.util.StringUtils;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

public class UIProxyHelper {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.ui.bizunitproxy.UIProxyHelper");
    private static UIProxyHelper instance;
    private EditUIProxyHelper editUIInstance;
    private ListUIProxyHelper listUIInstance;
    private Hashtable horizontalAlignmentHash = new Hashtable();
    private Hashtable verticalAlignmentHash = new Hashtable();
    public static final String INTFORMAT = "&int";
    public static final String DOUBLEFORMAT = "&double";
    public static final String CURRENCYFORMAT = "&currency";
    public static final String DATEFORMAT = "&date";
    public static final String TIMEFORMAT = "&time";
    public static final String DATETIMEFORMAT = "&datetime";

    private UIProxyHelper() {
        this.initHorizontalAlignmentHash();
        this.initVerticalAlignmentHash();
        this.listUIInstance = new ListUIProxyHelper(this);
        this.editUIInstance = new EditUIProxyHelper(this);
    }

    private void initHorizontalAlignmentHash() {
        this.horizontalAlignmentHash.put(HorizontalAlignmentType.Center, new Integer(0));
        this.horizontalAlignmentHash.put(HorizontalAlignmentType.Left, new Integer(2));
        this.horizontalAlignmentHash.put(HorizontalAlignmentType.Right, new Integer(4));
        this.horizontalAlignmentHash.put(HorizontalAlignmentType.Leading, new Integer(10));
        this.horizontalAlignmentHash.put(HorizontalAlignmentType.Trailing, new Integer(11));
    }

    private void initVerticalAlignmentHash() {
    }

    public int getSwingHorizontalAlignment(HorizontalAlignmentType type) {
        Integer value = (Integer)this.horizontalAlignmentHash.get((Object)type);
        if (value != null) {
            return value;
        }
        return -1;
    }

    public static UIProxyHelper getInstance() {
        if (instance == null) {
            instance = new UIProxyHelper();
        }
        return instance;
    }

    public void initUIObjectInfo(UIObjectInfo model) {
        if (model == null) {
            return;
        }
        ComponentCollection collection = model.getComponents();
        if (collection.size() != 0) {
            return;
        }
        ComponentCollection components = new ComponentCollection();
        ComponentInfo mainPanel = new ComponentInfo("com.kingdee.bos.ctrl.swing.KDPanel");
        mainPanel.setName(model.getName());
        mainPanel.setConstraint(new Rectangle(0, 0, 1016, 600), false);
        mainPanel.setContainer(true);
        mainPanel.setLayoutInfo(LayoutConverter.convertToInfo(new XYLayout()));
        components.add(mainPanel);
        ComponentInfo toolbar = new ComponentInfo("com.kingdee.bos.ctrl.swing.KDToolBar");
        toolbar.setName(model.getName() + "_toolbar");
        toolbar.setConstraint(new Rectangle(0, 0, 1016, 30), false);
        toolbar.setContainer(true);
        components.add(toolbar);
        ComponentInfo menubar = new ComponentInfo("com.kingdee.bos.ctrl.swing.KDMenuBar");
        menubar.setName(model.getName() + "_menubar");
        menubar.setConstraint(new Rectangle(0, 0, 1016, 28), false);
        menubar.setContainer(true);
        components.add(menubar);
        model.setComponents(components);
    }

    public void overrideDataObject(DataObjectInfo dataObj, BizUnitInfo bizUnit, boolean isQuery) {
        if (dataObj == null || bizUnit == null) {
            return;
        }
        if (isQuery) {
            JoinQueryInfo query = bizUnit.getQuery();
            this.overrideDataObjectForQuery(dataObj, query);
        } else {
            EntityObjectInfo entity = bizUnit.getEntity();
            this.overrideDataObjectForEntity(dataObj, entity);
        }
    }

    private void overrideDataObjectForQuery(DataObjectInfo dataObj, QueryInfo queryInfo) {
        if (dataObj == null || queryInfo == null) {
            return;
        }
        String type = "";
        if (!StringUtils.isEmpty((String)queryInfo.getPackage())) {
            type = queryInfo.getPackage() + ".";
        }
        type = type + queryInfo.getName();
        dataObj.setType(type);
        dataObj.setOverride(true);
        dataObj.setWriteCode(true);
    }

    private void overrideDataObjectForEntity(DataObjectInfo dataObj, EntityObjectInfo entityInfo) {
        if (dataObj == null || entityInfo == null) {
            return;
        }
        String type = "";
        if (!StringUtils.isEmpty((String)entityInfo.getPackage())) {
            type = entityInfo.getPackage() + ".";
        }
        type = type + entityInfo.getName();
        dataObj.setType(type);
        dataObj.setOverride(true);
        dataObj.setWriteCode(true);
    }

    public String bindingDataObject(UIObjectInfo model, BizUnitInfo bizUnit, boolean isQuery) {
        if (model == null || bizUnit == null) {
            return null;
        }
        if (isQuery) {
            JoinQueryInfo query = bizUnit.getQuery();
            return this.bindingDataObjectForQuery(model, query);
        }
        EntityObjectInfo entity = bizUnit.getEntity();
        return this.bindingDataObjectForEntity(model, entity);
    }

    private String bindingDataObjectForQuery(UIObjectInfo model, QueryInfo queryInfo) {
        if (model == null || queryInfo == null) {
            return null;
        }
        DataObjectInfo doInfo = new DataObjectInfo();
        String doName = "query" + queryInfo.getName();
        doInfo.setName(doName);
        String type = "";
        if (!StringUtils.isEmpty((String)queryInfo.getPackage())) {
            type = queryInfo.getPackage() + ".";
        }
        type = type + queryInfo.getName();
        doInfo.setType(type);
        doInfo.setObjectType(queryInfo.getBOSType().toString());
        model.getDataObjects().add(doInfo);
        return doName;
    }

    private String bindingDataObjectForEntity(UIObjectInfo model, EntityObjectInfo entityInfo) {
        DataObjectInfo doInfo;
        if (model == null || entityInfo == null) {
            return null;
        }
        String doName = "";
        if (model.getDataObjects().size() > 0) {
            doInfo = model.getDataObjects().get(0);
        } else {
            doInfo = new DataObjectInfo();
            model.getDataObjects().add(doInfo);
        }
        doName = "entity" + entityInfo.getName();
        doInfo.setName(doName);
        String type = "";
        if (!StringUtils.isEmpty((String)entityInfo.getPackage())) {
            type = entityInfo.getPackage() + ".";
        }
        type = type + entityInfo.getName();
        doInfo.setType(type);
        doInfo.setObjectType(entityInfo.getBOSType().toString());
        doInfo.setHerited(true);
        doInfo.setOverride(true);
        return doName;
    }

    public String findDataObjectName(UIObjectInfo model, BizUnitInfo bizUnit, boolean isQuery) {
        DataObjectInfo dataObject = this.findDataObject(model, bizUnit, isQuery);
        if (dataObject != null) {
            return dataObject.getName();
        }
        return null;
    }

    public DataObjectInfo findDataObject(UIObjectInfo model, BizUnitInfo bizUnit, boolean isQuery) {
        if (model == null || bizUnit == null) {
            return null;
        }
        AbstractMetaDataValue metaData = isQuery ? bizUnit.getQuery() : bizUnit.getEntity();
        if (metaData == null) {
            return null;
        }
        String type = "";
        if (!StringUtils.isEmpty((String)metaData.getPackage())) {
            type = metaData.getPackage() + ".";
        }
        type = type + metaData.getName();
        DataObjectCollection collection = model.getDataObjects();
        int j = collection.size();
        for (int i = 0; i < j; ++i) {
            DataObjectInfo dataObj = collection.get(i);
            if (!type.equals(dataObj.getType()) || !metaData.getBOSType().toString().equals(dataObj.getObjectType())) continue;
            return dataObj;
        }
        return null;
    }

    public void createKDTableForQuery(UIObjectInfo model, BizUnitInfo bizUnit, String dataObjName) {
        this.initUIObjectInfo(model);
        this.listUIInstance.createKDTableForQuery(model, bizUnit, dataObjName);
    }

    public void updateKDTableForQuery(UIObjectInfo model, BizUnitInfo bizUnit, String dataObjName, boolean needAdd) {
        this.listUIInstance.updateKDTableForQuery(model, bizUnit, dataObjName, needAdd);
    }

    void visitGroupField(BizGroupFieldInfo groupField, Vector bizFields, boolean checkState, ObjectStateType state, boolean recursive) {
        if (groupField == null || bizFields == null) {
            return;
        }
        if (checkState) assert (state != null);
        BizFieldCollection collection = groupField.getFields();
        if (collection == null || collection.size() == 0) {
            return;
        }
        int j = collection.size();
        for (int i = 0; i < j; ++i) {
            BizFieldInfo bizField = collection.get(i);
            if (!checkState || !state.equals((Object)bizField.getObjectState()) || !bizField.isGenControl()) continue;
            if (bizField instanceof BizGroupFieldInfo) {
                if (!recursive) continue;
                this.visitGroupField((BizGroupFieldInfo)bizField, bizFields, checkState, state, recursive);
                continue;
            }
            bizFields.add(bizField);
        }
    }

    public void delKDTableColumn(UIObjectInfo model, ComponentInfo kdTable, TableInfo tableInfo, BizFieldInfo[] delBizFields, boolean isEntity) {
        if (kdTable == null || tableInfo == null || delBizFields == null) {
            return;
        }
        HeaderInfo headerInfo = null;
        if (tableInfo.getHeaderCount() != 0) {
            headerInfo = (HeaderInfo)tableInfo.getHeaders().get(0);
        }
        for (int i = 0; i < delBizFields.length; ++i) {
            int[] indexs;
            List columns;
            BizFieldInfo field = delBizFields[i];
            String colName = null;
            if (!isEntity && field instanceof BizGroupFieldInfo) {
                if (StringUtils.isEmpty((String)field.getPropertyName())) continue;
                String preColName = field.getPropertyName() + ".";
                columns = tableInfo.getColumns();
                for (int j = columns.size() - 1; j >= 0; --j) {
                    colName = ((ColumnInfo)columns.get(j)).getName();
                    if (StringUtils.isEmpty((String)colName) || !colName.startsWith(preColName)) continue;
                    tableInfo.removeColumn((ColumnInfo)columns.get(j));
                    if (headerInfo != null && headerInfo.getCellCount() > j) {
                        headerInfo.removeCell((CellInfo)headerInfo.getCells().get(j));
                    }
                    kdTable.getPropertyBindings().removeObject(colName + ".text");
                }
                continue;
            }
            colName = isEntity ? field.getControlName() : field.getListItemName();
            columns = tableInfo.getColumns();
            ColumnInfo column = UIProxyHelper.findColumn(columns, colName, indexs = new int[]{-1});
            if (column == null) continue;
            tableInfo.removeColumn(column);
            if (headerInfo != null && headerInfo.getCellCount() > indexs[0]) {
                headerInfo.removeCell((CellInfo)headerInfo.getCells().get(indexs[0]));
            }
            kdTable.getPropertyBindings().removeObject(colName + ".text");
            String controlName = kdTable.getName() + "." + column.getName();
            if (StringUtils.isEmpty((String)controlName)) continue;
            StatusCollection statuses = model.getStatuses();
            int m = statuses.size();
            for (int j = 0; j < m; ++j) {
                StatusInfo status = statuses.get(j);
                StatusItemCollection items = status.getStatusItems();
                for (int k = items.size() - 1; k >= 0; --k) {
                    StatusItemInfo statusItem = items.get(k);
                    if (!controlName.equals(statusItem.getName())) continue;
                    items.removeObject(k);
                }
            }
        }
    }

    public static ColumnInfo findColumn(List columns, String columnName, int[] indexs) {
        if (columns == null || columns.isEmpty() || StringUtils.isEmpty((String)columnName)) {
            return null;
        }
        ColumnInfo colInfo = null;
        Iterator iter = columns.iterator();
        indexs[0] = -1;
        while (iter.hasNext()) {
            indexs[0] = indexs[0] + 1;
            colInfo = (ColumnInfo)iter.next();
            if (!columnName.equals(colInfo.getName())) continue;
            return colInfo;
        }
        return null;
    }

    ComponentInfo findBindingKDTable(ComponentInfo panel, String dataObjName) {
        ComponentInfo bindingKDTable = null;
        ComponentCollection children = panel.getComponents();
        int n = children.size();
        for (int m = 0; m < n; ++m) {
            ComponentInfo componentInfo = children.get(m);
            if ("com.kingdee.bos.ctrl.kdf.table.KDTable".equals(componentInfo.getClassType())) {
                PropertyBindingCollection propBindingCollection = componentInfo.getPropertyBindings();
                int l = propBindingCollection.size();
                for (int k = 0; k < l; ++k) {
                    PropertyBindingInfo propBinding = propBindingCollection.get(k);
                    if (!propBinding.getBindingObject().equals(dataObjName)) continue;
                    bindingKDTable = componentInfo;
                    return bindingKDTable;
                }
            }
            if ((bindingKDTable = this.findBindingKDTable(componentInfo, dataObjName)) == null) continue;
            return bindingKDTable;
        }
        return bindingKDTable;
    }

    ComponentInfo findFirstTabbedPane(ComponentInfo panel) {
        ComponentInfo componentInfo;
        int m;
        if (panel == null) {
            return null;
        }
        ComponentCollection children = panel.getComponents();
        int n = children.size();
        for (m = 0; m < n; ++m) {
            componentInfo = children.get(m);
            if (!"com.kingdee.bos.ctrl.swing.KDTabbedPane".equals(componentInfo.getClassType())) continue;
            return componentInfo;
        }
        n = children.size();
        for (m = 0; m < n; ++m) {
            componentInfo = children.get(m);
            ComponentInfo control = this.findFirstTabbedPane(componentInfo);
            if (control == null) continue;
            return control;
        }
        return null;
    }

    public static ComponentInfo findControlByName(UIObjectInfo model, String controlName) {
        if (model == null || StringUtils.isEmpty((String)controlName)) {
            return null;
        }
        ComponentCollection collection = model.getComponents();
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        int j = collection.size();
        for (int i = 0; i < j; ++i) {
            ComponentInfo control = UIProxyHelper.findControlByName(collection.get(i), controlName);
            if (control == null) continue;
            return control;
        }
        return null;
    }

    public static ComponentInfo findControlByName(WebUIObjectInfo model, String controlName) {
        if (model == null || StringUtils.isEmpty((String)controlName)) {
            return null;
        }
        ComponentCollection collection = model.getComponents();
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        int j = collection.size();
        for (int i = 0; i < j; ++i) {
            ComponentInfo control = UIProxyHelper.findControlByName(collection.get(i), controlName);
            if (control == null) continue;
            return control;
        }
        return null;
    }

    public static ComponentInfo findControlByName(ComponentInfo panel, String controlName) {
        ComponentInfo componentInfo;
        int m;
        if (StringUtils.isEmpty((String)controlName)) {
            return null;
        }
        if (controlName.equals(panel.getName())) {
            return panel;
        }
        ComponentCollection children = panel.getComponents();
        int n = children.size();
        for (m = 0; m < n; ++m) {
            componentInfo = children.get(m);
            if (!controlName.equals(componentInfo.getName())) continue;
            return componentInfo;
        }
        n = children.size();
        for (m = 0; m < n; ++m) {
            componentInfo = children.get(m);
            ComponentInfo control = UIProxyHelper.findControlByName(componentInfo, controlName);
            if (control == null) continue;
            return control;
        }
        return null;
    }

    ComponentInfo findParentControl(ComponentInfo fromPanel, BizFieldInfo bizFieldInfo) {
        BizFieldViewInfo viewInfo = bizFieldInfo.getFieldView();
        if (viewInfo == null) {
            return null;
        }
        BizFieldInfo parentField = bizFieldInfo.getParent();
        ComponentInfo container = null;
        if (parentField != null) {
            container = UIProxyHelper.findControlByName(fromPanel, parentField.getControlName());
        }
        return container;
    }

    boolean deleteControlByName(ComponentInfo panel, String controlName) {
        if (StringUtils.isEmpty((String)controlName)) {
            return false;
        }
        ComponentInfo control = UIProxyHelper.findControlByName(panel, controlName);
        if (control != null) {
            ComponentInfo parent = control.getParent();
            if (parent == null) {
                return false;
            }
            control.setParent(null);
            return parent.getComponents().remove(control);
        }
        return false;
    }

    public void createEditUI(UIObjectInfo model, BizUnitInfo bizUnit, String dataObjName) {
        this.initUIObjectInfo(model);
        this.editUIInstance.createEditUI(model, bizUnit, dataObjName);
    }

    public void updateEditUI(UIObjectInfo model, BizUnitInfo bizUnit, String dataObjName) {
        this.editUIInstance.updateEditUI(model, bizUnit, dataObjName);
    }

    public void updateBizMethod(UIObjectInfo model, BizUnitInfo bizUnit, boolean isEditUI) {
        if (model == null || bizUnit == null) {
            return;
        }
        BizMethodCollection methods = bizUnit.getMethods();
        if (methods == null || methods.isEmpty()) {
            return;
        }
        Vector<BizMethodInfo> newMethods = new Vector<BizMethodInfo>();
        Vector<BizMethodInfo> updMethods = new Vector<BizMethodInfo>();
        Vector<BizMethodInfo> delMethods = new Vector<BizMethodInfo>();
        int j = methods.size();
        for (int i = 0; i < j; ++i) {
            BizMethodInfo methodInfo = methods.get(i);
            if (ObjectStateType.NEW.equals((Object)methodInfo.getObjectState()) || StringUtils.isEmpty((String)methodInfo.getActionName()) && isEditUI && "generateEditUIAction".equalsIgnoreCase(methodInfo.getGenerateUIAction()) && "generateAllUIAction".equalsIgnoreCase(methodInfo.getGenerateUIAction()) || StringUtils.isEmpty((String)methodInfo.getListActionName()) && !isEditUI && "generateListUIAction".equalsIgnoreCase(methodInfo.getGenerateUIAction()) && "generateAllUIAction".equalsIgnoreCase(methodInfo.getGenerateUIAction())) {
                newMethods.add(methodInfo);
                continue;
            }
            if (ObjectStateType.DELETING.equals((Object)methodInfo.getObjectState())) {
                delMethods.add(methodInfo);
                continue;
            }
            if (!ObjectStateType.CHANGED.equals((Object)methodInfo.getObjectState())) continue;
            updMethods.add(methodInfo);
        }
        BizMethodInfo[] tempMethods = new BizMethodInfo[delMethods.size()];
        System.arraycopy(delMethods.toArray(), 0, tempMethods, 0, delMethods.size());
        this.deleteAction(model, tempMethods, isEditUI);
        tempMethods = new BizMethodInfo[newMethods.size()];
        System.arraycopy(newMethods.toArray(), 0, tempMethods, 0, newMethods.size());
        this.createAction(model, tempMethods, isEditUI);
        tempMethods = new BizMethodInfo[updMethods.size()];
        System.arraycopy(updMethods.toArray(), 0, tempMethods, 0, updMethods.size());
        this.updateAction(model, tempMethods, isEditUI);
    }

    public void createEditTemplateUI(UIObjectInfo model, BizTemplateInfo template, String dataObjName) {
        this.editUIInstance.createEditUI(model, template, dataObjName);
    }

    void updateComponentRules(UIObjectInfo model, ComponentInfo component, BizFieldInfo bizField) {
        ConditionRuleCollection rules = bizField.getConditionRules();
        if (component == null || rules == null) {
            return;
        }
        RuleCollection collection = new RuleCollection();
        if (model.getRuleSet() != null) {
            int j = rules.size();
            for (int i = 0; i < j; ++i) {
                collection.add(rules.get(i));
            }
            if (bizField instanceof BizGroupFieldInfo) {
                BizGroupFieldInfo groupField = (BizGroupFieldInfo)bizField;
                int n = groupField.getFields().size();
                for (int i = 0; i < n; ++i) {
                    BizFieldInfo subField = groupField.getFields().get(i);
                    if (ObjectStateType.DELETING.equals((Object)subField.getObjectState()) || ObjectStateType.DELETED.equals((Object)subField.getObjectState())) continue;
                    rules = subField.getConditionRules();
                    int m = rules.size();
                    for (int j2 = 0; j2 < m; ++j2) {
                        collection.add(rules.get(j2));
                    }
                }
            }
        }
        component.setRules(collection);
    }

    public void createListTemplateUI(UIObjectInfo model, BizTemplateInfo template, String dataObjName) {
        this.initUIObjectInfo(model);
        this.listUIInstance.createKDTableForQuery(model, template, dataObjName);
    }

    private void createAction(UIObjectInfo model, BizMethodInfo[] methods, boolean isEditUI) {
        assert (model != null && methods != null);
        if (methods.length == 0) {
            return;
        }
        ActionCollection actions = model.getActions();
        for (int i = 0; i < methods.length; ++i) {
            String tempStr;
            BizMethodInfo bizMethod = methods[i];
            String generateUIAction = bizMethod.getGenerateUIAction();
            if (!"generateAllUIAction".equalsIgnoreCase(generateUIAction) && (!isEditUI || !"generateEditUIAction".equalsIgnoreCase(generateUIAction)) && (isEditUI || !"generateListUIAction".equalsIgnoreCase(generateUIAction)) || StringUtils.isEmpty((String)(tempStr = methods[i].getName()))) continue;
            if (tempStr.length() < "action".length() || !"action".equalsIgnoreCase(tempStr.substring(0, "action".length()))) {
                tempStr = "action" + StringUtils.headCharUpperCase((String)tempStr);
            }
            ActionInfo action = new ActionInfo();
            action.setName(StringUtils.headCharLowerCase((String)tempStr));
            action.setClassName(StringUtils.headCharUpperCase((String)tempStr));
            action.setShortDesc(methods[i].getDescription());
            action.setControlName(methods[i].getAlias());
            action.setEnabled(true);
            action.setBindWorkFlow(methods[i].isBindWorkFlow());
            if (model.getDataObjects().size() > 0) {
                IObjectValue objVal = model.getDataObjects().get(0).getInstance();
                if (objVal != null) {
                    String actionCode;
                    if (objVal instanceof EntityObjectInfo && !StringUtils.isEmpty((String)(actionCode = ((EntityObjectInfo)objVal).getBusinessImplFactory()))) {
                        actionCode = actionCode + ".getRemoteInstance()." + methods[i].getMethodName() + "(editData);";
                        action.setActionPerformed(actionCode);
                    }
                } else {
                    objVal = model.getDataObjects().get(0).getInstanceOfQueryForBim();
                    if (objVal != null) {
                        try {
                            String actionCode;
                            EntityObjectInfo entity;
                            if (((JoinQueryInfo)objVal).getMainObject() != null && ((JoinQueryInfo)objVal).getMainObject() instanceof SubEntityInfo && (entity = ((SubEntityInfo)((JoinQueryInfo)objVal).getMainObject()).getEntityRef()) != null && !StringUtils.isEmpty((String)(actionCode = entity.getBusinessImplFactory()))) {
                                actionCode = "if (getSelectedKeyValue() == null) return;\n";
                                actionCode = actionCode + entity.getBusinessImplName() + "Info editData = (" + entity.getBusinessImplName() + "Info)getBizInterface().getValue(new com.kingdee.bos.dao.ormapping.ObjectUuidPK(BOSUuid.read(getSelectedKeyValue())));\n";
                                actionCode = actionCode + entity.getBusinessImplFactory() + ".getRemoteInstance()." + methods[i].getMethodName() + "(editData);";
                                action.setActionPerformed(actionCode);
                            }
                        }
                        catch (BOSException entity) {
                            // empty catch block
                        }
                    }
                }
            }
            ActionExtendPropertyHelper actionHelper = new ActionExtendPropertyHelper(action.getActionExtendProperty());
            actionHelper.setValue("isObjectUpdateLock", String.valueOf(methods[i].isObjectUpdateLock()));
            String mutexValue = methods[i].getMutexValue();
            if (!StringUtils.isEmpty((String)mutexValue)) {
                actionHelper.setValue("Mutex", mutexValue);
            } else {
                actionHelper.removeItem("Mutex");
            }
            actionHelper.setValue("userDefined", String.valueOf(methods[i].isUserDefined()));
            actionHelper.setValue("canForewarn", "true");
            ArrayList<ServiceItem> serviceList = new ArrayList<ServiceItem>();
            serviceList.add(ServiceItemConstants.PermissionService);
            serviceList.add(ServiceItemConstants.ForewarnService);
            if (!StringUtils.isEmpty((String)mutexValue)) {
                serviceList.add(ServiceItemConstants.MutexService);
            }
            if (methods[i].isBindWorkFlow()) {
                serviceList.add(ServiceItemConstants.WorkFlowService);
            }
            action.setServices(ActionServicePropertyHelper.toXmlString(serviceList));
            actions.add(action);
            if (isEditUI) {
                methods[i].setActionName(action.getName());
                methods[i].setActionClassName(action.getClassName());
            } else {
                methods[i].setListActionName(action.getName());
                methods[i].setListActionClassName(action.getClassName());
            }
            if (isEditUI) {
                this.updateActionRules(model, action, methods[i].getConditionRules());
            }
            if (methods[i].isGenMenuItem()) {
                this.createMenuItemByAction(model, action, methods[i]);
            }
            if (methods[i].isGenToolBarButton()) {
                this.createToolbarBtnByAction(model, action, methods[i]);
            }
            if (isEditUI) {
                String bizStatusFieldValue;
                if (methods[i].getBizStatusFieldValue() != null) {
                    actionHelper.setValue("BizStatusFieldValue", methods[i].getBizStatusFieldValue().getName());
                } else if (action.getExtendedProperty("BizStatusFieldValue") != null && !StringUtils.isEmpty((String)actionHelper.getValue(bizStatusFieldValue = action.getExtendedProperty("BizStatusFieldValue")))) {
                    actionHelper.removeItem("BizStatusFieldValue");
                }
            }
            action.setActionExtendProperty(actionHelper.toXmlString());
        }
    }

    private ComponentInfo createMenuItemByAction(UIObjectInfo model, ActionInfo action, BizMethodInfo method) {
        ComponentInfo menu = UIProxyHelper.findControlByName(model, "bizMenu");
        if (menu == null) {
            menu = this.createBizMethodMenu(model);
        }
        if (menu == null) {
            return null;
        }
        ComponentInfo bizMenuItem = new ComponentInfo("com.kingdee.bos.ctrl.swing.KDMenuItem");
        bizMenuItem.setName(ControlConstant.getControlNamePrefix("com.kingdee.bos.ctrl.swing.KDMenuItem") + StringUtils.headCharUpperCase((String)action.getName()));
        menu.addChild(bizMenuItem);
        PropertyInfo prop = new PropertyInfo();
        prop.setName("action");
        prop.setType("javax.swing.Action");
        prop.setMultiLanguage(false);
        prop.setValue(action.getName());
        bizMenuItem.getProperties().add(prop);
        method.setMenuItemName(bizMenuItem.getName());
        return bizMenuItem;
    }

    private ComponentInfo createToolbarBtnByAction(UIObjectInfo model, ActionInfo action, BizMethodInfo method) {
        ComponentInfo toolBar;
        try {
            toolBar = model.getComponents().get(1);
        }
        catch (Exception ex) {
            return null;
        }
        ComponentInfo btn = new ComponentInfo("com.kingdee.bos.ctrl.swing.KDWorkButton");
        btn.setName(ControlConstant.getControlNamePrefix("com.kingdee.bos.ctrl.swing.KDWorkButton") + StringUtils.headCharUpperCase((String)action.getName()));
        toolBar.addChild(btn);
        PropertyInfo prop = new PropertyInfo();
        prop.setName("action");
        prop.setType("javax.swing.Action");
        prop.setMultiLanguage(false);
        prop.setValue(action.getName());
        btn.getProperties().add(prop);
        method.setToolBarButtonName(btn.getName());
        return btn;
    }

    private ComponentInfo createBizMethodMenu(UIObjectInfo model) {
        ComponentInfo menuBar;
        if (model == null) {
            return null;
        }
        try {
            menuBar = model.getComponents().get(2);
        }
        catch (Exception ex) {
            return null;
        }
        ComponentInfo bizMenu = new ComponentInfo("com.kingdee.bos.ctrl.swing.KDMenu");
        bizMenu.setName("bizMenu");
        PropertyInfo prop = new PropertyInfo();
        prop.setName("text");
        prop.setType(String.class.getName());
        prop.setMultiLanguage(true);
        prop.setValue("\u81ea\u5b9a\u4e49\u83dc\u5355");
        bizMenu.getProperties().add(prop);
        menuBar.addChild(bizMenu);
        return bizMenu;
    }

    private void updateActionRules(UIObjectInfo model, ActionInfo action, ConditionRuleCollection rules) {
        if (action == null || rules == null) {
            return;
        }
        RuleCollection collection = new RuleCollection();
        if (model.getRuleSet() != null) {
            int j = rules.size();
            for (int i = 0; i < j; ++i) {
                collection.add(rules.get(i));
            }
        }
        action.setRules(collection);
    }

    private void deleteAction(UIObjectInfo model, BizMethodInfo[] methods, boolean isEditUI) {
        assert (model != null && methods != null);
        if (methods.length == 0) {
            return;
        }
        ActionCollection actions = model.getActions();
        for (int i = 0; i < methods.length; ++i) {
            String tempStr = isEditUI ? methods[i].getActionName() : methods[i].getListActionName();
            if (StringUtils.isEmpty((String)tempStr)) continue;
            boolean ret = actions.removeActionByName(tempStr = StringUtils.headCharLowerCase((String)tempStr));
            if (ret) {
                actions.deleteActionProp(model.getComponents(), tempStr);
                actions.deleteActionStatus(model.getStatuses(), tempStr);
            }
            if (isEditUI) {
                methods[i].setActionName(null);
            } else {
                methods[i].setListActionName(null);
            }
            this.deleteMenuItemByAction(model, methods[i].getMenuItemName());
            this.deleteToolbarBtnByAction(model, methods[i].getToolBarButtonName());
        }
    }

    private void deleteMenuItemByAction(UIObjectInfo model, String menuItemName) {
        ComponentInfo menu = UIProxyHelper.findControlByName(model, "bizMenu");
        if (menu == null) {
            return;
        }
        this.deleteControlByName(menu, menuItemName);
    }

    private void deleteToolbarBtnByAction(UIObjectInfo model, String btnName) {
        ComponentInfo toolbar;
        try {
            toolbar = model.getComponents().get(1);
        }
        catch (Exception ex) {
            return;
        }
        this.deleteControlByName(toolbar, btnName);
    }

    private void updateAction(UIObjectInfo model, BizMethodInfo[] methods, boolean isEditUI) {
        assert (model != null && methods != null);
        if (methods.length == 0) {
            return;
        }
        ActionCollection actions = model.getActions();
        for (int i = 0; i < methods.length; ++i) {
            String tempStr = isEditUI ? methods[i].getActionName() : methods[i].getListActionName();
            if (StringUtils.isEmpty((String)tempStr)) continue;
            ActionInfo action = actions.getActionByName(StringUtils.headCharLowerCase((String)tempStr));
            if (action == null) {
                action = new ActionInfo();
                action.setName(StringUtils.headCharLowerCase((String)tempStr));
                actions.add(action);
            }
            action.setClassName(StringUtils.headCharUpperCase((String)tempStr));
            action.setShortDesc(methods[i].getDescription());
            action.setControlName(methods[i].getAlias());
            action.setEnabled(true);
            action.setBindWorkFlow(methods[i].isBindWorkFlow());
            ActionExtendPropertyHelper actionHelper = new ActionExtendPropertyHelper(action.getActionExtendProperty());
            actionHelper.setValue("isObjectUpdateLock", String.valueOf(methods[i].isObjectUpdateLock()));
            String mutexValue = methods[i].getMutexValue();
            if (!StringUtils.isEmpty((String)mutexValue)) {
                actionHelper.setValue("Mutex", mutexValue);
            } else {
                actionHelper.removeItem("Mutex");
            }
            actionHelper.setValue("userDefined", String.valueOf(methods[i].isUserDefined()));
            if (action.isHerited()) {
                action.setOverride(true);
            }
            if (isEditUI) {
                methods[i].setActionName(action.getName());
            } else {
                methods[i].setListActionName(action.getName());
            }
            List serviceList = ActionServicePropertyHelper.parseServiceItems(action.getServices());
            ServiceItem workflowItem = null;
            ServiceItem mutexItem = null;
            int m = serviceList.size();
            for (int j = 0; j < m; ++j) {
                if (ServiceItemConstants.WorkFlowService.getServiceClass().equalsIgnoreCase(((ServiceItem)serviceList.get(j)).getServiceClass())) {
                    workflowItem = (ServiceItem)serviceList.get(j);
                    continue;
                }
                if (!ServiceItemConstants.MutexService.getServiceClass().equalsIgnoreCase(((ServiceItem)serviceList.get(j)).getServiceClass())) continue;
                mutexItem = (ServiceItem)serviceList.get(j);
            }
            if (StringUtils.isEmpty((String)mutexValue) && mutexItem != null) {
                serviceList.remove(mutexItem);
            } else if (!StringUtils.isEmpty((String)mutexValue) && mutexItem == null) {
                serviceList.add(ServiceItemConstants.MutexService);
            }
            if (!methods[i].isBindWorkFlow() && workflowItem != null) {
                serviceList.remove(workflowItem);
            } else if (methods[i].isBindWorkFlow() && workflowItem == null) {
                serviceList.add(ServiceItemConstants.WorkFlowService);
            }
            action.setServices(ActionServicePropertyHelper.toXmlString(serviceList));
            if (isEditUI) {
                this.updateActionRules(model, action, methods[i].getConditionRules());
            }
            if (methods[i].isGenMenuItem()) {
                this.updateMenuItemByAction(model, action, methods[i]);
            }
            if (methods[i].isGenToolBarButton()) {
                this.updateToobarBtnByAction(model, action, methods[i]);
            }
            if (isEditUI) {
                if (methods[i].getBizStatusFieldValue() != null) {
                    actionHelper.setValue("BizStatusFieldValue", methods[i].getBizStatusFieldValue().getName());
                } else if (action.getExtendedProperty("BizStatusFieldValue") != null && !StringUtils.isEmpty((String)actionHelper.getValue(action.getExtendedProperty("BizStatusFieldValue")))) {
                    actionHelper.removeItem("BizStatusFieldValue");
                }
            }
            action.setActionExtendProperty(actionHelper.toXmlString());
        }
    }

    private void updateMenuItemByAction(UIObjectInfo model, ActionInfo action, BizMethodInfo method) {
        String menuItemName;
        ComponentInfo menuItem;
        ComponentInfo menu = UIProxyHelper.findControlByName(model, "bizMenu");
        if (menu == null) {
            menu = this.createBizMethodMenu(model);
        }
        if ((menuItem = UIProxyHelper.findControlByName(menu, menuItemName = method.getMenuItemName())) == null) {
            this.createMenuItemByAction(model, action, method);
        }
    }

    private void updateToobarBtnByAction(UIObjectInfo model, ActionInfo action, BizMethodInfo method) {
        ComponentInfo toolbar;
        try {
            toolbar = model.getComponents().get(1);
        }
        catch (Exception ex) {
            return;
        }
        String btnName = method.getToolBarButtonName();
        ComponentInfo btn = UIProxyHelper.findControlByName(toolbar, btnName);
        if (btn == null) {
            this.createToolbarBtnByAction(model, action, method);
        }
    }

    public PropertyInfo getProperty(String className, String propertyName) {
        return EventInfoHelper.getInstance().getProperty(className, propertyName);
    }

    public PropertyInfo getDefaultProperty(String controlType) {
        if (StringUtils.isEmpty((String)controlType)) {
            return null;
        }
        PropertyInfo info = null;
        if ("com.kingdee.bos.ctrl.swing.KDTextField".equals(controlType)) {
            info = this.getTextFieldDefaultProp();
        } else if ("com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox".equals(controlType)) {
            info = this.getMultiLangBoxDefaultProp();
        } else if ("com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangArea".equals(controlType)) {
            info = this.getMultiLangBoxDefaultProp();
        } else if ("com.kingdee.bos.ctrl.swing.KDFormattedTextField".equals(controlType)) {
            info = this.getFormatTextFieldDefaultProp();
        } else if ("com.kingdee.bos.ctrl.swing.KDLabel".equals(controlType)) {
            info = this.getLabelDefaultProp();
        } else if ("com.kingdee.bos.ctrl.swing.KDCheckBox".equals(controlType)) {
            info = this.getCheckBoxDefaultProp();
        } else if ("com.kingdee.bos.ctrl.kdf.table.KDTable".equals(controlType)) {
            info = this.getTableDefaultProp();
        } else if ("com.kingdee.bos.ctrl.swing.KDPasswordField".equals(controlType)) {
            info = this.getPasswordDefaultProp();
        } else if ("com.kingdee.bos.ctrl.swing.KDTextArea".equals(controlType)) {
            info = this.getTextAreaDefaultProp();
        } else if ("com.kingdee.bos.ctrl.swing.KDList".equals(controlType)) {
            info = this.getListDefaultProp();
        } else if ("com.kingdee.bos.ctrl.swing.KDComboBox".equals(controlType)) {
            info = this.getComboDefaultProp();
        } else if ("com.kingdee.bos.ctrl.swing.KDDatePicker".equals(controlType)) {
            info = this.getDatePickerDefaultProp();
        } else if ("com.kingdee.bos.ctrl.swing.KDTimePicker".equals(controlType)) {
            info = this.getTimePickerDefaultProp();
        } else if ("com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox".equals(controlType)) {
            info = this.getPromptBoxDefaultProp();
        } else if ("com.kingdee.bos.ctrl.swing.KDCurrencyTextField".equals(controlType)) {
            info = this.getCurrencyTextDefaultProp();
        } else if ("com.kingdee.bos.ctrl.swing.KDSpinner".equals(controlType)) {
            info = this.getSpinnerDefaultProp();
        } else if ("com.kingdee.bos.ctrl.swing.KDFilterTextField".equals(controlType)) {
            info = this.getFilterTextDefaultProp();
        }
        return info;
    }

    private PropertyInfo getFilterTextDefaultProp() {
        PropertyInfo prop = new PropertyInfo();
        prop.setName("text");
        prop.setType(String.class.getName());
        prop.setValue("");
        return prop;
    }

    private PropertyInfo getTextFieldDefaultProp() {
        PropertyInfo prop = new PropertyInfo();
        prop.setName("text");
        prop.setType(String.class.getName());
        prop.setValue("");
        return prop;
    }

    private PropertyInfo getMultiLangBoxDefaultProp() {
        PropertyInfo prop = new PropertyInfo();
        prop.setName("defaultLangItemData");
        prop.setType(Object.class.getName());
        prop.setValue("");
        return prop;
    }

    private PropertyInfo getFormatTextFieldDefaultProp() {
        PropertyInfo prop = new PropertyInfo();
        prop.setName("value");
        prop.setType(Object.class.getName());
        return prop;
    }

    private PropertyInfo getLabelDefaultProp() {
        PropertyInfo prop = new PropertyInfo();
        prop.setName("text");
        prop.setType(String.class.getName());
        prop.setValue("");
        return prop;
    }

    private PropertyInfo getCheckBoxDefaultProp() {
        PropertyInfo prop = new PropertyInfo();
        prop.setName("selected");
        prop.setType("boolean");
        prop.setValue("false");
        return prop;
    }

    private PropertyInfo getTableDefaultProp() {
        PropertyInfo prop = new PropertyInfo();
        prop.setName("formatXml");
        prop.setType(String.class.getName());
        prop.setValue("");
        return prop;
    }

    private PropertyInfo getPasswordDefaultProp() {
        PropertyInfo prop = new PropertyInfo();
        prop.setName("text");
        prop.setType(String.class.getName());
        prop.setValue("");
        return prop;
    }

    private PropertyInfo getTextAreaDefaultProp() {
        PropertyInfo prop = new PropertyInfo();
        prop.setName("text");
        prop.setType(String.class.getName());
        prop.setValue("");
        return prop;
    }

    private PropertyInfo getListDefaultProp() {
        PropertyInfo prop = new PropertyInfo();
        prop.setName("selectedIndex");
        prop.setType("int");
        prop.setValue("-1");
        return prop;
    }

    private PropertyInfo getComboDefaultProp() {
        PropertyInfo prop = new PropertyInfo();
        prop.setName("selectedIndex");
        prop.setType("int");
        prop.setValue("-1");
        return prop;
    }

    private PropertyInfo getDatePickerDefaultProp() {
        PropertyInfo prop = new PropertyInfo();
        prop.setName("value");
        prop.setType(Object.class.getName());
        return prop;
    }

    private PropertyInfo getTimePickerDefaultProp() {
        PropertyInfo prop = new PropertyInfo();
        prop.setName("value");
        prop.setType(Object.class.getName());
        return prop;
    }

    private PropertyInfo getPromptBoxDefaultProp() {
        PropertyInfo prop = new PropertyInfo();
        prop.setName("data");
        prop.setType(Object.class.getName());
        return prop;
    }

    private PropertyInfo getCurrencyTextDefaultProp() {
        PropertyInfo prop = new PropertyInfo();
        prop.setName("value");
        prop.setType(Object.class.getName());
        return prop;
    }

    private PropertyInfo getSpinnerDefaultProp() {
        PropertyInfo prop = new PropertyInfo();
        prop.setName("value");
        prop.setType(Object.class.getName());
        return prop;
    }

    public static List findControlsByClassType(ComponentInfo container, String classType) {
        ArrayList<ComponentInfo> list = new ArrayList<ComponentInfo>();
        if (container == null || StringUtils.isEmpty((String)classType)) {
            return list;
        }
        ComponentCollection collection = container.getComponents();
        int n = collection.size();
        for (int i = 0; i < n; ++i) {
            ComponentInfo component = collection.get(i);
            if (classType.equalsIgnoreCase(component.getClassType())) {
                list.add(component);
            }
            if (component.getComponents() == null || component.getComponents().size() <= 0) continue;
            List subList = UIProxyHelper.findControlsByClassType(component, classType);
            list.addAll(subList);
        }
        return list;
    }

    public static List findControlsByClassType(UIObjectInfo model, String classType) {
        ArrayList list = new ArrayList();
        if (model == null || StringUtils.isEmpty((String)classType)) {
            return list;
        }
        return UIProxyHelper.findControlsByClassType(model.getMainPanelComponent(), classType);
    }

    public static List findControlsByClassType(WebUIObjectInfo model, String classType) {
        ArrayList list = new ArrayList();
        if (model == null || StringUtils.isEmpty((String)classType)) {
            return list;
        }
        return UIProxyHelper.findControlsByClassType(model.getMainPanelComponent(), classType);
    }

    public static List findControlsByClassType(AbstractUIObjectInfo model, String classType) {
        if (model instanceof UIObjectInfo) {
            return UIProxyHelper.findControlsByClassType((UIObjectInfo)model, classType);
        }
        return UIProxyHelper.findControlsByClassType((WebUIObjectInfo)model, classType);
    }

    public static void addChild(ComponentInfo parent, ComponentInfo child, UIObjectInfo model) {
        if (parent == null || child == null) {
            return;
        }
        parent.addChild(model, child);
        String layoutType = null;
        if (parent.getLayoutInfo() != null) {
            layoutType = parent.getLayoutInfo().getType();
        }
        if (!StringUtils.isEmpty(layoutType) && ("XYLayout".equals(layoutType) || "KDLayout".equals(layoutType))) {
            if ("XYLayout".equals(layoutType)) {
                if (child.getConstraint() instanceof Rectangle) {
                    child.setConstraint(UIProxyHelper.convertToKDLayoutConstraint((Rectangle)child.getConstraint()));
                }
            } else if ("KDLayout".equals(layoutType) && child.getConstraint() instanceof KDLayoutConstraint) {
                child.setConstraint(UIProxyHelper.convertToRectangle((KDLayoutConstraint)child.getConstraint()));
            }
        }
    }

    private static Rectangle convertToRectangle(KDLayoutConstraint constraint) {
        return constraint.toRectangle();
    }

    private static KDLayoutConstraint convertToKDLayoutConstraint(Rectangle constraint) {
        return new KDLayoutConstraint(constraint);
    }

    public static void setLayout(ComponentInfo control, LayoutInfo layout) {
        block4: {
            String layoutType;
            block5: {
                if (control == null || layout == null) {
                    return;
                }
                String oldLayoutType = null;
                if (control.getLayoutInfo() != null) {
                    oldLayoutType = control.getLayoutInfo().getType();
                }
                layoutType = layout.getType();
                if (StringUtils.isEmpty((String)oldLayoutType) || StringUtils.isEmpty((String)layoutType) || oldLayoutType.equals(layoutType) || !"XYLayout".equals(oldLayoutType) && !"KDLayout".equals(oldLayoutType)) break block4;
                if (!"XYLayout".equals(layoutType)) break block5;
                control.setLayoutInfo(layout);
                control.getLayoutInfo().setOverride(true);
                int n = control.getComponents().size();
                for (int i = 0; i < n; ++i) {
                    if (!(control.getComponents().get(i).getConstraint() instanceof KDLayoutConstraint)) continue;
                    control.getComponents().get(i).setConstraint(UIProxyHelper.convertToRectangle((KDLayoutConstraint)control.getComponents().get(i).getConstraint()));
                }
                break block4;
            }
            if (!"KDLayout".equals(layoutType)) break block4;
            control.setLayoutInfo(layout);
            control.getLayoutInfo().setOverride(true);
            int n = control.getComponents().size();
            for (int i = 0; i < n; ++i) {
                if (!(control.getComponents().get(i).getConstraint() instanceof Rectangle)) continue;
                control.getComponents().get(i).setConstraint(UIProxyHelper.convertToKDLayoutConstraint((Rectangle)control.getComponents().get(i).getConstraint()));
            }
        }
    }

    public static DataObjectInfo findDataObjectByType(AbstractUIObjectInfo uiObject, String type) {
        if (uiObject == null || StringUtils.isEmpty((String)type)) {
            return null;
        }
        DataObjectCollection dataObjects = uiObject.getDataObjects();
        int n = dataObjects.size();
        for (int i = 0; i < n; ++i) {
            if (!type.equalsIgnoreCase(dataObjects.get(i).getType())) continue;
            return dataObjects.get(i);
        }
        return null;
    }

    private static boolean isBindDataObject(ComponentInfo component, DataObjectInfo dataObject) {
        PropertyBindingCollection propBindings = component.getPropertyBindings();
        int n = propBindings.size();
        for (int i = 0; i < n; ++i) {
            if (!dataObject.getName().equalsIgnoreCase(propBindings.get(i).getBindingObject())) continue;
            return true;
        }
        return false;
    }

    public static List findControlsByDataObject(ComponentInfo container, DataObjectInfo dataObject) {
        ArrayList<ComponentInfo> list = new ArrayList<ComponentInfo>();
        if (container == null || dataObject == null) {
            return list;
        }
        ComponentCollection collection = container.getComponents();
        int n = collection.size();
        for (int i = 0; i < n; ++i) {
            ComponentInfo component = collection.get(i);
            if (UIProxyHelper.isBindDataObject(component, dataObject)) {
                list.add(component);
            }
            if (component.getComponents() == null || component.getComponents().size() <= 0) continue;
            List subList = UIProxyHelper.findControlsByDataObject(component, dataObject);
            list.addAll(subList);
        }
        return list;
    }

    public static List findControlsByDataObject(UIObjectInfo uiObject, DataObjectInfo dataObject) {
        ArrayList list = new ArrayList();
        if (uiObject == null || dataObject == null) {
            return list;
        }
        return UIProxyHelper.findControlsByDataObject(uiObject.getMainPanelComponent(), dataObject);
    }

    public static List findControlsByDataObject(WebUIObjectInfo uiObject, DataObjectInfo dataObject) {
        ArrayList list = new ArrayList();
        if (uiObject == null || dataObject == null) {
            return list;
        }
        return UIProxyHelper.findControlsByDataObject(uiObject.getMainPanelComponent(), dataObject);
    }

    public static ComponentInfo findKDTableByDataObject(ComponentInfo container, DataObjectInfo dataObject) {
        ComponentCollection collection = container.getComponents();
        int n = collection.size();
        for (int i = 0; i < n; ++i) {
            ComponentInfo component = collection.get(i);
            if (!("com.kingdee.bos.ctrl.kdf.table.KDTable".equalsIgnoreCase(component.getClassType()) ? UIProxyHelper.isBindDataObject(component, dataObject) : component.getComponents() != null && component.getComponents().size() > 0 && (component = UIProxyHelper.findKDTableByDataObject(component, dataObject)) != null)) continue;
            return component;
        }
        return null;
    }

    public static ComponentInfo findDataGridByDataObject(ComponentInfo container, DataObjectInfo dataObject) {
        ComponentCollection collection = container.getComponents();
        int n = collection.size();
        for (int i = 0; i < n; ++i) {
            ComponentInfo component = collection.get(i);
            if ("com.kingdee.bos.ctrl.web.DataGrid".equalsIgnoreCase(component.getClassType())) {
                ComponentCollection columns = component.getComponents();
                int size = columns.size();
                for (int j = 0; j < size; ++j) {
                    if (!UIProxyHelper.isBindDataObject(columns.get(j), dataObject)) continue;
                    return component;
                }
                continue;
            }
            if (component.getComponents() == null || component.getComponents().size() <= 0 || (component = UIProxyHelper.findDataGridByDataObject(component, dataObject)) == null) continue;
            return component;
        }
        return null;
    }

    public static ComponentInfo findKDTableByDataObject(UIObjectInfo uiObject, DataObjectInfo dataObject) {
        if (uiObject == null || dataObject == null) {
            return null;
        }
        return UIProxyHelper.findKDTableByDataObject(uiObject.getMainPanelComponent(), dataObject);
    }

    public static ComponentInfo findDataGridByDataObject(WebUIObjectInfo uiObject, DataObjectInfo dataObject) {
        if (uiObject == null || dataObject == null) {
            return null;
        }
        return UIProxyHelper.findDataGridByDataObject(uiObject.getMainPanelComponent(), dataObject);
    }

    public static DataObjectCollection getSubQuerys(UIObjectInfo uiObject) {
        DataObjectCollection subQuerys = new DataObjectCollection();
        if (uiObject == null) {
            return subQuerys;
        }
        DataObjectCollection dataObjects = uiObject.getDataObjects();
        int n = dataObjects.size();
        for (int i = 1; i < n; ++i) {
            if (!MetaDataTypeList.JOINQUERY.toString().equals(dataObjects.get(i).getObjectType())) continue;
            subQuerys.add(dataObjects.get(i));
        }
        return subQuerys;
    }

    public static String getTableColumnName(ComponentInfo kdTable, String fieldName) {
        if (StringUtils.isEmpty((String)fieldName)) {
            return null;
        }
        PropertyBindingCollection pbCol = kdTable.getPropertyBindings();
        int n = pbCol.size();
        for (int i = 0; i < n; ++i) {
            PropertyBindingInfo pbInfo = pbCol.get(i);
            if (!pbInfo.getBingdingField().endsWith(fieldName) || StringUtils.isEmpty((String)pbInfo.getPropertyName())) continue;
            return StringUtils.replace((String)pbInfo.getPropertyName(), (String)".text", (String)"");
        }
        return null;
    }

    public static ComponentInfo findComponentByBindingField(UIObjectInfo uiObject, String bindingField) {
        if (uiObject == null || StringUtils.isEmpty((String)bindingField)) {
            return null;
        }
        return UIProxyHelper.findComponentByBindingField(uiObject.getMainPanelComponent(), bindingField);
    }

    public static ComponentInfo findComponentByBindingField(ComponentInfo container, String bindingField) {
        if (container == null || StringUtils.isEmpty((String)bindingField)) {
            return null;
        }
        PropertyBindingCollection pbCol = container.getPropertyBindings();
        int n = pbCol.size();
        for (int i = 0; i < n; ++i) {
            PropertyBindingInfo pbInfo = pbCol.get(i);
            if (!bindingField.equalsIgnoreCase(pbInfo.getBingdingField())) continue;
            return container;
        }
        ComponentCollection collection = container.getComponents();
        int n2 = collection.size();
        for (int i = 0; i < n2; ++i) {
            ComponentInfo component = UIProxyHelper.findComponentByBindingField(collection.get(i), bindingField);
            if (component == null) continue;
            return component;
        }
        return null;
    }

    public static Object getConstraintByLayout(Layout layout, Rectangle rect) {
        if (layout instanceof WebLayout) {
            WebLayoutData.Unit width = WebLayoutData.Unit.parse(String.valueOf(rect.width));
            int height = Integer.parseInt(String.valueOf(rect.height));
            return new WebLayoutData(width, height, false);
        }
        if (layout instanceof SmartLayout) {
            return new SmartLayoutData(rect.x, rect.y, rect.width, rect.height, 0);
        }
        if (layout instanceof XYLayout) {
            return new Rectangle(rect.x, rect.y, rect.width, rect.height);
        }
        if (layout instanceof KDLayout) {
            return new KDLayoutConstraint(rect.x, rect.y, rect.width, rect.height, 0);
        }
        return null;
    }
}

