/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ui.dtp;

import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.ui.ComponentCollection;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.DataObjectCollection;
import com.kingdee.bos.metadata.ui.DataObjectInfo;
import com.kingdee.bos.metadata.ui.PropertyBindingCollection;
import com.kingdee.bos.metadata.ui.PropertyBindingInfo;
import com.kingdee.bos.metadata.ui.PropertyCollection;
import com.kingdee.bos.metadata.ui.PropertyInfo;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.ui.dtp.ControlConstant;
import com.kingdee.bos.ui.dtp.ControlDefaultSizeManager;
import com.kingdee.bos.ui.dtp.UIGenerator;
import com.kingdee.bos.ui.dtp.kdlayout.KDLayoutConstraint;
import com.kingdee.bos.ui.dtp.kdtable.CellInfo;
import com.kingdee.bos.ui.dtp.kdtable.ColumnInfo;
import com.kingdee.bos.ui.dtp.kdtable.HeaderInfo;
import com.kingdee.bos.ui.dtp.kdtable.KDTableDesignerHelper;
import com.kingdee.bos.ui.dtp.kdtable.TableInfo;
import com.kingdee.bos.ui.dtp.model.layout.FlowLayout;
import com.kingdee.bos.ui.dtp.model.layout.KDLayout;
import com.kingdee.bos.ui.dtp.model.layout.LabelContainerLayout;
import com.kingdee.bos.ui.dtp.model.layout.Layout;
import com.kingdee.bos.ui.dtp.model.layout.LayoutConverter;
import com.kingdee.bos.ui.dtp.model.layout.SameGridLayout;
import com.kingdee.bos.ui.dtp.model.layout.SplitLayout;
import com.kingdee.bos.ui.dtp.model.layout.TabbedPaneLayout;
import com.kingdee.bos.ui.dtp.model.layout.TreeViewLayout;
import com.kingdee.bos.ui.dtp.model.layout.XYLayout;
import com.kingdee.util.StringUtils;
import java.awt.Dimension;
import java.awt.Rectangle;
import org.apache.log4j.Logger;

public class UIGeneratorHelper {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.studio.wizard.uiobject.UIGeneratorHelper");
    private static final int CONTROL_TEXTFIELD = 1;
    private static final int CONTROL_TEXTAREA = 2;
    private static final int CONTROL_PASSWORDFIELD = 3;
    private static final int CONTROL_LIST = 11;
    private static final int CONTROL_COMBOBOX = 12;
    private static final int LAYOUT_XYLAYOUT = 1;
    private static final int LAYOUT_SAMEGRID = 2;
    private static final int LAYOUT_KDLAYOUT = 3;

    private UIGeneratorHelper() {
    }

    public static void createTextField(UIObjectInfo model, OwnPropertyInfo prop, String doName, int row, int col) {
        UIGeneratorHelper.createTextType(model, prop, doName, row, col, 1);
    }

    public static void createTextArea(UIObjectInfo model, OwnPropertyInfo prop, String doName, int row, int col) {
        UIGeneratorHelper.createTextType(model, prop, doName, row, col, 2);
    }

    public static void createPasswordField(UIObjectInfo model, OwnPropertyInfo prop, String doName, int row, int col) {
        UIGeneratorHelper.createTextType(model, prop, doName, row, col, 3);
    }

    private static void createTextType(UIObjectInfo model, OwnPropertyInfo prop, String doName, int row, int col, int type) {
        ComponentInfo txtControl;
        String txtName;
        Layout layout = UIGeneratorHelper.getLayout(model.getMainPanelComponent());
        int layoutType = 0;
        if (layout == null || layout instanceof XYLayout) {
            layoutType = 1;
        } else if (layout instanceof SameGridLayout) {
            layoutType = 2;
        } else if (layout instanceof KDLayout) {
            layoutType = 3;
        } else {
            return;
        }
        if (col == 1) {
            col = layoutType == 1 || layoutType == 3 ? 300 : 5;
        } else if (col == 0) {
            col = layoutType == 1 || layoutType == 3 ? 10 : 1;
        }
        if (layoutType == 1 || layoutType == 3) {
            row *= 10;
        }
        String propName = prop.getName();
        String baseName = propName.substring(0, 1).toUpperCase() + propName.substring(1);
        String labName = "cont" + baseName;
        labName = model.getNameManager().getNameByName(labName);
        String label = StringUtils.isEmpty((String)prop.getAlias()) ? prop.getName() : prop.getAlias();
        ComponentInfo labContainer = UIGeneratorHelper.createLabelContainer(labName, label);
        switch (type) {
            case 1: {
                String prefixName = ControlConstant.getControlNamePrefix("com.kingdee.bos.ctrl.swing.KDTextField");
                txtName = (prefixName == null ? "txt" : prefixName) + baseName;
                txtControl = new ComponentInfo("com.kingdee.bos.ctrl.swing.KDTextField");
                Dimension size = ControlDefaultSizeManager.getDefaultSize("com.kingdee.bos.ctrl.swing.KDTextField");
                break;
            }
            case 2: {
                String prefixName = ControlConstant.getControlNamePrefix("com.kingdee.bos.ctrl.swing.KDTextArea");
                txtName = (prefixName == null ? "txt" : prefixName) + baseName;
                txtControl = new ComponentInfo("com.kingdee.bos.ctrl.swing.KDTextArea");
                Dimension size = ControlDefaultSizeManager.getDefaultSize("com.kingdee.bos.ctrl.swing.KDTextArea");
                break;
            }
            case 3: {
                String prefixName = ControlConstant.getControlNamePrefix("com.kingdee.bos.ctrl.swing.KDPasswordField");
                txtName = (prefixName == null ? "psd" : prefixName) + baseName;
                txtControl = new ComponentInfo("com.kingdee.bos.ctrl.swing.KDPasswordField");
                Dimension size = ControlDefaultSizeManager.getDefaultSize("com.kingdee.bos.ctrl.swing.KDPasswordField");
                break;
            }
            default: {
                String prefixName = ControlConstant.getControlNamePrefix("com.kingdee.bos.ctrl.swing.KDTextField");
                txtName = (prefixName == null ? "txt" : prefixName) + baseName;
                txtControl = new ComponentInfo("com.kingdee.bos.ctrl.swing.KDTextField");
                Dimension size = ControlDefaultSizeManager.getDefaultSize("com.kingdee.bos.ctrl.swing.KDTextField");
            }
        }
        txtName = model.getNameManager().getNameByName(txtName);
        txtControl.setName(txtName, false);
        if (layoutType == 1) {
            Dimension labSize = ControlDefaultSizeManager.getDefaultSize("com.kingdee.bos.ctrl.swing.KDLabelContainer");
            labContainer.setConstraint(new Rectangle(col, row, labSize.width, labSize.height), false);
        } else if (layoutType == 3) {
            Dimension labSize = ControlDefaultSizeManager.getDefaultSize("com.kingdee.bos.ctrl.swing.KDLabelContainer");
            labContainer.setConstraint(new KDLayoutConstraint(col, row, labSize.width, labSize.height), false);
        } else {
            labContainer.setConstraint(new Rectangle(col, row, 1, 2), false);
        }
        txtControl.setConstraint(String.valueOf(7), false);
        PropertyBindingInfo propertyBindingInfo = new PropertyBindingInfo();
        propertyBindingInfo.setPropertyName("text");
        propertyBindingInfo.setPropertyType(String.class.getName());
        propertyBindingInfo.setAccessType(2);
        propertyBindingInfo.setAutoMode(false);
        propertyBindingInfo.setBindingObject(doName);
        propertyBindingInfo.setBingdingField(propName);
        propertyBindingInfo.setFieldType(prop.getJavaType());
        txtControl.getPropertyBindings().add(propertyBindingInfo);
        if (type == 1 || type == 2) {
            com.kingdee.bos.metadata.data.ColumnInfo columnInfo = prop.getMappingField();
            int length = -1;
            if (columnInfo != null) {
                length = columnInfo.getLength();
            }
            if (length <= 0) {
                length = prop.getLength();
            }
            if (length > 0) {
                PropertyInfo property = new PropertyInfo();
                property.setName("maxLength");
                property.setType("int");
                property.setMultiLanguage(false);
                property.setValue(String.valueOf(length));
                txtControl.getProperties().add(property);
            }
        }
        ComponentInfo parent = model.getMainPanelComponent();
        model.getComponents().add(labContainer);
        model.getComponents().add(txtControl);
        labContainer.addChild(txtControl);
        parent.addChild(labContainer);
    }

    public static void createKDFormattedTextField(UIObjectInfo model, OwnPropertyInfo prop, String doName, int row, int col) {
        Layout layout = UIGeneratorHelper.getLayout(model.getMainPanelComponent());
        int layoutType = 0;
        if (layout == null || layout instanceof XYLayout) {
            layoutType = 1;
        } else if (layout instanceof SameGridLayout) {
            layoutType = 2;
        } else if (layout instanceof KDLayout) {
            layoutType = 3;
        } else {
            return;
        }
        if (col == 1) {
            col = layoutType == 1 || layoutType == 3 ? 300 : 5;
        } else if (col == 0) {
            col = layoutType == 1 || layoutType == 3 ? 10 : 1;
        }
        if (layoutType == 1 || layoutType == 3) {
            row *= 10;
        }
        String propName = prop.getName();
        String baseName = propName.substring(0, 1).toUpperCase() + propName.substring(1);
        String labName = "cont" + baseName;
        labName = model.getNameManager().getNameByName(labName);
        String label = StringUtils.isEmpty((String)prop.getAlias()) ? prop.getName() : prop.getAlias();
        ComponentInfo labContainer = UIGeneratorHelper.createLabelContainer(labName, label);
        String prefixName = ControlConstant.getControlNamePrefix("com.kingdee.bos.ctrl.swing.KDFormattedTextField");
        String txtName = (prefixName == null ? "txt" : prefixName) + baseName;
        ComponentInfo txtControl = new ComponentInfo("com.kingdee.bos.ctrl.swing.KDFormattedTextField");
        txtName = model.getNameManager().getNameByName(txtName);
        txtControl.setName(txtName, false);
        if (layoutType == 1) {
            Dimension labSize = ControlDefaultSizeManager.getDefaultSize("com.kingdee.bos.ctrl.swing.KDLabelContainer");
            labContainer.setConstraint(new Rectangle(col, row, labSize.width, labSize.height), false);
        } else if (layoutType == 3) {
            Dimension labSize = ControlDefaultSizeManager.getDefaultSize("com.kingdee.bos.ctrl.swing.KDLabel");
            labContainer.setConstraint(new KDLayoutConstraint(col, row, labSize.width, labSize.height), false);
        } else {
            labContainer.setConstraint(new Rectangle(col, row, 1, 2), false);
        }
        txtControl.setConstraint(String.valueOf(7), false);
        PropertyBindingInfo propertyBindingInfo = new PropertyBindingInfo();
        propertyBindingInfo.setPropertyName("value");
        propertyBindingInfo.setPropertyType(Object.class.getName());
        propertyBindingInfo.setAccessType(2);
        propertyBindingInfo.setAutoMode(false);
        propertyBindingInfo.setBindingObject(doName);
        propertyBindingInfo.setBingdingField(propName);
        propertyBindingInfo.setFieldType(prop.getJavaType());
        txtControl.getPropertyBindings().add(propertyBindingInfo);
        ComponentInfo parent = model.getMainPanelComponent();
        model.getComponents().add(labContainer);
        model.getComponents().add(txtControl);
        labContainer.addChild(txtControl);
        parent.addChild(labContainer);
    }

    public static void createKDBizPromptBox(UIObjectInfo model, LinkPropertyInfo prop, String doName, int row, int col) {
        Layout layout = UIGeneratorHelper.getLayout(model.getMainPanelComponent());
        int layoutType = 0;
        if (layout == null || layout instanceof XYLayout) {
            layoutType = 1;
        } else if (layout instanceof SameGridLayout) {
            layoutType = 2;
        } else if (layout instanceof KDLayout) {
            layoutType = 3;
        } else {
            return;
        }
        if (col == 1) {
            col = layoutType == 1 || layoutType == 3 ? 300 : 5;
        } else if (col == 0) {
            col = layoutType == 1 || layoutType == 3 ? 10 : 1;
        }
        if (layoutType == 1 || layoutType == 3) {
            row *= 10;
        }
        String propName = prop.getName();
        String baseName = propName.substring(0, 1).toUpperCase() + propName.substring(1);
        String labName = "cont" + baseName;
        String prefixName = ControlConstant.getControlNamePrefix("com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox");
        String txtName = (prefixName == null ? "prmp" : prefixName) + baseName;
        String label = StringUtils.isEmpty((String)prop.getAlias()) ? prop.getName() : prop.getAlias();
        labName = model.getNameManager().getNameByName(labName);
        ComponentInfo labContainer = UIGeneratorHelper.createLabelContainer(labName, label);
        ComponentInfo dateControl = new ComponentInfo("com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox");
        txtName = model.getNameManager().getNameByName(txtName);
        dateControl.setName(txtName);
        if (layoutType == 1) {
            Dimension labSize = ControlDefaultSizeManager.getDefaultSize("com.kingdee.bos.ctrl.swing.KDLabelContainer");
            labContainer.setConstraint(new Rectangle(col, row, labSize.width, labSize.height), false);
        } else if (layoutType == 3) {
            Dimension labSize = ControlDefaultSizeManager.getDefaultSize("com.kingdee.bos.ctrl.swing.KDLabelContainer");
            labContainer.setConstraint(new KDLayoutConstraint(col, row, labSize.width, labSize.height), false);
        } else {
            labContainer.setConstraint(new Rectangle(col, row, 1, 2), false);
        }
        dateControl.setConstraint(String.valueOf(7), false);
        PropertyBindingInfo propertyBindingInfo = new PropertyBindingInfo();
        propertyBindingInfo.setPropertyName("data");
        propertyBindingInfo.setPropertyType(Object.class.getName());
        propertyBindingInfo.setAccessType(2);
        propertyBindingInfo.setAutoMode(false);
        propertyBindingInfo.setBindingObject(doName);
        propertyBindingInfo.setBingdingField(propName);
        propertyBindingInfo.setFieldType(prop.getRelationship().getSupplierObject().getObjectValueClass());
        dateControl.getPropertyBindings().add(propertyBindingInfo);
        ComponentInfo parent = model.getMainPanelComponent();
        model.getComponents().add(labContainer);
        model.getComponents().add(dateControl);
        labContainer.addChild(dateControl);
        parent.addChild(labContainer);
    }

    public static void createDatePicker(UIObjectInfo model, OwnPropertyInfo prop, String doName, int row, int col) {
        UIGeneratorHelper.createDateOrTimePicker(model, prop, doName, row, col, true);
    }

    public static void createTimePicker(UIObjectInfo model, OwnPropertyInfo prop, String doName, int row, int col) {
        UIGeneratorHelper.createDateOrTimePicker(model, prop, doName, row, col, false);
    }

    private static void createDateOrTimePicker(UIObjectInfo model, OwnPropertyInfo prop, String doName, int row, int col, boolean isDate) {
        String txtName;
        Layout layout = UIGeneratorHelper.getLayout(model.getMainPanelComponent());
        int layoutType = 0;
        if (layout == null || layout instanceof XYLayout) {
            layoutType = 1;
        } else if (layout instanceof SameGridLayout) {
            layoutType = 2;
        } else if (layout instanceof KDLayout) {
            layoutType = 3;
        } else {
            return;
        }
        if (col == 1) {
            col = layoutType == 1 || layoutType == 3 ? 300 : 5;
        } else if (col == 0) {
            col = layoutType == 1 || layoutType == 3 ? 10 : 1;
        }
        if (layoutType == 1 || layoutType == 3) {
            row *= 10;
        }
        String propName = prop.getName();
        String baseName = propName.substring(0, 1).toUpperCase() + propName.substring(1);
        String labName = "cont" + baseName;
        if (isDate) {
            String prefixName = ControlConstant.getControlNamePrefix("com.kingdee.bos.ctrl.swing.KDDatePicker");
            txtName = (prefixName == null ? "pk" : prefixName) + baseName;
        } else {
            String prefixName = ControlConstant.getControlNamePrefix("com.kingdee.bos.ctrl.swing.KDTimePicker");
            txtName = (prefixName == null ? "pk" : prefixName) + baseName;
        }
        String label = StringUtils.isEmpty((String)prop.getAlias()) ? prop.getName() : prop.getAlias();
        labName = model.getNameManager().getNameByName(labName);
        ComponentInfo labContainer = UIGeneratorHelper.createLabelContainer(labName, label);
        ComponentInfo dateControl = isDate ? new ComponentInfo("com.kingdee.bos.ctrl.swing.KDDatePicker") : new ComponentInfo("com.kingdee.bos.ctrl.swing.KDTimePicker");
        txtName = model.getNameManager().getNameByName(txtName);
        dateControl.setName(txtName);
        if (layoutType == 1) {
            Dimension labSize = ControlDefaultSizeManager.getDefaultSize("com.kingdee.bos.ctrl.swing.KDLabelContainer");
            labContainer.setConstraint(new Rectangle(col, row, labSize.width, labSize.height), false);
        } else if (layoutType == 3) {
            Dimension labSize = ControlDefaultSizeManager.getDefaultSize("com.kingdee.bos.ctrl.swing.KDLabelContainer");
            labContainer.setConstraint(new KDLayoutConstraint(col, row, labSize.width, labSize.height), false);
        } else {
            labContainer.setConstraint(new Rectangle(col, row, 1, 2), false);
        }
        dateControl.setConstraint(String.valueOf(7), false);
        PropertyBindingInfo propertyBindingInfo = new PropertyBindingInfo();
        propertyBindingInfo.setPropertyName("value");
        propertyBindingInfo.setPropertyType(Object.class.getName());
        propertyBindingInfo.setAccessType(2);
        propertyBindingInfo.setAutoMode(false);
        propertyBindingInfo.setBindingObject(doName);
        propertyBindingInfo.setBingdingField(propName);
        propertyBindingInfo.setFieldType(prop.getJavaType());
        dateControl.getPropertyBindings().add(propertyBindingInfo);
        ComponentInfo parent = model.getMainPanelComponent();
        model.getComponents().add(labContainer);
        model.getComponents().add(dateControl);
        labContainer.addChild(dateControl);
        parent.addChild(labContainer);
    }

    public static void createComboBox(UIObjectInfo model, OwnPropertyInfo prop, String doName, int row, int col) {
        UIGeneratorHelper.createComboBoxOrList(model, prop, doName, row, col, 12);
    }

    public static void createList(UIObjectInfo model, OwnPropertyInfo prop, String doName, int row, int col) {
        UIGeneratorHelper.createComboBoxOrList(model, prop, doName, row, col, 11);
    }

    private static void createComboBoxOrList(UIObjectInfo model, OwnPropertyInfo prop, String doName, int row, int col, int type) {
        ComponentInfo comboControl;
        String txtName;
        Layout layout = UIGeneratorHelper.getLayout(model.getMainPanelComponent());
        int layoutType = 0;
        if (layout == null || layout instanceof XYLayout) {
            layoutType = 1;
        } else if (layout instanceof SameGridLayout) {
            layoutType = 2;
        } else if (layout instanceof KDLayout) {
            layoutType = 3;
        } else {
            return;
        }
        if (col == 1) {
            col = layoutType == 1 || layoutType == 3 ? 300 : 5;
        } else if (col == 0) {
            col = layoutType == 1 || layoutType == 3 ? 10 : 1;
        }
        if (layoutType == 1 || layoutType == 3) {
            row *= 10;
        }
        String propName = prop.getName();
        String baseName = propName.substring(0, 1).toUpperCase() + propName.substring(1);
        String labName = "cont" + baseName;
        switch (type) {
            case 12: {
                String prefixName = ControlConstant.getControlNamePrefix("com.kingdee.bos.ctrl.swing.KDComboBox");
                txtName = (prefixName == null ? "combo" : prefixName) + baseName;
                comboControl = new ComponentInfo("com.kingdee.bos.ctrl.swing.KDComboBox");
                Dimension size = ControlDefaultSizeManager.getDefaultSize("com.kingdee.bos.ctrl.swing.KDComboBox");
                break;
            }
            case 11: {
                String prefixName = ControlConstant.getControlNamePrefix("com.kingdee.bos.ctrl.swing.KDList");
                txtName = (prefixName == null ? "list" : prefixName) + baseName;
                comboControl = new ComponentInfo("com.kingdee.bos.ctrl.swing.KDList");
                Dimension size = ControlDefaultSizeManager.getDefaultSize("com.kingdee.bos.ctrl.swing.KDList");
                break;
            }
            default: {
                String prefixName = ControlConstant.getControlNamePrefix("com.kingdee.bos.ctrl.swing.KDComboBox");
                txtName = (prefixName == null ? "combo" : prefixName) + baseName;
                comboControl = new ComponentInfo("com.kingdee.bos.ctrl.swing.KDComboBox");
                Dimension size = ControlDefaultSizeManager.getDefaultSize("com.kingdee.bos.ctrl.swing.KDComboBox");
            }
        }
        String label = StringUtils.isEmpty((String)prop.getAlias()) ? prop.getName() : prop.getAlias();
        labName = model.getNameManager().getNameByName(labName);
        ComponentInfo labContainer = UIGeneratorHelper.createLabelContainer(labName, label);
        txtName = model.getNameManager().getNameByName(txtName);
        comboControl.setName(txtName, false);
        if (layoutType == 1) {
            Dimension labSize = ControlDefaultSizeManager.getDefaultSize("com.kingdee.bos.ctrl.swing.KDLabelContainer");
            labContainer.setConstraint(new Rectangle(col, row, labSize.width, labSize.height), false);
        } else if (layoutType == 3) {
            Dimension labSize = ControlDefaultSizeManager.getDefaultSize("com.kingdee.bos.ctrl.swing.KDLabelContainer");
            labContainer.setConstraint(new KDLayoutConstraint(col, row, labSize.width, labSize.height), false);
        } else {
            labContainer.setConstraint(new Rectangle(col, row, 1, 2), false);
        }
        comboControl.setConstraint(String.valueOf(7), false);
        PropertyInfo propInfo = new PropertyInfo();
        propInfo.setName("items");
        propInfo.setType(String.class.getName());
        propInfo.setMultiLanguage(true);
        BizEnumInfo bizenum = prop.getEnumType();
        String value = "[Enum]";
        if (!StringUtils.isEmpty((String)bizenum.getPackage())) {
            value = value + bizenum.getPackage() + ".";
        }
        value = value + bizenum.getName();
        propInfo.setValue(value);
        comboControl.getProperties().add(propInfo);
        PropertyBindingInfo propertyBindingInfo = new PropertyBindingInfo();
        propertyBindingInfo.setPropertyName("selectedItem");
        propertyBindingInfo.setPropertyType(Object.class.getName());
        propertyBindingInfo.setAccessType(2);
        propertyBindingInfo.setAutoMode(false);
        propertyBindingInfo.setBindingObject(doName);
        propertyBindingInfo.setBingdingField(propName);
        propertyBindingInfo.setFieldType(prop.getEnumType().getClassName());
        comboControl.getPropertyBindings().add(propertyBindingInfo);
        ComponentInfo parent = model.getMainPanelComponent();
        model.getComponents().add(labContainer);
        model.getComponents().add(comboControl);
        labContainer.addChild(comboControl);
        parent.addChild(labContainer);
    }

    public static void createCheckBox(UIObjectInfo model, OwnPropertyInfo prop, String doName, int row, int col) {
        Layout layout = UIGeneratorHelper.getLayout(model.getMainPanelComponent());
        int layoutType = 0;
        if (layout == null || layout instanceof XYLayout) {
            layoutType = 1;
        } else if (layout instanceof SameGridLayout) {
            layoutType = 2;
        } else if (layout instanceof KDLayout) {
            layoutType = 3;
        } else {
            return;
        }
        if (col == 1) {
            col = layoutType == 1 || layoutType == 3 ? 300 : 5;
        } else if (col == 0) {
            col = layoutType == 1 || layoutType == 3 ? 10 : 1;
        }
        if (layoutType == 1 || layoutType == 3) {
            row *= 10;
        }
        String propName = prop.getName();
        String baseName = propName.substring(0, 1).toUpperCase() + propName.substring(1);
        String prefixName = ControlConstant.getControlNamePrefix("com.kingdee.bos.ctrl.swing.KDCheckBox");
        String labName = (prefixName == null ? "chk" : prefixName) + baseName;
        ComponentInfo chkControl = new ComponentInfo("com.kingdee.bos.ctrl.swing.KDCheckBox");
        if (StringUtils.isEmpty((String)prop.getAlias())) {
            chkControl.getProperties().add(UIGeneratorHelper.createTextProperty(prop.getName()));
        } else {
            chkControl.getProperties().add(UIGeneratorHelper.createTextProperty(prop.getAlias()));
        }
        labName = model.getNameManager().getNameByName(labName);
        chkControl.setName(labName, false);
        if (layoutType == 1) {
            Dimension size = ControlDefaultSizeManager.getDefaultSize("com.kingdee.bos.ctrl.swing.KDCheckBox");
            chkControl.setConstraint(new Rectangle(col, row, size.width, size.height), false);
        } else if (layoutType == 3) {
            Dimension size = ControlDefaultSizeManager.getDefaultSize("com.kingdee.bos.ctrl.swing.KDCheckBox");
            chkControl.setConstraint(new KDLayoutConstraint(col, row, size.width, size.height), false);
        } else {
            chkControl.setConstraint(new Rectangle(col, row, 3, 2), false);
        }
        PropertyBindingInfo propertyBindingInfo = new PropertyBindingInfo();
        propertyBindingInfo.setPropertyName("selected");
        propertyBindingInfo.setPropertyType("boolean");
        propertyBindingInfo.setAccessType(2);
        propertyBindingInfo.setAutoMode(false);
        propertyBindingInfo.setBindingObject(doName);
        propertyBindingInfo.setBingdingField(propName);
        propertyBindingInfo.setFieldType(prop.getJavaType());
        chkControl.getPropertyBindings().add(propertyBindingInfo);
        ComponentInfo parent = model.getMainPanelComponent();
        model.getComponents().add(chkControl);
        chkControl.setParent(parent);
        parent.getComponents().add(chkControl);
    }

    public static void createKDTableForEntity(UIObjectInfo model, EntityObjectInfo obj, String doName, String linkPropName, int row, int col, LanguageCollection locales) {
        int i;
        Dimension dsize;
        Layout layout = UIGeneratorHelper.getLayout(model.getMainPanelComponent());
        int layoutType = 0;
        if (layout == null || layout instanceof XYLayout) {
            layoutType = 1;
        } else if (layout instanceof SameGridLayout) {
            layoutType = 2;
        } else if (layout instanceof KDLayout) {
            layoutType = 3;
        } else {
            return;
        }
        col = layoutType == 1 || layoutType == 3 ? 10 : 1;
        if (layoutType == 1 || layoutType == 3) {
            row *= 10;
        }
        com.kingdee.bos.metadata.entity.PropertyCollection props = obj.getProperties();
        String baseName = linkPropName.substring(0, 1).toUpperCase() + linkPropName.substring(1);
        String prefixName = ControlConstant.getControlNamePrefix("com.kingdee.bos.ctrl.kdf.table.KDTable");
        String labName = (prefixName == null ? "kdt" : prefixName) + baseName;
        ComponentInfo kdtControl = new ComponentInfo("com.kingdee.bos.ctrl.kdf.table.KDTable");
        labName = model.getNameManager().getNameByName(labName);
        kdtControl.setName(labName);
        if (layoutType == 1) {
            dsize = ControlDefaultSizeManager.getDefaultSize("com.kingdee.bos.ctrl.kdf.table.KDTable");
            kdtControl.setConstraint(new Rectangle(col, row, dsize.width, dsize.height), false);
        } else if (layoutType == 3) {
            dsize = ControlDefaultSizeManager.getDefaultSize("com.kingdee.bos.ctrl.kdf.table.KDTable");
            kdtControl.setConstraint(new KDLayoutConstraint(col, row, dsize.width, dsize.height), false);
        } else {
            kdtControl.setConstraint(new Rectangle(col, row, 7, 5), false);
        }
        int size = props.size();
        int localeNum = 0;
        if (locales != null) {
            localeNum = locales.size();
        }
        TableInfo[] tables = new TableInfo[localeNum];
        HeaderInfo[] headers = new HeaderInfo[localeNum];
        for (int i2 = 0; i2 < localeNum; ++i2) {
            tables[i2] = new TableInfo();
            headers[i2] = new HeaderInfo();
            headers[i2].setName("header");
        }
        for (i = 0; i < size; ++i) {
            String name;
            com.kingdee.bos.metadata.entity.PropertyInfo prop = props.get(i);
            if (!(prop instanceof OwnPropertyInfo)) continue;
            OwnPropertyInfo ownProp = (OwnPropertyInfo)prop;
            String colName = name = ownProp.getName();
            ColumnInfo column = new ColumnInfo();
            column.setName(colName);
            for (int j = 0; j < localeNum; ++j) {
                tables[j].addColumn(column);
                CellInfo cell = new CellInfo();
                String cellName = ownProp.getAlias(locales.get(j).getOriginalLocale());
                if (StringUtils.isEmpty((String)cellName)) {
                    cell.setName(ownProp.getName());
                } else {
                    cell.setName(cellName);
                }
                cell.setColSpan(0);
                cell.setRowSpan(0);
                headers[j].addCell(cell);
            }
            PropertyBindingInfo propertyBindingInfo = new PropertyBindingInfo();
            propertyBindingInfo.setPropertyName(colName + ".text");
            propertyBindingInfo.setPropertyType(Object.class.getName());
            propertyBindingInfo.setAccessType(2);
            propertyBindingInfo.setAutoMode(false);
            propertyBindingInfo.setBindingObject(doName);
            propertyBindingInfo.setBingdingField(linkPropName + "." + ownProp.getName());
            propertyBindingInfo.setFieldType(ownProp.getJavaType());
            kdtControl.getPropertyBindings().add(propertyBindingInfo);
        }
        PropertyBindingInfo propertyBindingInfo = new PropertyBindingInfo();
        propertyBindingInfo.setPropertyName("userObject");
        propertyBindingInfo.setPropertyType(Object.class.getName());
        propertyBindingInfo.setAccessType(2);
        propertyBindingInfo.setAutoMode(false);
        propertyBindingInfo.setBindingObject(doName);
        propertyBindingInfo.setBingdingField(linkPropName);
        propertyBindingInfo.setFieldType(obj.getObjectCollectionClass());
        kdtControl.getPropertyBindings().add(propertyBindingInfo);
        for (i = 0; i < localeNum; ++i) {
            tables[i].addHeader(headers[i]);
        }
        PropertyInfo propInfo = new PropertyInfo();
        propInfo.setName("formatXml");
        propInfo.setType(String.class.getName());
        propInfo.setMultiLanguage(true);
        for (int i3 = 0; i3 < localeNum; ++i3) {
            propInfo.setValue(KDTableDesignerHelper.getXmlFrom(tables[i3]), locales.get(i3).getOriginalLocale());
        }
        kdtControl.getProperties().add(propInfo);
        ComponentInfo parent = model.getMainPanelComponent();
        model.getComponents().add(kdtControl);
        kdtControl.setParent(parent);
        parent.getComponents().add(kdtControl);
    }

    public static void createKDTableForQuery(UIObjectInfo model, QueryFieldInfo[] infos, String doName, int row, int col, LanguageCollection locales) {
        Dimension dsize;
        Layout layout = UIGeneratorHelper.getLayout(model.getMainPanelComponent());
        int layoutType = 0;
        if (layout == null || layout instanceof XYLayout) {
            layoutType = 1;
        } else if (layout instanceof SameGridLayout) {
            layoutType = 2;
        } else if (layout instanceof KDLayout) {
            layoutType = 3;
        } else {
            return;
        }
        col = layoutType == 1 || layoutType == 3 ? 10 : 1;
        if (layoutType == 1 || layoutType == 3) {
            row *= 10;
        }
        String baseName = doName.substring(0, 1).toUpperCase() + doName.substring(1);
        String prefixName = ControlConstant.getControlNamePrefix("com.kingdee.bos.ctrl.kdf.table.KDTable");
        String labName = (prefixName == null ? "kdt" : prefixName) + baseName;
        ComponentInfo kdtControl = new ComponentInfo("com.kingdee.bos.ctrl.kdf.table.KDTable");
        labName = model.getNameManager().getNameByName(labName);
        kdtControl.setName(labName);
        if (layoutType == 1) {
            dsize = ControlDefaultSizeManager.getDefaultSize("com.kingdee.bos.ctrl.kdf.table.KDTable");
            kdtControl.setConstraint(new Rectangle(col, row, dsize.width, dsize.height), false);
        } else if (layoutType == 3) {
            dsize = ControlDefaultSizeManager.getDefaultSize("com.kingdee.bos.ctrl.kdf.table.KDTable");
            kdtControl.setConstraint(new KDLayoutConstraint(col, row, dsize.width, dsize.height), false);
        } else {
            kdtControl.setConstraint(new Rectangle(col, row, 7, 5), false);
        }
        ComponentInfo parent = model.getMainPanelComponent();
        model.getComponents().add(kdtControl);
        kdtControl.setParent(parent);
        parent.getComponents().add(kdtControl);
        UIGeneratorHelper.bindingKDTableProperty(infos, doName, kdtControl, false, locales);
    }

    public static void bindingKDTableProperty(QueryFieldInfo[] infos, String doName, ComponentInfo kdtControl, boolean override, LanguageCollection locales) {
        int i;
        int size = infos.length;
        int localeNum = 0;
        if (locales != null) {
            localeNum = locales.size();
        }
        TableInfo[] tables = new TableInfo[localeNum];
        HeaderInfo[] headers = new HeaderInfo[localeNum];
        for (i = 0; i < localeNum; ++i) {
            tables[i] = new TableInfo();
            headers[i] = new HeaderInfo();
            headers[i].setName("header");
        }
        for (i = 0; i < size; ++i) {
            String name;
            QueryFieldInfo field = infos[i];
            String colName = name = field.getName();
            ColumnInfo column = new ColumnInfo();
            column.setName(colName);
            for (int j = 0; j < localeNum; ++j) {
                tables[j].addColumn(column);
                CellInfo cell = new CellInfo();
                String cellName = field.getDisplayName(locales.get(j).getOriginalLocale());
                if (StringUtils.isEmpty((String)cellName)) {
                    cell.setName(name);
                } else {
                    cell.setName(cellName);
                }
                cell.setColSpan(0);
                cell.setRowSpan(0);
                headers[j].addCell(cell);
            }
            PropertyBindingInfo propertyBindingInfo = new PropertyBindingInfo();
            propertyBindingInfo.setPropertyName(colName + ".text");
            propertyBindingInfo.setPropertyType(Object.class.getName());
            propertyBindingInfo.setAccessType(2);
            propertyBindingInfo.setAutoMode(false);
            propertyBindingInfo.setBindingObject(doName);
            propertyBindingInfo.setBingdingField(name);
            propertyBindingInfo.setFieldType(String.class.getName());
            propertyBindingInfo.setOverride(override);
            kdtControl.getPropertyBindings().add(propertyBindingInfo);
        }
        for (i = 0; i < localeNum; ++i) {
            tables[i].addHeader(headers[i]);
        }
        PropertyInfo propInfo = new PropertyInfo();
        propInfo.setName("formatXml");
        propInfo.setType(String.class.getName());
        propInfo.setMultiLanguage(true);
        propInfo.setOverride(override);
        for (int i2 = 0; i2 < localeNum; ++i2) {
            propInfo.setValue(KDTableDesignerHelper.getXmlFrom(tables[i2]), locales.get(i2).getOriginalLocale());
        }
        if (override) {
            kdtControl.getProperties().remove("formatXml");
        }
        kdtControl.getProperties().add(propInfo);
    }

    public static void replaceKDTableForQuery(UIObjectInfo model, QueryFieldInfo[] infos, QueryInfo queryInfo, int row, int col, LanguageCollection locales) {
        DataObjectInfo dataObj;
        int i;
        String classType = "";
        if (!StringUtils.isEmpty((String)queryInfo.getPackage())) {
            classType = queryInfo.getPackage() + ".";
        }
        classType = classType + queryInfo.getName();
        DataObjectCollection collection = model.getDataObjects();
        int j = collection.size();
        String oldDataObjName = null;
        for (i = 0; i < j; ++i) {
            dataObj = collection.get(i);
            String tempType = dataObj.getObjectType();
            if (!MetaDataTypeList.JOINQUERY.toString().equals(tempType)) continue;
            oldDataObjName = dataObj.getName();
            dataObj.setType(classType);
            dataObj.setOverride(true);
            dataObj.setWriteCode(true);
            break;
        }
        String temp = "query" + queryInfo.getName();
        temp = model.getNameManager().getNameByName(temp);
        if (j == 0 || i >= j) {
            dataObj = new DataObjectInfo();
            dataObj.setName(temp);
            dataObj.setType(classType);
            dataObj.setObjectType(queryInfo.getBOSType().toString());
            model.getDataObjects().add(dataObj);
            UIGeneratorHelper.createKDTableForQuery(model, infos, temp, row, col, locales);
            return;
        }
        ComponentInfo bindingKDTable = null;
        ComponentInfo firstKDTable = null;
        ComponentInfo mainPanel = model.getComponents().get(0);
        ComponentInfo[] ret = UIGeneratorHelper.findBindingKDTable(mainPanel, oldDataObjName);
        firstKDTable = ret[0];
        bindingKDTable = ret[1];
        if (bindingKDTable != null) {
            bindingKDTable.setPropertyBindings(new PropertyBindingCollection());
            UIGeneratorHelper.bindingKDTableProperty(infos, oldDataObjName, bindingKDTable, true, locales);
        } else if (firstKDTable != null) {
            if (firstKDTable.getPropertyBindings().size() == 0) {
                UIGeneratorHelper.bindingKDTableProperty(infos, oldDataObjName, firstKDTable, true, locales);
            } else {
                UIGeneratorHelper.createKDTableForQuery(model, infos, oldDataObjName, row, col, locales);
            }
        } else {
            UIGeneratorHelper.createKDTableForQuery(model, infos, oldDataObjName, row, col, locales);
        }
    }

    private static ComponentInfo[] findBindingKDTable(ComponentInfo panel, String oldDataObjName) {
        ComponentInfo bindingKDTable = null;
        ComponentInfo firstKDTable = null;
        ComponentCollection children = panel.getComponents();
        int n = children.size();
        for (int m = 0; m < n; ++m) {
            ComponentInfo componentInfo = children.get(m);
            if ("com.kingdee.bos.ctrl.kdf.table.KDTable".equals(componentInfo.getClassType())) {
                if (firstKDTable == null || StringUtils.isEmpty((String)firstKDTable.getName())) {
                    firstKDTable = componentInfo;
                }
                PropertyBindingCollection propBindingCollection = componentInfo.getPropertyBindings();
                int l = propBindingCollection.size();
                for (int k = 0; k < l; ++k) {
                    PropertyBindingInfo propBinding = propBindingCollection.get(k);
                    if (!propBinding.getBindingObject().equals(oldDataObjName)) continue;
                    bindingKDTable = componentInfo;
                    ComponentInfo[] ret = new ComponentInfo[]{firstKDTable, bindingKDTable};
                    return ret;
                }
            }
            ComponentInfo[] tempInfos = UIGeneratorHelper.findBindingKDTable(componentInfo, oldDataObjName);
            if (firstKDTable == null) {
                firstKDTable = tempInfos[0];
            }
            if (bindingKDTable == null) {
                bindingKDTable = tempInfos[1];
            }
            if (firstKDTable != null && bindingKDTable != null) break;
        }
        ComponentInfo[] ret = new ComponentInfo[]{firstKDTable, bindingKDTable};
        return ret;
    }

    private static ComponentInfo createLabelContainer(String name, String label) {
        ComponentInfo labelContainer = new ComponentInfo("com.kingdee.bos.ctrl.swing.KDLabelContainer");
        labelContainer.setName(name, false);
        labelContainer.setContainer(true);
        PropertyCollection props = labelContainer.getProperties();
        props.add(UIGeneratorHelper.createBoundLabelTextProperty(label));
        props.add(UIGeneratorHelper.createBoundLabelLengthProperty());
        props.add(UIGeneratorHelper.createBoundLabelUnderlineProperty());
        return labelContainer;
    }

    private static PropertyInfo createBoundLabelTextProperty(String label) {
        PropertyInfo prop = new PropertyInfo();
        prop.setName("boundLabelText");
        prop.setType(String.class.getName());
        prop.setValue(label);
        prop.setMultiLanguage(true);
        prop.setOverride(true);
        return prop;
    }

    private static PropertyInfo createBoundLabelLengthProperty() {
        PropertyInfo prop = new PropertyInfo();
        prop.setName("boundLabelLength");
        prop.setType("int");
        prop.setValue(String.valueOf(ControlDefaultSizeManager.getDefaultSize((String)"com.kingdee.bos.ctrl.swing.KDLabel").width));
        prop.setOverride(true);
        return prop;
    }

    private static PropertyInfo createBoundLabelUnderlineProperty() {
        PropertyInfo prop = new PropertyInfo();
        prop.setName("boundLabelUnderline");
        prop.setType("boolean");
        prop.setValue(String.valueOf(true));
        prop.setOverride(true);
        return prop;
    }

    private static PropertyInfo createTextProperty(String label) {
        PropertyInfo prop = new PropertyInfo();
        prop.setName("text");
        prop.setType(String.class.getName());
        prop.setValue(label);
        prop.setMultiLanguage(true);
        prop.setOverride(true);
        return prop;
    }

    public static Layout getLayout(ComponentInfo componentInfo) {
        Layout layout = null;
        String classType = componentInfo.getClassType();
        if ("com.kingdee.bos.ctrl.swing.KDScrollPane".equals(classType)) {
            layout = new SameGridLayout(1, 1);
        } else if ("com.kingdee.bos.ctrl.swing.KDSplitPane".equals(classType)) {
            layout = new SplitLayout();
        } else if ("com.kingdee.bos.ctrl.swing.KDTabbedPane".equals(classType)) {
            layout = new TabbedPaneLayout();
        } else if ("com.kingdee.bos.ctrl.swing.KDTreeView".equals(classType)) {
            layout = new TreeViewLayout();
        } else if ("com.kingdee.bos.ctrl.swing.KDLabelContainer".equals(classType)) {
            layout = new LabelContainerLayout();
        } else if ("com.kingdee.bos.ctrl.swing.KDToolBar".equals(classType) || "com.kingdee.bos.ctrl.swing.KDMenuBar".equals(classType) || "com.kingdee.bos.ctrl.swing.KDMenu".equals(classType)) {
            layout = new FlowLayout();
            componentInfo.setLayoutInfo(LayoutConverter.convertToInfo(layout));
        } else {
            layout = LayoutConverter.convertToLayoutObj(componentInfo.getLayoutInfo());
        }
        if (componentInfo.getLayoutInfo() == null) {
            componentInfo.setLayoutInfo(LayoutConverter.convertToInfo(layout));
        }
        return layout;
    }

    public static void createKDTableForTabelEditUI(UIObjectInfo model, EntityObjectInfo obj, UIGenerator.PropertyControlPair[] pairs, String doName, int row, int col, LanguageCollection locales) {
        int i;
        Layout layout = UIGeneratorHelper.getLayout(model.getMainPanelComponent());
        int layoutType = 0;
        if (layout == null || layout instanceof XYLayout) {
            layoutType = 1;
        } else if (layout instanceof SameGridLayout) {
            layoutType = 2;
        } else if (layout instanceof KDLayout) {
            layoutType = 3;
        } else {
            return;
        }
        col = layoutType == 1 || layoutType == 3 ? 10 : 1;
        if (layoutType == 1 || layoutType == 3) {
            row *= 10;
        }
        String baseName = doName.substring(0, 1).toUpperCase() + doName.substring(1);
        String prefixName = ControlConstant.getControlNamePrefix("com.kingdee.bos.ctrl.kdf.table.KDTable");
        String labName = (prefixName == null ? "kdt" : prefixName) + baseName;
        ComponentInfo kdtControl = null;
        boolean existTable = false;
        if (model.getParent() != null) {
            ComponentCollection children = model.getMainPanelComponent().getComponents();
            int j = children.size();
            for (int i2 = 0; i2 < j; ++i2) {
                ComponentInfo com = children.get(i2);
                if (!"com.kingdee.bos.ctrl.kdf.table.KDTable".equals(com.getClassType())) continue;
                kdtControl = com;
                existTable = true;
                break;
            }
        } else {
            Dimension dsize;
            kdtControl = new ComponentInfo("com.kingdee.bos.ctrl.kdf.table.KDTable");
            labName = model.getNameManager().getNameByName(labName);
            kdtControl.setName(labName);
            if (layoutType == 1) {
                dsize = ControlDefaultSizeManager.getDefaultSize("com.kingdee.bos.ctrl.kdf.table.KDTable");
                kdtControl.setConstraint(new Rectangle(col, row, dsize.width, dsize.height), false);
            } else if (layoutType == 3) {
                dsize = ControlDefaultSizeManager.getDefaultSize("com.kingdee.bos.ctrl.kdf.table.KDTable");
                kdtControl.setConstraint(new KDLayoutConstraint(col, row, dsize.width, dsize.height), false);
            } else {
                kdtControl.setConstraint(new Rectangle(col, row, 7, 5), false);
            }
        }
        int size = pairs.length;
        int localeNum = 0;
        if (locales != null) {
            localeNum = locales.size();
        }
        TableInfo[] tables = new TableInfo[localeNum];
        HeaderInfo[] headers = new HeaderInfo[localeNum];
        for (int i3 = 0; i3 < localeNum; ++i3) {
            tables[i3] = new TableInfo();
            headers[i3] = new HeaderInfo();
            headers[i3].setName("header");
        }
        for (i = 0; i < size; ++i) {
            String name;
            com.kingdee.bos.metadata.entity.PropertyInfo prop = pairs[i].property;
            String colName = name = prop.getName();
            ColumnInfo column = new ColumnInfo();
            column.setName(colName);
            for (int j = 0; j < localeNum; ++j) {
                tables[j].addColumn(column);
                CellInfo cell = new CellInfo();
                String cellName = prop.getAlias(locales.get(j).getOriginalLocale());
                if (StringUtils.isEmpty((String)cellName)) {
                    cell.setName(prop.getName());
                } else {
                    cell.setName(cellName);
                }
                cell.setColSpan(0);
                cell.setRowSpan(0);
                headers[j].addCell(cell);
            }
            PropertyBindingInfo propertyBindingInfo = new PropertyBindingInfo();
            propertyBindingInfo.setPropertyName(colName + ".text");
            propertyBindingInfo.setPropertyType(Object.class.getName());
            propertyBindingInfo.setAccessType(2);
            propertyBindingInfo.setAutoMode(false);
            propertyBindingInfo.setBindingObject(doName);
            propertyBindingInfo.setBingdingField(prop.getName());
            if (prop instanceof OwnPropertyInfo) {
                propertyBindingInfo.setFieldType(((OwnPropertyInfo)prop).getJavaType());
            }
            kdtControl.getPropertyBindings().add(propertyBindingInfo);
        }
        PropertyBindingInfo propertyBindingInfo = new PropertyBindingInfo();
        propertyBindingInfo.setPropertyName("userObject");
        propertyBindingInfo.setPropertyType(Object.class.getName());
        propertyBindingInfo.setAccessType(2);
        propertyBindingInfo.setAutoMode(false);
        propertyBindingInfo.setBindingObject(doName);
        propertyBindingInfo.setBingdingField("collection");
        propertyBindingInfo.setFieldType(obj.getObjectCollectionClass());
        kdtControl.getPropertyBindings().add(propertyBindingInfo);
        for (i = 0; i < localeNum; ++i) {
            tables[i].addHeader(headers[i]);
        }
        PropertyInfo propInfo = new PropertyInfo();
        propInfo.setName("formatXml");
        propInfo.setType(String.class.getName());
        propInfo.setMultiLanguage(true);
        propInfo.setOverride(existTable);
        for (int i4 = 0; i4 < localeNum; ++i4) {
            propInfo.setValue(KDTableDesignerHelper.getXmlFrom(tables[i4]), locales.get(i4).getOriginalLocale());
        }
        if (existTable) {
            kdtControl.getProperties().remove("formatXml");
        }
        kdtControl.getProperties().add(propInfo);
        if (!existTable) {
            ComponentInfo parent = model.getMainPanelComponent();
            model.getComponents().add(kdtControl);
            kdtControl.setParent(parent);
            parent.getComponents().add(kdtControl);
        }
    }
}

